/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.common.util.io.IoUtils;

public class NavHelp
extends JDialog {
    private transient Logger logger = LogManager.getLogger("applog");
    private Context context;
    public boolean fault = false;
    private Component previous;
    private JPanel dialogPane;
    private JPanel contentPanel;
    public JScrollPane scrollPane;
    private JEditorPane helpText;
    private JPanel buttonBar;
    private JCheckBox showCheckBox;
    private JLabel labelStatus;
    private JButton okButton;

    private NavHelp() {
    }

    public NavHelp(Window owner, Component prev, final Context context, String title, String resourceFilename, boolean modal) {
        super(owner);
        this.previous = prev;
        this.context = context;
        this.initComponents();
        this.setTitle(title);
        if (!resourceFilename.startsWith("gettingstarted_")) {
            this.showCheckBox.setVisible(false);
        } else {
            this.showCheckBox.setSelected(context.preferences.isShowGettingStarted());
        }
        this.helpText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\u001b') {
                    NavHelp.this.okButton.doClick();
                }
            }
        });
        this.okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavHelp.this.savePreferences();
                NavHelp.this.setVisible(false);
                if (NavHelp.this.previous == null) {
                    NavHelp.this.previous = context.mainFrame;
                }
                NavHelp.this.previous.requestFocus();
            }
        });
        this.okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\u001b') {
                    NavHelp.this.okButton.doClick();
                }
            }
        });
        if (context.preferences.getHelpXpos() != -1 && Utils.isOnScreen(context.preferences.getHelpXpos(), context.preferences.getHelpYpos())) {
            this.setLocation(context.preferences.getHelpXpos(), context.preferences.getHelpYpos());
            if (context.preferences.getHelpWidth() > 0) {
                this.setSize(context.preferences.getHelpWidth(), context.preferences.getHelpHeight());
            }
        } else {
            this.setSize(600, 550);
            Point position = owner.getLocation();
            position.x += 32;
            position.y += 32;
            this.setLocation(position);
        }
        this.load(resourceFilename);
        if (!this.fault) {
            this.setModal(modal);
            this.setVisible(true);
            this.buttonFocus();
        } else {
            if (this.previous == null) {
                this.previous = context.mainFrame;
            }
            this.previous.requestFocus();
        }
    }

    public void buttonFocus() {
        this.okButton.requestFocus();
    }

    private void load(String resourceFilename) {
        Object text = "";
        try {
            if (resourceFilename.startsWith("http")) {
                String buf;
                URL url = new URL(resourceFilename);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((buf = bufferedReader.readLine()) != null) {
                    text = (String)text + buf.trim() + "\n";
                }
                bufferedReader.close();
            } else {
                URL url = Thread.currentThread().getContextClassLoader().getResource(resourceFilename);
                List<String> lines = IoUtils.readAllLines(url);
                for (int i = 0; i < lines.size(); ++i) {
                    text = (String)text + lines.get(i) + "\n";
                }
            }
            this.helpText.setText((String)text);
            this.helpText.addHyperlinkListener(new HyperLink());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollBar bar = NavHelp.this.scrollPane.getVerticalScrollBar();
                    bar.setValue(bar.getMinimum());
                    NavHelp.this.buttonFocus();
                }
            });
        }
        catch (Exception e) {
            this.fault = true;
            this.logger.error(Utils.getStackTrace(e));
            JOptionPane.showMessageDialog(this.getOwner(), this.context.cfg.gs("NavHelp.error.opening.help.file") + resourceFilename + ", " + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
        }
    }

    private void savePreferences() {
        this.context.preferences.setShowGettingStarted(this.showCheckBox.isSelected());
        this.context.preferences.setHelpHeight(this.getHeight());
        this.context.preferences.setHelpWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setHelpXpos(location.x);
        this.context.preferences.setHelpYpos(location.y);
    }

    private void thisWindowClosed(WindowEvent e) {
        if (this.previous == null) {
            this.previous = this.context.mainFrame;
        }
        this.previous.requestFocus();
    }

    private void thisWindowClosing(WindowEvent e) {
        if (this.previous == null) {
            this.previous = this.context.mainFrame;
        }
        this.previous.requestFocus();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.helpText = new JEditorPane();
        this.buttonBar = new JPanel();
        this.showCheckBox = new JCheckBox();
        this.labelStatus = new JLabel();
        this.okButton = new JButton();
        this.setName(this.context.cfg.gs("NavHelp.name"));
        this.setMinimumSize(new Dimension(100, 50));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                NavHelp.this.thisWindowClosed(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                NavHelp.this.thisWindowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(570, 470));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.helpText.setEditable(false);
        this.helpText.setContentType("text/html");
        this.scrollPane.setViewportView(this.helpText);
        this.contentPanel.add(this.scrollPane);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new BorderLayout(8, 0));
        this.showCheckBox.setText(this.context.cfg.gs("NavHelp.showCheckBox.text"));
        this.showCheckBox.setMnemonic(this.context.cfg.gs("NavHelp.showCheckBox.mnemonic").charAt(0));
        this.buttonBar.add((Component)this.showCheckBox, "West");
        this.labelStatus.setHorizontalAlignment(0);
        this.buttonBar.add((Component)this.labelStatus, "Center");
        this.okButton.setText(this.context.cfg.gs("Z.ok"));
        this.okButton.setActionCommand(this.context.cfg.gs("Z.ok"));
        this.okButton.setMnemonic(this.context.cfg.gs("NavHelp.okButton.mnemonic").charAt(0));
        this.buttonBar.add((Component)this.okButton, "East");
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public class HyperLink
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType type = hyperlinkEvent.getEventType();
            if (type == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    URL url = hyperlinkEvent.getURL();
                    URI uri = url.toURI();
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(NavHelp.this.context.mainFrame, NavHelp.this.context.cfg.gs("Navigator.error.launching.browser"), NavHelp.this.context.cfg.getNavigatorName(), 0);
                }
            } else if (type == HyperlinkEvent.EventType.ENTERED) {
                String url = hyperlinkEvent.getURL().toString();
                NavHelp.this.labelStatus.setText(url);
            } else if (type == HyperlinkEvent.EventType.EXITED) {
                NavHelp.this.labelStatus.setText("  ");
            }
        }
    }
}

