/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.bookmarks;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.bookmarks.Bookmark;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Bookmarks
implements Cloneable,
Serializable {
    ArrayList<Bookmark> bookmarks;
    transient Context context;

    public Bookmarks(Context context) {
        this.context = context;
        this.bookmarks = new ArrayList();
    }

    public void add(Bookmark bookmark) {
        if (this.find(bookmark) > -1) {
            this.delete(bookmark);
        }
        this.bookmarks.add(bookmark);
    }

    public Object clone() {
        Bookmarks clone = new Bookmarks(this.context);
        for (Bookmark bookmark : this.bookmarks) {
            clone.add((Bookmark)bookmark.clone());
        }
        return clone;
    }

    public void delete(Bookmark bookmark) {
        this.bookmarks.remove(bookmark);
    }

    public void delete(int index) {
        this.bookmarks.remove(index);
    }

    public int find(Bookmark bookmark) {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            Bookmark candidate = this.bookmarks.get(i);
            if (!candidate.name.equals(bookmark.name)) continue;
            return i;
        }
        return -1;
    }

    public Bookmark find(String name) {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            Bookmark candidate = this.bookmarks.get(i);
            if (!candidate.name.equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public Bookmark get(int index) {
        return this.bookmarks.get(index);
    }

    public String getFullPath() {
        String path = System.getProperty("user.dir") + System.getProperty("file.separator") + "local" + System.getProperty("file.separator") + "bookmarks.json";
        return path;
    }

    public void sort() {
        Collections.sort(this.bookmarks, new Comparator<Bookmark>(this){

            @Override
            public int compare(Bookmark bookmark, Bookmark t1) {
                return bookmark.name.compareToIgnoreCase(t1.name);
            }
        });
    }

    public int size() {
        return this.bookmarks.size();
    }

    public void write() throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(Utils.getFullPathLocal(this.getFullPath()));
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(Utils.getFullPathLocal(this.getFullPath()));
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.context.cfg.gs("Z.error.writing") + Utils.getFullPathLocal(this.getFullPath()) + " trace: " + Utils.getStackTrace(fnf));
        }
    }
}

