/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.gui.browser.DateColumn;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.gui.browser.SizeColumn;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class BrowserTableModel
extends DefaultTableModel {
    Context context;
    private boolean initialized = false;
    private NavTreeNode node;

    public BrowserTableModel(Context context) {
        this.context = context;
    }

    public int findNavTreeUserObjectIndex(NavTreeNode find) {
        int size = this.node.getChildCount(false, true);
        for (int i = 0; i < size; ++i) {
            if ((NavTreeNode)this.node.getChildAt(i, false, true) != find) continue;
            return i;
        }
        return -1;
    }

    public int findNodeIndexInTable(NavTreeNode find) {
        int size = this.getRowCount();
        for (int i = 0; i < size; ++i) {
            if ((NavTreeNode)this.getValueAt(1, i) != find) continue;
            return i;
        }
        return -1;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return NavTreeUserObject.class;
            }
            case 2: {
                return SizeColumn.class;
            }
            case 3: {
                return DateColumn.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "";
            }
            case 1: {
                return this.context.cfg.gs("BrowserTable.column.name");
            }
            case 2: {
                return this.context.cfg.gs("BrowserTable.column.size");
            }
            case 3: {
                return this.context.cfg.gs("BrowserTable.column.modified");
            }
        }
        return this.context.cfg.gs("NavTreeNode.unknown");
    }

    public NavTreeNode getNode() {
        return this.node;
    }

    @Override
    public int getRowCount() {
        if (this.node != null) {
            return this.node.getChildCount(false, true);
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getValueAt(row, column, false, true);
    }

    private Object getValueAt(int row, int column, boolean hideFilesInTreeFilterActive, boolean hideHiddenFilterActive) {
        if (row >= this.node.getChildCount(hideFilesInTreeFilterActive, hideHiddenFilterActive)) {
            return null;
        }
        NavTreeNode child = (NavTreeNode)this.node.getChildAt(row, hideFilesInTreeFilterActive, hideHiddenFilterActive);
        if (child == null) {
            return null;
        }
        NavTreeUserObject tuo = child.getUserObject();
        if (tuo != null) {
            if (column == 0) {
                switch (tuo.type) {
                    case 0: {
                        return UIManager.getIcon("FileView.floppyDriveIcon");
                    }
                    case 1: {
                        return UIManager.getIcon("FileChooser.homeFolderIcon");
                    }
                    case 2: {
                        return UIManager.getIcon("FileView.computerIcon");
                    }
                    case 3: {
                        return UIManager.getIcon("FileView.hardDriveIcon");
                    }
                    case 4: {
                        return UIManager.getIcon("FileChooser.homeFolderIcon");
                    }
                    case 5: {
                        return UIManager.getIcon("FileView.directoryIcon");
                    }
                    case 6: {
                        if (tuo.isDir) {
                            return UIManager.getIcon("FileView.directoryIcon");
                        }
                        return UIManager.getIcon("FileView.fileIcon");
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        return UIManager.getIcon("InternalFrame.closeIcon");
                    }
                }
            }
            if (column == 1) {
                if (tuo.name.length() == 0) {
                    System.out.println("empty name");
                }
                return tuo;
            }
            if (column == 2) {
                switch (tuo.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        return new SizeColumn(child.getChildCount(false, true), this.context.cfg.getLongScale(), true);
                    }
                    case 3: {
                        return null;
                    }
                    case 6: {
                        if (tuo.isDir) {
                            return null;
                        }
                        return new SizeColumn(tuo.size, this.context.cfg.getLongScale());
                    }
                    case 7: {
                        return null;
                    }
                }
            }
            if (column == 3) {
                switch (tuo.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        return new DateColumn(this.context, tuo.fileTime);
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        return UIManager.getIcon("InternalFrame.closeIcon");
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setNode(NavTreeNode treeNode) {
        this.node = treeNode;
    }
}

