/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.Progress;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.repository.Repository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NavTransferWorker
extends SwingWorker<Object, Object> {
    private transient Logger logger = LogManager.getLogger("applog");
    private int action = 0;
    private long batchSize = 0L;
    private Context context;
    private int depth = 0;
    private int fileNumber = 0;
    private int filesToCopy = 0;
    private long filesSize = 0L;
    private ArrayList<Batch> queue;
    private boolean running = false;
    private Repository sourceRepo;
    private JTree sourceTree;
    private boolean targetIsPublisher = false;
    private Repository targetRepo;
    public JTree targetTree;
    public NavTreeUserObject targetTuo;
    public ArrayList<NavTreeUserObject> transferData;

    private NavTransferWorker() {
    }

    public NavTransferWorker(final Context context) {
        this.context = context;
        this.queue = new ArrayList();
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (context.browser.navTransferHandler.getTransferWorker() != null && !context.browser.navTransferHandler.getTransferWorker().isDone()) {
                    NavTransferWorker.this.logger.warn(context.cfg.gs("MainFrame.cancelling.transfers.as.requested"));
                    NavTransferWorker.this.running = false;
                    NavTransferWorker.this.cancel(true);
                }
            }
        };
        context.progress = new Progress(context, context.mainFrame, cancelAction, context.cfg.isDryRun());
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.depth = 0;
        boolean error = false;
        this.running = true;
        if (this.context.navigator.isBlockingProcessRunning()) {
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.please.wait.for.the.current.operation.to.finish"), this.context.cfg.getNavigatorName(), 2);
            return false;
        }
        this.context.navigator.setBlockingProcessRunning(true);
        this.fileNumber = 0;
        for (int i = 0; i < this.queue.size() && this.isRunning(); ++i) {
            Batch batch = this.queue.get(i);
            this.action = batch.action;
            this.transferData = batch.transferData;
            this.targetTree = batch.targetTree;
            this.targetTuo = batch.targetTuo;
            this.batchSize = batch.batchSize;
            this.targetIsPublisher = this.targetTree.getName().toLowerCase().endsWith("one");
            this.context.progress.display();
            for (NavTreeUserObject sourceTuo : this.transferData) {
                if (!this.isRunning()) break;
                NavTreeNode sourceNode = sourceTuo.node;
                this.sourceTree = sourceNode.getMyTree();
                if (sourceTuo.isDir) {
                    if (this.transferDirectory(sourceTuo, this.targetTree, this.targetTuo)) {
                        error = true;
                        break;
                    }
                } else if (this.transferFile(sourceTuo, this.targetTree, this.targetTuo)) {
                    error = true;
                    break;
                }
                if (this.action != 2) continue;
                error = false;
                error = sourceTuo.isDir ? this.context.browser.navTransferHandler.removeDirectory(sourceTuo) : this.context.browser.navTransferHandler.removeFile(sourceTuo);
                if (!error) continue;
                break;
            }
            if (error || this.isCancelled()) break;
            if (!this.context.browser.isHintTrackingButtonEnabled()) continue;
            this.exportHints(this.transferData, this.targetTuo);
        }
        if (this.isCancelled()) {
            this.logger.trace(this.context.cfg.gs("NavTransferWorker.cancelled"));
        }
        this.context.progress.redraw();
        return null;
    }

    @Override
    protected void done() {
        this.removeTransferData(this.transferData);
        Object msg = this.running ? this.context.cfg.gs("Transfer.of.complete") : this.context.cfg.gs("Transfer.of.cancelled");
        msg = MessageFormat.format((String)msg, this.filesToCopy);
        long now = System.currentTimeMillis();
        long diff = now - this.context.progress.getStartTime();
        if ((diff /= 1000L) > 0L) {
            String duration = Utils.formatDuration(diff);
            msg = (String)msg + ": " + Utils.formatLong(this.context.progress.getTotalBytesCopied(), false, this.context.cfg.getLongScale()) + ", " + duration + this.context.cfg.gs("NavTransferWorker.average") + Utils.formatRate(this.context.progress.getAverageBps(), this.context.cfg.getLongScale());
        }
        this.context.mainFrame.labelStatusMiddle.setText((String)msg);
        this.logger.info((String)msg);
        this.queue = new ArrayList();
        this.filesToCopy = 0;
        this.filesSize = 0L;
        if (this.context.progress != null) {
            this.context.progress.done();
            this.context.progress.dispose();
            this.context.progress = null;
        }
        if (this.context.preferences.isAutoRefresh()) {
            this.context.browser.refreshTree(this.sourceTree);
            if (this.sourceTree != this.targetTree) {
                this.context.browser.refreshTree(this.targetTree);
            }
        }
        this.context.navigator.setBlockingProcessRunning(false);
        this.running = false;
    }

    public void addBatch(int action, int count, long size, ArrayList<NavTreeUserObject> transferData, JTree target, NavTreeUserObject tuo) {
        Batch batch = new Batch(this, action, transferData, target, tuo, size);
        this.queue.add(batch);
        this.filesToCopy += count;
        this.filesSize += size;
        if (this.context.progress != null) {
            this.context.progress.setCountAndBytes(this.filesToCopy, this.filesSize);
        }
        this.logger.info(MessageFormat.format(this.context.cfg.gs("NavTransferWorker.added.batch.0.items"), count) + Utils.formatLong(size, false, this.context.cfg.getLongScale()));
    }

    private void exportHints(ArrayList<NavTreeUserObject> transferData, NavTreeUserObject targetTuo) throws Exception {
        if (this.action == 2) {
            for (NavTreeUserObject sourceTuo : transferData) {
                this.context.browser.navTransferHandler.exportHint("mv", sourceTuo, targetTuo);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private String makeToPath(NavTreeUserObject sourceTuo, NavTreeUserObject targetTuo) throws Exception {
        String directory = "";
        String filename = "";
        Object path = "";
        this.sourceRepo = sourceTuo.getRepo();
        String sourceSep = this.sourceRepo.getSeparator();
        this.targetRepo = targetTuo.getRepo();
        String targetSep = this.targetRepo.getSeparator();
        boolean checkSpace = true;
        if (targetTuo.type == 5) {
            checkSpace = false;
            directory = this.context.transfer.getTarget(this.sourceRepo, targetTuo.name, this.batchSize, this.targetRepo, targetTuo.isRemote, sourceTuo.path);
            if (directory == null || directory.length() == 0) {
                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Transfer.no.space.on.any.target.location"), this.targetRepo.getLibraryData().libraries.description, targetTuo.name, Utils.formatLong(this.batchSize, false, this.context.cfg.getLongScale()), sourceTuo.name));
            }
        } else if (targetTuo.type == 3 || targetTuo.type == 4) {
            directory = targetTuo.path;
        } else if (targetTuo.type == 6) {
            directory = targetTuo.path;
            if (!targetTuo.isDir) {
                directory = Utils.getLeftPath(directory, targetSep);
            }
        }
        assert (directory.length() > 0);
        if (checkSpace && !this.context.transfer.itFits(this.targetRepo, directory, targetTuo.isRemote, this.batchSize, 0L, false)) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Transfer.no.space.on.any.target.location"), this.targetRepo.getLibraryData().libraries.description, targetTuo.name, Utils.formatLong(this.batchSize, false, this.context.cfg.getLongScale()), sourceTuo.name));
        }
        if (Utils.isRelativePath(directory)) {
            if (this.targetRepo.getPurpose() == 1) {
                directory = Utils.getFullPathLocal(directory);
            } else if (this.targetRepo.getPurpose() == 2) {
                directory = this.context.cfg.getFullPathSubscriber(directory);
            }
        }
        int dirPos = Utils.rightIndexOf(sourceTuo.path, sourceSep, targetTuo.isDir ? 0 : this.depth);
        filename = sourceTuo.path.substring(dirPos);
        filename = Utils.pipe(filename);
        directory = Utils.pipe(directory);
        path = directory + filename;
        path = Utils.unpipe((String)path, targetSep);
        path = ((String)path).replace(":\\\\", ":\\");
        return path;
    }

    private void removeTransferData(ArrayList<NavTreeUserObject> transferData) {
        if (this.action == 2) {
            for (int i = transferData.size() - 1; i > -1; --i) {
                NavTreeUserObject sourceTuo = transferData.get(i);
                if (this.context.fault || !this.context.preferences.isAutoRefresh()) continue;
                NavTreeNode ntn = (NavTreeNode)sourceTuo.node.getParent();
                if (ntn != null) {
                    this.context.browser.rescanByNode(ntn);
                }
                this.logger.trace("rescanByNode complete");
            }
        }
    }

    public void setIsRunning(boolean state) {
        this.running = state;
    }

    private NavTreeUserObject setupToNode(NavTreeUserObject sourceTuo, NavTreeUserObject targetTuo, String path) {
        boolean exists = false;
        NavTreeNode toNode = null;
        toNode = targetTuo.node.findChildTuoPath(path, false);
        if (toNode == null) {
            toNode = (NavTreeNode)sourceTuo.node.clone();
            toNode.setMyRepo(targetTuo.node.getMyRepo());
            toNode.setMyTree(targetTuo.node.getMyTree());
            toNode.setMyTable(targetTuo.node.getMyTable());
            toNode.setMyStatus(targetTuo.node.getMyStatus());
        } else {
            exists = true;
        }
        NavTreeUserObject toTuo = toNode.getUserObject();
        toTuo.node = toNode;
        toTuo.path = path;
        toTuo.isRemote = !this.targetIsPublisher && this.context.cfg.isRemoteOperation();
        toTuo.fileTime = sourceTuo.fileTime;
        toNode.setAllowsChildren(toTuo.isDir);
        if (toNode.getMyRepo().getPurpose() == 1) {
            toTuo.file = new File(Utils.getFullPathLocal(path));
        } else if (toNode.getMyRepo().getPurpose() == 2) {
            toTuo.file = new File(this.context.cfg.getFullPathSubscriber(path));
        }
        if (!exists && !this.context.cfg.isDryRun()) {
            targetTuo.node.add(toNode);
        }
        return toTuo;
    }

    private boolean transferDirectory(NavTreeUserObject sourceTuo, JTree targetTree, NavTreeUserObject targetTuo) {
        boolean error = false;
        try {
            int childCount = sourceTuo.node.getChildCount(false, false);
            String path = this.makeToPath(sourceTuo, targetTuo);
            NavTreeUserObject toNodeTuo = this.setupToNode(sourceTuo, targetTuo, path);
            for (int i = 0; i < childCount && this.isRunning(); ++i) {
                NavTreeNode child = (NavTreeNode)sourceTuo.node.getChildAt(i, false, false);
                NavTreeUserObject childTuo = child.getUserObject();
                if (childTuo.isDir) {
                    ++this.depth;
                    error = this.transferDirectory(childTuo, targetTree, toNodeTuo);
                    if (!error) continue;
                    --this.depth;
                    continue;
                }
                error = this.transferFile(childTuo, targetTree, toNodeTuo);
                if (!error) {
                    continue;
                }
                break;
            }
        }
        catch (MungeException me) {
            if (!this.isCancelled() && !error) {
                String msg = this.context.cfg.gs("Browser.error") + me.getMessage();
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
            error = true;
        }
        catch (Exception e) {
            if (!this.isCancelled() && !error) {
                this.logger.error(Utils.getStackTrace(e));
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.error") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
            }
            error = true;
        }
        return error;
    }

    private boolean transferFile(NavTreeUserObject sourceTuo, JTree targetTree, NavTreeUserObject targetTuo) {
        boolean error = false;
        String path = "";
        String msg = this.context.browser.navTransferHandler.getOperationText(this.action, true).toLowerCase() + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : "") + this.context.cfg.gs("NavTransferHandler.transfer.file.from") + sourceTuo.path;
        try {
            ++this.fileNumber;
            if (this.context.progress != null) {
                this.context.progress.update(this.fileNumber, sourceTuo.size, sourceTuo.name);
            }
            path = this.makeToPath(sourceTuo, targetTuo);
            msg = msg + this.context.cfg.gs("NavTransferHandler.transfer.file.to") + path;
            if (!sourceTuo.isRemote && !targetTuo.isRemote) {
                this.logger.info(this.context.cfg.gs("NavTreeNode.local") + msg);
                if (!this.context.cfg.isDryRun()) {
                    if (this.action == 2) {
                        this.context.transfer.moveFile(sourceTuo.path, sourceTuo.fileTime, path, true);
                    } else {
                        this.context.transfer.copyFile(this.context.clientSftpMetadata, sourceTuo.path, sourceTuo.fileTime, path, false, true);
                    }
                    this.setupToNode(sourceTuo, targetTuo, path);
                }
            } else if (!sourceTuo.isRemote && targetTuo.isRemote) {
                this.logger.info(this.context.cfg.gs("NavTransferHandler.put") + msg);
                if (!this.context.cfg.isDryRun()) {
                    this.context.transfer.copyFile(this.context.clientSftpMetadata, sourceTuo.path, sourceTuo.fileTime, path, true, false);
                    this.setupToNode(sourceTuo, targetTuo, path);
                }
            } else if (sourceTuo.isRemote && !targetTuo.isRemote) {
                this.logger.info(this.context.cfg.gs("NavTransferHandler.get") + msg);
                if (!this.context.cfg.isDryRun()) {
                    String dir = Utils.getLeftPath(path, this.targetRepo.getSeparator());
                    Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
                    this.context.clientSftpMetadata.get(sourceTuo.path, path);
                    if (this.context.preferences.isPreserveFileTimes()) {
                        Files.setLastModifiedTime(Paths.get(Utils.getFullPathLocal(path), new String[0]), sourceTuo.fileTime);
                    }
                    this.setupToNode(sourceTuo, targetTuo, path);
                }
            } else {
                this.logger.info(this.context.cfg.gs("Z.remote.uppercase") + msg);
                if (!this.context.cfg.isDryRun()) {
                    String command = this.action == 2 ? "move \"" + this.context.cfg.getFullPathSubscriber(sourceTuo.path) + "\" \"" + this.context.cfg.getFullPathSubscriber(path) + "\"" : "copy \"" + this.context.cfg.getFullPathSubscriber(sourceTuo.path) + "\" \"" + this.context.cfg.getFullPathSubscriber(path) + "\"";
                    String response = this.context.clientStty.roundTrip(command, "Sending command: " + command, -1);
                    if (response.equalsIgnoreCase("true")) {
                        this.setupToNode(sourceTuo, targetTuo, path);
                        if (this.context.preferences.isPreserveFileTimes()) {
                            this.context.clientSftp.setDate(path, (int)sourceTuo.fileTime.to(TimeUnit.SECONDS));
                        }
                    } else {
                        throw new MungeException(this.context.cfg.gs("Z.remote.uppercase") + this.context.browser.navTransferHandler.getOperationText(this.action, true).toLowerCase() + this.context.cfg.gs("NavTransferHandler.progress.of") + sourceTuo.name + this.context.cfg.gs("NavTransferHandler.failed"));
                    }
                }
            }
            this.batchSize -= sourceTuo.size;
            if (this.context.preferences.isAutoRefresh()) {
                if (this.action == 2) {
                    this.context.browser.refreshTree(this.sourceTree);
                }
                if (this.sourceTree != targetTree) {
                    this.context.browser.refreshTree(targetTree);
                }
            }
        }
        catch (MungeException me) {
            if (!this.isCancelled() && !error) {
                msg = this.context.cfg.gs("Browser.error") + me.getMessage();
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
            error = true;
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            if (!this.isCancelled() && !error) {
                int reply = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("Browser.error") + this.context.browser.navTransferHandler.getOperationText(this.action, true) + ": " + e.toString() + "\n\n" + this.context.cfg.gs("NavTransferHandler.continue"), this.context.cfg.getNavigatorName(), 0, 0);
                if (reply == 1) {
                    error = true;
                }
            }
            error = true;
        }
        return error;
    }

    private class Batch {
        public int action;
        public ArrayList<NavTreeUserObject> transferData;
        public JTree targetTree;
        public NavTreeUserObject targetTuo;
        public long batchSize;

        public Batch(NavTransferWorker navTransferWorker, int act, ArrayList<NavTreeUserObject> td, JTree target, NavTreeUserObject tuo, long size) {
            this.action = act;
            this.transferData = td;
            this.targetTree = target;
            this.targetTuo = tuo;
            this.batchSize = size;
        }
    }
}

