/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.browser.BrowserTableModel;
import com.corionis.els.gui.browser.NavTreeModel;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.repository.Repository;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultRowSorter;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NavTreeNode
extends DefaultMutableTreeNode {
    private final boolean traceActions = false;
    public Context context;
    public SortFoldersBeforeFiles sortFoldersBeforeFiles;
    public SortTreeAlphabetically sortTreeAlphabetically;
    private boolean forceReload = false;
    private boolean loaded = false;
    private Repository myRepo;
    private JLabel myStatus;
    private JTable myTable;
    private JTree myTree;
    private boolean refresh = true;
    private boolean shown = true;
    private transient Logger logger = LogManager.getLogger("applog");

    private NavTreeNode() {
    }

    public NavTreeNode(Context context, Repository repo, JTree tree) {
        this.context = context;
        this.myRepo = repo;
        this.myTree = tree;
        this.allowsChildren = true;
        this.shown = true;
        this.sortTreeAlphabetically = new SortTreeAlphabetically();
        this.sortFoldersBeforeFiles = new SortFoldersBeforeFiles(this);
        if (tree.getName().equalsIgnoreCase("treeCollectionOne")) {
            this.myTable = context.mainFrame.tableCollectionOne;
            this.myStatus = context.mainFrame.labelStatusLeft;
        } else if (tree.getName().equalsIgnoreCase("treeSystemOne")) {
            this.myTable = context.mainFrame.tableSystemOne;
            this.myStatus = context.mainFrame.labelStatusLeft;
        } else if (tree.getName().equalsIgnoreCase("treeCollectionTwo")) {
            this.myTable = context.mainFrame.tableCollectionTwo;
            this.myStatus = context.mainFrame.labelStatusRight;
        } else if (tree.getName().equalsIgnoreCase("treeSystemTwo")) {
            this.myTable = context.mainFrame.tableSystemTwo;
            this.myStatus = context.mainFrame.labelStatusRight;
        }
    }

    public ArrayList<NavTreeUserObject> addChildUserObjectsToList(ArrayList<NavTreeUserObject> list) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            NavTreeNode child = (NavTreeNode)this.getChildAt(i, false, false);
            NavTreeUserObject tuo = child.getUserObject();
            list.add(tuo);
            if (!tuo.isDir) continue;
            list = child.addChildUserObjectsToList(list);
        }
        return list;
    }

    @Override
    public Object clone() {
        NavTreeNode object = new NavTreeNode(this.context, this.myRepo, this.myTree);
        object.loaded = this.loaded;
        object.refresh = this.refresh;
        object.shown = this.shown;
        NavTreeUserObject tuo = (NavTreeUserObject)this.getUserObject().clone();
        tuo.node = this;
        object.setUserObject(tuo);
        return object;
    }

    public int deepGetFileCount() {
        int count = 0;
        int childCount = this.getChildCount(false, false);
        for (int i = 0; i < childCount; ++i) {
            NavTreeNode child = (NavTreeNode)this.getChildAt(i, false, false);
            NavTreeUserObject tuo = child.getUserObject();
            if (!tuo.isDir) {
                ++count;
                continue;
            }
            count += child.deepGetFileCount();
        }
        return count;
    }

    public long deepGetFileSize() {
        long size = 0L;
        int childCount = this.getChildCount(false, false);
        for (int i = 0; i < childCount; ++i) {
            NavTreeNode child = (NavTreeNode)this.getChildAt(i, false, false);
            NavTreeUserObject tuo = child.getUserObject();
            if (!tuo.isDir) {
                size += tuo.size;
                continue;
            }
            size += child.deepGetFileSize();
        }
        return size;
    }

    public void deepScanChildren(boolean recursive) {
        List<NavTreeNode> nodeArray = this.scan(recursive);
        this.setChildren(nodeArray, false);
    }

    public int findChildIndex(NavTreeNode find, boolean hideFilesInTreeFilterActive, boolean hideHiddenFilterActive) {
        if (this.children == null) {
            return 0;
        }
        int index = -1;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            boolean sense = true;
            NavTreeNode node = (NavTreeNode)e.nextElement();
            if (hideFilesInTreeFilterActive && this.context.preferences.isHideFilesInTree() && !node.isVisible()) {
                sense = false;
            }
            if (hideHiddenFilterActive && this.context.preferences.isHideHiddenFiles() && node.getUserObject().isHidden) {
                sense = false;
            }
            if (!sense) continue;
            ++index;
            if (node != find) continue;
            return index;
        }
        return index > 0 ? index : 0;
    }

    public NavTreeNode findChildName(String name) {
        return this.findChildName(name, 1);
    }

    public NavTreeNode findChildName(String name, int occurrence) {
        NavTreeNode ntn = null;
        if (this.children != null) {
            int count = 0;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                boolean match;
                NavTreeNode node = (NavTreeNode)e.nextElement();
                NavTreeUserObject tuo = node.getUserObject();
                boolean sensitive = node.getMyRepo().getLibraryData().libraries.case_sensitive;
                boolean bl = match = sensitive ? tuo.name.equals(name) : tuo.name.equalsIgnoreCase(name);
                if (match) {
                    if (++count != occurrence) continue;
                    ntn = node;
                    break;
                }
                if (count <= 0) continue;
                break;
            }
        }
        return ntn;
    }

    public NavTreeNode findChildTuoPath(String path, boolean recursive) {
        NavTreeNode value = null;
        int childCount = this.getChildCount(false, false);
        for (int i = 0; i < childCount; ++i) {
            NavTreeNode child;
            NavTreeNode node = (NavTreeNode)this.getChildAt(i, false, false);
            if (path.equalsIgnoreCase(node.getUserObject().getPath())) {
                value = node;
                break;
            }
            if (!recursive || node.getChildCount(false, false) <= 0 || (child = node.findChildTuoPath(path, recursive)) == null) continue;
            value = child;
            break;
        }
        return value;
    }

    public TreeNode getChildAt(int index, boolean hideFilesInTreeFilterActive, boolean hideHiddenFilterActive) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int realIndex = -1;
        int visibleIndex = -1;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            boolean sense = true;
            NavTreeNode node = (NavTreeNode)e.nextElement();
            if (hideFilesInTreeFilterActive && this.context.preferences.isHideFilesInTree() && !node.isVisible()) {
                sense = false;
            }
            if (hideHiddenFilterActive && this.context.preferences.isHideHiddenFiles() && node.getUserObject().isHidden) {
                sense = false;
            }
            if (sense) {
                ++visibleIndex;
            }
            ++realIndex;
            if (visibleIndex != index) continue;
            TreeNode child = (TreeNode)this.children.elementAt(realIndex);
            return child;
        }
        return this;
    }

    public int getChildCount(boolean hideFilesInTreeFilterActive, boolean hideHiddenFilterActive) {
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            boolean sense = true;
            NavTreeNode node = (NavTreeNode)e.nextElement();
            if (hideFilesInTreeFilterActive && this.context.preferences.isHideFilesInTree() && !node.isVisible()) {
                sense = false;
            }
            if (hideHiddenFilterActive && this.context.preferences.isHideHiddenFiles() && node.getUserObject().isHidden) {
                sense = false;
            }
            if (!sense) continue;
            ++count;
        }
        return count;
    }

    public Repository getMyRepo() {
        return this.myRepo;
    }

    public JLabel getMyStatus() {
        return this.myStatus;
    }

    public JTable getMyTable() {
        return this.myTable;
    }

    public JTree getMyTree() {
        return this.myTree;
    }

    public TreePath getTreePath() {
        ArrayList<NavTreeNode> nodes = new ArrayList<NavTreeNode>();
        nodes.add(this);
        for (NavTreeNode treeNode = (NavTreeNode)this.getParent(); treeNode != null; treeNode = (NavTreeNode)treeNode.getParent()) {
            nodes.add(0, treeNode);
        }
        return nodes.isEmpty() ? null : new TreePath(nodes.toArray());
    }

    @Override
    public NavTreeUserObject getUserObject() {
        return (NavTreeUserObject)this.userObject;
    }

    public int indexInTable() {
        int index = -1;
        if (this.myTable != null) {
            for (int row = 0; row < this.myTable.getRowCount(); ++row) {
                NavTreeUserObject tuo = (NavTreeUserObject)this.myTable.getValueAt(row, 1);
                if (tuo != this.getUserObject()) continue;
                index = row;
                break;
            }
        }
        return index;
    }

    public boolean isForceReload() {
        return this.forceReload;
    }

    @Override
    public boolean isLeaf() {
        NavTreeUserObject tuo = this.getUserObject();
        if (tuo != null) {
            return !tuo.isDir;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public boolean isVisible() {
        return this.shown;
    }

    public SwingWorker<List<NavTreeNode>, Void> loadChildren(final boolean doLoadTable) {
        if (this.context.fault || !this.isRefresh()) {
            return null;
        }
        SwingWorker<List<NavTreeNode>, Void> worker = new SwingWorker<List<NavTreeNode>, Void>(){
            NavTreeUserObject myTuo;
            List<NavTreeNode> nodeArray;

            @Override
            protected List<NavTreeNode> doInBackground() throws Exception {
                this.myTuo = NavTreeNode.this.getUserObject();
                this.nodeArray = NavTreeNode.this.scan(false);
                return this.nodeArray;
            }

            @Override
            protected void done() {
                try {
                    if (this.myTuo.type != 1 && this.myTuo.type != 7) {
                        NavTreeNode.this.setChildren((List)this.get(), doLoadTable);
                    }
                    NavTreeModel model = (NavTreeModel)NavTreeNode.this.myTree.getModel();
                    model.nodeStructureChanged(NavTreeNode.this);
                    NavTreeNode.this.myTable.updateUI();
                    NavTreeNode.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(NavTreeNode.this.context.mainFrame, NavTreeNode.this.context.cfg.gs("NavTreeNode.swing.worker.fault.during.get.of") + ((NavTreeNode)NavTreeNode.this.parent).getTreePath().toString() + ", " + NavTreeNode.this.context.subscriberRepo.getLibraryData().libraries.description + "  ", NavTreeNode.this.context.cfg.getNavigatorName(), 0);
                    NavTreeNode.this.logger.error(Utils.getStackTrace(e));
                    NavTreeNode.this.context.fault = true;
                    NavTreeNode.this.context.navigator.stop();
                }
                super.done();
            }
        };
        worker.execute();
        return worker;
    }

    protected void loadProperties() {
        if (this.myRepo != null) {
            NavTreeUserObject tuo;
            if (this.myStatus != null) {
                int count = this.getChildCount(false, true);
                this.myStatus.setText(Utils.formatInteger(count) + " " + (this.myRepo.isPublisher() ? this.context.cfg.gs("Z.publisher") : this.context.cfg.gs("Z.subscriber")) + (count > 1 ? this.context.cfg.gs("NavTreeNode.items") : this.context.cfg.gs("NavTreeNode.item")));
            }
            if ((tuo = this.getUserObject()) != null) {
                this.context.mainFrame.textFieldLocation.setText(tuo.getDisplayPath());
                this.context.browser.propertiesPrint(tuo);
            }
        }
    }

    public void loadTable() {
        BrowserTableModel btm = (BrowserTableModel)this.myTable.getModel();
        btm.setNode(this);
        DefaultRowSorter sorter = (DefaultRowSorter)this.myTable.getRowSorter();
        btm.getDataVector().removeAllElements();
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        if (!btm.isInitialized() && btm.getColumnCount() > 0) {
            this.context.preferences.fixColumnSizes(this.context, this.myTable);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            RowSorter.SortKey sortkey = new RowSorter.SortKey(1, SortOrder.ASCENDING);
            sortKeys.add(sortkey);
            sorter.setSortKeys(sortKeys);
            btm.setInitialized(true);
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            sorter.sort();
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.context.preferences.fixColumnSizes(this.context, this.myTable);
        }
        btm.fireTableDataChanged();
        this.loadProperties();
    }

    protected List<NavTreeNode> scan(boolean recursive) {
        String path = "undefined";
        ArrayList<NavTreeNode> nodeArray = new ArrayList<NavTreeNode>();
        NavTreeUserObject myTuo = this.getUserObject();
        try {
            switch (myTuo.type) {
                case 0: {
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (!myTuo.isDir) break;
                    if (myTuo.isRemote) {
                        path = this.context.cfg.getFullPathSubscriber(myTuo.getPath());
                        this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.remote.drive") + path);
                        this.scanRemote(myTuo, path, nodeArray, recursive);
                        break;
                    }
                    path = Utils.getFullPathLocal(myTuo.getPath());
                    this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.local.drive") + path);
                    this.scanLocal(new File(path), nodeArray, recursive);
                    break;
                }
                case 4: {
                    File file = new File(Utils.getFullPathLocal(myTuo.getPath()));
                    if (!file.isDirectory()) break;
                    path = file.getPath();
                    this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.home.directory") + path);
                    this.scanLocal(file, nodeArray, recursive);
                    break;
                }
                case 5: {
                    if (myTuo.sources == null || myTuo.sources.length <= 0) break;
                    for (String source : myTuo.sources) {
                        if (myTuo.isRemote) {
                            path = this.context.cfg.getFullPathSubscriber(source);
                            this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.remote.library") + path);
                            this.scanRemote(myTuo, path, nodeArray, recursive);
                            continue;
                        }
                        path = Utils.getFullPathLocal(source);
                        this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.local.library") + path);
                        this.scanLocal(new File(path), nodeArray, recursive);
                    }
                    break;
                }
                case 6: {
                    if (!myTuo.isDir) break;
                    if (myTuo.isRemote) {
                        path = myTuo.getPath();
                        this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.remote.directory") + path);
                        this.scanRemote(myTuo, path, nodeArray, recursive);
                        break;
                    }
                    path = myTuo.file.getPath();
                    this.logger.info(this.context.cfg.gs("NavTreeNode.scanning.local.directory") + path);
                    this.scanLocal(myTuo.file, nodeArray, recursive);
                }
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("NavTreeNode.could.not.retrieve.listing.from") + this.context.subscriberRepo.getLibraryData().libraries.description + ", " + path;
            this.logger.error(msg);
            this.context.fault = true;
            JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
        }
        return nodeArray;
    }

    protected void scanLocal(File file, List<NavTreeNode> nodeArray, boolean recursive) {
        if (file.isDirectory()) {
            File[] files = FileSystemView.getFileSystemView().getFiles(file, Utils.isOsMac());
            this.logger.info(Utils.formatInteger(files.length) + this.context.cfg.gs("NavTreeNode.received.entries.from") + file.getPath());
            for (File entry : files) {
                NavTreeNode node = new NavTreeNode(this.context, this.myRepo, this.myTree);
                NavTreeUserObject tuo = new NavTreeUserObject(node, entry.getName(), file.getPath(), entry);
                node.setNavTreeUserObject(tuo);
                if (!entry.isDirectory()) {
                    node.setVisible(false);
                } else if (recursive) {
                    node.deepScanChildren(recursive);
                    node.setLoaded(true);
                }
                nodeArray.add(node);
            }
        }
    }

    protected void scanRemote(NavTreeUserObject myTuo, String directory, List<NavTreeNode> nodeArray, boolean recursive) throws Exception {
        this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        Vector listing = this.context.clientSftp.listDirectory(directory);
        if (directory.matches("^\\\\[a-zA-Z]:.*") || directory.matches("^/[a-zA-Z]:.*")) {
            directory = directory.substring(1);
        }
        if (directory.endsWith("/") || directory.endsWith("\\")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        int count = 0;
        for (int i = 0; i < listing.size(); ++i) {
            String longname;
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)listing.get(i);
            if (entry.getFilename().equals(".") || entry.getFilename().equals("..") || (longname = entry.getLongname()).matches("(?i).*OWNER\\@.*GROUP\\@.*") || longname.matches("(?i).*Administrators.*BUILTIN.*") || longname.matches("(?i).*NTUSER\\.DAT.*") || longname.matches("(?i).*TrustedInstaller.*NT SERVICE.*") && !entry.getFilename().toLowerCase().startsWith("program files") && !entry.getFilename().toLowerCase().equals("windows") || entry.getFilename().equalsIgnoreCase("$Recycle.Bin") || entry.getFilename().equalsIgnoreCase("$SysReset") || entry.getFilename().equalsIgnoreCase("$WINRE_BACKUP_PARTITION.MARKER") || entry.getFilename().equals("BOOTNXT") || entry.getFilename().equals("Documents and Settings") || entry.getFilename().equals("DumpStack.log.tmp") || entry.getFilename().equals("pagefile.sys") || entry.getFilename().equals("PerfLogs") || entry.getFilename().equals("ProgramData") || entry.getFilename().equals("swapfile.sys") || entry.getFilename().equals("System Volume Information") || entry.getFilename().equals(".DS_Store")) continue;
            String path = Utils.pipe(directory + this.context.subscriberRepo.getSeparator() + entry.getFilename());
            path = Utils.unpipe(this.myRepo, path);
            SftpATTRS attr = entry.getAttrs();
            NavTreeNode node = new NavTreeNode(this.context, this.myRepo, this.myTree);
            NavTreeUserObject tuo = new NavTreeUserObject(node, entry.getFilename(), path, attr.getSize(), attr.getMTime(), attr.isDir());
            node.setNavTreeUserObject(tuo);
            if (!attr.isDir()) {
                node.setVisible(false);
            } else if (recursive) {
                node.deepScanChildren(recursive);
                node.setLoaded(true);
            }
            nodeArray.add(node);
            ++count;
        }
        this.logger.info(Utils.formatInteger(count) + this.context.cfg.gs("NavTreeNode.received.entries.from") + myTuo.getDisplayPath());
        this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void selectMe() {
        this.myTree.requestFocus();
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.setSelectionPath(this.getTreePath());
        this.myTree.scrollPathToVisible(this.getTreePath());
    }

    public void selectMyTab() {
        int index = 0;
        JTabbedPane tabbedPane = null;
        switch (this.myTree.getName()) {
            case "treeCollectionOne": {
                tabbedPane = this.context.mainFrame.tabbedPaneBrowserOne;
                break;
            }
            case "treeSystemOne": {
                index = 1;
                tabbedPane = this.context.mainFrame.tabbedPaneBrowserOne;
                break;
            }
            case "treeCollectionTwo": {
                tabbedPane = this.context.mainFrame.tabbedPaneBrowserTwo;
                break;
            }
            case "treeSystemTwo": {
                index = 1;
                tabbedPane = this.context.mainFrame.tabbedPaneBrowserTwo;
            }
        }
        tabbedPane.setSelectedIndex(index);
    }

    protected void setChildren(List<NavTreeNode> children, boolean doLoadTable) {
        if (children != null) {
            this.removeAllChildren();
            Collections.sort(children, this.sortTreeAlphabetically);
            if (this.context.preferences.isSortFoldersBeforeFiles()) {
                Collections.sort(children, this.sortFoldersBeforeFiles);
            }
            this.setAllowsChildren(this.getUserObject().isDir);
            for (NavTreeNode ntn : children) {
                if (!ntn.getUserObject().isDir) {
                    ntn.setLoaded(true);
                }
                this.add(ntn);
            }
        }
        this.setLoaded(true);
        if (doLoadTable) {
            this.loadTable();
        }
    }

    public void setForceReload(boolean forceReload) {
        this.forceReload = forceReload;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
        if (this.loaded) {
            this.setForceReload(false);
            this.setRefresh(false);
        }
    }

    public void setMyRepo(Repository myRepo) {
        this.myRepo = myRepo;
    }

    public void setMyStatus(JLabel myStatus) {
        this.myStatus = myStatus;
    }

    public void setMyTable(JTable myTable) {
        this.myTable = myTable;
    }

    public void setMyTree(JTree myTree) {
        this.myTree = myTree;
    }

    public void setNavTreeUserObject(NavTreeUserObject ntuo) {
        this.setUserObject(ntuo);
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setVisible(boolean visible) {
        this.shown = visible;
    }

    public void sort() {
        if (this.children != null) {
            this.children.sort(this.sortTreeAlphabetically);
            if (this.context.preferences.isSortFoldersBeforeFiles()) {
                this.children.sort(this.sortFoldersBeforeFiles);
            }
            for (Object child : this.children) {
                NavTreeNode node = (NavTreeNode)child;
                if (!node.getUserObject().isDir) continue;
                node.sort();
            }
        }
    }

    class SortTreeAlphabetically
    implements Comparator<Object> {
        SortTreeAlphabetically() {
        }

        @Override
        public int compare(Object a, Object b) {
            if (NavTreeNode.this.context.preferences.isSortReverse()) {
                if (NavTreeNode.this.context.preferences.isSortCaseInsensitive()) {
                    return ((NavTreeNode)b).getUserObject().name.compareToIgnoreCase(((NavTreeNode)a).getUserObject().name);
                }
                return ((NavTreeNode)b).getUserObject().name.compareTo(((NavTreeNode)a).getUserObject().name);
            }
            if (NavTreeNode.this.context.preferences.isSortCaseInsensitive()) {
                return ((NavTreeNode)a).getUserObject().name.compareToIgnoreCase(((NavTreeNode)b).getUserObject().name);
            }
            return ((NavTreeNode)a).getUserObject().name.compareTo(((NavTreeNode)b).getUserObject().name);
        }
    }

    class SortFoldersBeforeFiles
    implements Comparator<Object> {
        SortFoldersBeforeFiles(NavTreeNode this$0) {
        }

        @Override
        public int compare(Object a, Object b) {
            return ((NavTreeNode)a).getUserObject().isDir && !((NavTreeNode)b).getUserObject().isDir ? -1 : 0;
        }
    }
}

