/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Utils;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public class NavTreeUserObject
implements Comparable {
    public static final int BOOKMARKS = 0;
    public static final int COLLECTION = 1;
    public static final int COMPUTER = 2;
    public static final int DRIVE = 3;
    public static final int HOME = 4;
    public static final int LIBRARY = 5;
    public static final int REAL = 6;
    public static final int SYSTEM = 7;
    public String name = "";
    public String path = "";
    public int type = 6;
    public boolean isDir = false;
    public boolean isRemote = false;
    public File file;
    public FileTime fileTime;
    public boolean isHidden = false;
    public int mtime;
    public NavTreeNode node;
    public long size = -1L;
    public String[] sources = null;

    private NavTreeUserObject() {
    }

    public NavTreeUserObject(NavTreeNode ntn, String name, int type, boolean remote) {
        this.node = ntn;
        this.name = name;
        this.isDir = true;
        this.isRemote = remote;
        this.type = type;
    }

    public NavTreeUserObject(NavTreeNode ntn, String name, String path, File file) {
        this.node = ntn;
        this.name = name;
        this.file = file;
        this.path = file.getPath();
        this.fileTime = Utils.getLocalFileTime(this.path);
        this.isDir = file.isDirectory();
        this.isHidden = file.isHidden();
        this.isRemote = false;
        this.type = 6;
        try {
            this.size = Files.size(file.toPath());
        }
        catch (Exception e) {
            this.size = -1L;
        }
    }

    public NavTreeUserObject(NavTreeNode ntn, String name, String[] sources, boolean remote) {
        this.node = ntn;
        this.name = name;
        this.sources = (String[])sources.clone();
        this.isDir = true;
        this.isRemote = remote;
        this.type = 5;
    }

    public NavTreeUserObject(NavTreeNode ntn, String name, String path, int type, boolean remote) {
        this.node = ntn;
        this.name = name;
        this.path = path;
        this.isDir = true;
        this.isRemote = remote;
        this.type = type;
    }

    public NavTreeUserObject(NavTreeNode ntn, String name, String path, long size, int mtime, boolean isDir) {
        this.node = ntn;
        this.name = name;
        this.path = path.startsWith("//") ? path.substring(1) : path;
        this.size = size;
        this.mtime = mtime;
        this.fileTime = mtime < 0 ? FileTime.fromMillis(System.currentTimeMillis()) : FileTime.from(mtime, TimeUnit.SECONDS);
        this.isDir = isDir;
        this.isHidden = name.startsWith(".");
        this.isRemote = true;
        this.type = 6;
    }

    public int compareTo(Object o) {
        NavTreeUserObject nto = (NavTreeUserObject)o;
        boolean thatDir = ((NavTreeUserObject)o).isDir;
        if (nto.node.context.preferences.isSortFoldersBeforeFiles()) {
            if (this.isDir && !thatDir) {
                return -1;
            }
            if (thatDir && !this.isDir) {
                return 1;
            }
        }
        if (nto.node.context.preferences.isSortCaseInsensitive()) {
            return this.name.compareToIgnoreCase(((NavTreeUserObject)o).name);
        }
        return this.name.compareTo(((NavTreeUserObject)o).name);
    }

    public Object clone() {
        NavTreeUserObject tuo = new NavTreeUserObject();
        tuo.file = this.file;
        tuo.fileTime = this.fileTime;
        tuo.isDir = this.isDir;
        tuo.isHidden = this.isHidden;
        tuo.mtime = this.mtime;
        tuo.name = this.name;
        tuo.node = this.node;
        tuo.path = this.path;
        tuo.isRemote = this.isRemote;
        tuo.size = this.size;
        tuo.sources = this.sources;
        tuo.type = this.type;
        return tuo;
    }

    public String getDisplayPath() {
        String path = this.getPath();
        if (this.node != null) {
            boolean isWindows;
            String os = this.node.getMyRepo().getLibraryData().libraries.flavor;
            boolean bl = isWindows = os.equalsIgnoreCase("windows");
            if (isWindows && path.length() > 1 && path.startsWith("/")) {
                path = path.substring(1);
                path = path.replaceAll("/", "\\\\");
                path = path.replaceAll("\\\\\\\\", "\\\\");
            }
        }
        return path;
    }

    public String getItemPath(String library, String path) {
        String itemPath;
        block6: {
            itemPath = "";
            try {
                Library lib = this.getRepo().getLibrary(library);
                if (lib == null) break block6;
                for (String source : lib.sources) {
                    String sourcePath;
                    if (Utils.isRelativePath(path)) {
                        sourcePath = source;
                    } else {
                        sourcePath = this.getRepo().getPurpose() == 1 ? Utils.getFullPathLocal(source) : this.node.context.cfg.getFullPathSubscriber(source);
                        if (sourcePath.matches("^\\\\[a-zA-Z]:.*") || sourcePath.matches("^/[a-zA-Z]:.*")) {
                            sourcePath = sourcePath.substring(1);
                        }
                    }
                    if (!path.startsWith(sourcePath)) continue;
                    itemPath = path.substring(sourcePath.length() + 1);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemPath;
    }

    public NavTreeNode getParentLibrary() {
        boolean found = false;
        NavTreeNode node = this.node;
        do {
            if (node.getUserObject().type != 5) continue;
            found = true;
            break;
        } while ((node = (NavTreeNode)node.getParent()) != null);
        if (!found) {
            node = null;
        }
        return node;
    }

    public String getPath() {
        switch (this.type) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.path;
            }
            case 4: {
                return this.path;
            }
            case 5: {
                return this.name;
            }
            case 6: {
                if (this.isRemote) {
                    return this.path;
                }
                return this.file.getPath();
            }
            case 7: {
                return this.name;
            }
        }
        return this.node.context.cfg.gs("NavTreeNode.unknown");
    }

    public String getRelativePath() {
        String path = this.getPath();
        if (this.type == 6) {
            path = this.node.getMyRepo().isPublisher() ? this.node.context.cfg.makeRelativePath(path) : this.node.context.cfg.makeRelativePathSubscriber(path);
        }
        return path;
    }

    public synchronized Repository getRepo() {
        Repository repo = null;
        if (this.node != null) {
            switch (this.node.getMyTree().getName()) {
                case "treeCollectionOne": 
                case "treeSystemOne": {
                    repo = this.node.context.publisherRepo;
                    break;
                }
                case "treeCollectionTwo": 
                case "treeSystemTwo": {
                    repo = this.node.context.subscriberRepo;
                }
            }
        }
        return repo;
    }

    public String getType() {
        String label = this.isRemote ? this.node.context.cfg.gs("Z.remote.uppercase") : this.node.context.cfg.gs("NavTreeNode.local");
        switch (this.type) {
            case 0: {
                return label + this.node.context.cfg.gs("NavTreeNode.bookmark");
            }
            case 1: {
                return label + this.node.context.cfg.gs("NavTreeNode.collection");
            }
            case 2: {
                return label + this.node.context.cfg.gs("NavTreeNode.computer");
            }
            case 3: {
                return label + this.node.context.cfg.gs("NavTreeNode.drive");
            }
            case 4: {
                return label + this.node.context.cfg.gs("NavTreeNode.home");
            }
            case 5: {
                return label + this.node.context.cfg.gs("NavTreeNode.library");
            }
            case 6: {
                return label + (this.isDir ? this.node.context.cfg.gs("NavTreeNode.directory") : this.node.context.cfg.gs("NavTreeNode.file"));
            }
            case 7: {
                return label + this.node.context.cfg.gs("NavTreeNode.system");
            }
        }
        return label + this.node.context.cfg.gs("NavTreeNode.unknown");
    }

    public String toString() {
        return this.name;
    }

    public boolean isSubscriber() {
        return this.node.getMyTree().getName().toLowerCase().endsWith("two");
    }
}

