/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.hints;

import com.corionis.els.Context;
import com.corionis.els.gui.hints.HintDate;
import com.corionis.els.gui.hints.HintsUI;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintStatus;
import com.corionis.els.repository.RepoMeta;
import com.corionis.els.repository.Repositories;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;

public class HintsTableModel
extends DefaultTableModel {
    private Context context;
    private HintsUI hintsUI;
    private ImageIcon iconGreen;
    private ImageIcon iconRed;
    private ImageIcon iconYellow;
    private Repositories repositories;

    private HintsTableModel() {
    }

    public HintsTableModel(Context context, Repositories repositories, HintsUI hintsUI) {
        this.context = context;
        this.repositories = repositories;
        this.hintsUI = hintsUI;
        this.iconGreen = this.getIcon("hint-green.png");
        this.iconGreen.setDescription(context.cfg.gs("HintsUI.status.done"));
        this.iconRed = this.getIcon("hint-red.png");
        this.iconRed.setDescription(context.cfg.gs("HintsUI.status.for"));
        this.iconYellow = this.getIcon("hint-yellow.png");
        this.iconYellow.setDescription(context.cfg.gs("HintsUI.status.unknown"));
    }

    private RepoMeta findRepoMeta(String key) {
        RepoMeta repoMeta = null;
        if (key != null && !key.isEmpty() && this.repositories.getMetaList() != null) {
            for (RepoMeta m : this.repositories.getMetaList()) {
                if (!m.key.equals(key)) continue;
                repoMeta = m;
                break;
            }
        }
        return repoMeta;
    }

    private ImageIcon getIcon(String name) {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            BufferedImage icon = ImageIO.read(url);
            ImageIcon image = new ImageIcon(icon);
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return HintDate.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
        }
        return ImageIcon.class;
    }

    @Override
    public int getColumnCount() {
        if (this.context.hintKeys != null) {
            return this.context.hintKeys.size() + 9;
        }
        return 9;
    }

    @Override
    public String getColumnName(int column) {
        Object name = "";
        switch (column) {
            case 0: {
                name = "";
                break;
            }
            case 1: {
                name = this.context.cfg.gs("HintsUI.header.system");
                break;
            }
            case 2: {
                name = this.context.cfg.gs("HintsUI.header.author");
                break;
            }
            case 3: {
                TimeZone timeZone = TimeZone.getDefault();
                SimpleDateFormat dateFormat = new SimpleDateFormat("z");
                String abbreviation = dateFormat.format(new Date());
                name = this.context.cfg.gs("HintsUI.header.utc") + " (" + abbreviation + ")";
                break;
            }
            case 4: {
                name = this.context.cfg.gs("HintsUI.header.action");
                break;
            }
            case 5: {
                name = this.context.cfg.gs("HintsUI.header.from.library");
                break;
            }
            case 6: {
                name = this.context.cfg.gs("HintsUI.header.from.item");
                break;
            }
            case 7: {
                name = this.context.cfg.gs("HintsUI.header.to.library");
                break;
            }
            case 8: {
                name = this.context.cfg.gs("HintsUI.header.to.item");
                break;
            }
            default: {
                HintKey hk = this.context.hintKeys.get().get(column - 9);
                String key = hk.uuid;
                RepoMeta meta = this.findRepoMeta(key);
                if (meta != null) {
                    name = meta.description;
                    break;
                }
                if (hk == null) break;
                name = hk.system;
            }
        }
        return name;
    }

    @Override
    public int getRowCount() {
        return this.hintsUI == null || this.hintsUI.hints == null ? 0 : this.hintsUI.hints.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object object = null;
        if (row < this.hintsUI.hints.size()) {
            Hint hint = this.hintsUI.hints.get(row);
            switch (column) {
                case 0: {
                    object = hint.selected;
                    break;
                }
                case 1: {
                    String system = hint.system;
                    HintKey hk = this.context.hintKeys.findSystem(system);
                    if (hk == null) break;
                    RepoMeta meta = this.findRepoMeta(hk.uuid);
                    if (meta != null) {
                        object = meta.description;
                        break;
                    }
                    object = hk.system;
                    break;
                }
                case 2: {
                    object = hint.author;
                    break;
                }
                case 3: {
                    object = new HintDate(this.context, hint.utc);
                    break;
                }
                case 4: {
                    object = hint.action.trim().toLowerCase().equals("mv") ? this.context.cfg.gs("HintsUI.action.move") : this.context.cfg.gs("HintsUI.action.delete");
                    break;
                }
                case 5: {
                    object = hint.fromLibrary;
                    break;
                }
                case 6: {
                    object = hint.fromItemPath;
                    break;
                }
                case 7: {
                    object = hint.toLibrary;
                    break;
                }
                case 8: {
                    object = hint.toItemPath;
                    break;
                }
                default: {
                    String stat;
                    HintStatus hs = null;
                    if (column - 9 < this.context.hintKeys.get().size()) {
                        hs = hint.findStatus(this.context.hintKeys.get().get((int)(column - 9)).system);
                    }
                    String string = stat = hs != null ? hs.status.trim().toLowerCase() : "for";
                    object = stat.equals("done") ? this.iconGreen : (stat.equals("fault") ? this.iconYellow : this.iconRed);
                }
            }
        }
        return object;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        if (object instanceof Boolean) {
            Hint hint = this.hintsUI.hints.get(row);
            hint.selected = (Boolean)object;
            int count = this.context.navigator.dialogHints.setButtons();
            this.context.navigator.dialogHints.labelStatus.setText(count + this.context.cfg.gs("HintsUI.hints.selected"));
        }
    }
}

