/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.jobs;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.Generator;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.util.RotatedIcon;
import com.corionis.els.gui.util.TextIcon;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Jobs;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Origins;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.RepoMeta;
import com.corionis.els.repository.Repositories;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.Tools;
import com.corionis.els.tools.operations.OperationsTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobsUI
extends AbstractToolDialog {
    private static final int CACHED_LAST_TASK = 0;
    private static final int ANY_PUBLISHER = 1;
    private static final int SPECIFIC_PUBLISHER = 2;
    private static final int ANY_SUBSCRIBER = 3;
    private static final int LOCAL = 4;
    private static final int REMOTE_CUSTOM = 8;
    private static final int REMOTE_HOST = 5;
    private static final int REMOTE_LISTEN = 6;
    private static final int PUBLISHER = 7;
    private ConfigModel configModel;
    private Context context;
    private Job currentJob = null;
    private Task currentTask = null;
    private AbstractTool currentTool = null;
    private Jobs jobsHandler = null;
    private Logger logger = LogManager.getLogger("applog");
    private NavHelp helpDialog;
    private boolean isDryRun;
    private ArrayList<ArrayList<Origin>> originsArray = null;
    private Repositories repositories = null;
    private ArrayList<Origin> savedOrigins = null;
    private ArrayList<AbstractTool> toolList;
    private SwingWorker<Void, Void> worker;
    public JPanel dialogPane;
    public JPanel contentPanel;
    public JPanel panelTop;
    public JPanel panelTopButtons;
    public JButton buttonNew;
    public JButton buttonCopy;
    public JButton buttonDelete;
    public JPanel hSpacerBeforeRun;
    public JButton buttonRun;
    public JPanel hSpacerBeforeGenerate;
    public JButton buttonGenerate;
    public JPanel panelHelp;
    public JLabel labelHelp;
    public JSplitPane splitPaneContent;
    public JScrollPane scrollPaneConfig;
    public JTable configItems;
    public JPanel panelJob;
    public JSplitPane splitPaneToolsOrigin;
    public JPanel panelTasks;
    public JLabel labelTasks;
    public JScrollPane scrollPaneTasks;
    public JList listTasks;
    public JPanel panelOrigin;
    public JLabel labelSpacer;
    public JLabel labelOrigins;
    public JPanel panelOriginInstance;
    public JPanel panelPubSub;
    public JLabel labelPub;
    public JButton buttonPub;
    public JLabel labelSub;
    public JButton buttonSub;
    public JLabel labelHints;
    public JButton buttonHints;
    public JLabel labelEmail;
    public JButton buttonEmail;
    public JScrollPane scrollPaneOrigins;
    public JList listOrigins;
    public JPanel panelOriginsButtons;
    public JButton buttonAddOrigin;
    public JButton buttonOriginUp;
    public JButton buttonOriginDown;
    public JButton buttonRemoveOrigin;
    public JPanel panelToolButtons;
    public JButton buttonAddTask;
    public JButton buttonTaskUp;
    public JButton buttonTaskDown;
    public JButton buttonRemoveTask;
    public JPanel buttonBar;
    public JButton saveButton;
    public JButton cancelButton;

    public JobsUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        TextIcon t1 = new TextIcon(this.buttonTaskUp, ">", TextIcon.Layout.HORIZONTAL);
        this.buttonTaskUp.setText("");
        RotatedIcon r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.UP);
        this.buttonTaskUp.setIcon(r1);
        t1 = new TextIcon(this.buttonTaskDown, ">", TextIcon.Layout.HORIZONTAL);
        this.buttonTaskDown.setText("");
        r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.DOWN);
        this.buttonTaskDown.setIcon(r1);
        t1 = new TextIcon(this.buttonOriginUp, ">", TextIcon.Layout.HORIZONTAL);
        this.buttonOriginUp.setText("");
        r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.UP);
        this.buttonOriginUp.setIcon(r1);
        t1 = new TextIcon(this.buttonOriginDown, ">", TextIcon.Layout.HORIZONTAL);
        this.buttonOriginDown.setText("");
        r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.DOWN);
        this.buttonOriginDown.setIcon(r1);
        if (context.preferences.getJobsXpos() != -1 && Utils.isOnScreen(context.preferences.getJobsXpos(), context.preferences.getJobsYpos())) {
            this.setLocation(context.preferences.getJobsXpos(), context.preferences.getJobsYpos());
            Dimension dim = new Dimension(context.preferences.getJobsWidth(), context.preferences.getJobsHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        this.splitPaneContent.setDividerLocation(context.preferences.getJobsTaskDividerLocation());
        this.splitPaneToolsOrigin.setDividerLocation(context.preferences.getJobsOriginDividerLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.configModel = new ConfigModel(context, this);
        this.configModel.setColumnCount(1);
        this.configModel.setJobsConfigModel(this.configModel);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel sm = (ListSelectionModel)listSelectionEvent.getSource();
                    int index = sm.getMinSelectionIndex();
                    JobsUI.this.loadTasks(index);
                }
            }
        });
        this.panelPubSub.setBorder(context.mainFrame.scrollPaneTableCollectionOne.getBorder());
        this.repositories = this.getRepositories();
        this.loadConfigurations();
        context.navigator.enableDisableToolMenus(this, false);
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.context.navigator.isWorkerRunning() && this.currentJob != null) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("JobsUI.stop.currently.running.job"), this.context.cfg.gs("Z.cancel.run"), 0);
            if (reply == 0) {
                this.currentJob.requestStop();
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Job.config.cancelled"), this.currentJob.getConfigName()));
            }
        } else if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            Job origJob = (Job)this.configModel.getValueAt(index, 0);
            String rename = origJob.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                Job job = origJob.clone();
                job.setConfigName(rename);
                job.setDataHasChanged();
                this.configModel.addRow(new Object[]{job});
                this.loadTasks(this.configModel.getRowCount() - 1);
                this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
                this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.context.cfg.gs("JobsUI.title"), 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            Job job = (Job)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + job.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(job.getConfigName(), null, job.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(job.getFullPath());
                    if (file.exists()) {
                        job.setDataHasChanged();
                        this.deletedTools.add(job);
                    }
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    this.configModel.fireTableDataChanged();
                    if (index >= 0) {
                        this.configItems.changeSelection(index, 0, false, false);
                        this.loadTasks(index);
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionEmailServerClicked(ActionEvent e) {
        if (this.currentTask != null) {
            ArrayList<Object> emailToolList = new ArrayList();
            String title = this.context.cfg.gs("JobsUI.combo.select.email");
            JComboBox<String> comboBoxEmailServer = new JComboBox<String>();
            Tools tools = new Tools();
            try {
                emailToolList = tools.loadAllTools(this.context, "Email");
                comboBoxEmailServer.addItem("None");
                for (AbstractTool abstractTool : emailToolList) {
                    comboBoxEmailServer.addItem(abstractTool.getConfigName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentTask.getEmailTool().length() == 0) {
                comboBoxEmailServer.setSelectedIndex(0);
            } else {
                comboBoxEmailServer.setSelectedItem(this.currentTask.getEmailTool());
            }
            Object[] params = new Object[]{title, comboBoxEmailServer};
            int n = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("JobsUI.title"), 2);
            if (n == 0) {
                String sel = comboBoxEmailServer.getSelectedItem().toString();
                this.labelEmail.setText(sel);
                if (sel.equalsIgnoreCase("None")) {
                    sel = "";
                }
                this.currentTask.setEmailTool(sel);
                this.currentJob.setDataHasChanged();
            }
        }
    }

    private void actionGenerateClicked(ActionEvent evt) {
        Generator generator = new Generator(this.context, false);
        generator.showDialog(this, this.currentJob, this.currentJob.getConfigName());
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("JobsUI.help"), "jobs_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNewClicked(ActionEvent evt) {
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            Job job = new Job(this.context, this.context.cfg.gs("Z.untitled"));
            job.setDataHasChanged();
            this.configModel.addRow(new Object[]{job});
            this.currentJob = job;
            this.loadTasks(-1);
            if (!this.buttonAddOrigin.isEnabled()) {
                this.buttonCopy.setEnabled(true);
                this.buttonDelete.setEnabled(true);
                this.buttonGenerate.setEnabled(true);
                this.buttonTaskUp.setEnabled(true);
                this.buttonTaskDown.setEnabled(true);
                this.buttonAddTask.setEnabled(true);
                this.buttonRemoveTask.setEnabled(true);
            }
            this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
            this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
            this.configItems.getEditorComponent().requestFocus();
            ((JTextField)this.configItems.getEditorComponent()).selectAll();
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.context.cfg.gs("JobsUI.title"), 2);
        }
    }

    private void actionOriginAddClicked(ActionEvent evt) {
        if (this.currentTask != null) {
            ArrayList<Origin> origins = new ArrayList<Origin>();
            try {
                boolean isSubscriber = Origins.makeOriginsFromSelected(this.context, this, origins);
                if (origins != null && origins.size() > 0) {
                    this.listOrigins.requestFocus();
                    int count = origins.size();
                    String which = isSubscriber ? this.context.cfg.gs("Z.subscriber") : this.context.cfg.gs("Z.publisher");
                    String message = MessageFormat.format(this.context.cfg.gs("JobsUI.add.N.origins"), count, which);
                    int reply = JOptionPane.showConfirmDialog(this, message, this.context.cfg.gs("JobsUI.title"), 0);
                    if (reply == 0) {
                        for (Origin origin : origins) {
                            origin.setLocation(this.context.cfg.makeRelativePathSubscriber(origin.getLocation()));
                        }
                        this.currentTask.addOrigins(origins);
                        this.currentJob.setDataHasChanged();
                        this.loadOrigins(this.currentTask);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void actionOriginDownClicked(ActionEvent e) {
        ArrayList<Origin> orgs;
        int index;
        int[] indices = this.listOrigins.getSelectedIndices();
        if (indices.length == 1 && (index = indices[0]) < (orgs = this.currentTask.getOrigins()).size() - 1) {
            this.listOrigins.requestFocus();
            Origin o1 = orgs.get(index).clone();
            Origin o2 = orgs.get(index + 1).clone();
            orgs.set(index + 1, o1);
            orgs.set(index, o2);
            this.currentTask.setOrigins(orgs);
            this.currentJob.setDataHasChanged();
            this.loadOrigins(this.currentTask);
            this.listOrigins.setSelectedIndex(index + 1);
        }
    }

    private void actionOriginRemoveClicked(ActionEvent e) {
        int[] indices;
        if (this.currentTask != null && (indices = this.listOrigins.getSelectedIndices()).length > 0) {
            this.listOrigins.requestFocus();
            int count = indices.length;
            String message = MessageFormat.format(this.context.cfg.gs("JobsUI.remove.N.origins"), count);
            int reply = JOptionPane.showConfirmDialog(this, message, this.context.cfg.gs("JobsUI.title"), 0);
            if (reply == 0) {
                Arrays.sort(indices);
                ArrayList<Origin> orgs = this.currentTask.getOrigins();
                for (int i = indices.length - 1; i >= 0; --i) {
                    orgs.remove(indices[i]);
                }
                this.currentTask.setOrigins(orgs);
                this.currentJob.setDataHasChanged();
                this.loadOrigins(this.currentTask);
            }
        }
    }

    private void actionOriginUpClicked(ActionEvent e) {
        int[] indices = this.listOrigins.getSelectedIndices();
        if (indices.length == 1) {
            int index = indices[0];
            ArrayList<Origin> orgs = this.currentTask.getOrigins();
            if (index > 0) {
                this.listOrigins.requestFocus();
                Origin o1 = orgs.get(index).clone();
                Origin o2 = orgs.get(index - 1).clone();
                orgs.set(index - 1, o1);
                orgs.set(index, o2);
                this.currentTask.setOrigins(orgs);
                this.currentJob.setDataHasChanged();
                this.loadOrigins(this.currentTask);
                this.listOrigins.setSelectedIndex(index - 1);
            }
        }
    }

    public void actionPubSubClicked(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (this.currentTask != null) {
            int opt;
            int taskIndex;
            boolean anySelected = false;
            final JComboBox<ComboItem> combo = new JComboBox<ComboItem>();
            final JTextField customAddress = new JTextField();
            final JLabel customLabel = new JLabel();
            JPanel customPanel = new JPanel(new BorderLayout());
            int id = 0;
            String key = "";
            String path = "";
            int selectedCombo = -1;
            int selectedList = -1;
            String cachedName = "";
            Object text = null;
            String title = null;
            String tip = null;
            Vector<String> vector = new Vector<String>();
            final Vector<Repository> vectorRepositories = new Vector<Repository>();
            if (this.currentTask.isToolCachedOrigins(this.context) && (taskIndex = this.findTaskIndex(this.currentTask.getConfigName())) >= 0 && (cachedName = this.findCachedLastTask(this.currentJob, taskIndex)).length() > 0) {
                combo.addItem(new ComboItem(this, id++, this.context.cfg.gs("JobsUI.cached.task") + cachedName, 0));
                if (this.currentTask.getPublisherKey().equals("_CACHEDLASTTASK_")) {
                    selectedCombo = id - 1;
                }
            }
            if (command.equals("buttonPub")) {
                if (this.currentTool.isToolPubOrSub()) {
                    title = this.context.cfg.gs("JobsUI.combo.select.publisher.or.subscriber");
                    tip = this.context.cfg.gs("JobsUI.select.publisher.or.subscriber.tooltip");
                } else {
                    title = this.context.cfg.gs("JobsUI.combo.select.publisher");
                    tip = this.context.cfg.gs("JobsUI.select.publisher.tooltip");
                }
            } else if (command.equals("buttonSub")) {
                title = this.context.cfg.gs("JobsUI.combo.select.subscriber");
                tip = this.context.cfg.gs("JobsUI.select.subscriber.tooltip");
            } else if (command.equals("buttonHints")) {
                title = this.context.cfg.gs("JobsUI.combo.select.hints");
                tip = this.context.cfg.gs("JobsUI.select.hint.tooltip");
            }
            combo.setToolTipText(tip);
            if (command.equals("buttonPub") || this.currentTool.isToolPubOrSub()) {
                combo.addItem(new ComboItem(this, id++, this.context.cfg.gs("JobsUI.any.publisher"), 1));
                if (this.currentTask.getPublisherKey().equals("_ANY_SERVER_") || this.currentTask.getPublisherKey().isEmpty()) {
                    selectedCombo = id - 1;
                    anySelected = true;
                }
                combo.addItem(new ComboItem(this, id++, this.context.cfg.gs("JobsUI.publisher.specific"), 2));
                if (this.currentTask.getPublisherKey().length() > 0 && !this.currentTask.getPublisherKey().equals("_ANY_SERVER_") && !this.currentTask.getPublisherKey().equals("_CACHEDLASTTASK_")) {
                    selectedCombo = id - 1;
                    anySelected = false;
                    RepoMeta repoMeta = this.repositories.findMetaPath(this.currentTask.publisherPath);
                    if (repoMeta != null) {
                        path = repoMeta.path;
                    }
                }
            }
            if (command.equals("buttonSub") || this.currentTool.isToolPubOrSub()) {
                if (this.currentTool.isToolPublisher() && (!this.currentTask.getInternalName().equals("Operations") || this.currentTask.getInternalName().equals("Operations") && !((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.SubscriberQuit) && !((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.Terminal))) {
                    combo.addItem(new ComboItem(this, id++, this.context.cfg.gs("JobsUI.any.subscriber"), 3));
                    if (this.currentTask.getSubscriberKey().equals("_ANY_SERVER_")) {
                        selectedCombo = id - 1;
                        anySelected = true;
                    }
                    text = this.context.cfg.gs("JobsUI.subscriber.local");
                    combo.addItem(new ComboItem(this, id++, (String)text, 4));
                }
                if (!this.currentTask.getInternalName().equals("Operations") || !((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.Listener)) {
                    text = this.context.cfg.gs("JobsUI.subscriber.remote.server");
                    combo.addItem(new ComboItem(this, id++, (String)text, 5));
                }
                text = this.context.cfg.gs("JobsUI.subscriber.remote.listen");
                combo.addItem(new ComboItem(this, id++, (String)text, 6));
                text = this.context.cfg.gs("JobsUI.subscriber.remote.custom");
                combo.addItem(new ComboItem(this, id++, (String)text, 8));
                if (this.currentTask.getSubscriberKey().length() > 0 && !this.currentTask.getSubscriberKey().equals("_ANY_SERVER_") && !this.currentTask.getPublisherKey().equals("_CACHEDLASTTASK_")) {
                    selectedCombo = id - 4;
                    RepoMeta repoMeta = this.repositories.findMetaPath(this.currentTask.subscriberPath);
                    if (repoMeta != null) {
                        if (this.currentTask.isSubscriberRemote()) {
                            selectedCombo = this.currentTask.getSubscriberOverride().trim().length() == 0 ? id - 3 : (this.currentTask.getSubscriberOverride().trim().equals("true") ? id - 2 : id - 1);
                        }
                        path = repoMeta.path;
                        anySelected = false;
                    }
                }
            }
            if (command.equals("buttonHints")) {
                RepoMeta repoMeta;
                if (this.currentTask.getInternalName().equals("Operations") && ((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.Publisher)) {
                    text = this.context.cfg.gs("JobsUI.hints.local.tracker");
                    combo.addItem(new ComboItem(this, id++, (String)text, 4));
                    if (!this.currentTask.isHintsRemote()) {
                        selectedCombo = id - 1;
                    }
                }
                if (!this.currentTask.getInternalName().equals("Operations") || !((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.HintServer)) {
                    text = this.context.cfg.gs("JobsUI.hints.remote.server");
                    combo.addItem(new ComboItem(this, id++, (String)text, 5));
                    if (this.currentTask.isHintsRemote() && !this.currentTask.isHintsOverrideHost()) {
                        selectedCombo = id - 1;
                    }
                }
                text = this.context.cfg.gs("JobsUI.hints.remote.listen");
                combo.addItem(new ComboItem(this, id++, (String)text, 6));
                if (this.currentTask.isHintsRemote() && this.currentTask.isHintsOverrideHost()) {
                    selectedCombo = id - 1;
                }
                if ((repoMeta = this.repositories.findMetaPath(this.currentTask.hintsPath)) != null) {
                    path = repoMeta.path;
                }
            }
            if (selectedCombo < 0) {
                selectedCombo = 0;
            }
            int vi = -1;
            for (int i = 0; i < this.repositories.getRepoList().size(); ++i) {
                Repository repo = this.repositories.getRepoList().get(i);
                if (repo.isDynamic()) continue;
                text = repo.getLibraryData().libraries.description;
                if (repo.getLibraryData().libraries.listen.equals(repo.getLibraryData().libraries.host)) {
                    text = (String)text + " *";
                }
                vector.add((String)text);
                vectorRepositories.add(repo);
                ++vi;
                if (!repo.getJsonFilename().equals(path)) continue;
                selectedList = vi;
            }
            final JList list = new JList(vector){

                @Override
                public String getToolTipText(MouseEvent me) {
                    Object tip = "";
                    int index = this.locationToIndex(me.getPoint());
                    if (index >= 0 && index < vectorRepositories.size()) {
                        Repository repo = (Repository)vectorRepositories.get(index);
                        tip = JobsUI.this.context.cfg.gs("Navigator.labelHostInternet.text");
                        tip = (String)tip + " " + repo.getLibraryData().libraries.host + "\n";
                        tip = (String)tip + JobsUI.this.context.cfg.gs("Navigator.labelListenLan.text");
                        tip = (String)tip + " " + repo.getLibraryData().libraries.listen;
                    }
                    return tip;
                }
            };
            if (selectedList >= 0) {
                list.setSelectedIndex(selectedList);
            }
            if (anySelected) {
                list.setEnabled(false);
            }
            combo.setSelectedIndex(selectedCombo);
            JPanel customObject = null;
            customAddress.setToolTipText(this.context.cfg.gs("Navigator.menu.Open.valid.port.tooltip"));
            if (command.equals("buttonPub") || command.equals("buttonSub") || this.currentTool.isToolPubOrSub()) {
                combo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String cmd = actionEvent.getActionCommand();
                        if (cmd.equals("comboBoxChanged")) {
                            int selected = combo.getSelectedIndex();
                            ComboItem item = (ComboItem)combo.getItemAt(selected);
                            if (item.type == 0 || item.type == 1 || item.type == 3) {
                                list.setEnabled(false);
                            } else {
                                list.setEnabled(true);
                                int s = list.getSelectedIndex();
                                if (s < 0) {
                                    list.setSelectedIndex(0);
                                }
                            }
                            customLabel.setEnabled(item.type == 8);
                            customAddress.setEnabled(item.type == 8);
                            if (item.type == 8 && customAddress.getText().isEmpty()) {
                                String override = JobsUI.this.currentTask.subscriberOverride;
                                if (override.trim().equals("true")) {
                                    override = "";
                                }
                                if (override.isEmpty()) {
                                    override = JobsUI.this.context.preferences.getLastOverrideSubscriber();
                                }
                                if (override.trim().equals("true")) {
                                    override = "";
                                }
                                customAddress.setText(override);
                                customAddress.requestFocus();
                            }
                        }
                    }
                });
                if (command.equals("buttonSub")) {
                    ComboItem item = (ComboItem)combo.getItemAt(selectedCombo);
                    customLabel.setEnabled(item.type == 8);
                    customAddress.setEnabled(item.type == 8);
                    customLabel.setText(this.context.cfg.gs("Navigator.labelCustom.text"));
                    if (item.type == 8) {
                        String override = this.currentTask.subscriberOverride;
                        if (override.isEmpty()) {
                            override = this.context.preferences.getLastOverrideSubscriber();
                        }
                        if (override.trim().equals("true")) {
                            override = "";
                        }
                        customAddress.setText(override);
                    }
                    customPanel.add((Component)customLabel, "West");
                    customPanel.add((Component)customAddress, "Center");
                    customObject = customPanel;
                }
            }
            String comment = this.context.cfg.gs("JobsUI.list.comment");
            JScrollPane pane = new JScrollPane();
            pane.setViewportView(list);
            list.requestFocus();
            Object[] params = new Object[]{title, combo, pane, comment, customObject};
            while ((opt = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("JobsUI.title"), 2)) == 0) {
                int selected = combo.getSelectedIndex();
                ComboItem item = (ComboItem)combo.getItemAt(selected);
                if (item.type == 0) {
                    key = "_CACHEDLASTTASK_";
                    this.savedOrigins = this.currentTask.getOrigins() != null && this.currentTask.getOrigins().size() > 0 ? this.currentTask.getOrigins() : null;
                    this.currentTask.setOrigins(new ArrayList<Origin>());
                } else if (item.type == 1 || item.type == 3) {
                    key = "_ANY_SERVER_";
                    if (this.savedOrigins != null) {
                        this.currentTask.setOrigins(this.savedOrigins);
                    }
                } else {
                    int index;
                    if (this.savedOrigins != null) {
                        this.currentTask.setOrigins(this.savedOrigins);
                    }
                    if ((index = list.getSelectedIndex()) < 0) {
                        String msg = this.currentTool.isToolPublisher() ? this.context.cfg.gs("JobsUI.select.publisher.tooltip") : (this.currentTool.isToolSubscriber() ? this.context.cfg.gs("JobsUI.select.subscriber.tooltip") : (this.currentTool.isToolPubOrSub() ? this.context.cfg.gs("JobsUI.select.publisher.or.subscriber.tooltip") : this.context.cfg.gs("JobsUI.select.hint.tooltip")));
                        JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 1);
                        continue;
                    }
                    Repository repo = (Repository)vectorRepositories.get(index);
                    key = repo.getLibraryData().libraries.key;
                    path = repo.getJsonFilename();
                }
                if (command.equals("buttonSub") || this.currentTool.isToolPubOrSub()) {
                    if (item.type == 5 || item.type == 6 || item.type == 8) {
                        if (!this.currentTask.isSubscriberRemote()) {
                            this.currentTask.setSubscriberRemote(true);
                            this.currentJob.setDataHasChanged();
                        }
                        if (item.type == 5) {
                            if (!this.currentTask.getSubscriberOverride().isEmpty()) {
                                this.currentJob.setDataHasChanged();
                                this.currentTask.setSubscriberOverride("");
                            }
                        } else if (!this.currentTask.getSubscriberOverride().trim().equals("true") && item.type == 6) {
                            this.currentTask.setSubscriberOverride("true");
                            this.currentJob.setDataHasChanged();
                        } else if ((this.currentTask.getSubscriberOverride().isEmpty() || this.currentTask.getSubscriberOverride().trim().equals("true") || !this.currentTask.getSubscriberOverride().trim().equals(customAddress.getText())) && item.type == 8) {
                            boolean bad = false;
                            if (customAddress.getText().isEmpty()) {
                                bad = true;
                            } else {
                                String host = Utils.parseHost(customAddress.getText());
                                String port = Utils.parsePort(customAddress.getText());
                                int p = -1;
                                if (!port.isEmpty()) {
                                    p = Integer.parseInt(port);
                                }
                                if (host.isEmpty() || p < 1 || p > 65535) {
                                    bad = true;
                                }
                            }
                            if (bad) {
                                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Navigator.menu.Open.valid.port"), this.context.cfg.gs("JobsUI.title"), 1);
                                continue;
                            }
                            this.context.preferences.setLastOverrideSubscriber(customAddress.getText());
                            this.currentTask.setSubscriberOverride(customAddress.getText());
                            this.currentJob.setDataHasChanged();
                        }
                    } else {
                        if (this.currentTask.isSubscriberRemote()) {
                            this.currentTask.setSubscriberRemote(false);
                            this.currentJob.setDataHasChanged();
                        }
                        if (!this.currentTask.getSubscriberOverride().isEmpty()) {
                            this.currentTask.setSubscriberOverride("");
                            this.currentJob.setDataHasChanged();
                        }
                    }
                }
                if (command.equals("buttonHints")) {
                    if (item.type == 4) {
                        if (this.currentTask.isHintsRemote()) {
                            this.currentTask.setHintsRemote(false);
                            this.currentJob.setDataHasChanged();
                        }
                        if (this.currentTask.isHintsOverrideHost()) {
                            this.currentTask.setHintsOverrideHost(false);
                            this.currentJob.setDataHasChanged();
                        }
                    } else if (item.type == 5 || item.type == 6) {
                        if (!this.currentTask.isHintsRemote()) {
                            this.currentTask.setHintsRemote(true);
                            this.currentJob.setDataHasChanged();
                        }
                        if (!this.currentTask.isHintsOverrideHost() && item.type == 6) {
                            this.currentTask.setHintsOverrideHost(true);
                            this.currentJob.setDataHasChanged();
                        } else if (this.currentTask.isHintsOverrideHost() && item.type == 5) {
                            this.currentTask.setHintsOverrideHost(false);
                            this.currentJob.setDataHasChanged();
                        }
                    } else {
                        if (this.currentTask.isHintsRemote()) {
                            this.currentTask.setHintsRemote(false);
                            this.currentJob.setDataHasChanged();
                        }
                        if (this.currentTask.isHintsOverrideHost()) {
                            this.currentTask.setHintsOverrideHost(false);
                            this.currentJob.setDataHasChanged();
                        }
                    }
                }
                if (item.type == 0) {
                    if (this.doesNotMatch(this.currentTask.getPublisherKey(), key) || !this.currentTask.getPublisherPath().equals(path)) {
                        this.currentTask.setPublisherKey(key);
                        this.currentTask.setPublisherPath("");
                        this.currentTask.setSubscriberKey("");
                        this.currentTask.setSubscriberPath("");
                        this.currentJob.setDataHasChanged();
                    }
                } else if (this.currentTool.isToolPubOrSub()) {
                    if (item.type == 1 || item.type == 2) {
                        if (this.doesNotMatch(this.currentTask.getPublisherKey(), key) || !this.currentTask.getPublisherPath().equals(path)) {
                            this.currentTask.setPublisherKey(key);
                            if (item.type == 1) {
                                this.currentTask.setPublisherPath("");
                            } else {
                                this.currentTask.setPublisherPath(path);
                            }
                            this.currentTask.setSubscriberKey("");
                            this.currentTask.setSubscriberPath("");
                            this.currentJob.setDataHasChanged();
                        }
                    } else if (!(item.type != 3 && item.type != 4 && item.type != 5 && item.type != 6 || !this.doesNotMatch(this.currentTask.getSubscriberKey(), key) && this.currentTask.getSubscriberPath().equals(path))) {
                        this.currentTask.setSubscriberKey(key);
                        if (item.type == 3) {
                            this.currentTask.setSubscriberPath("");
                        } else {
                            this.currentTask.setSubscriberPath(path);
                        }
                        this.currentTask.setPublisherKey("");
                        this.currentTask.setPublisherPath("");
                        this.currentJob.setDataHasChanged();
                    }
                } else if (command.equals("buttonPub")) {
                    if (this.doesNotMatch(this.currentTask.getPublisherKey(), key) || !this.currentTask.getPublisherPath().equals(path)) {
                        this.currentTask.setPublisherKey(key);
                        this.currentTask.setPublisherPath(path);
                        this.currentJob.setDataHasChanged();
                    }
                } else if (command.equals("buttonSub")) {
                    if (this.doesNotMatch(this.currentTask.getSubscriberKey(), key) || !this.currentTask.getSubscriberPath().equals(path)) {
                        this.currentTask.setSubscriberKey(key);
                        this.currentTask.setSubscriberPath(path);
                        this.currentJob.setDataHasChanged();
                    }
                } else if (command.equals("buttonHints") && (this.doesNotMatch(this.currentTask.getHintsKey(), key) || !this.currentTask.getHintsPath().equals(path))) {
                    this.currentTask.setHintsKey(key);
                    this.currentTask.setHintsPath(path);
                    this.currentJob.setDataHasChanged();
                }
                if (this.currentTask.getHintsKey() == null || this.currentTask.getHintsKey().isEmpty()) {
                    this.currentTask.setHintsKey("");
                }
                this.loadOrigins(this.currentTask);
                break;
            }
        }
    }

    private void actionRunClicked(ActionEvent evt) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            Job job = (Job)this.configModel.getValueAt(index, 0);
            if (job.isDataChanged()) {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.save.then.run"), this.context.cfg.gs("JobsUI.title"), 2);
                return;
            }
            this.processJob(job);
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        if (this.saveConfigurations()) {
            this.savePreferences();
            this.setVisible(false);
        }
    }

    private void actionTaskAddClicked(ActionEvent evt) {
        if (this.currentJob != null) {
            this.listTasks.requestFocus();
            String message = this.context.cfg.gs("JobsUI.select.tool");
            JList toolJList = new JList();
            try {
                ArrayList<String> toolNames = new ArrayList<String>();
                for (AbstractTool abstractTool : this.toolList) {
                    boolean deleted = false;
                    for (int i = 0; i < this.deletedTools.size(); ++i) {
                        if (!abstractTool.getFullPath().equals(((AbstractTool)this.deletedTools.get(i)).getFullPath())) continue;
                        deleted = true;
                        break;
                    }
                    if (deleted) continue;
                    toolNames.add(abstractTool.getListName());
                }
                Collections.sort(toolNames);
                DefaultListModel<String> dialogList = new DefaultListModel<String>();
                for (String name : toolNames) {
                    dialogList.addElement(name);
                }
                toolJList.setModel(dialogList);
                toolJList.setSelectionMode(0);
                toolJList.setSelectedIndex(0);
            }
            catch (Exception e) {
                String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 0);
                return;
            }
            JScrollPane pane = new JScrollPane();
            pane.setViewportView(toolJList);
            toolJList.requestFocus();
            Object[] params = new Object[]{message, pane};
            int n = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("JobsUI.title"), 2);
            if (n == 0) {
                int index;
                String name = (String)toolJList.getSelectedValue();
                for (index = 0; index < this.toolList.size() && !name.equals(this.toolList.get(index).getListName()); ++index) {
                }
                AbstractTool tool = this.toolList.get(index);
                if (index >= 0) {
                    this.currentTask = new Task(tool.getInternalName(), tool.getConfigName());
                    this.currentTask.setContext(this.context);
                    try {
                        this.currentTool = this.currentTask.getTool();
                    }
                    catch (Exception e) {
                        String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
                        this.logger.error(msg);
                        JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 0);
                    }
                    this.currentJob.getTasks().add(this.currentTask);
                    this.currentJob.setDataHasChanged();
                    this.loadTasks(-1);
                    this.listTasks.setSelectedIndex(this.currentJob.getTasks().size() - 1);
                    this.loadOrigins(this.currentTask);
                } else {
                    this.listTasks.requestFocus();
                }
            } else {
                this.listTasks.requestFocus();
            }
        }
    }

    private void actionTaskDownClicked(ActionEvent e) {
        ArrayList<Task> orgs;
        int index;
        int[] indices = this.listTasks.getSelectedIndices();
        if (indices.length == 1 && (index = indices[0]) < (orgs = this.currentJob.getTasks()).size() - 1) {
            this.listTasks.requestFocus();
            Task o1 = orgs.get(index).clone();
            Task o2 = orgs.get(index + 1).clone();
            orgs.set(index + 1, o1);
            orgs.set(index, o2);
            this.currentJob.setTasks(orgs);
            this.currentJob.setDataHasChanged();
            this.loadTasks(-1);
            this.listTasks.setSelectedIndex(index + 1);
        }
    }

    private void actionTaskRemoveClicked(ActionEvent e) {
        int[] indices;
        if (this.currentJob != null && (indices = this.listTasks.getSelectedIndices()).length > 0) {
            this.listTasks.requestFocus();
            int count = indices.length;
            String message = MessageFormat.format(this.context.cfg.gs("JobsUI.remove.N.tasks"), count);
            int reply = JOptionPane.showConfirmDialog(this, message, this.context.cfg.gs("JobsUI.title"), 0);
            if (reply == 0) {
                Arrays.sort(indices);
                ArrayList<Task> orgs = this.currentJob.getTasks();
                for (int i = indices.length - 1; i >= 0; --i) {
                    orgs.remove(indices[i]);
                }
                this.currentJob.setTasks(orgs);
                this.currentJob.setDataHasChanged();
                this.loadTasks(-1);
            }
        }
    }

    private void actionTaskUpClicked(ActionEvent e) {
        int[] indices = this.listTasks.getSelectedIndices();
        if (indices.length == 1) {
            int index = indices[0];
            ArrayList<Task> orgs = this.currentJob.getTasks();
            if (index > 0) {
                this.listTasks.requestFocus();
                Task o1 = orgs.get(index).clone();
                Task o2 = orgs.get(index - 1).clone();
                orgs.set(index - 1, o1);
                orgs.set(index, o2);
                this.currentJob.setTasks(orgs);
                this.currentJob.setDataHasChanged();
                this.loadTasks(-1);
                this.listTasks.setSelectedIndex(index - 1);
            }
        }
    }

    public void cancelChanges() {
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((Job)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((Job)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private void configItemsMouseClicked(MouseEvent e) {
    }

    private boolean doesNotMatch(String value, String compare) {
        boolean sense = true;
        if (value != null && !value.isEmpty() && compare != null && !compare.isEmpty() && value.equals(compare)) {
            sense = false;
        }
        return sense;
    }

    private void enableDisableOrigins(boolean sense) {
        this.buttonAddOrigin.setEnabled(sense);
        this.buttonOriginUp.setEnabled(sense);
        this.buttonOriginDown.setEnabled(sense);
        this.buttonRemoveOrigin.setEnabled(sense);
    }

    private String findCachedLastTask(Job job, int index) {
        String name = "";
        if (job.getTasks().size() > 0) {
            for (int j = index - 1; j >= 0; --j) {
                Task task = job.getTasks().get(j);
                if (task.isJob()) {
                    Job subJob = this.findJob(task.getConfigName());
                    if (subJob != null) {
                        name = this.findCachedLastTask(subJob, subJob.getTasks().size());
                    }
                    if (name.length() <= 0) continue;
                    break;
                }
                if (!task.isToolCachedOrigins(this.context) || task == this.currentTask) continue;
                name = task.getConfigName();
                break;
            }
        }
        return name;
    }

    private Job findJob(String name) {
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            Job job = (Job)this.configModel.getValueAt(i, 0);
            if (!job.getConfigName().equals(name)) continue;
            return job;
        }
        return null;
    }

    private int findJobIndex(String name) {
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            Job job = (Job)this.configModel.getValueAt(i, 0);
            if (!job.getConfigName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private Task findTask(String name) {
        for (int i = 0; i < this.currentJob.getTasks().size(); ++i) {
            Task task = this.currentJob.getTasks().get(i);
            if (!task.getConfigName().equals(name)) continue;
            task.setContext(this.context);
            return task;
        }
        return null;
    }

    private int findTaskIndex(String name) {
        for (int i = 0; i < this.currentJob.getTasks().size(); ++i) {
            Task task = this.currentJob.getTasks().get(i);
            if (!task.getConfigName().equals(name)) continue;
            task.setContext(this.context);
            return i;
        }
        return -1;
    }

    private AbstractTool findTool(Task task) {
        for (int i = 0; i < this.toolList.size(); ++i) {
            AbstractTool tool = this.toolList.get(i);
            if (!task.getConfigName().equals(tool.getConfigName())) continue;
            return tool;
        }
        return null;
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    public String getFullPath(Job job) {
        String path = job.getDirectoryPath() + System.getProperty("file.separator") + Utils.scrubFilename(job.getConfigName()) + ".json";
        return path;
    }

    public String getOriginType(int type) {
        switch (type) {
            case 0: {
                return this.context.cfg.gs("NavTreeNode.bookmark");
            }
            case 1: {
                return this.context.cfg.gs("NavTreeNode.collection");
            }
            case 2: {
                return this.context.cfg.gs("NavTreeNode.computer");
            }
            case 3: {
                return this.context.cfg.gs("NavTreeNode.drive");
            }
            case 4: {
                return this.context.cfg.gs("NavTreeNode.home");
            }
            case 5: {
                return this.context.cfg.gs("NavTreeNode.library");
            }
            case 6: {
                return "";
            }
            case 7: {
                return this.context.cfg.gs("NavTreeNode.system");
            }
        }
        return this.context.cfg.gs("NavTreeNode.unknown");
    }

    public Repositories getRepositories() {
        Repositories repositories = null;
        try {
            repositories = new Repositories();
            repositories.loadList(this.context);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 0);
        }
        return repositories;
    }

    private void listTasksMouseClicked(MouseEvent e) {
        int taskIndex;
        JList src = (JList)e.getSource();
        if (e.getClickCount() == 1 && (taskIndex = src.locationToIndex(e.getPoint())) >= 0) {
            this.loadOrigins(this.currentJob.getTasks().get(taskIndex));
        }
    }

    private void listTasksValueChanged(ListSelectionEvent e) {
        int taskIndex;
        if (!e.getValueIsAdjusting() && (taskIndex = this.listTasks.getSelectedIndex()) >= 0) {
            this.savedOrigins = null;
            this.loadOrigins(this.currentJob.getTasks().get(taskIndex));
        }
    }

    private void loadConfigurations() {
        try {
            this.jobsHandler = new Jobs(this.context);
            this.toolList = this.jobsHandler.loadAllJobs();
            this.toolList = this.context.tools.loadAllTools(this.context, null, this.toolList);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 0);
        }
        this.configModel.setToolList(this.toolList);
        this.configModel.loadJobsConfigurations(this, this.configModel);
        if (this.configModel.getRowCount() == 0) {
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonGenerate.setEnabled(false);
            this.buttonTaskUp.setEnabled(false);
            this.buttonTaskDown.setEnabled(false);
            this.buttonAddTask.setEnabled(false);
            this.buttonRemoveTask.setEnabled(false);
            this.enableDisableOrigins(false);
        } else {
            this.loadTasks(0);
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
            if (this.currentJob.getTasks().size() > 0) {
                this.listTasks.setSelectedIndex(0);
            }
        }
        this.context.navigator.loadJobsMenu();
    }

    private void loadEmpty() {
        this.labelPub.setVisible(false);
        this.buttonPub.setVisible(false);
        this.labelSub.setVisible(false);
        this.buttonSub.setVisible(false);
        this.labelHints.setVisible(false);
        this.buttonHints.setVisible(false);
        this.enableDisableOrigins(false);
    }

    private void loadTasks(int jobIndex) {
        DefaultListModel<CallSite> model = new DefaultListModel<CallSite>();
        this.savedOrigins = null;
        if (jobIndex < this.configModel.getRowCount()) {
            if (jobIndex >= 0) {
                this.currentJob = (Job)this.configModel.getValueAt(jobIndex, 0);
            }
            if (this.currentJob.getTasks() != null && this.currentJob.getTasks().size() > 0) {
                for (int i = 0; i < this.currentJob.getTasks().size(); ++i) {
                    Task task = this.currentJob.getTasks().get(i);
                    task.setContext(this.context);
                    Object i18n = task.getInternalName() + ".displayName";
                    i18n = this.context.cfg.gs((String)i18n);
                    if (((String)i18n).length() == 0) {
                        i18n = task.getInternalName();
                    }
                    String id = (String)i18n + ": " + task.getConfigName();
                    model.addElement((CallSite)((Object)id));
                }
                this.loadOrigins(this.currentJob.getTasks().get(0));
            }
        }
        if (this.currentJob.getTasks().size() == 0) {
            DefaultListModel omodel = new DefaultListModel();
            this.listOrigins.setModel(omodel);
            this.loadEmpty();
        }
        this.listTasks.setModel(model);
        if (model.size() > 0) {
            this.listTasks.setSelectedIndex(0);
        }
        if (model.size() == 0) {
            this.buttonAddTask.setEnabled(true);
            this.buttonTaskUp.setEnabled(false);
            this.buttonTaskDown.setEnabled(false);
            this.buttonRemoveTask.setEnabled(false);
        } else {
            this.buttonAddTask.setEnabled(true);
            if (model.size() > 1) {
                this.buttonTaskUp.setEnabled(true);
                this.buttonTaskDown.setEnabled(true);
            } else {
                this.buttonTaskUp.setEnabled(false);
                this.buttonTaskDown.setEnabled(false);
            }
            if (model.size() > 0) {
                this.buttonRemoveTask.setEnabled(true);
            }
        }
    }

    private void loadOrigins(Task task) {
        boolean optionalEmail;
        String key = "";
        Object value = "";
        DefaultListModel<CallSite> model = new DefaultListModel<CallSite>();
        try {
            this.currentTask = task;
            this.currentTask.setContext(this.context);
            this.currentTool = this.currentTask.getTool();
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 0);
            return;
        }
        this.labelPub.setVisible(false);
        this.buttonPub.setVisible(false);
        this.labelSub.setVisible(false);
        this.buttonSub.setVisible(false);
        this.labelHints.setVisible(false);
        this.buttonHints.setVisible(false);
        this.labelEmail.setVisible(false);
        this.buttonEmail.setVisible(false);
        if (this.currentTool == null) {
            if (!this.currentTask.getInternalName().equals(Job.INTERNAL_NAME)) {
                this.labelPub.setVisible(true);
                this.labelPub.setText(this.context.cfg.gs("JobsUI.tool.not.found") + this.currentTask.getConfigName());
            }
            this.enableDisableOrigins(false);
            this.listOrigins.setModel(model);
            return;
        }
        boolean needPublisher = this.currentTask.getInternalName().equals("Operations") && ((OperationsTool)this.currentTool).isToolSubscriber() && ((OperationsTool)this.currentTool).getOptAuthKeys().isEmpty();
        boolean needSubscriber = false;
        boolean needHints = this.currentTask.getInternalName().equals("Operations") && (((OperationsTool)this.currentTool).isToolHintServer() || ((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.StatusQuit) || !((OperationsTool)this.currentTool).getOptKeys().isEmpty());
        boolean bl = optionalEmail = this.currentTask.getInternalName().equals("Operations") && (((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.Publisher) || ((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.Listener) || ((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.HintServer));
        if (needPublisher || this.currentTool.isToolPublisher()) {
            value = "";
            boolean isSub = false;
            this.labelPub.setVisible(true);
            key = this.currentTask.getPublisherKey();
            if (this.currentTool.isToolPubOrSub() && key.trim().length() == 0) {
                isSub = true;
                key = this.currentTask.getSubscriberKey();
            }
            if (key.trim().length() == 0) {
                if (this.currentTool.isToolPubOrSub()) {
                    value = this.context.cfg.gs("JobsUI.select.publisher.or.subscriber");
                } else {
                    value = this.context.cfg.gs("JobsUI.select.publisher");
                    needSubscriber = true;
                }
            } else if (key.equals("_ANY_SERVER_")) {
                if (!isSub) {
                    value = this.context.cfg.gs("JobsUI.any.publisher");
                    needSubscriber = true;
                } else {
                    value = this.context.cfg.gs("JobsUI.any.subscriber");
                }
            } else if (key.equals("_CACHEDLASTTASK_")) {
                String cachedName;
                String name = "";
                int taskIndex = this.findTaskIndex(this.currentTask.getConfigName());
                if (taskIndex >= 0 && (cachedName = this.findCachedLastTask(this.currentJob, taskIndex)).length() > 0) {
                    name = cachedName;
                }
                value = !name.isEmpty() ? this.context.cfg.gs("JobsUI.cached.task") + name : this.currentTask.getConfigName() + this.context.cfg.gs("JobsUI.cached.task.not.found");
            } else {
                RepoMeta repoMeta = this.repositories.findMetaAdd(this.context, key, !isSub ? this.currentTask.publisherPath : this.currentTask.subscriberPath, isSub ? 2 : 1);
                if (repoMeta != null) {
                    if (!isSub) {
                        value = this.context.cfg.gs("Z.publisher");
                        value = (String)value + ": " + repoMeta.description;
                        needSubscriber = true;
                    } else {
                        value = this.currentTask.isSubscriberRemote() ? this.context.cfg.gs("Z.remote.uppercase") : this.context.cfg.gs("Z.local.uppercase");
                        value = (String)value + this.context.cfg.gs("Z.subscriber");
                        value = (String)value + ": " + repoMeta.description;
                        if (this.currentTask.isSubscriberRemote()) {
                            value = this.currentTask.getSubscriberOverride().trim().isEmpty() ? (String)value + this.context.cfg.gs("Z.host") : (this.currentTask.getSubscriberOverride().trim().equals("true") ? (String)value + this.context.cfg.gs("Z.listen") : (String)value + " (" + this.context.cfg.gs(this.currentTask.getSubscriberOverride().trim()) + ")");
                        }
                    }
                } else {
                    value = (String)value + key + this.context.cfg.gs("Z.not.found");
                }
            }
            this.labelPub.setText((String)value);
            this.labelPub.setToolTipText((String)value);
            this.buttonPub.setVisible(true);
            value = this.currentTool.isToolPubOrSub() ? this.context.cfg.gs("JobsUI.select.publisher.or.subscriber.tooltip") : this.context.cfg.gs("JobsUI.select.publisher.tooltip");
            this.buttonPub.setToolTipText((String)value);
            if (needSubscriber && (this.currentTool.isToolPubOrSub() || this.currentTask.getInternalName().equals("Operations") && (((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.HintServer) || ((OperationsTool)this.currentTool).getCard().equals((Object)OperationsTool.Cards.StatusQuit)))) {
                needSubscriber = false;
            }
        }
        if (needSubscriber || this.currentTool.isToolSubscriber()) {
            value = "";
            this.labelSub.setVisible(true);
            key = this.currentTask.getSubscriberKey();
            if (key.trim().length() == 0) {
                value = this.context.cfg.gs("JobsUI.select.subscriber");
            } else if (key.equals("_ANY_SERVER_")) {
                value = this.context.cfg.gs("JobsUI.any.subscriber");
            } else {
                RepoMeta repoMeta = this.repositories.findMetaAdd(this.context, key, this.currentTask.getSubscriberPath(), 2);
                if (repoMeta != null) {
                    value = this.currentTask.isSubscriberRemote() ? this.context.cfg.gs("Z.remote.uppercase") : this.context.cfg.gs("Z.local.uppercase");
                    value = (String)value + this.context.cfg.gs("Z.subscriber");
                    value = (String)value + ": " + repoMeta.description;
                    if (this.currentTask.isSubscriberRemote()) {
                        value = this.currentTask.getSubscriberOverride().trim().isEmpty() ? (String)value + this.context.cfg.gs("Z.host") : (this.currentTask.getSubscriberOverride().trim().equals("true") ? (String)value + this.context.cfg.gs("Z.listen") : (String)value + " (" + this.context.cfg.gs(this.currentTask.getSubscriberOverride().trim()) + ")");
                    }
                } else {
                    value = (String)value + key + this.context.cfg.gs("Z.not.found");
                }
            }
            this.labelSub.setText((String)value);
            this.labelSub.setToolTipText((String)value);
            this.buttonSub.setVisible(true);
            value = this.context.cfg.gs("JobsUI.select.subscriber.tooltip");
            this.buttonSub.setToolTipText((String)value);
            if (this.currentTool.isToolSubscriber()) {
                needHints = false;
            }
        }
        if (needHints || this.currentTool.isToolHintServer()) {
            value = "";
            this.labelHints.setVisible(true);
            key = this.currentTask.getHintsKey();
            if (key.trim().length() == 0) {
                value = this.context.cfg.gs("JobsUI.select.hint");
            } else {
                RepoMeta repoMeta = this.repositories.findMetaAdd(this.context, key, this.currentTask.getSubscriberPath(), 3);
                if (repoMeta != null) {
                    if (this.currentTask.isHintsRemote() || this.currentTask.isHintsOverrideHost()) {
                        value = this.context.cfg.gs("Z.remote.uppercase");
                        value = (String)value + this.context.cfg.gs("Z.hint.server");
                    } else {
                        value = this.context.cfg.gs("Z.local.uppercase");
                        value = (String)value + this.context.cfg.gs("Z.hint.tracker");
                    }
                    value = (String)value + ": " + repoMeta.description;
                    if (this.currentTask.isHintsRemote() || this.currentTask.isHintsOverrideHost()) {
                        value = this.currentTask.isHintsOverrideHost() || this.currentTool.isToolHintServer() ? (String)value + this.context.cfg.gs("Z.listen") : (String)value + this.context.cfg.gs("Z.host");
                    }
                } else {
                    value = (String)value + key + this.context.cfg.gs("Z.not.found");
                }
            }
            this.labelHints.setText((String)value);
            this.labelHints.setToolTipText((String)value);
            this.buttonHints.setVisible(true);
            value = this.context.cfg.gs("JobsUI.select.hint.tooltip");
            this.buttonHints.setToolTipText((String)value);
        }
        if (optionalEmail) {
            String email = this.currentTask.getEmailTool();
            if (email.isEmpty()) {
                this.labelEmail.setText("None");
            } else {
                this.labelEmail.setText(email);
            }
            this.labelEmail.setVisible(true);
            this.buttonEmail.setVisible(true);
            this.buttonEmail.setToolTipText(email);
        }
        this.enableDisableOrigins(this.currentTool.isToolOriginsUsed());
        if (this.currentTool.isToolOriginsUsed() && this.currentTask.getOrigins().size() > 0) {
            for (int i = 0; i < this.currentTask.getOrigins().size(); ++i) {
                Origin origin = this.currentTask.getOrigins().get(i);
                String ot = this.getOriginType(origin.getType());
                String path = origin.getLocation();
                if (path.matches("^\\\\[a-zA-Z]:.*") || path.matches("^/[a-zA-Z]:.*")) {
                    path = path.substring(1);
                }
                String id = this.getOriginType(origin.getType()) + (ot.length() > 0 ? ": " : "") + path;
                model.addElement((CallSite)((Object)id));
            }
            if (this.listOrigins.getModel().getSize() > 0) {
                this.listOrigins.setSelectedIndex(0);
            }
        }
        this.listOrigins.setModel(model);
    }

    public void processJob(final Job job) {
        String status = job.validate(this.context.cfg, true);
        if (status.length() == 0) {
            String message = MessageFormat.format(this.context.cfg.gs("JobsUI.run.as.defined"), job.getConfigName());
            JCheckBox checkbox = new JCheckBox(this.context.cfg.gs("Navigator.dryrun"));
            checkbox.setToolTipText(this.context.cfg.gs("Navigator.dryrun.tooltip"));
            checkbox.setSelected(this.context.preferences.isDefaultDryrun());
            Object[] params = new Object[]{message, checkbox};
            int reply = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("JobsUI.title"), 0);
            this.isDryRun = checkbox.isSelected();
            if (reply == 0) {
                block10: {
                    try {
                        this.originsArray = Origins.makeAllOrigins(this.context, this.context.mainFrame);
                    }
                    catch (Exception e) {
                        if (e.getMessage().equals("HANDLED_INTERNALLY")) break block10;
                        String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                        if (this.context.navigator != null) {
                            this.logger.error(msg);
                            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("JobsUI.title"), 0);
                        }
                        this.logger.error(msg);
                    }
                }
                this.worker = job.process(this.context, this, this.getTitle(), job, this.isDryRun);
                if (this.worker != null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.context.navigator.disableComponent(true, this.getContentPane());
                    this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
                    this.context.mainFrame.menuItemFileQuit.setEnabled(true);
                    this.cancelButton.setEnabled(true);
                    this.cancelButton.setCursor(Cursor.getPredefinedCursor(0));
                    this.labelHelp.setEnabled(true);
                    this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
                    this.context.navigator.setBlockingProcessRunning(true);
                    this.context.navigator.setWorkerRunning(true);
                    this.context.navigator.disableGui(true);
                    this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                JobsUI.this.processTerminated(job);
                            }
                        }
                    });
                    this.worker.execute();
                    JScrollBar vertical = this.context.mainFrame.scrollPaneLog.getVerticalScrollBar();
                    vertical.setValue(vertical.getMaximum());
                    try {
                        this.logger.debug(this.context.cfg.gs("Jobs.waiting.for.job.thread.to.complete"));
                        this.worker.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.logger.debug(this.context.cfg.gs("Jobs.waiting.is.over.for.the.job.thread"));
                } else {
                    this.processTerminated(job);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, status, this.context.cfg.gs("JobsUI.title"), 2);
        }
    }

    private void processTerminated(Job job) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (!this.isDryRun) {
                if (job.usesPublisher() && this.context.publisherRepo != null) {
                    if (this.context.progress != null) {
                        this.context.progress.update(this.context.cfg.gs("Navigator.scanning.publisher"));
                    }
                    this.context.browser.deepScanCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false, false);
                    this.context.browser.deepScanSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false, false);
                }
                if (job.usesSubscriber() && this.context.subscriberRepo != null) {
                    if (this.context.progress != null) {
                        this.context.progress.update(this.context.cfg.gs("Navigator.scanning.subscriber"));
                    }
                    this.context.browser.deepScanCollectionTree(this.context.mainFrame.treeCollectionTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation(), false);
                    this.context.browser.deepScanSystemTree(this.context.mainFrame.treeSystemTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation(), false);
                }
            }
            if (this.context.progress != null) {
                this.context.progress.done();
                this.context.progress.dispose();
                this.context.progress = null;
            }
            if (this.originsArray != null && this.originsArray.size() == 8) {
                Origins.setAllOrigins(this.context, this.context.mainFrame, this.originsArray);
            }
            this.requestFocus();
            this.context.navigator.reconnectRemote(this.context, this.context.publisherRepo, this.context.subscriberRepo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (job.isRequestStop()) {
            this.logger.info(job.getConfigName() + this.context.cfg.gs("Z.cancelled"));
            this.context.mainFrame.labelStatusMiddle.setText(job.getConfigName() + this.context.cfg.gs("Z.cancelled"));
        } else {
            String msg = MessageFormat.format(this.context.cfg.gs(this.context.fault ? "Job.failed.job" : "Job.completed.job"), job.getConfigName() + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : ""));
            this.logger.info(msg);
            this.context.mainFrame.labelStatusMiddle.setText(msg);
            this.context.main.stopVerbiage();
        }
        this.context.navigator.setWorkerRunning(false);
        this.context.navigator.disableGui(false);
        this.context.navigator.disableComponent(false, this.getContentPane());
        this.context.navigator.setBlockingProcessRunning(false);
    }

    private boolean saveConfigurations() {
        for (int i = 0; i < this.deletedTools.size(); ++i) {
            AbstractTool tool = (AbstractTool)this.deletedTools.get(i);
            File del = new File(tool.getFullPath());
            if (!del.exists()) continue;
            del.delete();
        }
        this.deletedTools = new ArrayList();
        this.configModel.saveJobsConfigurations(this.configModel);
        return true;
    }

    private void savePreferences() {
        this.context.preferences.setJobsHeight(this.getHeight());
        this.context.preferences.setJobsWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setJobsXpos(location.x);
        this.context.preferences.setJobsYpos(location.y);
        this.context.preferences.setJobsTaskDividerLocation(this.splitPaneContent.getDividerLocation());
        this.context.preferences.setJobsOriginDividerLocation(this.splitPaneToolsOrigin.getDividerLocation());
    }

    private boolean validateJob(Job job, boolean onlyFound) throws Exception {
        boolean cachedFound = false;
        boolean sense = true;
        for (int i = 0; i < job.getTasks().size(); ++i) {
            Task task = job.getTasks().get(i);
            if (!task.getInternalName().equals(Job.INTERNAL_NAME) && !task.getInternalName().equals("Sleep")) {
                AbstractTool tool = this.context.tools.getTool(task.getInternalName(), task.getConfigName());
                if (tool != null) {
                    if (!tool.isToolCachedOrigins()) continue;
                    if (task.getPublisherKey().equals("_CACHEDLASTTASK_")) {
                        if (task.getOrigins().size() != 0 || cachedFound) continue;
                        sense = false;
                        JOptionPane.showMessageDialog(this, this.context.cfg.gs("JobsUI.task.has.no.origins") + job.getConfigName() + ", " + task.getConfigName(), this.context.cfg.gs("JobsUI.title"), 2);
                        continue;
                    }
                    if (task.getOrigins().size() <= 0) continue;
                    cachedFound = true;
                    continue;
                }
                sense = false;
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("JobsUI.tool.not.found") + job.getConfigName() + ", " + task.getConfigName(), this.context.cfg.gs("JobsUI.title"), 2);
                continue;
            }
            if (task.getInternalName().equals("Sleep")) continue;
            Job subJob = job.load(task.getConfigName());
            cachedFound = this.validateJob(subJob, true);
            onlyFound = false;
        }
        return onlyFound ? cachedFound : sense;
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void windowHidden(ComponentEvent e) {
        this.context.navigator.enableDisableToolMenus(this, true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.hSpacerBeforeRun = new JPanel(null);
        this.buttonRun = new JButton();
        this.hSpacerBeforeGenerate = new JPanel(null);
        this.buttonGenerate = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.splitPaneContent = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.configItems = new JTable();
        this.panelJob = new JPanel();
        this.splitPaneToolsOrigin = new JSplitPane();
        this.panelTasks = new JPanel();
        this.labelTasks = new JLabel();
        this.scrollPaneTasks = new JScrollPane();
        this.listTasks = new JList();
        this.panelOrigin = new JPanel();
        this.labelSpacer = new JLabel();
        this.labelOrigins = new JLabel();
        this.panelOriginInstance = new JPanel();
        this.panelPubSub = new JPanel();
        this.labelPub = new JLabel();
        this.buttonPub = new JButton();
        this.labelSub = new JLabel();
        this.buttonSub = new JButton();
        this.labelHints = new JLabel();
        this.buttonHints = new JButton();
        this.labelEmail = new JLabel();
        this.buttonEmail = new JButton();
        this.scrollPaneOrigins = new JScrollPane();
        this.listOrigins = new JList();
        this.panelOriginsButtons = new JPanel();
        this.buttonAddOrigin = new JButton();
        this.buttonOriginUp = new JButton();
        this.buttonOriginDown = new JButton();
        this.buttonRemoveOrigin = new JButton();
        this.panelToolButtons = new JPanel();
        this.buttonAddTask = new JButton();
        this.buttonTaskUp = new JButton();
        this.buttonTaskDown = new JButton();
        this.buttonRemoveTask = new JButton();
        this.buttonBar = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(this.context.cfg.gs("JobsUI.title"));
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                JobsUI.this.windowHidden(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JobsUI.this.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(570, 470));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNew.setText(this.context.cfg.gs("JobsUI.buttonNew.text"));
        this.buttonNew.setMnemonic(this.context.cfg.gs("JobsUI.buttonNew.mnemonic").charAt(0));
        this.buttonNew.setToolTipText(this.context.cfg.gs("JobsUI.buttonNew.toolTipText"));
        this.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("Navigator.buttonCopy.text"));
        this.buttonCopy.setMnemonic(this.context.cfg.gs("JobsUI.buttonCopy.mnemonic").charAt(0));
        this.buttonCopy.setToolTipText(this.context.cfg.gs("Navigator.buttonCopy.toolTipText"));
        this.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("Navigator.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("JobsUI.buttonDelete.mnemonic").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("Navigator.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.hSpacerBeforeRun.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeRun.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeRun);
        this.buttonRun.setText(this.context.cfg.gs("Z.run.ellipsis"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("JobsUI.buttonRun.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("JobsUI.buttonRun.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.hSpacerBeforeGenerate.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeGenerate.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeGenerate);
        this.buttonGenerate.setText(this.context.cfg.gs("JobsUI.buttonGenerate.text"));
        this.buttonGenerate.setMnemonic(this.context.cfg.gs("JobsUI.buttonGenerate.mnemonic_2").charAt(0));
        this.buttonGenerate.setToolTipText(this.context.cfg.gs("JobsUI.buttonGenerate.toolTipText"));
        this.buttonGenerate.addActionListener(e -> this.actionGenerateClicked(e));
        this.panelTopButtons.add(this.buttonGenerate);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("JobsUI.help"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JobsUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "East");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.splitPaneContent.setDividerLocation(142);
        this.splitPaneContent.setLastDividerLocation(142);
        this.splitPaneContent.setMinimumSize(new Dimension(140, 80));
        this.configItems.setSelectionMode(0);
        this.configItems.setFillsViewportHeight(true);
        this.configItems.setShowVerticalLines(false);
        this.configItems.setShowHorizontalLines(false);
        this.configItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JobsUI.this.configItemsMouseClicked(e);
            }
        });
        this.scrollPaneConfig.setViewportView(this.configItems);
        this.splitPaneContent.setLeftComponent(this.scrollPaneConfig);
        this.panelJob.setLayout(new BorderLayout());
        this.splitPaneToolsOrigin.setDividerLocation(142);
        this.splitPaneToolsOrigin.setLastDividerLocation(142);
        this.panelTasks.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelTasks.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.panelTasks.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.panelTasks.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)this.panelTasks.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        this.labelTasks.setText(this.context.cfg.gs("JobsUI.labelTasks.text"));
        this.labelTasks.setHorizontalAlignment(2);
        this.labelTasks.setHorizontalTextPosition(2);
        this.labelTasks.setFont(this.labelTasks.getFont().deriveFont(this.labelTasks.getFont().getStyle() | 1, (float)this.labelTasks.getFont().getSize() + 1.0f));
        this.labelTasks.setMaximumSize(new Dimension(37, 18));
        this.labelTasks.setMinimumSize(new Dimension(37, 18));
        this.labelTasks.setPreferredSize(new Dimension(37, 18));
        this.panelTasks.add((Component)this.labelTasks, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.listTasks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JobsUI.this.listTasksMouseClicked(e);
            }
        });
        this.listTasks.addListSelectionListener(e -> this.listTasksValueChanged(e));
        this.scrollPaneTasks.setViewportView(this.listTasks);
        this.panelTasks.add((Component)this.scrollPaneTasks, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPaneToolsOrigin.setLeftComponent(this.panelTasks);
        this.panelOrigin.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelOrigin.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.panelOrigin.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelOrigin.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)this.panelOrigin.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.labelSpacer.setText("    ");
        this.labelSpacer.setFont(this.labelSpacer.getFont().deriveFont((float)this.labelSpacer.getFont().getSize() + 1.0f));
        this.labelSpacer.setHorizontalAlignment(2);
        this.labelSpacer.setHorizontalTextPosition(2);
        this.labelSpacer.setMaximumSize(new Dimension(57, 18));
        this.labelSpacer.setMinimumSize(new Dimension(57, 18));
        this.labelSpacer.setPreferredSize(new Dimension(57, 18));
        this.panelOrigin.add((Component)this.labelSpacer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.labelOrigins.setText(this.context.cfg.gs("JobsUI.labelOrigins.text"));
        this.labelOrigins.setFont(this.labelOrigins.getFont().deriveFont(this.labelOrigins.getFont().getStyle() | 1, (float)this.labelOrigins.getFont().getSize() + 1.0f));
        this.labelOrigins.setHorizontalAlignment(2);
        this.labelOrigins.setHorizontalTextPosition(2);
        this.labelOrigins.setMaximumSize(new Dimension(57, 18));
        this.labelOrigins.setMinimumSize(new Dimension(57, 18));
        this.labelOrigins.setPreferredSize(new Dimension(57, 18));
        this.panelOrigin.add((Component)this.labelOrigins, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.panelOriginInstance.setLayout(new BorderLayout());
        this.panelPubSub.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelPubSub.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panelPubSub.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelPubSub.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panelPubSub.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.labelPub.setMaximumSize(new Dimension(24, 18));
        this.labelPub.setMinimumSize(new Dimension(24, 18));
        this.labelPub.setPreferredSize(new Dimension(24, 30));
        this.labelPub.setFont(this.labelPub.getFont().deriveFont((float)this.labelPub.getFont().getSize() + 1.0f));
        this.panelPubSub.add((Component)this.labelPub, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 4, 0, 8), 0, 0));
        this.buttonPub.setText("...");
        this.buttonPub.setMaximumSize(new Dimension(32, 24));
        this.buttonPub.setMinimumSize(new Dimension(32, 24));
        this.buttonPub.setPreferredSize(new Dimension(32, 24));
        this.buttonPub.setVerticalTextPosition(1);
        this.buttonPub.setFont(this.buttonPub.getFont().deriveFont(this.buttonPub.getFont().getStyle() | 1));
        this.buttonPub.setHorizontalTextPosition(10);
        this.buttonPub.setIconTextGap(0);
        this.buttonPub.setActionCommand("buttonPub");
        this.buttonPub.addActionListener(e -> this.actionPubSubClicked(e));
        this.panelPubSub.add((Component)this.buttonPub, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelSub.setMaximumSize(new Dimension(24, 18));
        this.labelSub.setMinimumSize(new Dimension(24, 18));
        this.labelSub.setPreferredSize(new Dimension(24, 30));
        this.labelSub.setFont(this.labelSub.getFont().deriveFont((float)this.labelSub.getFont().getSize() + 1.0f));
        this.panelPubSub.add((Component)this.labelSub, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 4, 0, 8), 0, 0));
        this.buttonSub.setText("...");
        this.buttonSub.setMaximumSize(new Dimension(32, 24));
        this.buttonSub.setMinimumSize(new Dimension(32, 24));
        this.buttonSub.setPreferredSize(new Dimension(32, 24));
        this.buttonSub.setVerticalTextPosition(1);
        this.buttonSub.setFont(this.buttonSub.getFont().deriveFont(this.buttonSub.getFont().getStyle() | 1));
        this.buttonSub.setHorizontalTextPosition(10);
        this.buttonSub.setIconTextGap(0);
        this.buttonSub.setActionCommand("buttonSub");
        this.buttonSub.addActionListener(e -> this.actionPubSubClicked(e));
        this.panelPubSub.add((Component)this.buttonSub, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelHints.setMaximumSize(new Dimension(24, 18));
        this.labelHints.setMinimumSize(new Dimension(24, 18));
        this.labelHints.setPreferredSize(new Dimension(24, 30));
        this.labelHints.setFont(this.labelHints.getFont().deriveFont((float)this.labelHints.getFont().getSize() + 1.0f));
        this.panelPubSub.add((Component)this.labelHints, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 4, 0, 8), 0, 0));
        this.buttonHints.setText("...");
        this.buttonHints.setMaximumSize(new Dimension(32, 24));
        this.buttonHints.setMinimumSize(new Dimension(32, 24));
        this.buttonHints.setPreferredSize(new Dimension(32, 24));
        this.buttonHints.setVerticalTextPosition(1);
        this.buttonHints.setFont(this.buttonHints.getFont().deriveFont(this.buttonHints.getFont().getStyle() | 1));
        this.buttonHints.setHorizontalTextPosition(10);
        this.buttonHints.setIconTextGap(0);
        this.buttonHints.setActionCommand("buttonHints");
        this.buttonHints.addActionListener(e -> this.actionPubSubClicked(e));
        this.panelPubSub.add((Component)this.buttonHints, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelEmail.setMaximumSize(new Dimension(24, 18));
        this.labelEmail.setMinimumSize(new Dimension(24, 18));
        this.labelEmail.setPreferredSize(new Dimension(24, 30));
        this.labelEmail.setFont(this.labelEmail.getFont().deriveFont((float)this.labelEmail.getFont().getSize() + 1.0f));
        this.panelPubSub.add((Component)this.labelEmail, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 4, 0, 8), 0, 0));
        this.buttonEmail.setText("...");
        this.buttonEmail.setMaximumSize(new Dimension(32, 24));
        this.buttonEmail.setMinimumSize(new Dimension(32, 24));
        this.buttonEmail.setPreferredSize(new Dimension(32, 24));
        this.buttonEmail.setVerticalTextPosition(1);
        this.buttonEmail.setFont(this.buttonEmail.getFont().deriveFont(this.buttonEmail.getFont().getStyle() | 1));
        this.buttonEmail.setHorizontalTextPosition(10);
        this.buttonEmail.setIconTextGap(0);
        this.buttonEmail.setActionCommand("buttonEmail'");
        this.buttonEmail.addActionListener(e -> this.actionEmailServerClicked(e));
        this.panelPubSub.add((Component)this.buttonEmail, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelOriginInstance.add((Component)this.panelPubSub, "North");
        this.scrollPaneOrigins.setViewportView(this.listOrigins);
        this.panelOriginInstance.add((Component)this.scrollPaneOrigins, "Center");
        this.panelOriginsButtons.setBorder(null);
        this.panelOriginsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAddOrigin.setText(this.context.cfg.gs("JobsUI.buttonAddOrigin.text"));
        this.buttonAddOrigin.setFont(this.buttonAddOrigin.getFont().deriveFont((float)this.buttonAddOrigin.getFont().getSize() - 2.0f));
        this.buttonAddOrigin.setPreferredSize(new Dimension(78, 24));
        this.buttonAddOrigin.setMinimumSize(new Dimension(78, 24));
        this.buttonAddOrigin.setMaximumSize(new Dimension(78, 24));
        this.buttonAddOrigin.setMnemonic(this.context.cfg.gs("JobsUI.buttonAddOrigin.mnemonic").charAt(0));
        this.buttonAddOrigin.setToolTipText(this.context.cfg.gs("JobsUI.buttonAddOrigin.toolTipText"));
        this.buttonAddOrigin.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAddOrigin.addActionListener(e -> this.actionOriginAddClicked(e));
        this.panelOriginsButtons.add(this.buttonAddOrigin);
        this.buttonOriginUp.setText("^");
        this.buttonOriginUp.setMaximumSize(new Dimension(24, 24));
        this.buttonOriginUp.setMinimumSize(new Dimension(24, 24));
        this.buttonOriginUp.setPreferredSize(new Dimension(24, 24));
        this.buttonOriginUp.setFont(this.buttonOriginUp.getFont().deriveFont((float)this.buttonOriginUp.getFont().getSize() - 2.0f));
        this.buttonOriginUp.setToolTipText(this.context.cfg.gs("JobsUI.buttonOriginUp.toolTipText"));
        this.buttonOriginUp.addActionListener(e -> this.actionOriginUpClicked(e));
        this.panelOriginsButtons.add(this.buttonOriginUp);
        this.buttonOriginDown.setText("v");
        this.buttonOriginDown.setFont(this.buttonOriginDown.getFont().deriveFont((float)this.buttonOriginDown.getFont().getSize() - 2.0f));
        this.buttonOriginDown.setMaximumSize(new Dimension(24, 24));
        this.buttonOriginDown.setMinimumSize(new Dimension(24, 24));
        this.buttonOriginDown.setPreferredSize(new Dimension(24, 24));
        this.buttonOriginDown.setToolTipText(this.context.cfg.gs("JobsUI.buttonOriginDown.toolTipText"));
        this.buttonOriginDown.addActionListener(e -> this.actionOriginDownClicked(e));
        this.panelOriginsButtons.add(this.buttonOriginDown);
        this.buttonRemoveOrigin.setText(this.context.cfg.gs("JobsUI.buttonRemoveOrigin.text"));
        this.buttonRemoveOrigin.setFont(this.buttonRemoveOrigin.getFont().deriveFont((float)this.buttonRemoveOrigin.getFont().getSize() - 2.0f));
        this.buttonRemoveOrigin.setPreferredSize(new Dimension(78, 24));
        this.buttonRemoveOrigin.setMinimumSize(new Dimension(78, 24));
        this.buttonRemoveOrigin.setMaximumSize(new Dimension(78, 24));
        this.buttonRemoveOrigin.setMnemonic(this.context.cfg.gs("JobsUI.buttonRemoveOrigin.mnemonic_2").charAt(0));
        this.buttonRemoveOrigin.setToolTipText(this.context.cfg.gs("JobsUI.buttonRemoveOrigin.toolTipText"));
        this.buttonRemoveOrigin.setMargin(new Insets(0, -10, 0, -10));
        this.buttonRemoveOrigin.addActionListener(e -> this.actionOriginRemoveClicked(e));
        this.panelOriginsButtons.add(this.buttonRemoveOrigin);
        this.panelOriginInstance.add((Component)this.panelOriginsButtons, "South");
        this.panelOrigin.add((Component)this.panelOriginInstance, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPaneToolsOrigin.setRightComponent(this.panelOrigin);
        this.panelJob.add((Component)this.splitPaneToolsOrigin, "Center");
        this.panelToolButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAddTask.setText(this.context.cfg.gs("JobsUI.buttonAddTask.text"));
        this.buttonAddTask.setFont(this.buttonAddTask.getFont().deriveFont((float)this.buttonAddTask.getFont().getSize() - 2.0f));
        this.buttonAddTask.setPreferredSize(new Dimension(78, 24));
        this.buttonAddTask.setMinimumSize(new Dimension(78, 24));
        this.buttonAddTask.setMaximumSize(new Dimension(78, 24));
        this.buttonAddTask.setMnemonic(this.context.cfg.gs("JobsUI.buttonAddTask.mnemonic").charAt(0));
        this.buttonAddTask.setToolTipText(this.context.cfg.gs("JobsUI.buttonAddTask.toolTipText"));
        this.buttonAddTask.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAddTask.addActionListener(e -> this.actionTaskAddClicked(e));
        this.panelToolButtons.add(this.buttonAddTask);
        this.buttonTaskUp.setText("^");
        this.buttonTaskUp.setMaximumSize(new Dimension(24, 24));
        this.buttonTaskUp.setMinimumSize(new Dimension(24, 24));
        this.buttonTaskUp.setPreferredSize(new Dimension(24, 24));
        this.buttonTaskUp.setFont(this.buttonTaskUp.getFont().deriveFont((float)this.buttonTaskUp.getFont().getSize() - 2.0f));
        this.buttonTaskUp.setToolTipText(this.context.cfg.gs("JobsUI.buttonTaskUp.toolTipText"));
        this.buttonTaskUp.addActionListener(e -> this.actionTaskUpClicked(e));
        this.panelToolButtons.add(this.buttonTaskUp);
        this.buttonTaskDown.setText("v");
        this.buttonTaskDown.setFont(this.buttonTaskDown.getFont().deriveFont((float)this.buttonTaskDown.getFont().getSize() - 2.0f));
        this.buttonTaskDown.setMaximumSize(new Dimension(24, 24));
        this.buttonTaskDown.setMinimumSize(new Dimension(24, 24));
        this.buttonTaskDown.setPreferredSize(new Dimension(24, 24));
        this.buttonTaskDown.setToolTipText(this.context.cfg.gs("JobsUI.buttonTaskDown.toolTipText"));
        this.buttonTaskDown.addActionListener(e -> this.actionTaskDownClicked(e));
        this.panelToolButtons.add(this.buttonTaskDown);
        this.buttonRemoveTask.setText(this.context.cfg.gs("JobsUI.buttonRemoveTask.text"));
        this.buttonRemoveTask.setFont(this.buttonRemoveTask.getFont().deriveFont((float)this.buttonRemoveTask.getFont().getSize() - 2.0f));
        this.buttonRemoveTask.setPreferredSize(new Dimension(78, 24));
        this.buttonRemoveTask.setMinimumSize(new Dimension(78, 24));
        this.buttonRemoveTask.setMaximumSize(new Dimension(78, 24));
        this.buttonRemoveTask.setMnemonic(this.context.cfg.gs("JobsUI.buttonRemoveTask.mnemonic").charAt(0));
        this.buttonRemoveTask.setToolTipText(this.context.cfg.gs("JobsUI.buttonRemoveTask.toolTipText"));
        this.buttonRemoveTask.setMargin(new Insets(0, -10, 0, -10));
        this.buttonRemoveTask.addActionListener(e -> this.actionTaskRemoveClicked(e));
        this.panelToolButtons.add(this.buttonRemoveTask);
        this.panelJob.add((Component)this.panelToolButtons, "South");
        this.splitPaneContent.setRightComponent(this.panelJob);
        this.contentPanel.add((Component)this.splitPaneContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 82, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.saveButton.setText(this.context.cfg.gs("Z.save"));
        this.saveButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.saveButton.setActionCommand(this.context.cfg.gs("Z.save"));
        this.saveButton.setMnemonic(this.context.cfg.gs("JobsUI.saveButton.mnemonic").charAt(0));
        this.saveButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("Z.cancel"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic(this.context.cfg.gs("JobsUI.cancelButton.mnemonic_2").charAt(0));
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class ComboItem {
        public int id;
        public String text;
        public int type;

        public ComboItem(JobsUI jobsUI, int id, String text, int type) {
            this.id = id;
            this.text = text;
            this.type = type;
        }

        public String toString() {
            return this.text;
        }
    }
}

