/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.libraries;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.gui.libraries.LibrariesUI;
import com.corionis.els.repository.Library;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

public class BiblioLibrariesTableModel
extends DefaultTableModel {
    private Context context;
    private String displayName;
    private boolean editable = true;
    private LibrariesUI.LibMeta libMeta;

    public BiblioLibrariesTableModel(Context context) {
        this.context = context;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Comparable<Library> value = null;
        if (this.libMeta != null && this.libMeta.repo != null && this.libMeta.repo.getLibraryData().libraries.bibliography != null && row < this.libMeta.repo.getLibraryData().libraries.bibliography.length) {
            Library lib = this.libMeta.repo.getLibraryData().libraries.bibliography[row];
            value = column == 0 ? lib : Boolean.valueOf(lib.matchDates);
        }
        return value;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setLibMeta(LibrariesUI.LibMeta libMeta) {
        this.libMeta = libMeta;
    }

    @Override
    public void setValueAt(Object object, int row, int col) {
        if (this.libMeta != null && this.libMeta.repo != null && this.libMeta.repo.getLibraryData().libraries.bibliography != null && row < this.libMeta.repo.getLibraryData().libraries.bibliography.length) {
            try {
                if (col == 0) {
                    Library lib = this.libMeta.repo.getLibrary((String)object);
                    if (lib != null && lib != this.libMeta.repo.getLibraryData().libraries.bibliography[row]) {
                        JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Libraries.that.library.already.exists"), this.displayName, 2);
                    } else {
                        this.libMeta.repo.getLibraryData().libraries.bibliography[row].name = (String)object;
                        this.libMeta.setDataHasChanged();
                    }
                } else {
                    this.libMeta.repo.getLibraryData().libraries.bibliography[row].matchDates = (Boolean)object;
                    this.libMeta.setDataHasChanged();
                }
            }
            catch (MungeException mungeException) {
                // empty catch block
            }
        }
        this.context.mainFrame.tableBiblioLibraries.requestFocus();
        this.context.mainFrame.tableBiblioLibraries.changeSelection(row, 0, false, false);
    }
}

