/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.libraries;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.MainFrame;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.Conflict;
import com.corionis.els.gui.libraries.BiblioLibrariesTableModel;
import com.corionis.els.gui.libraries.ConfigModel;
import com.corionis.els.gui.libraries.LibrarySelector;
import com.corionis.els.gui.libraries.LibrarySelectorTableModel;
import com.corionis.els.gui.libraries.LocationsTableModel;
import com.corionis.els.gui.libraries.MatchDateCell;
import com.corionis.els.gui.util.DirectoryPicker;
import com.corionis.els.gui.util.DisableJListSelectionModel;
import com.corionis.els.gui.util.NumberFilter;
import com.corionis.els.gui.util.RotatedIcon;
import com.corionis.els.gui.util.TextIcon;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Jobs;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Origins;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Libraries;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Location;
import com.corionis.els.repository.RepoMeta;
import com.corionis.els.repository.Repositories;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.text.PlainDocument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibrariesUI {
    public JTable configItems;
    protected ArrayList<LibMeta> deletedLibraries;
    private BiblioLibrariesTableModel biblioLibrariesTableModel;
    private JComboBox comboBoxMode;
    private ConfigModel configModel;
    private Context context;
    private int currentConfigIndex = -1;
    private int currentLibraryIndex = 0;
    private int currentLocationIndex = 0;
    private int currentSourceIndex = -1;
    private DirectoryPicker directoryPicker = null;
    public String displayName;
    private boolean dontAsk = false;
    private NavHelp helpDialog;
    private Jobs jobsHandler = null;
    private ArrayList<AbstractTool> jobsList;
    private File lastDirectory;
    private int lastTab = 0;
    private LibrarySelectorTableModel librarySelectorTableModel = null;
    private LibrarySelector[] librarySelectors = null;
    private DefaultListModel listSourcesModel = null;
    private boolean loading = false;
    private LocationsTableModel locationsTableModel = null;
    private Logger logger = LogManager.getLogger("applog");
    private MainFrame mf;
    private Mode[] modes;
    private NumberFilter numberFilter;
    private boolean promptingKeyChange = false;

    private LibrariesUI() {
    }

    public LibrariesUI(Context context) {
        this.context = context;
        this.mf = context.mainFrame;
        this.displayName = context.cfg.gs("Navigator.splitPane.Libraries.tab.title");
        this.initialize();
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            LibMeta original = (LibMeta)this.configModel.getValueAt(index, 0);
            String rename = original.description + this.context.cfg.gs("Z.copy");
            if (this.configModel.findMeta(rename, null) == null) {
                LibMeta copy = original.clone();
                copy.description = rename;
                copy.repo.getLibraryData().libraries.description = rename;
                copy.key = "";
                copy.repo.getLibraryData().libraries.key = "";
                copy.path = "";
                copy.repo.setJsonFilename("");
                copy.repo.setDynamic(false);
                copy.setDataHasChanged();
                this.configModel.addRow(new Object[]{copy});
                this.currentConfigIndex = this.configModel.getRowCount() - 1;
                this.loadGeneralTab();
                this.configItems.editCellAt(this.currentConfigIndex, 0);
                this.configItems.changeSelection(this.currentConfigIndex, 0, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this.mf, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.displayName, 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.mf.librariesConfigItems.isEditing()) {
                this.mf.librariesConfigItems.getCellEditor().stopCellEditing();
            }
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this.mf, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + libMeta.description, this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(libMeta.description, null, false);
                if (answer >= 0) {
                    File file = new File(libMeta.path);
                    if (file.exists()) {
                        this.deletedLibraries.add(libMeta);
                    }
                    libMeta.setDataHasChanged();
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    if (index < 0) {
                        index = 0;
                    }
                    this.currentConfigIndex = index;
                    this.configModel.fireTableDataChanged();
                    if (this.configModel.getRowCount() > 0) {
                        this.loadGeneralTab();
                        this.configItems.changeSelection(index, 0, false, false);
                    } else {
                        this.mf.tabbedPaneLibrarySpaces.setSelectedIndex(0);
                        ((CardLayout)this.mf.generalOptions.getLayout()).show(this.mf.generalOptions, "cardGettingStarted");
                        this.mf.labelLibaryType.setText("");
                        this.mf.buttonCopy.setEnabled(false);
                        this.mf.buttonDelete.setEnabled(false);
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionGenerateUUIDClicked(ActionEvent e) {
        this.currentConfigIndex = this.configItems.getSelectedRow();
        if (this.currentConfigIndex >= 0) {
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            if (libMeta.key != null && libMeta.key.length() > 0) {
                int reply = 1;
                String description = this.context.cfg.gs("Libraries.generate.new.uuid.for") + libMeta.description;
                String blank = "<html><body><br/></body></html>";
                String message = this.context.cfg.gs("Libraries.this.will.overwrite.any.existing.uuid");
                String question = this.context.cfg.gs("Z.are.you.sure");
                Object[] params = new Object[]{description, blank, message, question};
                Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
                reply = JOptionPane.showOptionDialog(this.context.mainFrame, params, this.context.cfg.gs("Navigator.splitPane.Libraries.tab.title"), 0, 3, null, opts, opts[1]);
                if (reply != 0) {
                    return;
                }
            }
            UUID uuid = UUID.randomUUID();
            this.mf.textFieldKey.setText(uuid.toString());
            this.mf.textFieldKey.postActionEvent();
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this.mf, this.mf, this.context, this.context.cfg.gs("Libraries.help"), "libraries_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionIgnorePatternAdd(ActionEvent e) {
        String line4;
        String line3;
        String line2;
        String blank;
        String line1;
        Object[] params;
        String pattern;
        this.currentConfigIndex = this.configItems.getSelectedRow();
        if (this.currentConfigIndex >= 0 && (pattern = JOptionPane.showInputDialog(this.mf, params = new Object[]{line1 = this.context.cfg.gs("Libraries.add.ignore.1"), blank = "<html><body><br/></body></html>", line2 = this.context.cfg.gs("Libraries.add.ignore.2"), line3 = this.context.cfg.gs("Libraries.add.ignore.3"), blank, line4 = this.context.cfg.gs("Libraries.add.ignore.4")}, this.displayName, -1)) != null && pattern.length() > 0) {
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            int newSize = libMeta.repo.getLibraryData().libraries.ignore_patterns.length + 1;
            String[] expanded = new String[newSize];
            System.arraycopy(libMeta.repo.getLibraryData().libraries.ignore_patterns, 0, expanded, 0, libMeta.repo.getLibraryData().libraries.ignore_patterns.length);
            expanded[newSize - 1] = pattern;
            libMeta.repo.getLibraryData().libraries.ignore_patterns = expanded;
            libMeta.setDataHasChanged();
            this.loadGeneralTab();
            this.mf.listLibrariesIgnorePatterns.setSelectionInterval(newSize - 1, newSize - 1);
        }
    }

    private void actionIgnorePatternRemove(ActionEvent e) {
        this.currentConfigIndex = this.configItems.getSelectedRow();
        if (this.currentConfigIndex >= 0) {
            int reply;
            int[] selected;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            if (libMeta.repo.getLibraryData().libraries.ignore_patterns.length > 0 && (selected = this.mf.listLibrariesIgnorePatterns.getSelectedIndices()).length > 0 && (reply = JOptionPane.showConfirmDialog(this.mf, MessageFormat.format(this.context.cfg.gs("Libraries.are.you.sure.remove.ignores"), selected.length), this.displayName, 0)) == 0) {
                int i;
                String[] ignores = libMeta.repo.getLibraryData().libraries.ignore_patterns;
                ArrayList<String> contracted = new ArrayList<String>();
                for (i = 0; i < ignores.length; ++i) {
                    contracted.add(ignores[i]);
                }
                for (i = selected.length - 1; i >= 0; --i) {
                    contracted.remove(selected[i]);
                }
                ignores = new String[contracted.size()];
                for (i = 0; i < contracted.size(); ++i) {
                    ignores[i] = (String)contracted.get(i);
                }
                libMeta.repo.getLibraryData().libraries.ignore_patterns = ignores;
                libMeta.setDataHasChanged();
                this.loadGeneralTab();
            }
        }
    }

    private void actionLibraryAdd(ActionEvent evt) {
        if (this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            try {
                Library lib = libMeta.repo.getLibrary(this.context.cfg.gs("Z.untitled"));
                if (lib == null) {
                    lib = new Library();
                    lib.name = this.context.cfg.gs("Z.untitled");
                    lib.sources = new String[0];
                    Library[] biblio = libMeta.repo.getLibraryData().libraries.bibliography;
                    int arraySize = biblio.length + 1;
                    Library[] expanded = new Library[arraySize];
                    System.arraycopy(libMeta.repo.getLibraryData().libraries.bibliography, 0, expanded, 0, libMeta.repo.getLibraryData().libraries.bibliography.length);
                    expanded[arraySize - 1] = lib;
                    libMeta.repo.getLibraryData().libraries.bibliography = expanded;
                    libMeta.setDataHasChanged();
                    this.biblioLibrariesTableModel.addRow(new Object[]{lib});
                    this.currentLibraryIndex = arraySize - 1;
                    this.currentSourceIndex = -1;
                    this.loadBibliographyTab();
                    this.mf.tableBiblioLibraries.editCellAt(this.currentLibraryIndex, 0);
                    this.mf.tableBiblioLibraries.changeSelection(this.currentLibraryIndex, 0, false, false);
                    this.mf.tableBiblioLibraries.getEditorComponent().requestFocus();
                    ((JTextField)this.mf.tableBiblioLibraries.getEditorComponent()).selectAll();
                } else {
                    JOptionPane.showMessageDialog(this.mf, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.displayName, 2);
                }
            }
            catch (MungeException mungeException) {
                // empty catch block
            }
        }
    }

    private void actionLibraryRemove(ActionEvent e) {
        if (this.currentConfigIndex >= 0) {
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            int[] rows = this.mf.tableBiblioLibraries.getSelectedRows();
            if (rows.length > 0) {
                int row = rows[0];
                int reply = JOptionPane.showConfirmDialog(this.mf, MessageFormat.format(this.context.cfg.gs("Libraries.remove.library.from"), libMeta.repo.getLibraryData().libraries.bibliography[row].name, libMeta.description), this.displayName, 0);
                if (reply == 0) {
                    int i;
                    Library[] libraries = libMeta.repo.getLibraryData().libraries.bibliography;
                    ArrayList<Library> libraryList = new ArrayList<Library>();
                    for (i = 0; i < libraries.length; ++i) {
                        libraryList.add(libraries[i]);
                    }
                    for (i = rows.length - 1; i >= 0; --i) {
                        libraryList.remove(rows[i]);
                    }
                    libraries = new Library[libraryList.size()];
                    for (i = 0; i < libraryList.size(); ++i) {
                        libraries[i] = (Library)libraryList.get(i);
                    }
                    libMeta.repo.getLibraryData().libraries.bibliography = libraries;
                    int index = -1;
                    libMeta.setDataHasChanged();
                    if (index > libraryList.size()) {
                        index = libraryList.size() - 1;
                    }
                    if (index < 0) {
                        index = 0;
                    }
                    this.currentLibraryIndex = index;
                    this.currentSourceIndex = -1;
                    if (libraries.length == 0) {
                        this.biblioLibrariesTableModel.setRowCount(0);
                    } else {
                        this.mf.tableBiblioLibraries.changeSelection(this.currentLocationIndex, 0, false, false);
                        this.loadBibliographyTab();
                    }
                }
            }
        }
    }

    private void actionLocationAddClicked(ActionEvent e) {
        if (this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            final LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            this.directoryPicker = new DirectoryPicker(this.context, this.context.cfg.gs("Libraries.select.new.location.path"), this.context.cfg.gs("Libraries.select.new.location") + ": " + libMeta.repo.getLibraryData().libraries.description, true, false, "");
            this.directoryPicker.browserSelectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean empty;
                    block19: {
                        boolean done = false;
                        empty = false;
                        boolean isSubscriber = false;
                        int reply = 1;
                        if (LibrariesUI.this.context.browser.lastComponent != null) {
                            try {
                                LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(0);
                                ArrayList<Origin> origins = new ArrayList<Origin>();
                                isSubscriber = Origins.makeOriginsFromSelected(LibrariesUI.this.context, LibrariesUI.this.context.mainFrame, origins);
                                if (origins != null && origins.size() > 0) {
                                    int count = origins.size();
                                    Origin origin = origins.get(0);
                                    if (count != 1 || origin.getType() != 6 || !origin.tuo.isDir) {
                                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.please.select.a.single.directory.to.add"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 0);
                                    } else {
                                        String path = origin.tuo.isRemote ? origin.getLocation() : Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), origin.getLocation());
                                        boolean found = false;
                                        Location[] locations = libMeta.repo.getLibraryData().libraries.locations;
                                        for (int j = 0; j < locations.length; ++j) {
                                            if (!locations[j].location.equals(path)) continue;
                                            found = true;
                                            break;
                                        }
                                        if (found) {
                                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.that.location.is.already.defined"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 0);
                                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText("");
                                            LibrariesUI.this.directoryPicker.pane.requestFocus();
                                        } else {
                                            String key = origin.tuo.node.getMyRepo().getLibraryData().libraries.key;
                                            if (!libMeta.repo.getLibraryData().libraries.key.equals(key)) {
                                                String name = libMeta.repo.getLibraryData().libraries.description;
                                                reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.selected.path.is.not.from.repository.continue"), name), LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 0);
                                                if (reply == 0) {
                                                    done = true;
                                                }
                                            } else {
                                                LibrariesUI.this.directoryPicker.pane.requestFocus();
                                                String which = isSubscriber ? LibrariesUI.this.context.cfg.gs("Z.subscriber") : LibrariesUI.this.context.cfg.gs("Z.publisher");
                                                String message = MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.use.selected.item"), which);
                                                reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, message, LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 0);
                                                done = true;
                                            }
                                        }
                                        if (reply == 0) {
                                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                                        }
                                        if (done) {
                                            LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(1);
                                        }
                                    }
                                    break block19;
                                }
                                empty = true;
                            }
                            catch (Exception e) {
                                String msg = LibrariesUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                if (e.getMessage() == null || !e.getMessage().equals("HANDLED_INTERNALLY")) {
                                    if (LibrariesUI.this.context.navigator != null) {
                                        LibrariesUI.this.logger.error(msg);
                                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, msg, LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 0);
                                    } else {
                                        LibrariesUI.this.logger.error(msg);
                                    }
                                    break block19;
                                }
                                LibrariesUI.this.logger.error(msg);
                            }
                        } else {
                            empty = true;
                        }
                    }
                    if (empty) {
                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.nothing.selected.in.browser"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 2);
                    }
                }
            });
            this.directoryPicker.directorySelectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String path = LibrariesUI.this.directorySystemPicker(LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"));
                    path = Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), path);
                    boolean found = false;
                    Location[] locations = libMeta.repo.getLibraryData().libraries.locations;
                    for (int j = 0; j < locations.length; ++j) {
                        if (!locations[j].location.equals(path)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.that.location.is.already.defined"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.location.path"), 0);
                        LibrariesUI.this.directoryPicker.directoryPathTextField.setText("");
                        LibrariesUI.this.directoryPicker.pane.requestFocus();
                    } else {
                        LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                    }
                }
            });
            this.directoryPicker.pane.addPropertyChangeListener("value", ignored -> {
                int selectedValue;
                if (this.directoryPicker.pane != null && this.directoryPicker.pane.getValue() != null && (selectedValue = ((Integer)this.directoryPicker.pane.getValue()).intValue()) == 0) {
                    String path = this.directoryPicker.directoryPathTextField.getText();
                    String min = this.directoryPicker.minSize.getText();
                    if (path.length() > 0 && min.length() > 0) {
                        int i;
                        Location loc = new Location();
                        loc.location = path;
                        loc.minimum = min + String.valueOf(this.directoryPicker.scales.getSelectedItem());
                        Location[] locations = libMeta.repo.getLibraryData().libraries.locations;
                        int arraySize = locations.length + 1;
                        Location[] expanded = new Location[arraySize];
                        System.arraycopy(libMeta.repo.getLibraryData().libraries.locations, 0, expanded, 0, libMeta.repo.getLibraryData().libraries.locations.length);
                        expanded[arraySize - 1] = loc;
                        libMeta.repo.getLibraryData().libraries.locations = expanded;
                        libMeta.setDataHasChanged();
                        this.currentLocationIndex = arraySize - 1;
                        this.loadLocationsTab();
                        this.mf.tableLocations.changeSelection(this.currentLocationIndex, 0, false, false);
                        for (i = 0; i < this.mf.tableLocations.getRowCount() && !this.locationsTableModel.getValueAt(i, 0).equals(path); ++i) {
                        }
                        if (i < this.mf.tableLocations.getRowCount()) {
                            this.mf.tableLocations.setRowSelectionInterval(i, i);
                        }
                    }
                }
                this.mf.tabbedPaneMain.setSelectedIndex(1);
                this.mf.buttonNew.setEnabled(true);
                this.mf.buttonCopy.setEnabled(true);
                this.mf.buttonDelete.setEnabled(true);
                this.mf.librariesConfigItems.setEnabled(true);
                this.mf.tabbedPaneLibrarySpaces.setEnabled(true);
                this.mf.buttonAddLocation.setEnabled(true);
                this.mf.saveButton.setEnabled(true);
                this.mf.cancelButton.setEnabled(true);
                this.directoryPicker.dialog.dispose();
                this.mf.buttonAddLocation.requestFocus();
                this.directoryPicker = null;
            });
            this.mf.buttonNew.setEnabled(false);
            this.mf.buttonCopy.setEnabled(false);
            this.mf.buttonDelete.setEnabled(false);
            this.mf.librariesConfigItems.setEnabled(false);
            this.mf.tabbedPaneLibrarySpaces.setEnabled(false);
            this.mf.buttonAddLocation.setEnabled(false);
            this.mf.saveButton.setEnabled(false);
            this.mf.cancelButton.setEnabled(false);
            this.directoryPicker.dialog.setVisible(true);
        }
    }

    private void actionLocationsRemove(ActionEvent e) {
        if (this.currentConfigIndex >= 0) {
            int reply;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            int[] rows = this.mf.tableLocations.getSelectedRows();
            if (rows.length > 0 && (reply = JOptionPane.showConfirmDialog(this.mf, MessageFormat.format(this.context.cfg.gs("Libraries.remove.locations.from"), rows.length, libMeta.description), this.displayName, 0)) == 0) {
                int i;
                Location[] locations = libMeta.repo.getLibraryData().libraries.locations;
                ArrayList<Location> locationsList = new ArrayList<Location>();
                for (i = 0; i < locations.length; ++i) {
                    locationsList.add(locations[i]);
                }
                for (i = rows.length - 1; i >= 0; --i) {
                    locationsList.remove(rows[i]);
                }
                locations = new Location[locationsList.size()];
                for (i = 0; i < locationsList.size(); ++i) {
                    locations[i] = (Location)locationsList.get(i);
                }
                libMeta.repo.getLibraryData().libraries.locations = locations;
                libMeta.setDataHasChanged();
                this.mf.tableLocations.changeSelection(this.currentLocationIndex, 0, false, false);
                this.loadLocationsTab();
            }
        }
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.configModel.findMeta(this.context.cfg.gs("Z.untitled"), null) == null) {
            String message = this.context.cfg.gs("Libraries.mode.select.type");
            Object[] params = new Object[]{message, this.comboBoxMode};
            this.comboBoxMode.setSelectedIndex(0);
            LibMeta libMeta = new LibMeta();
            Mode mode = this.modes[this.comboBoxMode.getSelectedIndex()];
            libMeta.description = this.context.cfg.gs("Z.untitled");
            libMeta.key = "";
            libMeta.path = "";
            libMeta.card = mode.card;
            libMeta.repo = new Repository(this.context, -1);
            libMeta.repo.createStructure();
            libMeta.setDataHasChanged();
            this.initNewCard();
            this.mf.buttonCopy.setEnabled(true);
            this.mf.buttonDelete.setEnabled(true);
            this.mf.saveButton.setEnabled(true);
            this.configModel.addRow(new Object[]{libMeta});
            this.currentConfigIndex = this.configModel.getRowCount() - 1;
            this.loadGeneralTab();
            this.mf.tabbedPaneLibrarySpaces.setSelectedIndex(0);
            this.configItems.editCellAt(this.currentConfigIndex, 0);
            this.configItems.changeSelection(this.currentConfigIndex, 0, false, false);
            this.configItems.getEditorComponent().requestFocus();
            ((JTextField)this.configItems.getEditorComponent()).selectAll();
        } else {
            JOptionPane.showMessageDialog(this.mf, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.displayName, 2);
        }
    }

    private void actionOkClicked(ActionEvent e) {
        LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
        int state = this.saveConfigurations();
        if (state < 0) {
            return;
        }
        this.savePreferences();
        int cci = this.configModel.findIndex(libMeta);
        if (cci >= 0) {
            this.currentConfigIndex = cci;
            this.configItems.setRowSelectionInterval(cci, cci);
            this.loadGeneralTab();
        }
        if (state > 0) {
            this.mf.labelStatusMiddle.setText(this.context.cfg.gs("Libraries.libraries.changes.saved"));
        } else {
            this.mf.labelStatusMiddle.setText(this.context.cfg.gs("Libraries.libraries.changes.none"));
        }
    }

    private void actionSourcesAddClicked(ActionEvent e) {
        if (this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            final LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            if (libMeta.repo.getLibraryData().libraries.bibliography.length > 0 && this.currentLibraryIndex < libMeta.repo.getLibraryData().libraries.bibliography.length) {
                String name = this.biblioLibrariesTableModel.getValueAt(this.currentLibraryIndex, 0).toString();
                this.directoryPicker = new DirectoryPicker(this.context, this.context.cfg.gs("Libraries.select.new.source.path"), this.context.cfg.gs("Libraries.select.new.source") + ": " + libMeta.repo.getLibraryData().libraries.description + ", " + name, false, false, "");
                this.directoryPicker.browserSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean empty;
                        block21: {
                            boolean done = false;
                            empty = false;
                            boolean isSubscriber = false;
                            int reply = 1;
                            if (LibrariesUI.this.context.browser.lastComponent != null) {
                                try {
                                    LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(0);
                                    ArrayList<Origin> origins = new ArrayList<Origin>();
                                    isSubscriber = Origins.makeOriginsFromSelected(LibrariesUI.this.context, LibrariesUI.this.context.mainFrame, origins);
                                    if (origins != null && origins.size() > 0) {
                                        int count = origins.size();
                                        Origin origin = origins.get(0);
                                        if (count != 1 || origin.getType() != 6 || !origin.tuo.isDir) {
                                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.please.select.a.single.directory.to.add"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 0);
                                        } else {
                                            String path;
                                            if (origin.tuo.isRemote) {
                                                path = LibrariesUI.this.context.cfg.makeRelativePathSubscriber(origin.getLocation());
                                                if (path.matches("^\\\\[a-zA-Z]:.*") || path.matches("^/[a-zA-Z]:.*")) {
                                                    path = path.substring(1);
                                                }
                                            } else {
                                                path = Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), origin.getLocation());
                                            }
                                            boolean found = false;
                                            Library lib = libMeta.repo.getLibraryData().libraries.bibliography[LibrariesUI.this.currentLibraryIndex];
                                            for (int j = 0; j < lib.sources.length; ++j) {
                                                if (!lib.sources[j].equals(path)) continue;
                                                found = true;
                                                break;
                                            }
                                            if (found) {
                                                JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.that.source.is.already.defined"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 0);
                                                LibrariesUI.this.directoryPicker.directoryPathTextField.setText("");
                                                LibrariesUI.this.directoryPicker.pane.requestFocus();
                                            } else {
                                                String key = origin.tuo.node.getMyRepo().getLibraryData().libraries.key;
                                                if (!libMeta.repo.getLibraryData().libraries.key.equals(key)) {
                                                    String name = libMeta.repo.getLibraryData().libraries.description;
                                                    reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.selected.path.is.not.from.repository.continue"), name), LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 0, 2);
                                                    done = true;
                                                } else {
                                                    LibrariesUI.this.directoryPicker.pane.requestFocus();
                                                    String which = isSubscriber ? LibrariesUI.this.context.cfg.gs("Z.subscriber") : LibrariesUI.this.context.cfg.gs("Z.publisher");
                                                    String message = MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.use.selected.item"), which);
                                                    reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, message, LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 0);
                                                    done = true;
                                                }
                                            }
                                            if (reply == 0) {
                                                LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                                            }
                                            if (done) {
                                                LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(1);
                                            }
                                        }
                                        break block21;
                                    }
                                    empty = true;
                                }
                                catch (Exception e) {
                                    String msg = LibrariesUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                    if (e.getMessage() == null || !e.getMessage().equals("HANDLED_INTERNALLY")) {
                                        if (LibrariesUI.this.context.navigator != null) {
                                            LibrariesUI.this.logger.error(msg);
                                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, msg, LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 0);
                                        } else {
                                            LibrariesUI.this.logger.error(msg);
                                        }
                                        break block21;
                                    }
                                    LibrariesUI.this.logger.error(msg);
                                }
                            } else {
                                empty = true;
                            }
                        }
                        if (empty) {
                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.nothing.selected.in.browser"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 2);
                        }
                    }
                });
                this.directoryPicker.directorySelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String path = LibrariesUI.this.directorySystemPicker(LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"));
                        path = Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), path);
                        boolean found = false;
                        Library lib = libMeta.repo.getLibraryData().libraries.bibliography[LibrariesUI.this.currentLibraryIndex];
                        for (int j = 0; j < lib.sources.length; ++j) {
                            if (!lib.sources[j].equals(path)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.that.source.is.already.defined"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.source.path"), 0);
                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText("");
                            LibrariesUI.this.directoryPicker.pane.requestFocus();
                        } else {
                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                        }
                    }
                });
                this.directoryPicker.pane.addPropertyChangeListener("value", ignored -> {
                    int selectedValue;
                    if (this.directoryPicker.pane != null && this.directoryPicker.pane.getValue() != null && (selectedValue = ((Integer)this.directoryPicker.pane.getValue()).intValue()) == 0) {
                        Library lib = libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex];
                        String path = this.directoryPicker.directoryPathTextField.getText();
                        if (path != null && path.length() > 0) {
                            int arraySize = lib.sources.length + 1;
                            String[] expanded = new String[arraySize];
                            System.arraycopy(lib.sources, 0, expanded, 0, lib.sources.length);
                            expanded[arraySize - 1] = path;
                            lib.sources = expanded;
                            this.listSourcesModel.addElement(path);
                            libMeta.setDataHasChanged();
                        }
                        this.currentSourceIndex = lib.sources.length - 1;
                        this.loadSources();
                        this.mf.listSources.setSelectedIndex(this.currentSourceIndex);
                    }
                    this.mf.tabbedPaneMain.setSelectedIndex(1);
                    this.mf.buttonNew.setEnabled(true);
                    this.mf.buttonCopy.setEnabled(true);
                    this.mf.buttonDelete.setEnabled(true);
                    this.mf.librariesConfigItems.setEnabled(true);
                    this.mf.tabbedPaneLibrarySpaces.setEnabled(true);
                    this.mf.tableBiblioLibraries.setEnabled(true);
                    this.mf.buttonAddLibrary.setEnabled(true);
                    this.mf.buttonRemoveLibrary.setEnabled(true);
                    this.mf.buttonAddSource.setEnabled(true);
                    this.mf.saveButton.setEnabled(true);
                    this.mf.cancelButton.setEnabled(true);
                    this.directoryPicker.dialog.dispose();
                    this.mf.buttonAddSource.requestFocus();
                    this.directoryPicker = null;
                });
                this.mf.buttonNew.setEnabled(false);
                this.mf.buttonCopy.setEnabled(false);
                this.mf.buttonDelete.setEnabled(false);
                this.mf.librariesConfigItems.setEnabled(false);
                this.mf.tabbedPaneLibrarySpaces.setEnabled(false);
                this.mf.tableBiblioLibraries.setEnabled(false);
                this.mf.buttonAddLibrary.setEnabled(false);
                this.mf.buttonRemoveLibrary.setEnabled(false);
                this.mf.buttonAddSource.setEnabled(false);
                this.mf.buttonAddMultiSource.setEnabled(false);
                this.mf.saveButton.setEnabled(false);
                this.mf.cancelButton.setEnabled(false);
                this.directoryPicker.dialog.setVisible(true);
            }
        }
    }

    private void actionSourcesDown(ActionEvent e) {
        if (this.currentConfigIndex >= 0) {
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            int[] rows = this.mf.listSources.getSelectedIndices();
            if (rows.length > 1) {
                JOptionPane.showMessageDialog(this.mf, this.context.cfg.gs("Libraries.please.select.a.single.source.to.move"), this.displayName, 1);
            } else if (rows.length == 1) {
                int row = rows[0];
                String[] sources = libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources;
                if (row >= 0 && row < sources.length - 1) {
                    this.mf.listSources.requestFocus();
                    String s1 = sources[row];
                    String s2 = sources[row + 1];
                    sources[row + 1] = s1;
                    sources[row] = s2;
                    libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources = sources;
                    libMeta.setDataHasChanged();
                    this.currentSourceIndex = row + 1;
                    this.loadSources();
                    this.mf.listSources.setSelectedIndex(this.currentSourceIndex);
                }
            }
        }
    }

    private void actionSourcesMultiClicked(ActionEvent e) {
        if (this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            final LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            if (libMeta.repo.getLibraryData().libraries.bibliography.length > 0 && this.currentLibraryIndex < libMeta.repo.getLibraryData().libraries.bibliography.length) {
                this.directoryPicker = new DirectoryPicker(this.context, this.context.cfg.gs("Libraries.select.new.multiple.source.path"), MessageFormat.format(this.context.cfg.gs("Libraries.select.new.multiple.source"), libMeta.repo.getLibraryData().libraries.description), false, true, "");
                this.directoryPicker.browserSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean empty;
                        block19: {
                            boolean done = false;
                            empty = false;
                            boolean isSubscriber = false;
                            int reply = 1;
                            if (LibrariesUI.this.context.browser.lastComponent != null) {
                                try {
                                    LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(0);
                                    ArrayList<Origin> origins = new ArrayList<Origin>();
                                    isSubscriber = Origins.makeOriginsFromSelected(LibrariesUI.this.context, LibrariesUI.this.context.mainFrame, origins);
                                    if (origins != null && origins.size() > 0) {
                                        int count = origins.size();
                                        Origin origin = origins.get(0);
                                        if (count != 1 || origin.getType() != 6 || !origin.tuo.isDir) {
                                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.please.select.a.single.directory.to.add"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0);
                                        } else {
                                            String path = origin.tuo.isRemote ? origin.getLocation() : Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), origin.getLocation());
                                            boolean found = false;
                                            Library lib = libMeta.repo.getLibraryData().libraries.bibliography[LibrariesUI.this.currentLibraryIndex];
                                            for (int j = 0; j < lib.sources.length; ++j) {
                                                if (!lib.sources[j].equals(path)) continue;
                                                found = true;
                                                break;
                                            }
                                            if (found) {
                                                JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.that.source.is.already.defined"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0);
                                                LibrariesUI.this.directoryPicker.directoryPathTextField.setText("");
                                                LibrariesUI.this.directoryPicker.pane.requestFocus();
                                            } else {
                                                String key = origin.tuo.node.getMyRepo().getLibraryData().libraries.key;
                                                if (!libMeta.repo.getLibraryData().libraries.key.equals(key)) {
                                                    String name = libMeta.repo.getLibraryData().libraries.description;
                                                    reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.selected.path.is.not.from.repository.continue"), name), LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0);
                                                    if (reply == 0) {
                                                        done = true;
                                                    }
                                                } else {
                                                    LibrariesUI.this.directoryPicker.pane.requestFocus();
                                                    String which = isSubscriber ? LibrariesUI.this.context.cfg.gs("Z.subscriber") : LibrariesUI.this.context.cfg.gs("Z.publisher");
                                                    String message = MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.use.selected.item"), which);
                                                    reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, message, LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0);
                                                    done = true;
                                                }
                                            }
                                            if (reply == 0) {
                                                LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                                            }
                                            if (done) {
                                                LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(1);
                                            }
                                        }
                                        break block19;
                                    }
                                    empty = true;
                                }
                                catch (Exception e) {
                                    String msg = LibrariesUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                    if (e.getMessage() == null || !e.getMessage().equals("HANDLED_INTERNALLY")) {
                                        if (LibrariesUI.this.context.navigator != null) {
                                            LibrariesUI.this.logger.error(msg);
                                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, msg, LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0);
                                        } else {
                                            LibrariesUI.this.logger.error(msg);
                                        }
                                        break block19;
                                    }
                                    LibrariesUI.this.logger.error(msg);
                                }
                            } else {
                                empty = true;
                            }
                        }
                        if (empty) {
                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.nothing.selected.in.browser"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 2);
                        }
                    }
                });
                this.directoryPicker.directorySelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String path = LibrariesUI.this.directorySystemPicker(LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"));
                        path = Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), path);
                        boolean found = false;
                        Library lib = libMeta.repo.getLibraryData().libraries.bibliography[LibrariesUI.this.currentLibraryIndex];
                        for (int j = 0; j < lib.sources.length; ++j) {
                            if (!lib.sources[j].equals(path)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.that.source.is.already.defined"), LibrariesUI.this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0);
                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText("");
                            LibrariesUI.this.directoryPicker.pane.requestFocus();
                        } else {
                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                        }
                    }
                });
                this.directoryPicker.allCheckbox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean sense = LibrariesUI.this.directoryPicker.allCheckbox.isSelected();
                        for (int i = 0; i < LibrariesUI.this.librarySelectorTableModel.getRowCount(); ++i) {
                            LibrariesUI.this.librarySelectors[i].selected = sense;
                        }
                        LibrariesUI.this.librarySelectorTableModel.fireTableDataChanged();
                    }
                });
                this.directoryPicker.pane.addPropertyChangeListener("value", ignored -> {
                    String path;
                    int selectedValue;
                    if (this.directoryPicker.pane != null && this.directoryPicker.pane.getValue() != null && (selectedValue = ((Integer)this.directoryPicker.pane.getValue()).intValue()) == 0 && (path = this.directoryPicker.directoryPathTextField.getText()) != null && path.length() > 0) {
                        try {
                            for (int i = 0; i < this.librarySelectors.length; ++i) {
                                Library lib;
                                if (!this.librarySelectors[i].selected || (lib = libMeta.repo.getLibrary(this.librarySelectors[i].name)) == null) continue;
                                String source = path + libMeta.repo.getSeparator() + lib.name;
                                boolean found = false;
                                for (int j = 0; j < lib.sources.length; ++j) {
                                    if (!lib.sources[j].equals(source)) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    int srcSize = lib.sources.length + 1;
                                    String[] expSources = new String[srcSize];
                                    System.arraycopy(lib.sources, 0, expSources, 0, lib.sources.length);
                                    expSources[srcSize - 1] = source;
                                    lib.sources = expSources;
                                    libMeta.setDataHasChanged();
                                    continue;
                                }
                                if (this.dontAsk) continue;
                                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok"), this.context.cfg.gs("Z.dont.ask.again")};
                                int reply = JOptionPane.showOptionDialog(this.directoryPicker.pane, MessageFormat.format(this.context.cfg.gs("Libraries.select.new.multiple.already.defined"), source, lib.name), this.context.cfg.gs("Libraries.select.new.multiple.source.path"), 0, 2, null, opts, opts[0]);
                                if (reply != 1) continue;
                                this.dontAsk = true;
                            }
                        }
                        catch (MungeException mungeException) {
                            // empty catch block
                        }
                        this.loadSources();
                    }
                    this.mf.tabbedPaneMain.setSelectedIndex(1);
                    this.mf.buttonNew.setEnabled(true);
                    this.mf.buttonCopy.setEnabled(true);
                    this.mf.buttonDelete.setEnabled(true);
                    this.mf.librariesConfigItems.setEnabled(true);
                    this.mf.tabbedPaneLibrarySpaces.setEnabled(true);
                    this.mf.tableBiblioLibraries.setEnabled(true);
                    this.mf.buttonAddLibrary.setEnabled(true);
                    this.mf.buttonRemoveLibrary.setEnabled(true);
                    this.mf.buttonAddSource.setEnabled(true);
                    this.mf.buttonAddMultiSource.setEnabled(true);
                    this.mf.saveButton.setEnabled(true);
                    this.mf.cancelButton.setEnabled(true);
                    this.directoryPicker.dialog.dispose();
                    this.mf.buttonAddMultiSource.requestFocus();
                    this.directoryPicker = null;
                });
                if (libMeta.repo != null && libMeta.repo.getLibraryData().libraries.bibliography != null && libMeta.repo.getLibraryData().libraries.bibliography.length > 0) {
                    Library[] biblio = libMeta.repo.getLibraryData().libraries.bibliography;
                    this.librarySelectors = new LibrarySelector[biblio.length];
                    this.librarySelectorTableModel = new LibrarySelectorTableModel(this.context, this.librarySelectors);
                    for (int i = 0; i < biblio.length; ++i) {
                        LibrarySelector libSel;
                        this.librarySelectors[i] = libSel = new LibrarySelector(biblio[i].name);
                    }
                    Arrays.sort(this.librarySelectors);
                } else {
                    this.librarySelectors = new LibrarySelector[0];
                    this.librarySelectorTableModel = new LibrarySelectorTableModel(this.context, null);
                }
                this.directoryPicker.table.setModel(this.librarySelectorTableModel);
                TableColumn column = this.directoryPicker.table.getColumnModel().getColumn(0);
                column.setResizable(false);
                column.setWidth(32);
                column.setPreferredWidth(32);
                column.setMaxWidth(32);
                column.setMinWidth(32);
                column = this.directoryPicker.table.getColumnModel().getColumn(1);
                column.setResizable(false);
                this.mf.buttonNew.setEnabled(false);
                this.mf.buttonCopy.setEnabled(false);
                this.mf.buttonDelete.setEnabled(false);
                this.mf.librariesConfigItems.setEnabled(false);
                this.mf.tabbedPaneLibrarySpaces.setEnabled(false);
                this.mf.tableBiblioLibraries.setEnabled(false);
                this.mf.buttonAddLibrary.setEnabled(false);
                this.mf.buttonRemoveLibrary.setEnabled(false);
                this.mf.buttonAddSource.setEnabled(false);
                this.mf.buttonAddMultiSource.setEnabled(false);
                this.mf.saveButton.setEnabled(false);
                this.mf.cancelButton.setEnabled(false);
                this.directoryPicker.dialog.setVisible(true);
            }
        }
    }

    private void actionSourcesRemove(ActionEvent e) {
        if (this.currentConfigIndex >= 0) {
            int reply;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            int[] rows = this.mf.listSources.getSelectedIndices();
            if (rows.length > 0 && (reply = JOptionPane.showConfirmDialog(this.mf, MessageFormat.format(this.context.cfg.gs("Libraries.remove.sources.from.library"), rows.length, libMeta.description, libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].name), this.displayName, 0)) == 0) {
                int i;
                String[] sources = libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources;
                ArrayList<String> sourcesList = new ArrayList<String>();
                for (i = 0; i < sources.length; ++i) {
                    sourcesList.add(sources[i]);
                }
                for (i = rows.length - 1; i >= 0; --i) {
                    sourcesList.remove(rows[i]);
                }
                sources = new String[sourcesList.size()];
                for (i = 0; i < sourcesList.size(); ++i) {
                    sources[i] = (String)sourcesList.get(i);
                }
                libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources = sources;
                libMeta.setDataHasChanged();
                this.loadSources();
                this.mf.tableLocations.changeSelection(this.currentLocationIndex, 0, false, false);
            }
        }
    }

    private void actionSourcesUp(ActionEvent e) {
        if (this.currentConfigIndex >= 0) {
            int row;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            int[] rows = this.mf.listSources.getSelectedIndices();
            if (rows.length > 1) {
                JOptionPane.showMessageDialog(this.mf, this.context.cfg.gs("Libraries.please.select.a.single.source.to.move"), this.displayName, 1);
            } else if (rows.length == 1 && (row = rows[0]) > 0) {
                this.mf.listSources.requestFocus();
                String[] sources = libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources;
                String s1 = sources[row];
                String s2 = sources[row - 1];
                sources[row - 1] = s1;
                sources[row] = s2;
                libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources = sources;
                libMeta.setDataHasChanged();
                this.currentSourceIndex = row - 1;
                this.loadSources();
                this.mf.listSources.setSelectedIndex(this.currentSourceIndex);
            }
        }
    }

    private void actionSelectTempLocationClicked(ActionEvent e) {
        if (this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            final LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            this.directoryPicker = new DirectoryPicker(this.context, this.context.cfg.gs("Libraries.select.temp.location.path"), this.context.cfg.gs("Libraries.select.temp.location") + ": " + libMeta.repo.getLibraryData().libraries.description, false, false, ((LibMeta)this.configModel.getValueAt((int)this.currentConfigIndex, (int)0)).repo.getLibraryData().libraries.temp_location);
            this.directoryPicker.browserSelectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean empty;
                    block16: {
                        boolean done = false;
                        empty = false;
                        boolean isSubscriber = false;
                        int reply = 1;
                        if (LibrariesUI.this.context.browser.lastComponent != null) {
                            try {
                                LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(0);
                                ArrayList<Origin> origins = new ArrayList<Origin>();
                                isSubscriber = Origins.makeOriginsFromSelected(LibrariesUI.this.context, LibrariesUI.this.context.mainFrame, origins);
                                if (origins != null && origins.size() > 0) {
                                    int count = origins.size();
                                    Origin origin = origins.get(0);
                                    if (count != 1 || origin.getType() != 6 || !origin.tuo.isDir) {
                                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.please.select.a.single.directory.to.add"), LibrariesUI.this.context.cfg.gs("Libraries.select.temp.location.path"), 0);
                                    } else {
                                        String path = origin.tuo.isRemote ? origin.getLocation() : Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), origin.getLocation());
                                        String key = origin.tuo.node.getMyRepo().getLibraryData().libraries.key;
                                        if (!libMeta.repo.getLibraryData().libraries.key.equals(key)) {
                                            String name = libMeta.repo.getLibraryData().libraries.description;
                                            reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.selected.path.is.not.from.repository.continue"), name), LibrariesUI.this.context.cfg.gs("Libraries.select.temp.location.path"), 0);
                                            if (reply == 0) {
                                                done = true;
                                            }
                                        } else {
                                            LibrariesUI.this.directoryPicker.pane.requestFocus();
                                            String which = isSubscriber ? LibrariesUI.this.context.cfg.gs("Z.subscriber") : LibrariesUI.this.context.cfg.gs("Z.publisher");
                                            String message = MessageFormat.format(LibrariesUI.this.context.cfg.gs("Libraries.use.selected.item"), which);
                                            reply = JOptionPane.showConfirmDialog(LibrariesUI.this.directoryPicker.pane, message, LibrariesUI.this.context.cfg.gs("Libraries.select.temp.location.path"), 0);
                                            done = true;
                                        }
                                        if (reply == 0) {
                                            LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                                        }
                                        if (done) {
                                            LibrariesUI.this.mf.tabbedPaneMain.setSelectedIndex(1);
                                        }
                                    }
                                    break block16;
                                }
                                empty = true;
                            }
                            catch (Exception e) {
                                String msg = LibrariesUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                if (e.getMessage() == null || !e.getMessage().equals("HANDLED_INTERNALLY")) {
                                    if (LibrariesUI.this.context.navigator != null) {
                                        LibrariesUI.this.logger.error(msg);
                                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, msg, LibrariesUI.this.context.cfg.gs("Libraries.select.temp.location.path"), 0);
                                    } else {
                                        LibrariesUI.this.logger.error(msg);
                                    }
                                    break block16;
                                }
                                LibrariesUI.this.logger.error(msg);
                            }
                        } else {
                            empty = true;
                        }
                    }
                    if (empty) {
                        JOptionPane.showMessageDialog(LibrariesUI.this.directoryPicker.pane, LibrariesUI.this.context.cfg.gs("Libraries.nothing.selected.in.browser"), LibrariesUI.this.context.cfg.gs("Libraries.select.temp.location.path"), 2);
                    }
                }
            });
            this.directoryPicker.directorySelectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String path = LibrariesUI.this.directorySystemPicker(LibrariesUI.this.context.cfg.gs("Libraries.select.temp.location.path"));
                    path = Utils.makeRelativePath(LibrariesUI.this.context.cfg.getWorkingDirectory(), path);
                    LibrariesUI.this.directoryPicker.directoryPathTextField.setText(path);
                }
            });
            this.directoryPicker.pane.addPropertyChangeListener("value", ignored -> {
                String path;
                int selectedValue;
                if (this.directoryPicker.pane != null && this.directoryPicker.pane.getValue() != null && (selectedValue = ((Integer)this.directoryPicker.pane.getValue()).intValue()) == 0 && (path = this.directoryPicker.directoryPathTextField.getText()).length() > 0) {
                    this.mf.textFieldTempLocation.setText(path);
                    this.mf.textFieldTempLocation.postActionEvent();
                    libMeta.setDataHasChanged();
                }
                this.mf.tabbedPaneMain.setSelectedIndex(1);
                this.mf.buttonNew.setEnabled(true);
                this.mf.buttonCopy.setEnabled(true);
                this.mf.buttonDelete.setEnabled(true);
                this.mf.librariesConfigItems.setEnabled(true);
                this.mf.tabbedPaneLibrarySpaces.setEnabled(true);
                this.mf.saveButton.setEnabled(true);
                this.mf.cancelButton.setEnabled(true);
                this.directoryPicker.dialog.dispose();
                this.mf.textFieldTempLocation.requestFocus();
                this.directoryPicker = null;
            });
            this.mf.buttonNew.setEnabled(false);
            this.mf.buttonCopy.setEnabled(false);
            this.mf.buttonDelete.setEnabled(false);
            this.mf.librariesConfigItems.setEnabled(false);
            this.mf.tabbedPaneLibrarySpaces.setEnabled(false);
            this.mf.saveButton.setEnabled(false);
            this.mf.cancelButton.setEnabled(false);
            this.directoryPicker.dialog.setVisible(true);
        }
    }

    private void actionUndoClicked(ActionEvent e) {
        if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this.context.mainFrame, this.context.cfg.gs("Z.cancel.all.changes"), this.context.cfg.gs("Navigator.splitPane.Libraries.tab.title"), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
            }
        } else {
            this.mf.labelStatusMiddle.setText(this.context.cfg.gs("Libraries.nothing.to.undo"));
        }
    }

    private void cancelChanges() {
        LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
        if (this.deletedLibraries.size() > 0) {
            this.deletedLibraries = new ArrayList();
        }
        this.currentConfigIndex = 0;
        this.currentLocationIndex = 0;
        this.currentLibraryIndex = 0;
        this.currentSourceIndex = 0;
        this.loadConfigurations();
        int cci = this.configModel.findIndex(libMeta);
        if (cci >= 0) {
            this.configItems.setRowSelectionInterval(cci, cci);
        }
        this.mf.labelStatusMiddle.setText(this.context.cfg.gs("Libraries.libraries.changes.cancelled"));
    }

    public void cardShown(ComponentEvent e) {
    }

    public boolean checkForChanges() {
        if (!this.deletedLibraries.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((LibMeta)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private String directorySystemPicker(String title) {
        String path;
        block2: {
            File file;
            path = "";
            JFileChooser fc = new JFileChooser();
            fc.setFileHidingEnabled(false);
            fc.setDialogTitle(title);
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }

                @Override
                public String getDescription() {
                    String desc = LibrariesUI.this.context.cfg.gs("Libraries.select.directory");
                    return desc;
                }
            });
            fc.setFileSelectionMode(1);
            fc.setAcceptAllFileFilterUsed(false);
            if (this.lastDirectory != null) {
                fc.setCurrentDirectory(this.lastDirectory);
            } else {
                fc.setCurrentDirectory(new File(this.context.cfg.getWorkingDirectory()));
            }
            fc.setDialogType(1);
            int selection = fc.showOpenDialog(this.directoryPicker == null ? this.mf : this.directoryPicker.pane);
            if (selection != 0) break block2;
            this.lastDirectory = file = fc.getSelectedFile();
            path = Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), file.getPath());
        }
        return path;
    }

    private String filePickerDirectory(String path) {
        if (Utils.isRelativePath((String)path)) {
            path = this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + (String)path;
        }
        return Utils.getLeftPath((String)path, Utils.getSeparatorFromPath((String)path));
    }

    public void genericAction(ActionEvent e) {
        if (e.getSource().getClass().equals(JButton.class)) {
            JButton button = (JButton)e.getSource();
            if (!button.getActionCommand().toLowerCase().endsWith("filepick")) {
                this.updateOnChange(e.getSource());
            }
        } else {
            this.updateOnChange(e.getSource());
        }
    }

    public void genericTextFieldFocusLost(FocusEvent e) {
        if (!(e.getOppositeComponent() instanceof JTable)) {
            this.updateOnChange(e.getSource());
        }
    }

    public ArrayList<LibMeta> getDeletedLibraries() {
        return this.deletedLibraries;
    }

    public String getDirectoryPath() {
        String path = System.getProperty("user.dir") + System.getProperty("file.separator") + "libraries";
        return path;
    }

    private ArrayList<Conflict> getJobKeyReferences(String oldKey, String newKey) {
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        for (int i = 0; i < this.getJobsList().size(); ++i) {
            Job job = (Job)this.getJobsList().get(i);
            for (int j = 0; j < job.getTasks().size(); ++j) {
                Task task = job.getTasks().get(j);
                if (!task.getPublisherKey().equals(oldKey) && !task.getSubscriberKey().equals(oldKey) && !task.getHintsKey().equals(oldKey)) continue;
                Conflict conflict = new Conflict();
                conflict.job = job;
                conflict.oldName = oldKey;
                conflict.newName = newKey;
                conflict.taskNumber = j;
                conflicts.add(conflict);
            }
        }
        return conflicts;
    }

    public AbstractList<AbstractTool> getJobsList() {
        return this.jobsList;
    }

    private Repositories getRepositories() {
        Repositories repositories = null;
        try {
            repositories = new Repositories();
            repositories.loadList(this.context);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this.mf, msg, this.displayName, 0);
        }
        return repositories;
    }

    private void initNewCard() {
        this.loading = true;
        this.updateState();
        this.loading = false;
    }

    private void initialize() {
        this.configItems = this.mf.librariesConfigItems;
        this.deletedLibraries = new ArrayList();
        Icon icon = this.mf.labelLibrariesHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.mf.labelLibrariesHelp.setIcon(replacement);
        this.mf.splitPaneLibs.setDividerLocation(this.context.preferences.getLibrariesDividerLocation());
        this.mf.splitPanelBiblio.setDividerLocation(this.context.preferences.getLibrariesBiblioDividerLocation());
        this.configModel = new ConfigModel(this.context, this.displayName, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.mf.scrollPaneConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel sm;
                int index;
                if (!listSelectionEvent.getValueIsAdjusting() && (index = (sm = (ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex()) >= 0 && index != LibrariesUI.this.currentConfigIndex) {
                    LibrariesUI.this.currentConfigIndex = index;
                    LibrariesUI.this.currentLocationIndex = 0;
                    LibrariesUI.this.currentLibraryIndex = 0;
                    LibrariesUI.this.currentSourceIndex = 0;
                    LibrariesUI.this.loadGeneralTab();
                }
                LibrariesUI.this.mf.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
            }
        });
        this.mf.tabbedPaneLibrarySpaces.addChangeListener(e -> this.tabbedPaneLibrarySpacesStateChanged(e));
        this.locationsTableModel = new LocationsTableModel(this.context, null);
        ListSelectionModel llsm = this.mf.tableLocations.getSelectionModel();
        llsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel sm;
                int index;
                if (!listSelectionEvent.getValueIsAdjusting() && (index = (sm = (ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex()) >= 0 && index != LibrariesUI.this.currentLocationIndex) {
                    LibrariesUI.this.currentLocationIndex = index;
                    LibrariesUI.this.mf.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                }
            }
        });
        this.mf.tableLocations.setModel(this.locationsTableModel);
        this.mf.tableLocations.getColumnModel().getColumn(0).setWidth(this.context.preferences.getLibrariesLocationColumnWidth());
        this.mf.tableLocations.getColumnModel().getColumn(0).setPreferredWidth(this.context.preferences.getLibrariesLocationColumnWidth());
        this.mf.tableLocations.getColumnModel().getColumn(1).setWidth(this.context.preferences.getLibrariesMinimumSizeColumnWidth());
        this.mf.tableLocations.getColumnModel().getColumn(1).setPreferredWidth(this.context.preferences.getLibrariesMinimumSizeColumnWidth());
        this.biblioLibrariesTableModel = new BiblioLibrariesTableModel(this.context);
        this.biblioLibrariesTableModel.setColumnCount(2);
        this.biblioLibrariesTableModel.setDisplayName(this.displayName);
        this.mf.tableBiblioLibraries.setModel(this.biblioLibrariesTableModel);
        this.mf.tableBiblioLibraries.getTableHeader().setUI(null);
        this.mf.tableBiblioLibraries.setTableHeader(null);
        this.mf.scrollPaneBiblioLibraries.setColumnHeaderView(null);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(0).setMinWidth(10);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(1).setPreferredWidth(24);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(1).setWidth(24);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(1).setMaxWidth(24);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(1).setMinWidth(24);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(1).setResizable(false);
        this.mf.tableBiblioLibraries.getColumnModel().getColumn(1).setCellRenderer(new MatchDateCell(this.context));
        ListSelectionModel blsm = this.mf.tableBiblioLibraries.getSelectionModel();
        blsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel sm;
                int index;
                if (!LibrariesUI.this.loading && !listSelectionEvent.getValueIsAdjusting() && (index = (sm = (ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex()) >= 0 && index != LibrariesUI.this.currentLibraryIndex) {
                    LibrariesUI.this.currentLibraryIndex = index;
                    LibrariesUI.this.currentSourceIndex = 0;
                    LibrariesUI.this.mf.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                    LibrariesUI.this.loadSources();
                }
            }
        });
        this.listSourcesModel = new DefaultListModel();
        this.mf.listSources.setModel(this.listSourcesModel);
        ListSelectionModel slsm = this.mf.listSources.getSelectionModel();
        slsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel sm;
                int index;
                if (!LibrariesUI.this.loading && !listSelectionEvent.getValueIsAdjusting() && (index = (sm = (ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex()) >= 0 && index != LibrariesUI.this.currentSourceIndex) {
                    LibrariesUI.this.currentSourceIndex = index;
                }
            }
        });
        this.modes = new Mode[3];
        this.modes[0] = new Mode(this, this.context.cfg.gs("Libraries.library"), Cards.Library);
        this.modes[1] = new Mode(this, this.context.cfg.gs("Libraries.hint.server"), Cards.HintServer);
        this.modes[2] = new Mode(this, this.context.cfg.gs("Libraries.targets"), Cards.Targets);
        this.comboBoxMode = new JComboBox();
        this.comboBoxMode.setModel(new DefaultComboBoxModel<Mode>(new Mode[0]));
        this.comboBoxMode.removeAllItems();
        for (Mode m : this.modes) {
            this.comboBoxMode.addItem(m);
        }
        this.numberFilter = new NumberFilter();
        this.setNumberFilter(this.mf.textFieldTimeout);
        this.currentConfigIndex = 0;
        this.currentLocationIndex = 0;
        this.currentLibraryIndex = 0;
        this.currentSourceIndex = 0;
        this.context.mainFrame.dynamicLabel.setVisible(false);
        this.initializeControls();
        this.loadConfigurations();
        this.loadJobs();
        this.configItems.requestFocus();
    }

    private void initializeControls() {
        this.mf.cancelButton.addActionListener(e -> this.actionUndoClicked(e));
        this.mf.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.mf.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.mf.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.mf.saveButton.addActionListener(e -> this.actionOkClicked(e));
        this.mf.labelLibrariesHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LibrariesUI.this.actionHelpClicked(e);
            }
        });
        this.mf.textFieldKey.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!LibrariesUI.this.promptingKeyChange) {
                    LibrariesUI.this.genericTextFieldFocusLost(e);
                }
            }
        });
        this.mf.textFieldKey.addActionListener(e -> this.genericAction(e));
        this.mf.buttonLibraryGenerateKey.addActionListener(e -> this.actionGenerateUUIDClicked(e));
        this.mf.textFieldHost.addActionListener(e -> this.genericAction(e));
        this.mf.textFieldHost.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LibrariesUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.mf.textFieldListen.addActionListener(e -> this.genericAction(e));
        this.mf.textFieldListen.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LibrariesUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.mf.textFieldTimeout.addActionListener(e -> this.genericAction(e));
        this.mf.textFieldTimeout.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LibrariesUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.mf.comboBoxFlavor.addActionListener(e -> this.genericAction(e));
        this.mf.checkBoxCase.addActionListener(e -> this.genericAction(e));
        this.mf.checkBoxTempDated.addActionListener(e -> this.genericAction(e));
        this.mf.textFieldTempLocation.addActionListener(e -> this.genericAction(e));
        this.mf.textFieldTempLocation.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LibrariesUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.mf.buttonLibrarySelectTempLocation.addActionListener(e -> this.actionSelectTempLocationClicked(e));
        this.mf.checkBoxTerminalAllowed.addActionListener(e -> this.genericAction(e));
        this.mf.buttonLibrariesAddIgnore.addActionListener(e -> this.actionIgnorePatternAdd(e));
        this.mf.buttonLibrariesRemoveIgnore.addActionListener(e -> this.actionIgnorePatternRemove(e));
        this.mf.textFieldEmailAddr.addActionListener(e -> this.genericAction(e));
        this.mf.textFieldEmailAddr.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LibrariesUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.mf.comboBoxFormat.addActionListener(e -> this.genericAction(e));
        this.mf.checkBoxMismatches.addActionListener(e -> this.genericAction(e));
        this.mf.checkBoxWhatsNew.addActionListener(e -> this.genericAction(e));
        this.mf.checkBoxSkipOffline.addActionListener(e -> this.genericAction(e));
        this.mf.buttonAddLocation.addActionListener(e -> this.actionLocationAddClicked(e));
        this.mf.buttonRemoveLocation.addActionListener(e -> this.actionLocationsRemove(e));
        this.mf.buttonAddLibrary.addActionListener(e -> this.actionLibraryAdd(e));
        this.mf.buttonRemoveLibrary.addActionListener(e -> this.actionLibraryRemove(e));
        this.mf.buttonAddSource.addActionListener(e -> this.actionSourcesAddClicked(e));
        TextIcon t1 = new TextIcon(this.mf.buttonUpSource, ">", TextIcon.Layout.HORIZONTAL);
        this.mf.buttonUpSource.setText("");
        RotatedIcon r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.UP);
        this.mf.buttonUpSource.setIcon(r1);
        this.mf.buttonUpSource.addActionListener(e -> this.actionSourcesUp(e));
        t1 = new TextIcon(this.mf.buttonDownSource, ">", TextIcon.Layout.HORIZONTAL);
        this.mf.buttonDownSource.setText("");
        r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.DOWN);
        this.mf.buttonDownSource.setIcon(r1);
        this.mf.buttonDownSource.addActionListener(e -> this.actionSourcesDown(e));
        this.mf.buttonRemoveSource.addActionListener(e -> this.actionSourcesRemove(e));
        this.mf.buttonAddMultiSource.addActionListener(e -> this.actionSourcesMultiClicked(e));
    }

    private void loadBibliographyTab() {
        this.mf.tableBiblioLibraries.removeAll();
        this.biblioLibrariesTableModel.getDataVector().removeAllElements();
        this.biblioLibrariesTableModel.setEditable(true);
        if (!this.loading && this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            this.loading = true;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            this.biblioLibrariesTableModel.setLibMeta(libMeta);
            Object[] libraries = libMeta.repo.getLibraryData().libraries.bibliography;
            if (!libMeta.isDataChanged() && libraries != null && libraries.length > 0) {
                Arrays.sort(libraries);
            }
            if (libraries != null && libraries.length > 0) {
                for (int i = 0; i < libraries.length; ++i) {
                    this.biblioLibrariesTableModel.addRow(new Object[]{libraries[i]});
                }
            }
            this.biblioLibrariesTableModel.fireTableDataChanged();
            if (this.biblioLibrariesTableModel.getRowCount() == 0) {
                this.mf.buttonRemoveLibrary.setEnabled(false);
                this.mf.buttonAddSource.setEnabled(false);
                this.mf.buttonAddMultiSource.setEnabled(false);
                this.mf.buttonUpSource.setEnabled(false);
                this.mf.buttonDownSource.setEnabled(false);
                this.mf.buttonRemoveSource.setEnabled(false);
            } else {
                this.mf.buttonRemoveLibrary.setEnabled(true);
                this.mf.buttonAddSource.setEnabled(true);
                int len = libMeta.repo.getLibraryData().libraries.bibliography.length;
                if (len == 0 || this.currentLibraryIndex >= len) {
                    this.currentLibraryIndex = 0;
                }
                if (libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources.length > 1) {
                    this.mf.buttonAddMultiSource.setEnabled(true);
                    this.mf.buttonUpSource.setEnabled(true);
                    this.mf.buttonDownSource.setEnabled(true);
                } else {
                    this.mf.buttonUpSource.setEnabled(false);
                    this.mf.buttonDownSource.setEnabled(false);
                }
                if (libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex].sources.length > 0) {
                    this.mf.buttonRemoveSource.setEnabled(true);
                }
                this.mf.tableBiblioLibraries.changeSelection(this.currentLibraryIndex, 0, false, false);
            }
            this.loading = false;
            this.loadSources();
            if (libMeta.repo.isDynamic()) {
                this.mf.buttonAddLibrary.setEnabled(false);
                this.mf.buttonRemoveLibrary.setEnabled(false);
                this.mf.buttonAddSource.setEnabled(false);
                this.mf.buttonAddMultiSource.setEnabled(false);
                this.mf.buttonUpSource.setEnabled(false);
                this.mf.buttonDownSource.setEnabled(false);
                this.mf.buttonRemoveSource.setEnabled(false);
                this.biblioLibrariesTableModel.setEditable(false);
            } else {
                this.mf.buttonAddLibrary.setEnabled(true);
            }
        }
    }

    public void loadConfigurations() {
        this.loading = true;
        this.configModel.setRowCount(0);
        this.biblioLibrariesTableModel.setRowCount(0);
        Repositories repositories = this.getRepositories();
        if (repositories.getMetaList() != null) {
            for (RepoMeta repoMeta : repositories.getMetaList()) {
                LibMeta libMeta = new LibMeta();
                libMeta.description = repoMeta.description;
                libMeta.key = repoMeta.key;
                libMeta.path = repoMeta.path;
                libMeta.card = Cards.Library;
                libMeta.dataHasChanged = false;
                try {
                    Repository repo = repositories.findRepoPath(libMeta.path);
                    if (repo != null) {
                        libMeta.repo = repo;
                    } else {
                        libMeta.repo = new Repository(this.context, -1);
                        libMeta.repo.read(libMeta.path, "a", false);
                    }
                }
                catch (Exception e) {
                    String msg = e.getMessage() + " : " + Utils.getStackTrace(e);
                    this.logger.error(msg);
                    JOptionPane.showMessageDialog(this.mf, msg, this.displayName, 0);
                }
                this.configModel.addRow(new Object[]{libMeta});
            }
        }
        this.loading = false;
        if (this.configModel.getRowCount() == 0) {
            this.mf.buttonCopy.setEnabled(false);
            this.mf.buttonDelete.setEnabled(false);
            this.mf.saveButton.setEnabled(false);
        } else {
            this.currentConfigIndex = 0;
            this.configItems.setRowSelectionInterval(0, 0);
            this.loadGeneralTab();
            this.configItems.requestFocus();
        }
    }

    private void loadGeneralTab() {
        if (!this.loading && this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            int index;
            this.loading = true;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            ((CardLayout)this.mf.generalOptions.getLayout()).show(this.mf.generalOptions, libMeta.card.name());
            Repository repo = libMeta.repo;
            Libraries libraries = repo.getLibraryData().libraries;
            Dimension d = this.mf.textFieldPath.getSize();
            this.mf.textFieldPath.setPreferredSize(d);
            this.mf.textFieldPath.setText(repo.getJsonFilename());
            this.mf.textFieldKey.setText(libraries.key);
            this.mf.textFieldHost.setText(libraries.host);
            this.mf.textFieldListen.setText(libraries.listen);
            this.mf.textFieldTimeout.setText(Integer.toString(libraries.timeout));
            int n = libraries.flavor.toLowerCase().equals("linux") ? 0 : (libraries.flavor.toLowerCase().equals("mac") ? 1 : (index = libraries.flavor.toLowerCase().equals("windows") ? 2 : -1));
            assert (index >= 0);
            this.mf.comboBoxFlavor.setSelectedIndex(index);
            if (libraries.case_sensitive != null) {
                this.mf.checkBoxCase.setSelected(libraries.case_sensitive);
            } else {
                this.mf.checkBoxCase.setSelected(false);
            }
            if (libraries.temp_dated != null) {
                this.mf.checkBoxTempDated.setSelected(libraries.temp_dated);
            } else {
                this.mf.checkBoxTempDated.setSelected(false);
            }
            this.mf.textFieldTempLocation.setText(libraries.temp_location);
            if (libraries.terminal_allowed != null) {
                this.mf.checkBoxTerminalAllowed.setSelected(libraries.terminal_allowed);
            } else {
                this.mf.checkBoxTerminalAllowed.setSelected(false);
            }
            if (libraries.ignore_patterns != null) {
                ArrayList<String> ignores = new ArrayList<String>();
                for (int i = 0; i < libraries.ignore_patterns.length; ++i) {
                    ignores.add(libraries.ignore_patterns[i]);
                }
                DefaultListModel<String> model = new DefaultListModel<String>();
                if (ignores.size() > 0) {
                    Collections.sort(ignores);
                    for (String element : ignores) {
                        model.addElement(element);
                    }
                } else {
                    this.mf.listLibrariesIgnorePatterns.removeAll();
                    model.removeAllElements();
                    model.clear();
                }
                this.mf.listLibrariesIgnorePatterns.setModel(model);
                this.mf.scrollPaneLibrariesIgnorePatterns.setViewportView(this.mf.listLibrariesIgnorePatterns);
                this.mf.listLibrariesIgnorePatterns.setSelectionInterval(0, 0);
                this.mf.textFieldEmailAddr.setText(libraries.email);
                this.mf.comboBoxFormat.setSelectedItem(libraries.format);
                if (libraries.mismatches != null) {
                    this.mf.checkBoxMismatches.setSelected(libraries.mismatches);
                } else {
                    this.mf.checkBoxMismatches.setSelected(false);
                }
                if (libraries.whatsNew != null) {
                    this.mf.checkBoxWhatsNew.setSelected(libraries.whatsNew);
                } else {
                    this.mf.checkBoxWhatsNew.setSelected(false);
                }
                if (libraries.skipOffline != null) {
                    this.mf.checkBoxSkipOffline.setSelected(libraries.skipOffline);
                } else {
                    this.mf.checkBoxSkipOffline.setSelected(true);
                }
            }
            if (repo.isDynamic()) {
                this.mf.buttonDelete.setEnabled(false);
                this.mf.dynamicLabel.setVisible(true);
                this.mf.textFieldKey.setEnabled(false);
                this.mf.buttonLibraryGenerateKey.setEnabled(false);
                this.mf.textFieldHost.setEnabled(false);
                this.mf.textFieldListen.setEnabled(false);
                this.mf.textFieldTimeout.setEnabled(false);
                this.mf.comboBoxFlavor.setEnabled(false);
                this.mf.checkBoxCase.setEnabled(false);
                this.mf.checkBoxTempDated.setEnabled(false);
                this.mf.textFieldTempLocation.setEnabled(false);
                this.mf.buttonLibrarySelectTempLocation.setEnabled(false);
                this.mf.checkBoxTerminalAllowed.setEnabled(false);
                this.mf.buttonLibrariesAddIgnore.setEnabled(false);
                this.mf.buttonLibrariesRemoveIgnore.setEnabled(false);
                this.mf.textFieldEmailAddr.setEnabled(false);
                this.mf.comboBoxFormat.setEnabled(false);
                this.mf.checkBoxMismatches.setEnabled(false);
                this.mf.checkBoxWhatsNew.setEnabled(false);
                this.mf.checkBoxSkipOffline.setEnabled(false);
            } else {
                this.mf.buttonDelete.setEnabled(true);
                this.mf.dynamicLabel.setVisible(false);
                this.mf.textFieldKey.setEnabled(true);
                this.mf.buttonLibraryGenerateKey.setEnabled(true);
                this.mf.textFieldHost.setEnabled(true);
                this.mf.textFieldListen.setEnabled(true);
                this.mf.textFieldTimeout.setEnabled(true);
                this.mf.comboBoxFlavor.setEnabled(true);
                this.mf.checkBoxCase.setEnabled(true);
                this.mf.checkBoxTempDated.setEnabled(true);
                this.mf.textFieldTempLocation.setEnabled(true);
                this.mf.buttonLibrarySelectTempLocation.setEnabled(true);
                this.mf.checkBoxTerminalAllowed.setEnabled(true);
                this.mf.buttonLibrariesAddIgnore.setEnabled(true);
                this.mf.buttonLibrariesRemoveIgnore.setEnabled(true);
                this.mf.textFieldEmailAddr.setEnabled(true);
                this.mf.comboBoxFormat.setEnabled(true);
                this.mf.checkBoxMismatches.setEnabled(true);
                this.mf.checkBoxWhatsNew.setEnabled(true);
                this.mf.checkBoxSkipOffline.setEnabled(true);
            }
            this.loading = false;
            this.loadLocationsTab();
            if (this.mf.librariesConfigItems.isEditing()) {
                this.mf.librariesConfigItems.getCellEditor().stopCellEditing();
            }
            this.updateState();
        }
    }

    public void loadJobs() {
        try {
            if (this.jobsHandler == null) {
                this.jobsHandler = new Jobs(this.context);
            }
            this.jobsList = this.jobsHandler.loadAllJobs();
            this.setJobsList(this.jobsList);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.gs("JobsUI.title"), 0);
        }
    }

    private void loadLocationsTab() {
        this.locationsTableModel.getDataVector().removeAllElements();
        if (!this.loading && this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            this.loading = true;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            Object[] locations = libMeta.repo.getLibraryData().libraries.locations;
            if (locations.length > 0) {
                Arrays.sort(locations);
            }
            this.locationsTableModel.setLocations((Location[])locations);
            this.locationsTableModel.fireTableDataChanged();
            if (this.locationsTableModel.getRowCount() == 0) {
                this.mf.buttonAddLocation.setEnabled(true);
                this.mf.buttonRemoveLocation.setEnabled(false);
            } else {
                this.mf.tableLocations.changeSelection(this.currentLocationIndex, 0, false, false);
                this.mf.buttonAddLocation.setEnabled(true);
                this.mf.buttonRemoveLocation.setEnabled(true);
            }
            if (libMeta.repo.isDynamic()) {
                this.mf.buttonAddLocation.setEnabled(false);
                this.mf.buttonRemoveLocation.setEnabled(false);
            }
            this.loading = false;
            this.loadBibliographyTab();
        }
    }

    private void loadSources() {
        this.mf.listSources.removeAll();
        this.listSourcesModel.removeAllElements();
        if (!this.loading && this.currentConfigIndex >= 0 && this.currentConfigIndex < this.configModel.getRowCount()) {
            Library lib;
            this.loading = true;
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            if (this.currentLibraryIndex < libMeta.repo.getLibraryData().libraries.bibliography.length && (lib = libMeta.repo.getLibraryData().libraries.bibliography[this.currentLibraryIndex]) != null && lib.sources.length > 0) {
                for (int i = 0; i < lib.sources.length; ++i) {
                    this.listSourcesModel.addElement(lib.sources[i]);
                }
                if (!libMeta.repo.isDynamic()) {
                    this.mf.buttonRemoveLibrary.setEnabled(true);
                    this.mf.buttonAddSource.setEnabled(true);
                    if (lib.sources.length > 1) {
                        this.mf.buttonUpSource.setEnabled(true);
                        this.mf.buttonDownSource.setEnabled(true);
                    } else {
                        this.mf.buttonUpSource.setEnabled(false);
                        this.mf.buttonDownSource.setEnabled(false);
                    }
                    if (libMeta.repo.getLibraryData().libraries.bibliography.length > 1) {
                        this.mf.buttonAddMultiSource.setEnabled(true);
                    } else {
                        this.mf.buttonAddMultiSource.setEnabled(false);
                    }
                    this.mf.buttonRemoveSource.setEnabled(true);
                }
                if (this.currentSourceIndex >= 0) {
                    this.mf.listSources.setSelectedIndex(this.currentSourceIndex);
                }
            }
            this.loading = false;
        }
    }

    private boolean processJobKeyChanges(String oldKey, ArrayList<Conflict> conflicts) {
        JList conflictJList = new JList();
        ArrayList<String> conflictNames = new ArrayList<String>();
        for (Conflict conflict : conflicts) {
            conflictNames.add(conflict.toString(this.context));
        }
        Collections.sort(conflictNames);
        DefaultListModel<String> dialogList = new DefaultListModel<String>();
        for (String name : conflictNames) {
            dialogList.addElement(name);
        }
        conflictJList.setModel(dialogList);
        conflictJList.setSelectionModel(new DisableJListSelectionModel());
        String string = MessageFormat.format(this.context.cfg.gs("Jobs.references.for.found.in.jobs"), oldKey);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(conflictJList);
        String question = this.context.cfg.gs("LibrariesUI.change.the.listed.references");
        Object[] params = new Object[]{string, pane, question};
        this.promptingKeyChange = true;
        int opt = JOptionPane.showConfirmDialog(this.context.mainFrame, params, this.displayName, 2);
        if (opt == 0) {
            for (Conflict conflict : conflicts) {
                Job job = (Job)conflict.job;
                if (conflict.newName.isEmpty()) continue;
                Task task = job.getTasks().get(conflict.taskNumber);
                task.setContext(this.context);
                if (task.getPublisherKey().equals(conflict.oldName)) {
                    task.setPublisherKey(conflict.newName);
                }
                if (task.getSubscriberKey().equals(conflict.oldName)) {
                    task.setSubscriberKey(conflict.newName);
                }
                if (task.getHintsKey().equals(conflict.oldName)) {
                    task.setHintsKey(conflict.newName);
                }
                job.setDataHasChanged();
            }
            this.promptingKeyChange = false;
            return true;
        }
        this.promptingKeyChange = false;
        return false;
    }

    private int saveConfigurations() {
        LibMeta libMeta = null;
        int state = 0;
        try {
            int i;
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                libMeta = (LibMeta)this.configModel.getValueAt(i, 0);
                if (libMeta.key != null && !libMeta.key.isEmpty()) continue;
                this.currentConfigIndex = i;
                this.configItems.setRowSelectionInterval(i, i);
                this.loadGeneralTab();
                JOptionPane.showMessageDialog(this.context.mainFrame, MessageFormat.format(this.context.cfg.gs("LibrariesUI.please.assign.a.key"), libMeta.description));
                this.context.mainFrame.textFieldKey.requestFocus();
                return -1;
            }
            for (i = 0; i < this.deletedLibraries.size(); ++i) {
                libMeta = this.deletedLibraries.get(i);
                File file = new File(libMeta.path);
                if (file.exists()) {
                    file.delete();
                }
                libMeta.setDataHasChanged(false);
                state = 1;
            }
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                libMeta = (LibMeta)this.configModel.getValueAt(i, 0);
                if (libMeta.isDataChanged()) {
                    if (libMeta.repo.getJsonFilename() == null || libMeta.repo.getJsonFilename().length() == 0) {
                        libMeta.repo.setJsonFilename(this.getDirectoryPath() + System.getProperty("file.separator") + libMeta.description + ".json");
                    }
                    Arrays.sort(libMeta.repo.getLibraryData().libraries.bibliography);
                    libMeta.repo.write();
                    state = 1;
                }
                libMeta.setDataHasChanged(false);
            }
            this.jobsHandler.saveAllJobs(this.jobsList);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.mf, msg, this.displayName, 0);
            }
            this.logger.error(msg);
        }
        if (this.deletedLibraries.size() > 0) {
            this.deletedLibraries = new ArrayList();
        }
        this.configModel.setRowCount(0);
        this.biblioLibrariesTableModel.setRowCount(0);
        this.loadConfigurations();
        return state;
    }

    public void savePreferences() {
        this.context.preferences.setLibrariesDividerLocation(this.mf.splitPaneLibs.getDividerLocation());
        this.context.preferences.setLibrariesBiblioDividerLocation(this.mf.splitPanelBiblio.getDividerLocation());
    }

    public void selectLastTab() {
        if (this.lastTab == 0) {
            this.mf.generalOptions.requestFocus();
        } else if (this.lastTab == 1) {
            this.mf.locationsTab.requestFocus();
        } else if (this.lastTab == 2) {
            this.mf.bibliographyTab.requestFocus();
            if (this.currentConfigIndex >= 0) {
                this.configItems.setRowSelectionInterval(this.currentConfigIndex, this.currentConfigIndex);
            }
            if (this.currentLibraryIndex >= 0) {
                this.mf.tableBiblioLibraries.setRowSelectionInterval(this.currentLibraryIndex, this.currentLibraryIndex);
            }
            if (this.currentSourceIndex >= 0) {
                this.mf.listSources.setSelectedIndex(this.currentSourceIndex);
            }
        }
    }

    public void setJobsList(ArrayList<AbstractTool> jobsList) {
        this.jobsList = jobsList;
    }

    private void setNumberFilter(JTextField field) {
        PlainDocument pd = (PlainDocument)field.getDocument();
        pd.setDocumentFilter(this.numberFilter);
    }

    public void tabbedPaneLibrarySpacesStateChanged(ChangeEvent changeEvent) {
        this.mf.labelStatusMiddle.setText(this.context.cfg.gs(""));
        this.lastTab = this.mf.tabbedPaneLibrarySpaces.getSelectedIndex();
        this.loadGeneralTab();
        if (this.lastTab == 0) {
            this.mf.generalOptions.requestFocus();
            this.mf.textFieldKey.select(0, 0);
        } else if (this.lastTab == 1) {
            this.mf.locationsTab.requestFocus();
        } else if (this.lastTab == 2) {
            this.mf.bibliographyTab.requestFocus();
        }
        this.mf.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void updateOnChange(Object source) {
        String name = null;
        if (source != null && !this.loading) {
            this.currentConfigIndex = this.configItems.getSelectedRow();
            if (this.currentConfigIndex >= 0) {
                LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
                if (source instanceof JTextField) {
                    String current = null;
                    JTextField tf = (JTextField)source;
                    name = tf.getName();
                    switch (name.toLowerCase()) {
                        case "key": {
                            ArrayList<Conflict> conflicts;
                            current = libMeta.key;
                            if (!(tf.getText().isEmpty() || current.isEmpty() || tf.getText().equals(current) || (conflicts = this.getJobKeyReferences(libMeta.key, tf.getText())).isEmpty() || this.processJobKeyChanges(libMeta.key, conflicts))) {
                                tf.setText(libMeta.key);
                                libMeta.setDataHasChanged(false);
                                return;
                            }
                            libMeta.key = tf.getText();
                            libMeta.repo.getLibraryData().libraries.key = tf.getText();
                            break;
                        }
                        case "host": {
                            current = libMeta.repo.getLibraryData().libraries.host;
                            libMeta.repo.getLibraryData().libraries.host = tf.getText();
                            break;
                        }
                        case "listen": {
                            current = libMeta.repo.getLibraryData().libraries.listen;
                            libMeta.repo.getLibraryData().libraries.listen = tf.getText();
                            break;
                        }
                        case "timeout": {
                            current = Integer.toString(libMeta.repo.getLibraryData().libraries.timeout);
                            libMeta.repo.getLibraryData().libraries.timeout = Integer.valueOf(tf.getText());
                            break;
                        }
                        case "templocation": {
                            current = libMeta.repo.getLibraryData().libraries.temp_location;
                            libMeta.repo.getLibraryData().libraries.temp_location = tf.getText();
                            break;
                        }
                        case "email": {
                            current = libMeta.repo.getLibraryData().libraries.email;
                            libMeta.repo.getLibraryData().libraries.email = tf.getText();
                        }
                    }
                    if (tf != null && current != null && !current.equals(tf.getText())) {
                        libMeta.setDataHasChanged();
                        this.updateState();
                    }
                } else if (source instanceof JCheckBox) {
                    boolean state = false;
                    JCheckBox cb = (JCheckBox)source;
                    name = cb.getName();
                    switch (name.toLowerCase()) {
                        case "case": {
                            state = libMeta.repo.getLibraryData().libraries.case_sensitive;
                            libMeta.repo.getLibraryData().libraries.case_sensitive = cb.isSelected();
                            break;
                        }
                        case "tempdated": {
                            state = libMeta.repo.getLibraryData().libraries.temp_dated;
                            libMeta.repo.getLibraryData().libraries.temp_dated = cb.isSelected();
                            break;
                        }
                        case "terminalallowed": {
                            state = libMeta.repo.getLibraryData().libraries.terminal_allowed;
                            libMeta.repo.getLibraryData().libraries.terminal_allowed = cb.isSelected();
                            break;
                        }
                        case "mismatches": {
                            state = libMeta.repo.getLibraryData().libraries.mismatches;
                            libMeta.repo.getLibraryData().libraries.mismatches = cb.isSelected();
                            break;
                        }
                        case "whatsnew": {
                            state = libMeta.repo.getLibraryData().libraries.whatsNew;
                            libMeta.repo.getLibraryData().libraries.whatsNew = cb.isSelected();
                            break;
                        }
                        case "skipoffline": {
                            state = libMeta.repo.getLibraryData().libraries.skipOffline;
                            libMeta.repo.getLibraryData().libraries.skipOffline = cb.isSelected();
                        }
                    }
                    if (state != cb.isSelected()) {
                        libMeta.setDataHasChanged();
                        this.updateState();
                    }
                } else if (source instanceof JComboBox) {
                    JComboBox combo = (JComboBox)source;
                    name = combo.getName();
                    int current = -1;
                    int index = combo.getSelectedIndex();
                    String value = "";
                    switch (name.toLowerCase()) {
                        case "flavor": {
                            current = libMeta.repo.getLibraryData().libraries.flavor.toLowerCase().equals("linux") ? 0 : (libMeta.repo.getLibraryData().libraries.flavor.toLowerCase().equals("mac") ? 1 : 2);
                            libMeta.repo.getLibraryData().libraries.flavor = (String)combo.getSelectedItem();
                            break;
                        }
                        case "format": {
                            current = libMeta.repo.getLibraryData().libraries.format.toLowerCase().equals("html") ? 0 : 1;
                            libMeta.repo.getLibraryData().libraries.format = (String)combo.getSelectedItem();
                        }
                    }
                    if (index != current) {
                        libMeta.setDataHasChanged();
                        this.updateState();
                    }
                }
            }
        }
    }

    private void updateState() {
        if (this.configModel.getRowCount() > 0) {
            if (this.currentConfigIndex >= this.configModel.getRowCount()) {
                this.currentConfigIndex = this.configModel.getRowCount() - 1;
            }
            LibMeta libMeta = (LibMeta)this.configModel.getValueAt(this.currentConfigIndex, 0);
            if (libMeta.card == Cards.Library || libMeta.card == Cards.HintServer || libMeta.card == Cards.Targets) {
                // empty if block
            }
        }
    }

    protected class LibMeta
    extends RepoMeta {
        public boolean dataHasChanged = false;
        public Repository repo;
        Cards card;

        protected LibMeta() {
        }

        @Override
        public LibMeta clone() {
            LibMeta libMeta = new LibMeta();
            libMeta.description = this.description;
            libMeta.key = this.key;
            libMeta.path = this.path;
            libMeta.card = this.card;
            libMeta.dataHasChanged = true;
            libMeta.repo = this.repo.cloneNoItems();
            return libMeta;
        }

        public boolean isDataChanged() {
            return this.dataHasChanged;
        }

        public void setDataHasChanged(boolean sense) {
            this.dataHasChanged = sense;
        }

        public void setDataHasChanged() {
            this.dataHasChanged = true;
        }
    }

    private class Mode {
        public Cards card;
        public String description;

        public Mode(LibrariesUI librariesUI, String description, Cards card) {
            this.description = description;
            this.card = card;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Cards {
        Library,
        HintServer,
        Targets;

    }
}

