/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.system;

import com.corionis.els.Context;
import com.corionis.els.hints.HintKey;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class DataTableModel
extends DefaultTableModel {
    private Context context;
    private boolean dataChanged = false;
    private ArrayList<HintKey> keys;
    private ArrayList<String> ipAddresses;

    public DataTableModel(Context context, ArrayList<HintKey> hintKeys, ArrayList<String> ipAddresses) {
        this.context = context;
        this.keys = hintKeys;
        this.ipAddresses = ipAddresses;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        if (this.keys != null) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if (this.keys != null) {
                    return this.context.cfg.gs("FileEditor.name");
                }
                return this.context.cfg.gs("FileEditor.ip.address");
            }
            case 1: {
                if (this.keys != null) {
                    return this.context.cfg.gs("FileEditor.collection.uuid.key");
                }
                return "";
            }
        }
        return this.context.cfg.gs("NavTreeNode.unknown");
    }

    @Override
    public int getRowCount() {
        if (this.keys != null) {
            return this.keys.size();
        }
        if (this.ipAddresses != null) {
            return this.ipAddresses.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            if (this.keys != null) {
                return this.keys.get((int)row).system;
            }
            if (this.ipAddresses != null) {
                return this.ipAddresses.get(row);
            }
        } else if (column == 1) {
            if (this.keys != null) {
                return this.keys.get((int)row).uuid;
            }
            return "";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    @Override
    public void removeRow(int row) {
        if (this.keys != null) {
            this.keys.remove(row);
        }
        if (this.ipAddresses != null) {
            this.ipAddresses.remove(row);
        }
    }

    public void setDataHasChanged() {
        this.dataChanged = true;
    }

    @Override
    public void setValueAt(Object object, int row, int col) {
        if (col == 0) {
            if (this.keys != null) {
                this.keys.get((int)row).system = (String)object;
            }
            if (this.ipAddresses != null) {
                this.ipAddresses.set(row, (String)object);
            }
        }
        if (col == 1 && this.keys != null) {
            this.keys.get((int)row).uuid = (String)object;
        }
        if (this.keys != null && row == this.keys.size() - 1) {
            this.keys.add(new HintKey());
        }
        if (this.ipAddresses != null && row == this.ipAddresses.size() - 1) {
            this.ipAddresses.add("");
        }
        this.setDataHasChanged();
    }
}

