/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.system;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.MainFrame;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.system.CollectionSelector;
import com.corionis.els.gui.system.CollectionTableModel;
import com.corionis.els.gui.system.DataTableModel;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintKeys;
import com.corionis.els.repository.RepoMeta;
import com.corionis.els.repository.Repositories;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileEditor
extends JDialog {
    private Context context;
    private DataTableModel dataTableModel;
    private String description;
    private String displayName;
    private String fileName;
    private NavHelp helpDialog;
    private String helpTip;
    private HintKeys hintKeys = null;
    private ArrayList<String> ipAddresses = null;
    private Logger logger = LogManager.getLogger("FileEditorlog");
    private MainFrame mf;
    private EditorTypes type;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel labelDescription;
    private JLabel labelSystemHelp;
    private JScrollPane scrollPane;
    private JTable tableContent;
    private JPanel panelActionButtons;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JPanel hSpacer1;
    private JButton buttonUuidList;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    private FileEditor() {
    }

    public FileEditor(Context context, EditorTypes type) {
        super(context.mainFrame);
        this.context = context;
        this.mf = context.mainFrame;
        this.type = type;
        this.initComponents();
        this.initialize();
        this.process();
    }

    private void actionAddClicked(ActionEvent e) {
        switch (this.type) {
            case Authentication: 
            case HintKeys: {
                if (this.hintKeys.get().size() == 0 || this.hintKeys.get().get((int)(this.hintKeys.get().size() - 1)).system != null) {
                    HintKey hintKey = new HintKey();
                    this.hintKeys.get().add(hintKey);
                    this.dataTableModel.fireTableDataChanged();
                }
                this.tableContent.editCellAt(this.dataTableModel.getRowCount() - 1, 0);
                this.tableContent.changeSelection(this.dataTableModel.getRowCount() - 1, this.dataTableModel.getRowCount() - 1, false, false);
                this.tableContent.getEditorComponent().requestFocus();
                ((JTextField)this.tableContent.getEditorComponent()).selectAll();
                break;
            }
            case BlackList: 
            case WhiteList: {
                if (this.ipAddresses.size() == 0 || this.ipAddresses.get(this.ipAddresses.size() - 1) != null) {
                    this.ipAddresses.add("");
                    this.dataTableModel.fireTableDataChanged();
                }
                this.tableContent.editCellAt(this.dataTableModel.getRowCount() - 1, 0);
                this.tableContent.changeSelection(this.dataTableModel.getRowCount() - 1, this.dataTableModel.getRowCount() - 1, false, false);
                this.tableContent.getEditorComponent().requestFocus();
                ((JTextField)this.tableContent.getEditorComponent()).selectAll();
            }
        }
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.dataTableModel.isDataChanged()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
        this.context.navigator.enableDisableSystemMenus(null, true);
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null || !this.helpDialog.isVisible()) {
            String title = "";
            String helpName = "";
            switch (this.type) {
                case Authentication: {
                    title = this.context.cfg.gs("FileEditor.labelHelpAuthentication.toolTipText");
                    helpName = "authentication-keys_";
                    break;
                }
                case HintKeys: {
                    title = this.context.cfg.gs("FileEditor.labelHelpHint.toolTipText");
                    helpName = "hint-keys_";
                    break;
                }
                case BlackList: {
                    title = this.context.cfg.gs("FileEditor.labelHelpBlacklist.toolTipText");
                    helpName = "blacklist_";
                    break;
                }
                case WhiteList: {
                    title = this.context.cfg.gs("FileEditor.labelHelpWhitelist.toolTipText");
                    helpName = "whitelist_";
                }
            }
            this.helpDialog = new NavHelp(this, this, this.context, title, helpName + this.context.preferences.getLocale() + ".html", false);
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionRemoveClicked(ActionEvent e) {
        int[] rows = this.tableContent.getSelectedRows();
        if (rows.length > 0) {
            this.tableContent.requestFocus();
            int count = rows.length;
            String message = MessageFormat.format(this.context.cfg.gs("FileEditor.remove.entries"), count);
            int reply = JOptionPane.showConfirmDialog(this, message, this.displayName, 0);
            if (reply == 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.dataTableModel.removeRow(rows[i]);
                }
                this.dataTableModel.setDataHasChanged();
                this.dataTableModel.fireTableDataChanged();
            }
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        if (this.saveContent()) {
            this.savePreferences();
            this.context.navigator.enableDisableSystemMenus(null, true);
            this.setVisible(false);
        }
    }

    private void actionUuidClicked(ActionEvent e) {
        if (this.tableContent.getSelectedRows().length == 1) {
            if (this.tableContent.isEditing()) {
                this.tableContent.getCellEditor().stopCellEditing();
            }
            ArrayList<CollectionSelector> csList = new ArrayList<CollectionSelector>();
            Repositories repositories = this.getRepositories();
            if (repositories.getMetaList().size() > 0) {
                JPanel controls = new JPanel();
                GridBagLayout gridBagLayout = new GridBagLayout();
                controls.setLayout(gridBagLayout);
                JLabel prompt = new JLabel(this.context.cfg.gs("FileEditor.select.library.uuid"));
                controls.add((Component)prompt, new GridBagConstraints(0, 0, 7, 1, 1.0, 0.0, 17, 1, new Insets(4, 0, 4, 4), 0, 0));
                JTable table = new JTable();
                table.setCellSelectionEnabled(false);
                table.setRowSelectionAllowed(true);
                table.setColumnSelectionAllowed(false);
                table.setFillsViewportHeight(true);
                table.setSelectionMode(0);
                table.setMinimumSize(new Dimension(530, 100));
                table.setPreferredSize(new Dimension(530, 260));
                for (int i = 0; i < repositories.getMetaList().size(); ++i) {
                    RepoMeta repoMeta = repositories.getMetaList().get(i);
                    CollectionSelector cs = new CollectionSelector();
                    cs.description = repoMeta.description;
                    cs.key = repoMeta.key;
                    csList.add(cs);
                }
                CollectionTableModel model = new CollectionTableModel(this.context, csList);
                table.setModel(model);
                JScrollPane scrollPane = new JScrollPane();
                scrollPane.setMinimumSize(new Dimension(530, 100));
                scrollPane.setPreferredSize(new Dimension(530, 260));
                scrollPane.setViewportView(table);
                controls.add((Component)scrollPane, new GridBagConstraints(0, 1, 7, 4, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0));
                Object[] params = new Object[]{controls};
                int opt = JOptionPane.showConfirmDialog(this.mf, params, this.displayName, 2);
                if (opt == 0 && table.getSelectedRow() >= 0) {
                    int index = this.tableContent.getSelectedRow();
                    HintKey hk = this.hintKeys.get().get(index);
                    if (hk.uuid != null && hk.uuid.length() > 0 && (opt = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("FileEditor.overwrite.existing.uuid"), this.displayName, 2)) != 0) {
                        return;
                    }
                    index = table.getSelectedRow();
                    CollectionSelector cs = csList.get(index);
                    boolean found = false;
                    for (int i = 0; i < this.hintKeys.get().size(); ++i) {
                        HintKey check = this.hintKeys.get().get(i);
                        if (check.uuid == null || !check.uuid.equals(cs.key)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        JOptionPane.showMessageDialog(this, this.context.cfg.gs("FileEditor.that.collection.uuid.key.is.already.defined"), this.displayName, 1);
                    } else {
                        hk.uuid = cs.key;
                        if (hk.system == null || hk.system.length() == 0) {
                            hk.system = Utils.compactString(cs.description);
                        }
                        this.dataTableModel.setDataHasChanged();
                        this.dataTableModel.fireTableDataChanged();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("FileEditor.there.are.no.collections.to.choose.from"), this.displayName, 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("FileEditor.please.select.a.single.row.to.update"), this.displayName, 1);
        }
    }

    private String getConfigName() {
        return this.fileName;
    }

    private String getDirectoryPath() {
        String path = System.getProperty("user.dir") + System.getProperty("file.separator") + (this.getSubsystem().length() > 0 ? this.getSubsystem() : "");
        return path;
    }

    private String getFullPath() {
        String path = this.getDirectoryPath() + System.getProperty("file.separator") + Utils.scrubFilename(this.getConfigName());
        return path;
    }

    public Repositories getRepositories() {
        Repositories repositories = null;
        try {
            repositories = new Repositories();
            repositories.loadList(this.context);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this.mf, msg, this.displayName, 0);
        }
        return repositories;
    }

    private String getSubsystem() {
        return "system";
    }

    private void process() {
        this.setVisible(true);
    }

    private void initialize() {
        Icon icon = this.labelSystemHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelSystemHelp.setIcon(replacement);
        if (this.context.preferences.getFileEditorXpos() != -1 && Utils.isOnScreen(this.context.preferences.getFileEditorXpos(), this.context.preferences.getFileEditorYpos())) {
            this.setLocation(this.context.preferences.getFileEditorXpos(), this.context.preferences.getFileEditorYpos());
            Dimension dim = new Dimension(this.context.preferences.getFileEditorWidth(), this.context.preferences.getFileEditorHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(this.context.mainFrame, this));
        }
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileEditor.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        switch (this.type) {
            case Authentication: {
                this.displayName = this.context.cfg.gs("FileEditor.authentication.keys");
                this.description = this.context.cfg.gs("FileEditor.collection.keys.allowed.to.connect");
                this.buttonUuidList.setVisible(true);
                break;
            }
            case HintKeys: {
                this.displayName = this.context.cfg.gs("FileEditor.hint.keys");
                this.description = this.context.cfg.gs("FileEditor.collection.keys.involved.in.processing.hints");
                this.buttonUuidList.setVisible(true);
                break;
            }
            case BlackList: {
                this.displayName = this.context.cfg.gs("FileEditor.blacklist");
                this.description = this.context.cfg.gs("FileEditor.ip.addresses.that.may.not.connect");
                this.buttonUuidList.setVisible(false);
                break;
            }
            case WhiteList: {
                this.displayName = this.context.cfg.gs("FileEditor.whitelist");
                this.description = this.context.cfg.gs("FileEditor.ip.addresses.allowed.to.connect");
                this.buttonUuidList.setVisible(false);
            }
        }
        this.helpTip = this.displayName + this.context.cfg.gs(" Help");
        this.context.navigator.enableDisableSystemMenus(this.type, false);
        this.setTitle(this.displayName);
        this.labelDescription.setText(this.description);
        this.labelSystemHelp.setToolTipText(this.helpTip);
        this.loadTable();
    }

    private void loadTable() {
        HintKeys hintKeys = null;
        ArrayList<String> ipAddresses = null;
        switch (this.type) {
            case Authentication: {
                hintKeys = this.readHintKeys();
                break;
            }
            case HintKeys: {
                hintKeys = this.readHintKeys();
                break;
            }
            case BlackList: {
                ipAddresses = this.readIpAddresses();
                break;
            }
            case WhiteList: {
                ipAddresses = this.readIpAddresses();
            }
        }
        this.dataTableModel = new DataTableModel(this.context, hintKeys != null ? hintKeys.get() : null, ipAddresses);
        this.tableContent.setModel(this.dataTableModel);
    }

    private HintKeys readHintKeys() {
        this.hintKeys = new HintKeys(this.context);
        try {
            switch (this.type) {
                case Authentication: {
                    this.fileName = "authentication.keys";
                    break;
                }
                case HintKeys: {
                    this.fileName = "hint.keys";
                }
            }
            this.fileName = this.getFullPath();
            File file = new File(this.fileName);
            if (file.exists()) {
                this.hintKeys.read(this.fileName);
            } else {
                this.hintKeys.setFilename(this.fileName);
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
        }
        return this.hintKeys;
    }

    private ArrayList<String> readIpAddresses() {
        this.ipAddresses = new ArrayList();
        try {
            switch (this.type) {
                case BlackList: {
                    this.fileName = "blacklist.txt";
                    break;
                }
                case WhiteList: {
                    this.fileName = "whitelist.txt";
                }
            }
            this.fileName = this.getFullPath();
            File file = new File(this.fileName);
            if (file.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.fileName));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    this.ipAddresses.add(line);
                }
                br.close();
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
        }
        this.logger.info(MessageFormat.format(this.context.cfg.gs("FileEditor.read.ip.addresses.0.successfully"), this.fileName));
        return this.ipAddresses;
    }

    private boolean saveContent() {
        if (this.tableContent.isEditing()) {
            this.tableContent.getCellEditor().stopCellEditing();
        }
        if (this.dataTableModel.isDataChanged()) {
            try {
                Object header = "";
                switch (this.type) {
                    case Authentication: {
                        header = "# ELS Authentication Keys" + System.getProperty("line.separator");
                        break;
                    }
                    case HintKeys: {
                        header = "# ELS Hint Keys" + System.getProperty("line.separator");
                        break;
                    }
                    case BlackList: {
                        header = "# ELS Blacklist" + System.getProperty("line.separator");
                        break;
                    }
                    case WhiteList: {
                        header = "# ELS Whitelist" + System.getProperty("line.separator");
                    }
                }
                switch (this.type) {
                    case Authentication: 
                    case HintKeys: {
                        header = (String)header + "#" + System.getProperty("line.separator") + "# Format: name uuid" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "#   Name is any shortname, no spaces." + System.getProperty("line.separator") + "#   UUID is the key from the collection JSON file." + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# Use space/tab separators, no quotes." + System.getProperty("line.separator") + "#" + System.getProperty("line.separator");
                        this.hintKeys.write((String)header);
                        break;
                    }
                    case BlackList: 
                    case WhiteList: {
                        header = (String)header + "#" + System.getProperty("line.separator") + "# Format: xxx.xxx.xxx.xxx" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "#   A standard IPv4 address." + System.getProperty("line.separator") + "#   One address per line." + System.getProperty("line.separator") + "#" + System.getProperty("line.separator");
                        this.writeIpAddresses((String)header);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(Utils.getStackTrace(e));
            }
        }
        return true;
    }

    private void savePreferences() {
        this.context.preferences.setFileEditorHeight(this.getHeight());
        this.context.preferences.setFileEditorWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setFileEditorXpos(location.x);
        this.context.preferences.setFileEditorYpos(location.y);
    }

    private void writeIpAddresses(String header) throws Exception {
        if (this.ipAddresses != null) {
            File file = new File(this.fileName);
            file.getParentFile().mkdirs();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.fileName));
            bw.write(header);
            bw.write(System.getProperty("line.separator"));
            for (int i = 0; i < this.ipAddresses.size(); ++i) {
                if (this.ipAddresses.get(i) == null || this.ipAddresses.get(i).length() <= 0) continue;
                bw.write(this.ipAddresses.get(i) + System.getProperty("line.separator"));
            }
            bw.write(System.getProperty("line.separator"));
            bw.close();
        }
    }

    private void windowClosing(WindowEvent e) {
        this.context.navigator.enableDisableSystemMenus(null, true);
        this.cancelButton.doClick();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.corionis.els.locales.bundle");
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.labelDescription = new JLabel();
        this.labelSystemHelp = new JLabel();
        this.scrollPane = new JScrollPane();
        this.tableContent = new JTable();
        this.panelActionButtons = new JPanel();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.hSpacer1 = new JPanel(null);
        this.buttonUuidList = new JButton();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setPreferredSize(new Dimension(560, 390));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FileEditor.this.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(560, 390));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.labelDescription.setPreferredSize(new Dimension(360, 30));
        this.contentPanel.add((Component)this.labelDescription, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelSystemHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelSystemHelp.setPreferredSize(new Dimension(32, 30));
        this.labelSystemHelp.setMinimumSize(new Dimension(32, 30));
        this.labelSystemHelp.setMaximumSize(new Dimension(32, 30));
        this.labelSystemHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelSystemHelp.setIconTextGap(0);
        this.labelSystemHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FileEditor.this.actionHelpClicked(e);
            }
        });
        this.contentPanel.add((Component)this.labelSystemHelp, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.tableContent.setAutoResizeMode(4);
        this.tableContent.setShowVerticalLines(false);
        this.scrollPane.setViewportView(this.tableContent);
        this.contentPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 7, 10, 1.0, 1.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        this.panelActionButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAdd.setText(bundle.getString("FileEditor.buttonAdd.text"));
        this.buttonAdd.setFont(this.buttonAdd.getFont().deriveFont((float)this.buttonAdd.getFont().getSize() - 2.0f));
        this.buttonAdd.setPreferredSize(new Dimension(78, 24));
        this.buttonAdd.setMinimumSize(new Dimension(78, 24));
        this.buttonAdd.setMaximumSize(new Dimension(78, 24));
        this.buttonAdd.setMnemonic(bundle.getString("FileEditor.buttonAdd.mnemonic").charAt(0));
        this.buttonAdd.setToolTipText(bundle.getString("FileEditor.buttonAdd.toolTipText"));
        this.buttonAdd.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAdd.addActionListener(e -> this.actionAddClicked(e));
        this.panelActionButtons.add(this.buttonAdd);
        this.buttonRemove.setText(bundle.getString("FileEditor.buttonRemove.text"));
        this.buttonRemove.setFont(this.buttonRemove.getFont().deriveFont((float)this.buttonRemove.getFont().getSize() - 2.0f));
        this.buttonRemove.setPreferredSize(new Dimension(78, 24));
        this.buttonRemove.setMinimumSize(new Dimension(78, 24));
        this.buttonRemove.setMaximumSize(new Dimension(78, 24));
        this.buttonRemove.setMnemonic(bundle.getString("FileEditor.buttonRemove.mnemonic").charAt(0));
        this.buttonRemove.setToolTipText(bundle.getString("FileEditor.buttonRemove.toolTipText"));
        this.buttonRemove.setMargin(new Insets(0, -10, 0, -10));
        this.buttonRemove.addActionListener(e -> this.actionRemoveClicked(e));
        this.panelActionButtons.add(this.buttonRemove);
        this.hSpacer1.setPreferredSize(new Dimension(22, 10));
        this.hSpacer1.setMinimumSize(new Dimension(22, 12));
        this.panelActionButtons.add(this.hSpacer1);
        this.buttonUuidList.setText(bundle.getString("FileEditor.buttonUuidList.text"));
        this.buttonUuidList.setFont(this.buttonUuidList.getFont().deriveFont((float)this.buttonUuidList.getFont().getSize() - 2.0f));
        this.buttonUuidList.setPreferredSize(new Dimension(78, 24));
        this.buttonUuidList.setMinimumSize(new Dimension(78, 24));
        this.buttonUuidList.setMaximumSize(new Dimension(78, 24));
        this.buttonUuidList.setMnemonic('U');
        this.buttonUuidList.setToolTipText(bundle.getString("FileEditor.buttonUuidList.toolTipText"));
        this.buttonUuidList.setMargin(new Insets(0, -10, 0, -10));
        this.buttonUuidList.addActionListener(e -> this.actionUuidClicked(e));
        this.panelActionButtons.add(this.buttonUuidList);
        this.contentPanel.add((Component)this.panelActionButtons, new GridBagConstraints(0, 11, 7, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setPreferredSize(new Dimension(190, 36));
        this.buttonBar.setMinimumSize(new Dimension(190, 36));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText(bundle.getString("Z.save"));
        this.okButton.setToolTipText(bundle.getString("Z.save.toolTip.text"));
        this.okButton.setMnemonic('S');
        this.okButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(bundle.getString("Z.cancel"));
        this.cancelButton.setToolTipText(bundle.getString("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic('L');
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static enum EditorTypes {
        Authentication,
        Hints,
        HintKeys,
        BlackList,
        WhiteList;

    }
}

