/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.duplicateFinder;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.bookmarks.Bookmark;
import com.corionis.els.gui.tools.duplicateFinder.ActionsCell;
import com.corionis.els.gui.tools.duplicateFinder.Dupe;
import com.corionis.els.gui.tools.duplicateFinder.DupesTableModel;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DuplicateFinderUI
extends JDialog {
    private ArrayList<Dupe> dupes;
    private Context context;
    private boolean isPublisher = false;
    private NavHelp helpDialog;
    private Logger logger = LogManager.getLogger("applog");
    private boolean requestStop = false;
    private final DuplicateFinderUI thisDialog = this;
    private boolean workerRunning = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panelTop;
    private JPanel panelTopButtons;
    private JCheckBox checkBoxCrossLibrary;
    private JPanel hSpacerBeforeRun;
    private JButton buttonRun;
    private JPanel panelHelp;
    private JLabel labelHelp;
    private JScrollPane scrollPaneDupes;
    private JTable tableDupes;
    private JPanel panelBottom;
    private JLabel labelStatus;
    private JPanel buttonBar;
    private JButton closeButton;

    private DuplicateFinderUI() {
    }

    public DuplicateFinderUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsDuplicateFinderXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsDuplicateFinderXpos(), context.preferences.getToolsDuplicateFinderYpos())) {
            this.setLocation(context.preferences.getToolsDuplicateFinderXpos(), context.preferences.getToolsDuplicateFinderYpos());
            Dimension dim = new Dimension(context.preferences.getToolsDuplicateFinderWidth(), context.preferences.getToolsDuplicateFinderHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DuplicateFinderUI.this.closeButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.adjustDupesTable();
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionCloseClicked(ActionEvent e) {
        if (this.workerRunning) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.stop.run.after.scan"), "Z.cancel.run", 0);
            if (reply == 0) {
                this.requestStop = true;
                this.logger.info(this.context.cfg.gs("Z.run.cancelled"));
            } else {
                return;
            }
        }
        this.savePreferences();
        this.setVisible(false);
    }

    private void actionCrossLibraryClicked(ActionEvent e) {
        if (e.getActionCommand() == null || e.getActionCommand().equals("crossLibraryChanged")) {
            // empty if block
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("DuplicateFinder.help"), "duplicatefinder_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionRunClicked(ActionEvent e) {
        String which;
        String name = "";
        JComponent object = this.context.browser.lastComponent;
        if (object instanceof JTree) {
            JTree sourceTree = (JTree)object;
            name = sourceTree.getName();
        } else if (object instanceof JTable) {
            JTable sourceTable = (JTable)object;
            name = sourceTable.getName();
        }
        if (name.toLowerCase().contains("system")) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.select.collection.for.run"), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        if (name.toLowerCase().endsWith("one")) {
            this.isPublisher = true;
            which = this.context.cfg.gs("Z.publisher");
        } else {
            this.isPublisher = false;
            which = this.context.cfg.gs("Z.subscriber");
        }
        int reply = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.context.cfg.gs("DuplicateFinder.run.tool.on.collection"), which), this.getTitle(), 0);
        if (reply == 0) {
            this.process();
        }
    }

    private void adjustDupesTable() {
        this.tableDupes.setShowGrid(false);
        this.tableDupes.getTableHeader().setReorderingAllowed(false);
        this.tableDupes.setCellSelectionEnabled(false);
        this.tableDupes.setColumnSelectionAllowed(false);
        this.tableDupes.setRowSelectionAllowed(true);
        this.tableDupes.setRowHeight(24);
        this.dupes = new ArrayList();
        this.tableDupes.setModel(new DupesTableModel(this.context, this.dupes));
        TableColumn column = this.tableDupes.getColumnModel().getColumn(0);
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setHorizontalAlignment(2);
        column.setCellRenderer(cellRenderer);
        column.setMinWidth(32);
        column.setPreferredWidth(320);
        column.setWidth(320);
        column.setResizable(true);
        column = this.tableDupes.getColumnModel().getColumn(1);
        cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setHorizontalAlignment(4);
        column.setCellRenderer(cellRenderer);
        column.setMinWidth(18);
        column.setPreferredWidth(56);
        column.setWidth(56);
        column.setResizable(true);
        column = this.tableDupes.getColumnModel().getColumn(2);
        cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setHorizontalAlignment(4);
        column.setCellRenderer(cellRenderer);
        column.setMinWidth(18);
        column.setPreferredWidth(90);
        column.setWidth(90);
        column.setResizable(true);
        column = this.tableDupes.getColumnModel().getColumn(3);
        ActionsCell actionsCell = new ActionsCell(this.context, this);
        column.setMinWidth(68);
        column.setMaxWidth(68);
        column.setWidth(68);
        column.setPreferredWidth(68);
        column.setCellRenderer(actionsCell);
        column.setCellEditor(actionsCell);
        column.setResizable(false);
    }

    public void gotoItem(ActionEvent e) {
        if (e.getActionCommand() != null && e.getActionCommand().equals("goto")) {
            int selected = this.tableDupes.getSelectedRow();
            if (this.tableDupes.isEditing()) {
                this.tableDupes.getCellEditor().stopCellEditing();
            }
            if (selected > 0) {
                Dupe dupe = (Dupe)this.tableDupes.getValueAt(selected, 3);
                Bookmark bm = this.context.browser.bookmarkCreate(dupe.item, "goto-dupe", this.isPublisher);
                this.context.browser.bookmarkGoto(bm);
            }
        }
    }

    private void process() {
        try {
            Repository repo;
            Repository repository = repo = this.isPublisher ? this.context.publisherRepo : this.context.subscriberRepo;
            if (repo != null) {
                this.checkBoxCrossLibrary.setEnabled(false);
                this.buttonRun.setEnabled(false);
                this.dupes = new ArrayList();
                DupesTableModel dtm = (DupesTableModel)this.tableDupes.getModel();
                dtm.setDupes(this.dupes);
                dtm.fireTableDataChanged();
                this.logger.info(this.context.cfg.gs("DuplicateFinder.running"));
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.context.cfg.setCrossCheck(this.checkBoxCrossLibrary.isSelected());
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                    int duplicates = 0;
                    int totalDirectories = 0;
                    int totalItems = 0;

                    @Override
                    protected Void doInBackground() throws Exception {
                        String msg;
                        DuplicateFinderUI.this.workerRunning = true;
                        if (DuplicateFinderUI.this.isPublisher) {
                            DuplicateFinderUI.this.labelStatus.setText(DuplicateFinderUI.this.context.cfg.gs("Z.scanning"));
                            repo.scan();
                        } else if (DuplicateFinderUI.this.context.cfg.isRemoteOperation()) {
                            Object[] opts;
                            if (!DuplicateFinderUI.this.context.clientStty.isConnected()) {
                                opts = new Object[]{DuplicateFinderUI.this.context.cfg.gs("Z.ok")};
                                JOptionPane.showOptionDialog(DuplicateFinderUI.this.thisDialog, DuplicateFinderUI.this.context.cfg.gs("Browser.connection.lost"), DuplicateFinderUI.this.thisDialog.getTitle(), -1, 2, null, opts, opts[0]);
                            }
                            if (DuplicateFinderUI.this.context.transfer != null) {
                                DuplicateFinderUI.this.labelStatus.setText(DuplicateFinderUI.this.context.cfg.gs("Z.requesting.collection.data.from.remote"));
                                DuplicateFinderUI.this.context.transfer.requestCollection();
                            } else {
                                opts = new Object[]{DuplicateFinderUI.this.context.cfg.gs("Z.ok")};
                                JOptionPane.showOptionDialog(DuplicateFinderUI.this.thisDialog, DuplicateFinderUI.this.context.cfg.gs("Transfer.could.not.retrieve.remote.collection.file"), DuplicateFinderUI.this.thisDialog.getTitle(), -1, 2, null, opts, opts[0]);
                            }
                        } else {
                            DuplicateFinderUI.this.labelStatus.setText(DuplicateFinderUI.this.context.cfg.gs("Z.scanning"));
                            repo.scan();
                        }
                        Repository repo2 = DuplicateFinderUI.this.isPublisher ? DuplicateFinderUI.this.context.publisherRepo : DuplicateFinderUI.this.context.subscriberRepo;
                        for (Library lib : repo2.getLibraryData().libraries.bibliography) {
                            if (DuplicateFinderUI.this.requestStop) break;
                            msg = DuplicateFinderUI.this.context.cfg.gs("DuplicateFinder.analyzing.library") + "'" + lib.name + "'";
                            DuplicateFinderUI.this.labelStatus.setText(msg);
                            DuplicateFinderUI.this.logger.info(msg);
                            for (Item item : lib.items) {
                                if (item.isDirectory()) {
                                    ++this.totalDirectories;
                                } else {
                                    ++this.totalItems;
                                }
                                repo2.hasPublisherDuplicate(item, Utils.pipe(repo2, item.getItemPath()));
                            }
                        }
                        for (Library pubLib : repo2.getLibraryData().libraries.bibliography) {
                            if (DuplicateFinderUI.this.requestStop) break;
                            msg = DuplicateFinderUI.this.context.cfg.gs("DuplicateFinder.analyzing.library") + "'" + pubLib.name + "'";
                            DuplicateFinderUI.this.labelStatus.setText(msg);
                            for (Item item : pubLib.items) {
                                if (item.getHas().size() <= 0) continue;
                                this.duplicates = DuplicateFinderUI.this.queueDupe(item, this.duplicates);
                            }
                        }
                        DuplicateFinderUI.this.labelStatus.setText("  " + MessageFormat.format(DuplicateFinderUI.this.context.cfg.gs("DuplicateFinder.duplicates.items.directories"), this.duplicates, this.totalItems, this.totalDirectories));
                        return null;
                    }
                };
                if (worker != null) {
                    worker.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                DuplicateFinderUI.this.workerRunning = false;
                                DuplicateFinderUI.this.checkBoxCrossLibrary.setEnabled(true);
                                DuplicateFinderUI.this.buttonRun.setEnabled(true);
                                DupesTableModel dtm = (DupesTableModel)DuplicateFinderUI.this.tableDupes.getModel();
                                dtm.setDupes(DuplicateFinderUI.this.dupes);
                                dtm.fireTableDataChanged();
                                DuplicateFinderUI.this.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                    });
                    worker.execute();
                }
            } else {
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                JOptionPane.showOptionDialog(this, this.context.cfg.gs("DuplicateFinder.collection.not.loaded"), this.getTitle(), -1, 2, null, opts, opts[0]);
            }
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(ex);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
        }
    }

    private int queueDupe(Item item, int duplicates) {
        if (!item.isReported()) {
            this.dupes.add(new Dupe(item, true));
            this.dupes.add(new Dupe(item));
            ++duplicates;
            item.setReported(true);
            for (Item dupe : item.getHas()) {
                if (dupe.isReported()) continue;
                this.dupes.add(new Dupe(dupe));
                ++duplicates;
                dupe.setReported(true);
            }
            this.dupes.add(new Dupe(null));
        }
        return duplicates;
    }

    private void savePreferences() {
        this.context.preferences.setToolsDuplicateFinderHeight(this.getHeight());
        this.context.preferences.setToolsDuplicateFinderWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsDuplicateFinderXpos(location.x);
        this.context.preferences.setToolsDuplicateFinderYpos(location.y);
    }

    private void windowClosing(WindowEvent e) {
        this.closeButton.doClick();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.checkBoxCrossLibrary = new JCheckBox();
        this.hSpacerBeforeRun = new JPanel(null);
        this.buttonRun = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.scrollPaneDupes = new JScrollPane();
        this.tableDupes = new JTable();
        this.panelBottom = new JPanel();
        this.labelStatus = new JLabel();
        this.buttonBar = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.context.cfg.gs("DuplicateFinder.this.title"));
        this.setName("dialogDuplicateFinderUI");
        this.setMinimumSize(new Dimension(150, 126));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DuplicateFinderUI.this.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setMinimumSize(new Dimension(214, 152));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.checkBoxCrossLibrary.setText(this.context.cfg.gs("DuplicateFinder.checkBoxCrossLibrary.text"));
        this.checkBoxCrossLibrary.setActionCommand("crossLibraryChanged");
        this.checkBoxCrossLibrary.setToolTipText(this.context.cfg.gs("DuplicateFinder.checkBoxCrossLibrary.toolTipText"));
        this.checkBoxCrossLibrary.setMnemonic(this.context.cfg.gs("DuplicateFinder.checkBoxCrossLibrary.mnemonic").charAt(0));
        this.checkBoxCrossLibrary.addActionListener(e -> this.actionCrossLibraryClicked(e));
        this.panelTopButtons.add(this.checkBoxCrossLibrary);
        this.hSpacerBeforeRun.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeRun.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeRun);
        this.buttonRun.setText(this.context.cfg.gs("Z.run.ellipsis"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("DuplicateFinder.buttonRun.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("DuplicateFinder.buttonRun.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("DuplicateFinder.help"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DuplicateFinderUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "Center");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.tableDupes.setFillsViewportHeight(true);
        this.tableDupes.setSelectionMode(0);
        this.tableDupes.setAutoResizeMode(1);
        this.scrollPaneDupes.setViewportView(this.tableDupes);
        this.contentPanel.add((Component)this.scrollPaneDupes, "Center");
        this.panelBottom.setLayout(new BorderLayout());
        this.panelBottom.add((Component)this.labelStatus, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.closeButton.setText(this.context.cfg.gs("Z.done"));
        this.closeButton.setToolTipText(this.context.cfg.gs("Z.done.toolTipText"));
        this.closeButton.setMnemonic(this.context.cfg.gs("DuplicateFinder.closeButton.mnemonic").charAt(0));
        this.closeButton.addActionListener(e -> this.actionCloseClicked(e));
        this.buttonBar.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelBottom.add((Component)this.buttonBar, "After");
        this.contentPanel.add((Component)this.panelBottom, "South");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

