/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.junkRemover;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.tools.junkRemover.JunkTableModel;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Origins;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.junkremover.JunkRemoverTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JunkRemoverUI
extends AbstractToolDialog {
    private ConfigModel configModel;
    private Context context;
    private Logger logger = LogManager.getLogger("applog");
    private NavHelp helpDialog;
    private boolean isDryRun;
    private boolean isSubscriber;
    private JunkRemoverUI me;
    private SwingWorker<Void, Void> worker;
    private JunkRemoverTool workerJrt = null;
    private boolean workerRunning = false;
    private Task workerTask = null;
    public JPanel dialogPane;
    public JPanel contentPanel;
    public JPanel panelTop;
    public JPanel panelTopButtons;
    public JButton buttonNew;
    public JButton buttonCopy;
    public JButton buttonDelete;
    public JPanel hSpacerBeforeRun;
    public JButton buttonRun;
    public JPanel panelHelp;
    public JLabel labelHelp;
    public JSplitPane splitPaneContent;
    public JScrollPane scrollPaneConfig;
    public JTable configItems;
    public JPanel panelOptions;
    public JScrollPane scrollPaneOptions;
    public JTable tableJunk;
    public JPanel panelOptionsButtons;
    public JButton buttonAddRow;
    public JButton buttonRemoveRow;
    public JPanel buttonBar;
    public JButton saveButton;
    public JButton cancelButton;

    public JunkRemoverUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.me = this;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsJunkRemoverXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsJunkRemoverXpos(), context.preferences.getToolsJunkRemoverYpos())) {
            this.setLocation(context.preferences.getToolsJunkRemoverXpos(), context.preferences.getToolsJunkRemoverYpos());
            Dimension dim = new Dimension(context.preferences.getToolsJunkRemoverWidth(), context.preferences.getToolsJunkRemoverHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        this.splitPaneContent.setDividerLocation(context.preferences.getToolsJunkRemoverDividerLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JunkRemoverUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.configModel = new ConfigModel(context, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel sm = (ListSelectionModel)listSelectionEvent.getSource();
                    int index = sm.getMinSelectionIndex();
                    JunkRemoverUI.this.loadJunkTable(index);
                }
            }
        });
        this.adjustJunkTable();
        this.loadConfigurations();
        context.navigator.enableDisableToolMenus(this, false);
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionAddRowClicked(ActionEvent e) {
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if (((JunkTableModel)this.tableJunk.getModel()).getTool() != null) {
            ((JunkTableModel)this.tableJunk.getModel()).getTool().addJunkItem();
            ((JunkTableModel)this.tableJunk.getModel()).fireTableDataChanged();
            this.tableJunk.requestFocus();
            int col = 0;
            int row = ((JunkTableModel)this.tableJunk.getModel()).find("");
            if (row >= 0) {
                row = this.tableJunk.convertRowIndexToView(row);
                this.tableJunk.changeSelection(row, col, false, false);
                this.tableJunk.editCellAt(row, col);
                if (this.tableJunk.getEditorComponent() != null) {
                    this.tableJunk.getEditorComponent().requestFocus();
                }
            }
        }
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.workerRunning && this.workerJrt != null) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("JunkRemover.stop.running.junk.remover"), "Z.cancel.run", 0);
            if (reply == 0) {
                this.workerJrt.requestStop();
                this.logger.info(MessageFormat.format(this.context.cfg.gs("JunkRemover.config.cancelled"), this.workerJrt.getConfigName()));
            }
        } else if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index;
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if ((index = this.configItems.getSelectedRow()) >= 0) {
            JunkRemoverTool origJrt = (JunkRemoverTool)this.configModel.getValueAt(index, 0);
            String rename = origJrt.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                JunkRemoverTool jrt = origJrt.clone();
                jrt.setConfigName(rename);
                jrt.setDataHasChanged();
                jrt.addJunkItem();
                this.configModel.addRow(new Object[]{jrt});
                ((JunkTableModel)this.tableJunk.getModel()).setTool(null);
                this.tableJunk.removeAll();
                ((JunkTableModel)this.tableJunk.getModel()).fireTableDataChanged();
                ((JunkTableModel)this.tableJunk.getModel()).setTool(jrt);
                ((JunkTableModel)this.tableJunk.getModel()).fireTableDataChanged();
                this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
                this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.context.cfg.gs("JunkRemover.title"), 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index;
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if ((index = this.configItems.getSelectedRow()) >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            JunkRemoverTool tool = (JunkRemoverTool)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + tool.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(tool.getConfigName(), null, tool.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(tool.getFullPath());
                    if (file.exists()) {
                        this.deletedTools.add(tool);
                    }
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    this.configModel.fireTableDataChanged();
                    if (index >= 0) {
                        this.configItems.changeSelection(index, 0, false, false);
                        this.loadJunkTable(index);
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("JunkRemover.help"), "junkremover_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            JunkRemoverTool jrt = new JunkRemoverTool(this.context);
            jrt.setConfigName(this.context.cfg.gs("Z.untitled"));
            jrt.setDataHasChanged();
            jrt.addJunkItem();
            this.configModel.addRow(new Object[]{jrt});
            ((JunkTableModel)this.tableJunk.getModel()).setTool(null);
            this.tableJunk.removeAll();
            ((JunkTableModel)this.tableJunk.getModel()).fireTableDataChanged();
            ((JunkTableModel)this.tableJunk.getModel()).setTool(jrt);
            ((JunkTableModel)this.tableJunk.getModel()).fireTableDataChanged();
            if (this.configModel.getRowCount() > 0) {
                this.buttonCopy.setEnabled(true);
                this.buttonDelete.setEnabled(true);
                this.buttonRun.setEnabled(true);
                this.buttonAddRow.setEnabled(true);
                this.buttonRemoveRow.setEnabled(true);
            }
            this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
            this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
            this.configItems.getEditorComponent().requestFocus();
            ((JTextField)this.configItems.getEditorComponent()).selectAll();
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.context.cfg.gs("JunkRemover.title"), 2);
        }
    }

    private void actionRemoveRowClicked(ActionEvent e) {
        int[] rows;
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if ((rows = this.tableJunk.getSelectedRows()).length > 0) {
            int i;
            for (i = 0; i < rows.length; ++i) {
                int rm;
                rows[i] = rm = this.tableJunk.convertRowIndexToModel(rows[i]);
            }
            Arrays.sort(rows);
            for (i = rows.length - 1; i >= 0; --i) {
                ((JunkTableModel)this.tableJunk.getModel()).removeRow(rows[i]);
            }
            int index = this.configItems.getSelectedRow();
            if (index >= 0) {
                JunkRemoverTool jrt = (JunkRemoverTool)this.configModel.getValueAt(index, 0);
                jrt.setDataHasChanged();
            }
            ((JunkTableModel)this.tableJunk.getModel()).fireTableDataChanged();
            this.tableJunk.requestFocus();
            if (this.tableJunk.getRowCount() > 0) {
                this.tableJunk.changeSelection(0, 0, false, false);
            }
        }
    }

    private void actionRunClicked(ActionEvent e) {
        block10: {
            int index;
            if (this.tableJunk.isEditing()) {
                this.tableJunk.getCellEditor().stopCellEditing();
            }
            if ((index = this.configItems.getSelectedRow()) >= 0) {
                try {
                    final ArrayList<Origin> origins = new ArrayList<Origin>();
                    this.isSubscriber = Origins.makeOriginsFromSelected(this.context, this, origins);
                    int count = origins.size();
                    if (origins != null && origins.size() > 0) {
                        final JunkRemoverTool jrt = (JunkRemoverTool)this.configModel.getValueAt(index, 0);
                        if (jrt.isDataChanged()) {
                            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.save.then.run"), this.context.cfg.gs("JunkRemover.title"), 2);
                            return;
                        }
                        String which = this.isSubscriber ? this.context.cfg.gs("Z.subscriber") : this.context.cfg.gs("Z.publisher");
                        String message = MessageFormat.format(this.context.cfg.gs("JunkRemover.run.on.N.locations"), jrt.getConfigName(), count, which);
                        JCheckBox checkbox = new JCheckBox(this.context.cfg.gs("Navigator.dryrun"));
                        checkbox.setToolTipText(this.context.cfg.gs("Navigator.dryrun.tooltip"));
                        checkbox.setSelected(this.context.preferences.isDefaultDryrun());
                        Object[] params = new Object[]{message, checkbox};
                        int reply = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("JunkRemover.title"), 0);
                        this.isDryRun = checkbox.isSelected();
                        if (reply == 0) {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.setComponentEnabled(false);
                            this.cancelButton.setEnabled(true);
                            this.cancelButton.setCursor(Cursor.getPredefinedCursor(0));
                            this.labelHelp.setEnabled(true);
                            this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
                            this.worker = new SwingWorker<Void, Void>(){

                                @Override
                                protected Void doInBackground() throws Exception {
                                    block3: {
                                        try {
                                            JunkRemoverUI.this.workerJrt = jrt.clone();
                                            JunkRemoverUI.this.processSelected(JunkRemoverUI.this.workerJrt, origins, JunkRemoverUI.this.isSubscriber);
                                        }
                                        catch (Exception e) {
                                            if (e.getMessage().equals("HANDLED_INTERNALLY")) break block3;
                                            String msg = JunkRemoverUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                            if (JunkRemoverUI.this.context != null) {
                                                JunkRemoverUI.this.logger.error(msg);
                                                JOptionPane.showMessageDialog(JunkRemoverUI.this.me, msg, JunkRemoverUI.this.context.cfg.gs("JunkRemover.title"), 0);
                                            }
                                            JunkRemoverUI.this.logger.error(msg);
                                        }
                                    }
                                    return null;
                                }
                            };
                            if (this.worker != null) {
                                this.workerRunning = true;
                                this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent e) {
                                        if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                            JunkRemoverUI.this.processTerminated();
                                        }
                                    }
                                });
                                this.worker.execute();
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, this.context.cfg.gs("JunkRemover.nothing.selected.in.browser"), this.context.cfg.gs("JunkRemover.title"), 2);
                    }
                }
                catch (Exception e1) {
                    if (e1.getMessage().equals("HANDLED_INTERNALLY")) break block10;
                    String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e1);
                    if (this.context != null) {
                        this.logger.error(msg);
                        JOptionPane.showMessageDialog(this.context.navigator.dialogJunkRemover, msg, this.context.cfg.gs("JunkRemover.title"), 0);
                    }
                    this.logger.error(msg);
                }
            }
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        this.saveConfigurations();
        this.savePreferences();
        this.setVisible(false);
    }

    private void adjustJunkTable() {
        this.tableJunk.setModel(new JunkTableModel(this.context));
        this.tableJunk.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        TableColumn column = this.tableJunk.getColumnModel().getColumn(0);
        cellRenderer.setHorizontalAlignment(2);
        column.setMinWidth(32);
        column.setCellRenderer(cellRenderer);
        column.setResizable(true);
        column = this.tableJunk.getColumnModel().getColumn(1);
        column.setResizable(false);
        column.setWidth(62);
        column.setPreferredWidth(62);
        column.setMaxWidth(62);
        column.setMinWidth(62);
        this.tableJunk.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "Action.NextCell");
        this.tableJunk.getActionMap().put("Action.NextCell", new NextCellAction());
    }

    public void cancelChanges() {
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((JunkRemoverTool)this.configModel.getValueAt(i, 0)).reset();
            ((JunkRemoverTool)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (this.tableJunk.isEditing()) {
            this.tableJunk.getCellEditor().stopCellEditing();
        }
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((JunkRemoverTool)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private void configItemsMouseClicked(MouseEvent e) {
        JTable src = (JTable)e.getSource();
        if (e.getClickCount() == 1) {
            if (this.tableJunk.isEditing()) {
                this.tableJunk.getCellEditor().stopCellEditing();
            }
            int index = src.getSelectedRow();
            this.loadJunkTable(index);
        }
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    private void loadConfigurations() {
        ArrayList<AbstractTool> toolList = null;
        try {
            toolList = this.context.tools.loadAllTools(this.context, "JunkRemover");
            for (AbstractTool tool : toolList) {
                JunkRemoverTool jrt = (JunkRemoverTool)tool;
                this.configModel.addRow(new Object[]{jrt});
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogJunkRemover, msg, this.context.cfg.gs("JunkRemover.title"), 0);
            }
            this.logger.error(msg);
        }
        this.configModel.setToolList(toolList);
        this.configModel.loadJobsConfigurations(this, null);
        if (this.configModel.getRowCount() == 0) {
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonRun.setEnabled(false);
            this.buttonAddRow.setEnabled(false);
            this.buttonRemoveRow.setEnabled(false);
        } else {
            this.loadJunkTable(0);
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
        }
    }

    private void loadJunkTable(int index) {
        if (index >= 0 && index < this.configModel.getRowCount()) {
            JunkRemoverTool jrt = (JunkRemoverTool)this.configModel.getValueAt(index, 0);
            JunkTableModel model = (JunkTableModel)this.tableJunk.getModel();
            model.setTool(jrt);
            model.fireTableDataChanged();
            this.buttonCopy.setEnabled(true);
            this.buttonDelete.setEnabled(true);
            this.buttonRun.setEnabled(true);
            this.buttonAddRow.setEnabled(true);
            this.buttonRemoveRow.setEnabled(true);
        } else {
            JunkTableModel model = (JunkTableModel)this.tableJunk.getModel();
            for (int i = model.getRowCount() - 1; i >= 0; --i) {
                model.removeRow(i);
            }
            model.setTool(null);
            model.fireTableDataChanged();
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonRun.setEnabled(false);
            this.buttonAddRow.setEnabled(false);
            this.buttonRemoveRow.setEnabled(false);
        }
    }

    private void processSelected(JunkRemoverTool jrt, ArrayList<Origin> origins, boolean isSubscriber) throws Exception {
        if (jrt != null && origins != null && origins.size() > 0) {
            this.workerTask = new Task(jrt.getInternalName(), jrt.getConfigName());
            this.workerTask.setContext(jrt.getContext());
            this.workerTask.setDryRun(this.isDryRun);
            this.workerTask.setOrigins(origins);
            if (isSubscriber) {
                this.workerTask.setSubscriberKey("_ANY_SERVER_");
            } else {
                this.workerTask.setPublisherKey("_ANY_SERVER_");
            }
            if (this.context.cfg.isHintTrackingEnabled()) {
                this.workerTask.setHintsKey("_ANY_SERVER_");
            }
            this.workerTask.process(this.context);
        }
    }

    private void processTerminated() {
        if (this.context.progress != null) {
            this.context.progress.done();
            this.context.progress.dispose();
            this.context.progress = null;
        }
        Origins.setSelectedFromOrigins(this.context, this, this.workerTask.getOrigins());
        this.setComponentEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.workerJrt.isRequestStop()) {
            this.logger.info(this.workerJrt.getConfigName() + this.context.cfg.gs("Z.cancelled"));
            this.context.mainFrame.labelStatusMiddle.setText(this.workerJrt.getConfigName() + this.context.cfg.gs("Z.cancelled"));
        }
        this.workerRunning = false;
        this.workerJrt = null;
    }

    private void saveConfigurations() {
        JunkRemoverTool tool = null;
        try {
            int i;
            for (i = 0; i < this.deletedTools.size(); ++i) {
                tool = (JunkRemoverTool)this.deletedTools.get(i);
                File file = new File(tool.getFullPath());
                if (!file.exists()) continue;
                file.delete();
            }
            this.deletedTools = new ArrayList();
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (JunkRemoverTool)this.configModel.getValueAt(i, 0);
                if (tool.isDataChanged()) {
                    tool.write();
                }
                tool.setDataHasChanged(false);
            }
            this.configModel.saveJobsConfigurations(null);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogJunkRemover, msg, this.context.cfg.gs("JunkRemover.title"), 0);
            }
            this.logger.error(msg);
        }
    }

    private void savePreferences() {
        this.context.preferences.setToolsJunkRemoverHeight(this.getHeight());
        this.context.preferences.setToolsJunkRemoverWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsJunkRemoverXpos(location.x);
        this.context.preferences.setToolsJunkRemoverYpos(location.y);
        this.context.preferences.setToolsJunkRemoverDividerLocation(this.splitPaneContent.getDividerLocation());
    }

    public void setComponentEnabled(boolean enabled) {
        this.setComponentEnabled(enabled, this.getContentPane());
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        component.setEnabled(enabled);
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component comp : components) {
                this.setComponentEnabled(enabled, comp);
            }
        }
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void windowHidden(ComponentEvent e) {
        this.context.navigator.enableDisableToolMenus(this, true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.hSpacerBeforeRun = new JPanel(null);
        this.buttonRun = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.splitPaneContent = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.configItems = new JTable();
        this.panelOptions = new JPanel();
        this.scrollPaneOptions = new JScrollPane();
        this.tableJunk = new JTable();
        this.panelOptionsButtons = new JPanel();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.buttonBar = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(this.context.cfg.gs("JunkRemover.title"));
        this.setName("junkRemoverUI");
        this.setMinimumSize(new Dimension(150, 126));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JunkRemoverUI.this.windowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                JunkRemoverUI.this.windowHidden(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(570, 470));
        this.dialogPane.setMinimumSize(new Dimension(150, 80));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setPreferredSize(new Dimension(570, 470));
        this.contentPanel.setMinimumSize(new Dimension(140, 120));
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNew.setText(this.context.cfg.gs("JunkRemover.button.New.text"));
        this.buttonNew.setMnemonic(this.context.cfg.gs("JunkRemover.button.New.mnemonic").charAt(0));
        this.buttonNew.setToolTipText(this.context.cfg.gs("JunkRemover.button.New.toolTipText"));
        this.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("Navigator.buttonCopy.text"));
        this.buttonCopy.setMnemonic(this.context.cfg.gs("JunkRemover.button.Copy.mnemonic").charAt(0));
        this.buttonCopy.setToolTipText(this.context.cfg.gs("Navigator.buttonCopy.toolTipText"));
        this.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("Navigator.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("JunkRemover.button.Delete.mnemonic").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("Navigator.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.hSpacerBeforeRun.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeRun.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeRun);
        this.buttonRun.setText(this.context.cfg.gs("Z.run.ellipsis"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("JunkRemover.button.Run.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("JunkRemover.button.Run.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("JunkRemover.help"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JunkRemoverUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "East");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.splitPaneContent.setDividerLocation(142);
        this.splitPaneContent.setLastDividerLocation(142);
        this.splitPaneContent.setMinimumSize(new Dimension(140, 80));
        this.scrollPaneConfig.setMinimumSize(new Dimension(140, 16));
        this.scrollPaneConfig.setPreferredSize(new Dimension(142, 146));
        this.configItems.setSelectionMode(0);
        this.configItems.setShowVerticalLines(false);
        this.configItems.setFillsViewportHeight(true);
        this.configItems.setShowHorizontalLines(false);
        this.configItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JunkRemoverUI.this.configItemsMouseClicked(e);
            }
        });
        this.scrollPaneConfig.setViewportView(this.configItems);
        this.splitPaneContent.setLeftComponent(this.scrollPaneConfig);
        this.panelOptions.setMinimumSize(new Dimension(0, 78));
        this.panelOptions.setLayout(new BorderLayout());
        this.tableJunk.setShowVerticalLines(false);
        this.tableJunk.setName("tableJunk");
        this.tableJunk.setAutoCreateRowSorter(true);
        this.tableJunk.setCellSelectionEnabled(true);
        this.scrollPaneOptions.setViewportView(this.tableJunk);
        this.panelOptions.add((Component)this.scrollPaneOptions, "Center");
        this.panelOptionsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAddRow.setText(this.context.cfg.gs("JunkRemover.button.AddRow.text"));
        this.buttonAddRow.setFont(this.buttonAddRow.getFont().deriveFont((float)this.buttonAddRow.getFont().getSize() - 2.0f));
        this.buttonAddRow.setPreferredSize(new Dimension(78, 24));
        this.buttonAddRow.setMinimumSize(new Dimension(78, 24));
        this.buttonAddRow.setMaximumSize(new Dimension(78, 24));
        this.buttonAddRow.setMnemonic(this.context.cfg.gs("JunkRemover.button.AddRow.mnemonic").charAt(0));
        this.buttonAddRow.setToolTipText(this.context.cfg.gs("JunkRemover.button.AddRow.toolTipText"));
        this.buttonAddRow.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAddRow.addActionListener(e -> this.actionAddRowClicked(e));
        this.panelOptionsButtons.add(this.buttonAddRow);
        this.buttonRemoveRow.setText(this.context.cfg.gs("JunkRemover.button.RemoveRow.text"));
        this.buttonRemoveRow.setFont(this.buttonRemoveRow.getFont().deriveFont((float)this.buttonRemoveRow.getFont().getSize() - 2.0f));
        this.buttonRemoveRow.setPreferredSize(new Dimension(78, 24));
        this.buttonRemoveRow.setMinimumSize(new Dimension(78, 24));
        this.buttonRemoveRow.setMaximumSize(new Dimension(78, 24));
        this.buttonRemoveRow.setMnemonic(this.context.cfg.gs("JunkRemover.button.RemoveRow.mnemonic").charAt(0));
        this.buttonRemoveRow.setToolTipText(this.context.cfg.gs("JunkRemover.button.RemoveRow.toolTipText"));
        this.buttonRemoveRow.setMargin(new Insets(0, -10, 0, -10));
        this.buttonRemoveRow.addActionListener(e -> this.actionRemoveRowClicked(e));
        this.panelOptionsButtons.add(this.buttonRemoveRow);
        this.panelOptions.add((Component)this.panelOptionsButtons, "South");
        this.splitPaneContent.setRightComponent(this.panelOptions);
        this.contentPanel.add((Component)this.splitPaneContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 82, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.saveButton.setText(this.context.cfg.gs("Z.save"));
        this.saveButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.saveButton.setMnemonic(this.context.cfg.gs("JunkRemover.saveButton.mnemonic").charAt(0));
        this.saveButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("Z.cancel"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic(this.context.cfg.gs("JunkRemover.cancelButton.mnemonic_2").charAt(0));
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class NextCellAction
    extends AbstractAction {
        private NextCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JunkRemoverUI.this.tableJunk.getSelectedRow();
            int col = JunkRemoverUI.this.tableJunk.getSelectedColumn();
            int rowCount = JunkRemoverUI.this.tableJunk.getRowCount();
            int colCount = JunkRemoverUI.this.tableJunk.getColumnCount();
            if (++col >= colCount) {
                col = 0;
                ++row;
            }
            if (row >= rowCount) {
                ((JunkTableModel)JunkRemoverUI.this.tableJunk.getModel()).getTool().addJunkItem();
                ((JunkTableModel)JunkRemoverUI.this.tableJunk.getModel()).fireTableDataChanged();
            }
            JunkRemoverUI.this.tableJunk.changeSelection(row, col, false, false);
            JunkRemoverUI.this.tableJunk.editCellAt(row, col);
            JunkRemoverUI.this.tableJunk.getEditorComponent().requestFocus();
        }
    }
}

