/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabel
extends BasicLabelUI {
    private static final Rectangle paintIconR = new Rectangle();
    private static final Rectangle paintTextR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static final Rectangle paintViewR = new Rectangle();
    protected boolean clockwise;

    public VerticalLabel(boolean clockwise) {
        this.clockwise = clockwise;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        VerticalLabel.paintViewR.x = VerticalLabel.paintViewInsets.left;
        VerticalLabel.paintViewR.y = VerticalLabel.paintViewInsets.top;
        VerticalLabel.paintViewR.height = c.getWidth() - (VerticalLabel.paintViewInsets.left + VerticalLabel.paintViewInsets.right);
        VerticalLabel.paintViewR.width = c.getHeight() - (VerticalLabel.paintViewInsets.top + VerticalLabel.paintViewInsets.bottom);
        VerticalLabel.paintIconR.height = 0;
        VerticalLabel.paintIconR.width = 0;
        VerticalLabel.paintIconR.y = 0;
        VerticalLabel.paintIconR.x = 0;
        VerticalLabel.paintTextR.height = 0;
        VerticalLabel.paintTextR.width = 0;
        VerticalLabel.paintTextR.y = 0;
        VerticalLabel.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c, g, VerticalLabel.paintIconR.x, VerticalLabel.paintIconR.y);
        }
        if (text != null) {
            int textX = VerticalLabel.paintTextR.x;
            int textY = VerticalLabel.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }

    static {
        labelUI = new VerticalLabel(false);
    }
}

