/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.jobs;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Job;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Jobs {
    private Context context;
    private Logger logger = LogManager.getLogger("applog");

    private Jobs() {
    }

    public Jobs(Context context) {
        this.context = context;
    }

    public ArrayList<AbstractTool> loadAllJobs() throws Exception {
        ArrayList<AbstractTool> jobList = new ArrayList<AbstractTool>();
        jobList = this.scanJobs(jobList);
        Collections.sort(jobList);
        return jobList;
    }

    public void saveAllJobs(ArrayList<AbstractTool> jobList) throws Exception {
        boolean changed = false;
        Job job = null;
        if (jobList != null) {
            for (int i = 0; i < jobList.size(); ++i) {
                job = (Job)jobList.get(i);
                if (!job.isDataChanged()) continue;
                String status = job.validate(this.context.cfg, false);
                if (status.length() > 0) {
                    JOptionPane.showMessageDialog(this.context.mainFrame, status, this.context.cfg.gs("JobsUI.title"), 2);
                }
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String json = gson.toJson(job);
                String path = job.getDirectoryPath() + System.getProperty("file.separator") + Utils.scrubFilename(job.getConfigName()) + ".json";
                File f = new File(path);
                if (f != null) {
                    f.getParentFile().mkdirs();
                }
                PrintWriter outputStream = new PrintWriter(path);
                outputStream.println(json);
                outputStream.close();
                changed = true;
                job.setDataHasChanged(false);
            }
            if (changed) {
                this.context.navigator.loadJobsMenu();
                this.context.libraries.loadJobs();
            }
        }
    }

    private ArrayList<AbstractTool> scanJobs(ArrayList<AbstractTool> jobList) throws Exception {
        Job tmpJob = new Job(this.context, "temp");
        String dir = tmpJob.getDirectoryPath();
        File jobDir = new File(dir);
        if (jobDir.exists() && jobDir.isDirectory()) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new Job(Jobs.this.context, "");
                }
            }
            builder.registerTypeAdapter((Type)((Object)Job.class), new ObjInstanceCreator());
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(jobDir.toPath());
            for (Path entry : directoryStream) {
                Job job;
                String json;
                boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (job = builder.create().fromJson(json, Job.class)) == null) continue;
                jobList.add(job);
            }
        }
        return jobList;
    }
}

