/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.repository;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Libraries;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.LibraryData;
import com.corionis.els.repository.Location;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Repository
implements Comparable {
    public static final int HINT_SERVER = 3;
    public static final boolean NO_VALIDATE = false;
    public static final int PUBLISHER = 1;
    public static final int SUBSCRIBER = 2;
    public static final boolean VALIDATE = true;
    public final String SUB_EXCLUDE = "ELS-SUBSCRIBER-SKIP_";
    private String jsonFilename = "";
    private LibraryData libraryData = null;
    private int purpose = -1;
    private transient Context context;
    private transient boolean dynamic = false;
    private transient Logger logger = LogManager.getLogger("applog");

    public Repository(Context context, int purpose) {
        this.context = context;
        this.purpose = purpose;
    }

    public Repository cloneNoItems() {
        Repository noItems = new Repository(this.context, this.purpose);
        noItems.setJsonFilename(this.getJsonFilename());
        noItems.createStructure();
        noItems.libraryData.libraries.description = this.getLibraryData().libraries.description;
        noItems.libraryData.libraries.host = this.getLibraryData().libraries.host;
        noItems.libraryData.libraries.listen = this.getLibraryData().libraries.listen;
        noItems.libraryData.libraries.timeout = this.getLibraryData().libraries.timeout;
        noItems.libraryData.libraries.flavor = this.getLibraryData().libraries.flavor;
        noItems.libraryData.libraries.case_sensitive = this.getLibraryData().libraries.case_sensitive;
        noItems.libraryData.libraries.temp_dated = this.getLibraryData().libraries.temp_dated;
        noItems.libraryData.libraries.temp_location = this.getLibraryData().libraries.temp_location;
        noItems.libraryData.libraries.terminal_allowed = this.getLibraryData().libraries.terminal_allowed;
        noItems.libraryData.libraries.key = this.getLibraryData().libraries.key;
        noItems.libraryData.libraries.ignore_patterns = this.getLibraryData().libraries.ignore_patterns != null ? (String[])this.getLibraryData().libraries.ignore_patterns.clone() : null;
        noItems.libraryData.libraries.email = this.getLibraryData().libraries.email;
        noItems.libraryData.libraries.format = this.getLibraryData().libraries.format;
        noItems.libraryData.libraries.mismatches = this.getLibraryData().libraries.mismatches;
        noItems.libraryData.libraries.whatsNew = this.getLibraryData().libraries.whatsNew;
        noItems.libraryData.libraries.skipOffline = this.getLibraryData().libraries.skipOffline;
        noItems.libraryData.libraries.locations = this.getLibraryData().libraries.locations != null ? (Location[])this.getLibraryData().libraries.locations.clone() : null;
        noItems.libraryData.libraries.bibliography = new Library[this.getLibraryData().libraries.bibliography.length];
        for (int i = 0; i < this.getLibraryData().libraries.bibliography.length; ++i) {
            Library lib = new Library();
            lib.name = this.getLibraryData().libraries.bibliography[i].name;
            lib.sources = (String[])this.getLibraryData().libraries.bibliography[i].sources.clone();
            noItems.libraryData.libraries.bibliography[i] = lib;
        }
        return noItems;
    }

    public int compareTo(Object o) {
        return this.getLibraryData().libraries.description.compareTo(((Repository)o).getLibraryData().libraries.description);
    }

    public void createLibrary(String name) {
        Library lib = new Library();
        lib.name = name;
        this.expandBibliography(lib);
    }

    public void createStructure() {
        this.libraryData = new LibraryData();
        this.libraryData.libraries = new Libraries();
    }

    private void expandBibliography(Library lib) {
        Library[] expanded = new Library[this.libraryData.libraries.bibliography.length + 1];
        System.arraycopy(this.libraryData.libraries.bibliography, 0, expanded, 0, this.libraryData.libraries.bibliography.length);
        this.libraryData.libraries.bibliography = expanded;
        this.libraryData.libraries.bibliography[expanded.length - 1] = lib;
    }

    public void exportItems(boolean isCollection) throws MungeException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String where = Utils.getFullPathLocal(this.context.cfg.getExportCollectionFilename());
        File outFile = new File(where);
        outFile.getParentFile().mkdirs();
        this.logger.info(MessageFormat.format(this.context.cfg.gs("Repository.writing.choice.collection.library.file"), isCollection ? 0 : 1) + where);
        String json = gson.toJson(this.getLibraryData());
        try {
            PrintWriter outputStream = new PrintWriter(where);
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.exception.while.writing.choice.collection.library.file.trace"), isCollection ? 0 : 1, where) + Utils.getStackTrace(fnf));
        }
    }

    public void exportText() throws MungeException {
        String where = Utils.getFullPathLocal(this.context.cfg.getExportTextFilename());
        File outFile = new File(where);
        outFile.getParentFile().mkdirs();
        this.logger.info(this.context.cfg.gs("Repository.writing.text.file") + where);
        try {
            PrintWriter outputStream = new PrintWriter(where);
            for (Library lib : this.getLibraryData().libraries.bibliography) {
                if (this.context.cfg.isSpecificLibrary() && !this.context.cfg.isSelectedLibrary(lib.name) || this.context.cfg.isSpecificExclude() && this.context.cfg.isExcludedLibrary(lib.name)) continue;
                for (Item item : lib.items) {
                    if (item.isDirectory() || this.ignore(item)) continue;
                    outputStream.println(item.getItemPath());
                }
            }
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.exception.while.writing.text.file.0.trace"), where) + Utils.getStackTrace(fnf));
        }
    }

    public String getItemName(Item item) throws MungeException {
        String path = item.getItemPath();
        String sep = this.getSeparator();
        String name = path.substring(path.lastIndexOf(sep) + 1, path.length());
        return name;
    }

    public String getJsonFilename() {
        return this.jsonFilename;
    }

    public Library getLibrary(String libraryName) throws MungeException {
        boolean has = false;
        Library retLib = null;
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            if (!lib.name.equalsIgnoreCase(libraryName)) continue;
            if (has) {
                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.library.found.more.than.once.in"), lib.name) + this.getJsonFilename());
            }
            has = true;
            retLib = lib;
        }
        return retLib;
    }

    public LibraryData getLibraryData() {
        return this.libraryData;
    }

    public Collection getMapItem(Library lib, String itemPath) throws MungeException {
        List collection = null;
        try {
            String key = itemPath;
            if (!this.getLibraryData().libraries.case_sensitive.booleanValue()) {
                key = key.toLowerCase();
            }
            collection = lib.itemMap.get((Object)key);
        }
        catch (Exception e) {
            throw new MungeException("itemMap.get '" + itemPath + "' failed");
        }
        return collection;
    }

    public int getPurpose() {
        return this.purpose;
    }

    public String getSeparator() {
        String sep = this.getWriteSeparator();
        return sep;
    }

    public String getWriteSeparator() {
        return Utils.getFileSeparator(this.getLibraryData().libraries.flavor);
    }

    public boolean hasContent() {
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            if (lib.items == null || lib.items.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public String hasDirectory(String libraryName, String itemPath) throws MungeException {
        String match = itemPath;
        Item foundItem = null;
        int i = match.lastIndexOf("|");
        if (i < 0) {
            return null;
        }
        String path = match.substring(0, i);
        if (path.length() < 1) {
            path = match.substring(0, match.lastIndexOf("|"));
        }
        match = path;
        path = null;
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            if (!lib.name.equalsIgnoreCase(libraryName)) continue;
            foundItem = null;
            if (lib.items != null) {
                for (Item item : lib.items) {
                    if (this.getLibraryData().libraries.case_sensitive.booleanValue()) {
                        if (!Utils.pipe(this, item.getItemPath()).equals(match)) continue;
                        foundItem = item;
                    } else {
                        if (!Utils.pipe(this, item.getItemPath()).equalsIgnoreCase(match)) continue;
                        foundItem = item;
                    }
                    break;
                }
            } else {
                this.logger.warn(MessageFormat.format(this.context.cfg.gs("Repository.subscriber.library.has.no.items.is.command.line.configured.correctly"), lib.name));
            }
            if (foundItem == null || !foundItem.isDirectory()) break;
            path = foundItem.getFullPath().substring(0, foundItem.getFullPath().lastIndexOf(foundItem.getItemPath()) - 1);
            break;
        }
        return path;
    }

    public Item hasItem(Item pubItem, String libName, String itemPath) throws MungeException {
        Item has = null;
        if (pubItem == null || !pubItem.isDirectory()) {
            for (Library lib : this.getLibraryData().libraries.bibliography) {
                Collection collection;
                if (!this.context.cfg.isCrossCheck() && !lib.name.equalsIgnoreCase(libName) || lib.itemMap == null || (collection = this.getMapItem(lib, itemPath)) == null) continue;
                Iterator it = collection.iterator();
                for (int i = 0; i < collection.size(); ++i) {
                    Integer j = (Integer)it.next();
                    Item item = lib.items.elementAt(j);
                    if (item.isDirectory()) continue;
                    if (pubItem != null) {
                        pubItem.addHas(item);
                    }
                    if (has != null) {
                        this.logger.warn(MessageFormat.format(this.context.cfg.gs("Repository.duplicate.of.found.at"), itemPath, item.getFullPath()));
                        continue;
                    }
                    has = item;
                }
            }
        }
        return has;
    }

    public void hasPublisherDuplicate(Item pubItem, String itemPath) throws MungeException {
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            if (!this.context.cfg.isCrossCheck() && !lib.name.equalsIgnoreCase(pubItem.getLibrary())) continue;
            if (lib.itemMap != null) {
                Collection collection = this.getMapItem(lib, itemPath);
                if (collection == null) continue;
                Iterator it = collection.iterator();
                for (int i = 0; i < collection.size(); ++i) {
                    Integer j = (Integer)it.next();
                    Item item = lib.items.elementAt(j);
                    if (item == pubItem || item.isDirectory()) continue;
                    pubItem.addHas(item);
                    this.logger.warn(MessageFormat.format(this.context.cfg.gs("Repository.duplicate.of.found.at"), pubItem.getFullPath(), item.getFullPath()));
                }
                continue;
            }
            throw new MungeException(this.context.cfg.gs("Repository.itemmap.is.null.for.library") + lib.name);
        }
    }

    public boolean ignore(Item item) throws MungeException {
        String str = "";
        String strPatt = "";
        boolean ret = false;
        String name = this.getItemName(item);
        if (name.toLowerCase().endsWith(".els")) {
            ret = true;
        } else {
            int i = 0;
            for (Pattern patt : this.getLibraryData().libraries.compiledPatterns) {
                str = this.getLibraryData().libraries.ignore_patterns[i++];
                strPatt = patt.toString();
                if (str.startsWith(".*\\" + this.getSeparator()) || str.endsWith("\\" + this.getSeparator() + ".*")) {
                    if (!item.getFullPath().matches(strPatt)) continue;
                    ret = true;
                    break;
                }
                if (!name.matches(strPatt)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isInitialized() {
        return this.getLibraryData() != null && this.jsonFilename != null && this.jsonFilename.length() > 0;
    }

    public boolean isPublisher() {
        return this.getPurpose() == 1;
    }

    public boolean isSubscriber() {
        return this.getPurpose() == 2;
    }

    public void normalize() throws MungeException {
        if (this.getLibraryData() != null) {
            Object path;
            String flavor;
            if (this.getLibraryData().libraries.timeout < 0) {
                this.getLibraryData().libraries.timeout = 15;
            }
            if (!((flavor = this.getLibraryData().libraries.flavor.toLowerCase()).equalsIgnoreCase("Linux") || flavor.equalsIgnoreCase("Mac") || flavor.equalsIgnoreCase("Windows"))) {
                throw new MungeException(this.context.cfg.gs("Repository.flavor.is.not.linux.mac.or.windows") + flavor);
            }
            String from = "";
            String to = "";
            if (flavor.equalsIgnoreCase("Linux") || flavor.equalsIgnoreCase("Mac")) {
                from = "\\\\";
                to = "/";
            } else if (flavor.equalsIgnoreCase("Windows")) {
                from = "/";
                to = "\\\\";
            }
            if (this.getLibraryData().libraries.temp_location != null && ((String)(path = this.getLibraryData().libraries.temp_location)).startsWith("~")) {
                this.getLibraryData().libraries.temp_location = path = System.getProperty("user.home") + ((String)path).substring(1);
            }
            if (this.getLibraryData().libraries.bibliography != null) {
                for (Library lib : this.getLibraryData().libraries.bibliography) {
                    int i;
                    if (lib.sources != null) {
                        for (i = 0; i < lib.sources.length; ++i) {
                            if (lib.sources[i] == null || lib.sources[i].length() <= 0) {
                                throw new MungeException("Malformed JSON");
                            }
                            lib.sources[i] = this.normalizeSubst(lib.sources[i], from, to);
                        }
                    }
                    if (lib.items == null) continue;
                    if (lib.itemMap == null) {
                        lib.itemMap = ArrayListMultimap.create();
                    } else {
                        lib.itemMap.clear();
                    }
                    for (i = 0; i < lib.items.size(); ++i) {
                        Item item = lib.items.elementAt(i);
                        item.setItemPath(this.normalizeSubst(item.getItemPath(), from, to));
                        item.setFullPath(this.normalizeSubst(item.getFullPath(), from, to));
                        String key = item.getItemPath();
                        if (!this.getLibraryData().libraries.case_sensitive.booleanValue()) {
                            key = key.toLowerCase();
                        }
                        lib.itemMap.put((Object)Utils.pipe(this, key), (Object)i);
                    }
                }
            }
        }
    }

    public String normalizePath(String toFlavor, String path) throws MungeException {
        String to = Utils.getFileSeparator(toFlavor);
        path = this.normalizeSubst(path, Utils.getFileSeparator(this.getLibraryData().libraries.flavor), to);
        return path;
    }

    private String normalizeSubst(String path, String from, String to) {
        path = Utils.unpipe(Utils.pipe(path), to);
        return path;
    }

    public boolean read(String filename, String type, boolean printLog) throws Exception {
        boolean valid = false;
        try {
            if (this.getLibraryData() != null) {
                this.libraryData = null;
            }
            Gson gson = new Gson();
            filename = Utils.getFullPathLocal(filename);
            if (printLog) {
                this.logger.info(this.context.cfg.gs("Repository.reading.library.file") + filename);
            }
            this.setJsonFilename(filename);
            String json = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
            this.libraryData = gson.fromJson(json, LibraryData.class);
            if (this.libraryData != null && this.libraryData.libraries != null) {
                this.normalize();
                if (printLog) {
                    this.logger.info(MessageFormat.format(this.context.cfg.gs("Repository.read.successfully"), this.libraryData.libraries.description));
                }
                valid = true;
            }
        }
        catch (Exception ioe) {
            String msg = MessageFormat.format(this.context.cfg.gs("Repository.exception.while.reading.library"), type) + filename + System.getProperty("line.separator");
            if (this.context.main.isStartupActive()) {
                this.logger.error(msg);
                int opt = JOptionPane.showConfirmDialog(this.context.guiLogAppender.getStartup(), msg + "Continue?", this.context.cfg.getNavigatorName(), 0);
                if (opt == 0) {
                    this.context.fault = false;
                    return false;
                }
            }
            throw new MungeException(msg);
        }
        return valid;
    }

    public void scan() throws Exception {
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            if (this.context.cfg.isSpecificLibrary() && !this.context.cfg.isSelectedLibrary(lib.name) || this.context.cfg.isSpecificExclude() && this.context.cfg.isExcludedLibrary(lib.name)) continue;
            this.scanSources(lib);
            this.sort(lib);
        }
        this.normalize();
    }

    public void scan(String libraryName) throws MungeException {
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            if (libraryName.length() <= 0 || !libraryName.equalsIgnoreCase(lib.name)) continue;
            this.scanSources(lib);
            this.sort(lib);
        }
        this.normalize();
    }

    private int scanDirectory(Library library, String base, String directory) throws MungeException {
        int count = 0;
        Item item = null;
        String fullPath = "";
        String itemPath = "";
        long size = 0L;
        boolean isDir = false;
        boolean isSym = false;
        directory = this.isSubscriber() && this.context.cfg.isRemoteSubscriber() ? this.context.cfg.getFullPathSubscriber(directory) : Utils.getFullPathLocal(directory);
        Path path = Paths.get(directory, new String[0]);
        if (library.items == null) {
            library.items = new Vector();
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path entry : directoryStream) {
                ++count;
                item = new Item();
                fullPath = entry.toString();
                item.setFullPath(fullPath);
                path = Paths.get(fullPath, new String[0]);
                isDir = Files.isDirectory(path, new LinkOption[0]);
                item.setDirectory(isDir);
                size = isDir ? 0L : Files.size(path);
                item.setSize(size);
                String full = this.isSubscriber() && this.context.cfg.isRemoteSubscriber() ? this.context.cfg.getFullPathSubscriber(base) : Utils.getFullPathLocal(base);
                int p = full.length() + 1;
                itemPath = fullPath.substring(p);
                item.setItemPath(itemPath);
                isSym = Files.isSymbolicLink(path);
                item.setSymLink(isSym);
                item.setLibrary(library.name);
                item.setModifiedDate(Files.getLastModifiedTime(path, new LinkOption[0]));
                if (!Utils.isFileOnly(item.getItemPath())) {
                    item.setItemSubdirectory(Utils.pipe(this, Utils.getLeftPath(item.getItemPath(), this.getSeparator())));
                }
                item.setItemShortName(Utils.getShortPath(item.getItemPath(), this.getSeparator()));
                library.items.add(item);
                if (!isDir) continue;
                item.setSize(this.scanDirectory(library, base, item.getFullPath()));
            }
        }
        catch (IOException ioe) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.exception.reading.directory.trace"), directory) + Utils.getStackTrace(ioe));
        }
        library.rescanNeeded = false;
        return count;
    }

    private void scanSources(Library lib) throws MungeException {
        this.logger.info((lib.rescanNeeded ? this.context.cfg.gs("Repository.rescan.required") : this.context.cfg.gs("Repository.scanning")) + this.getLibraryData().libraries.description + ": " + lib.name);
        lib.items = null;
        for (String src : lib.sources) {
            this.logger.info("  src: " + src);
            this.scanDirectory(lib, src, src);
        }
    }

    public void setDynamic(boolean sense) {
        this.dynamic = sense;
    }

    public void setJsonFilename(String jsonFilename) {
        this.jsonFilename = jsonFilename;
    }

    public void sort(Library lib) {
        lib.items.sort((item1, item2) -> item1.getItemPath().compareToIgnoreCase(item2.getItemPath()));
    }

    public void sortAll() {
        for (Library lib : this.getLibraryData().libraries.bibliography) {
            this.sort(lib);
        }
    }

    public String toString() {
        return this.libraryData != null && this.libraryData.libraries != null ? this.libraryData.libraries.description : "";
    }

    public void validate() throws Exception {
        if (this.getLibraryData() == null) {
            throw new MungeException(this.context.cfg.gs("Repository.libraries.are.null"));
        }
        Libraries lbs = this.getLibraryData().libraries;
        if (lbs == null) {
            throw new MungeException(this.context.cfg.gs("Repository.libraries.must.be.defined"));
        }
        if (lbs.description == null || lbs.description.length() == 0) {
            throw new MungeException(this.context.cfg.gs("Repository.libraries.description.must.be.defined"));
        }
        if (lbs.case_sensitive == null) {
            throw new MungeException(this.context.cfg.gs("Repository.libraries.case.sensitive.true.false.must.be.defined"));
        }
        if (lbs.ignore_patterns != null && lbs.ignore_patterns.length > 0) {
            Pattern patt = null;
            String src = null;
            try {
                String[] stringArray = lbs.ignore_patterns;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s;
                    src = s = stringArray[i];
                    patt = Pattern.compile(src);
                    lbs.compiledPatterns.add(patt);
                }
            }
            catch (PatternSyntaxException pe) {
                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.ignore.pattern.has.bad.regular.expression.regex.syntax"), src));
            }
            catch (IllegalArgumentException iae) {
                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.ignore.pattern.has.bad.flags"), src));
            }
        }
        if (this.getLibraryData().libraries.bibliography != null) {
            this.logger.info(MessageFormat.format(this.context.cfg.gs("Repository.validating.libraries.in"), lbs.description) + this.getJsonFilename());
            for (int i = 0; i < lbs.bibliography.length; ++i) {
                Library lib = lbs.bibliography[i];
                if (lib.name == null || lib.name.length() == 0) {
                    throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.bibliography.name.must.be.defined"), i));
                }
                if (lib.sources == null || lib.sources.length == 0) {
                    throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.bibliography.sources.must.be.defined"), i));
                }
                if (this.context.cfg.isSpecificLibrary() && !this.context.cfg.isSelectedLibrary(lib.name) || this.context.cfg.isSpecificExclude() && this.context.cfg.isExcludedLibrary(lib.name)) continue;
                this.logger.info("  library: " + lib.name + ", " + lib.sources.length + " source" + (lib.sources.length > 1 ? "s" : "") + (String)(lib.items != null && lib.items.size() > 0 ? ", " + lib.items.size() + " item" + (lib.items.size() > 0 ? "s" : "") : ""));
                for (int j = 0; j < lib.sources.length; ++j) {
                    if (lib.sources[j].length() == 0) {
                        throw new MungeException(MessageFormat.format(this.context.cfg.gs("Repository.bibliography.source.path.must.be.defined"), i, j));
                    }
                    if (Files.notExists(Paths.get(Utils.getFullPathLocal(lib.sources[j]), new String[0]), new LinkOption[0])) {
                        String msg = MessageFormat.format(this.context.cfg.gs("Repository.bibliography.sources.does.not.exist"), i, j, lib.sources[j]);
                        if (this.context.cfg.isGui()) {
                            this.logger.error(msg);
                        } else {
                            throw new MungeException(msg);
                        }
                    }
                    this.logger.info("    src: " + lib.sources[j]);
                    if (lib.items == null || lib.items.size() <= 0) continue;
                    for (Item item : lib.items) {
                        if (Files.notExists(Paths.get(item.getFullPath(), new String[0]), new LinkOption[0])) {
                            this.logger.error(this.context.cfg.gs("Repository.file.does.not.exist") + item.getFullPath());
                        } else if (!item.isDirectory() && Files.size(Paths.get(item.getFullPath(), new String[0])) != item.getSize()) {
                            this.logger.error(this.context.cfg.gs("Repository.file.size.does.not.match.file.is") + Files.size(Paths.get(item.getFullPath(), new String[0])) + ", data has " + item.getSize() + ": " + item.getFullPath());
                        }
                        if (item.getLibrary().equals(lib.name)) continue;
                        this.logger.error(this.context.cfg.gs("Repository.file.library.does.not.match.file.is.in") + lib.name + ", data has " + item.getLibrary() + ": " + item.getFullPath());
                    }
                }
            }
        }
    }

    public void write() throws Exception {
        try {
            File f = new File(Utils.getFullPathLocal(this.getJsonFilename()));
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            Gson gson = new GsonBuilder().serializeNulls().create();
            JsonWriter jsonWriter = new JsonWriter(new FileWriter(f.getPath()));
            jsonWriter.setIndent("    ");
            gson.toJson((Object)this.libraryData, (Type)((Object)LibraryData.class), jsonWriter);
            jsonWriter.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.context.cfg.gs("Z.error.writing") + this.getJsonFilename() + ": " + Utils.getStackTrace(fnf));
        }
    }
}

