/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.sftp;

import com.corionis.els.Utils;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.SftpEventListener;

public class EventListener
implements SftpEventListener {
    private transient Logger logger = LogManager.getLogger("applog");

    @Override
    public void blocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask, Throwable thrown) throws IOException {
        this.logger.debug("Sftp: blocked " + localHandle.getFile().toString());
    }

    @Override
    public void blocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) throws IOException {
    }

    @Override
    public void closed(ServerSession session, String remoteHandle, Handle localHandle, Throwable thrown) throws IOException {
        this.logger.trace("Sftp: closed " + localHandle.getFile().toString());
    }

    @Override
    public void closing(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
    }

    @Override
    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        this.logger.debug("Sftp: created " + String.valueOf(path));
    }

    @Override
    public void creating(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
    }

    @Override
    public void destroying(ServerSession session) throws IOException {
    }

    @Override
    public void exiting(ServerSession session, Handle handle) throws IOException {
        this.logger.debug("Sftp: exiting");
    }

    @Override
    public void initialized(ServerSession session, int version) throws IOException {
    }

    @Override
    public void linked(ServerSession session, Path source, Path target, boolean symLink, Throwable thrown) throws IOException {
        this.logger.debug("Sftp: linked " + source.toString() + " -> " + target.toString());
    }

    @Override
    public void linking(ServerSession session, Path source, Path target, boolean symLink) throws IOException {
    }

    @Override
    public void modifiedAttributes(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        this.logger.debug("Sftp: modifiedAttributes " + path.toString());
        if (thrown != null) {
            this.logger.error(Utils.getStackTrace(thrown));
        }
    }

    @Override
    public void modifyingAttributes(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
    }

    @Override
    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
        this.logger.debug("Sftp: moved " + String.valueOf(srcPath) + " -> " + String.valueOf(dstPath));
        if (thrown != null) {
            this.logger.error(Utils.getStackTrace(thrown));
        }
    }

    @Override
    public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
    }

    @Override
    public void open(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        this.logger.info("Sftp: open " + localHandle.getFile().toString());
    }

    @Override
    public void openFailed(ServerSession session, String remotePath, Path localPath, boolean isDirectory, Throwable thrown) throws IOException {
        this.logger.error("Sftp: openFailed " + localPath.toString());
    }

    @Override
    public void opening(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
    }

    @Override
    public void read(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, int readLen, Throwable thrown) throws IOException {
        this.logger.trace("Sftp: read " + localHandle.getFile().toString());
        if (thrown != null) {
            this.logger.error(Utils.getStackTrace(thrown));
        }
    }

    @Override
    public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
    }

    @Override
    public void removed(ServerSession session, Path path, boolean isDirectory, Throwable thrown) throws IOException {
        if (thrown != null) {
            if (!(thrown instanceof NoSuchFileException)) {
                this.logger.error(Utils.getStackTrace(thrown));
            }
        } else {
            this.logger.debug("Sftp: removed " + (isDirectory ? "directory " : "file ") + String.valueOf(path));
        }
    }

    @Override
    public void removing(ServerSession session, Path path, boolean isDirectory) throws IOException {
    }

    @Override
    public void unblocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, Throwable thrown) throws IOException {
        this.logger.trace("Sftp: unblocked");
    }

    @Override
    public void unblocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length) throws IOException {
    }

    @Override
    public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
    }

    @Override
    public void written(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, Throwable thrown) throws IOException {
    }
}

