/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.stty.ServeStty;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Listener
extends Thread {
    protected static Logger logger = LogManager.getLogger("applog");
    private InetAddress addr;
    private Configuration cfg;
    private Context context;
    private ServeStty instance = null;
    private ServerSocket listenSocket;
    private int port;
    private boolean stop = false;

    public Listener(ThreadGroup group, ServeStty instance, String host, int aPort, Context ctxt) throws Exception {
        super(group, "listener:" + host + ":" + aPort);
        this.instance = instance;
        this.addr = Inet4Address.getByName(host);
        this.port = aPort;
        this.context = ctxt;
        this.cfg = ctxt.cfg;
        this.listenSocket = new ServerSocket(this.port, 5, this.addr);
        this.listenSocket.setSoTimeout(2000);
    }

    public String getInetAddr() {
        return this.addr.getHostAddress();
    }

    private boolean isListed(Socket aSocket, boolean whiteList) throws IOException {
        String inet;
        String filename;
        String file;
        boolean sense = whiteList;
        String string = file = whiteList ? this.cfg.getIpWhitelist() : this.cfg.getBlacklist();
        if (file != null && file.length() > 0 && (filename = Utils.getFullPathLocal(file)).length() > 0 && (inet = aSocket.getInetAddress().toString()) != null) {
            String line;
            sense = false;
            inet = inet.replaceAll("/", "");
            inet = inet.replaceAll("\\\\", "");
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#") || !inet.equals(line)) continue;
                sense = true;
                break;
            }
            br.close();
        }
        return sense;
    }

    public void requestStop() {
        this.stop = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Socket socket = null;
        while (!this.stop) {
            try {
                socket = this.listenSocket.accept();
                if (this.isListed(socket, false)) {
                    socket.close();
                    logger.warn(this.context.cfg.gs("Comm.blacklisted.ip") + socket.getInetAddress().toString().replaceAll("/", "").replaceAll("\\\\", "") + this.context.cfg.gs("Comm.attempted.login"));
                    continue;
                }
                if (this.isListed(socket, true)) {
                    this.instance.addConnection(socket);
                    continue;
                }
                socket.close();
                logger.warn(this.context.cfg.gs("Comm.not.whitelisted.ip") + socket.getInetAddress().toString().replaceAll("/", "").replaceAll("\\\\", "") + this.context.cfg.gs("Comm.attempted.login"));
            }
            catch (SocketTimeoutException e) {
            }
            catch (InterruptedIOException e) {
                logger.debug(MessageFormat.format(this.context.cfg.gs("Stty.listener.interrupted.on.port.stop"), this.port) + (this.stop ? "true" : "false"));
                break;
            }
            catch (IOException e) {
                logger.error(Utils.getStackTrace(e));
                this.stop = true;
                this.context.fault = true;
            }
            catch (MungeException e) {
                logger.error(Utils.getStackTrace(e));
                this.stop = true;
                this.context.fault = true;
            }
        }
        if (logger != null) {
            logger.trace(this.context.cfg.gs("Stty.stopping.stty.listener.on") + this.listenSocket.getLocalSocketAddress().toString() + ":" + this.listenSocket.getLocalPort());
        }
        if (this.listenSocket != null && this.listenSocket.isBound()) {
            try {
                this.listenSocket.close();
                this.listenSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

