/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty.hintServer;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintStatus;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Library;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Datastore {
    public List<Hint> hints;
    private transient Context context;
    private transient Library statusLibrary;
    private transient String statusDirectory;
    private transient String statusFullPath;
    private final transient String DATASTORE_NAME = "hint-datastore.json";
    private final transient Logger logger = LogManager.getLogger("applog");
    private final transient Marker SIMPLE = MarkerManager.getMarker("SIMPLE");
    private final transient Marker SHORT = MarkerManager.getMarker("SHORT");

    public Datastore(Context context) {
        this.context = context;
    }

    public synchronized void add(Hint hint) {
        if (this.hints == null) {
            this.hints = new ArrayList<Hint>();
        }
        this.hints.add(hint);
    }

    public synchronized int count(String system) {
        int count = 0;
        if (this.hints != null && this.hints.size() > 0) {
            for (int i = 0; i < this.hints.size(); ++i) {
                HintStatus hs = this.hints.get(i).findStatus(system);
                if (hs != null && !hs.status.toLowerCase().equals("done")) {
                    ++count;
                    continue;
                }
                if (hs != null) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized Hint get(Hint hint, String mode) {
        ArrayList<Hint> list = this.getAll(hint, mode);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            this.logger.warn(MessageFormat.format(this.context.cfg.gs("Stty.datastore.get.singleton.hint.returned.hints"), list.size()));
        }
        return null;
    }

    public synchronized ArrayList<Hint> getAll(Hint hint, String mode) {
        ArrayList<Hint> results = new ArrayList<Hint>();
        if (this.hints != null && this.hints.size() > 0) {
            boolean conflict;
            boolean all = mode.toLowerCase().equals("all");
            boolean exact = mode.toLowerCase().equals("exact");
            boolean full = mode.toLowerCase().equals("full");
            boolean bl = conflict = mode.toLowerCase().equals("conflict");
            if (all) {
                if (this.hints != null) {
                    results.addAll(this.hints);
                }
                return results;
            }
            if (exact || full || conflict) {
                for (int i = 0; i < this.hints.size(); ++i) {
                    Hint entry = this.hints.get(i);
                    if (conflict) {
                        if (hint.fromLibrary != null && hint.fromLibrary.length() > 0 && entry.fromLibrary.compareTo(hint.fromLibrary) != 0 || hint.fromItemPath != null && hint.fromItemPath.length() > 0 && entry.fromItemPath.compareTo(hint.fromItemPath) != 0) continue;
                        results.add(entry);
                        continue;
                    }
                    if (exact && hint.utc != 0L && entry.utc != hint.utc || exact && hint.author != null && hint.author.length() > 0 && entry.author.compareTo(hint.author) != 0 || hint.system != null && hint.system.length() > 0 && entry.system.compareTo(hint.system) != 0 || hint.action != null && hint.action.length() > 0 && entry.action.compareTo(hint.action) != 0 || hint.fromLibrary != null && hint.fromLibrary.length() > 0 && entry.fromLibrary.compareTo(hint.fromLibrary) != 0 || hint.fromItemPath != null && hint.fromItemPath.length() > 0 && entry.fromItemPath.compareTo(hint.fromItemPath) != 0 || hint.toLibrary != null && hint.toLibrary.length() > 0 && entry.toLibrary.compareTo(hint.toLibrary) != 0 || hint.toItemPath != null && hint.toItemPath.length() > 0 && entry.toItemPath.compareTo(hint.toItemPath) != 0) continue;
                    results.add(entry);
                }
            }
        }
        return results;
    }

    public ArrayList<Hint> getFor(String hintSystemName) {
        ArrayList<Hint> results = null;
        if (this.hints != null && this.hints.size() > 0) {
            for (int i = 0; i < this.hints.size(); ++i) {
                Hint hint = this.hints.get(i);
                if (hint.isFor(hintSystemName) < -1) continue;
                if (results == null) {
                    results = new ArrayList<Hint>();
                }
                results.add(hint);
            }
        }
        return results;
    }

    public boolean initialize() throws Exception {
        if (this.context.hintsRepo.getLibraryData() == null || this.context.hintsRepo.getLibraryData().libraries == null || this.context.hintsRepo.getLibraryData().libraries.bibliography == null || this.context.hintsRepo.getLibraryData().libraries.bibliography.length <= 0) {
            throw new MungeException(this.context.cfg.gs("Stty.hint.status.tracker.server.repo.contains.no.library.for.status.datastore"));
        }
        this.statusLibrary = this.context.hintsRepo.getLibraryData().libraries.bibliography[0];
        this.statusDirectory = "";
        if (this.statusLibrary.sources == null || this.statusLibrary.sources.length <= 0) {
            throw new MungeException(this.context.cfg.gs("Stty.hint.status.tracker.server.repo.first.library.contains.no.sources") + this.statusLibrary.name);
        }
        this.statusDirectory = this.statusLibrary.sources[0];
        File dir = new File(Utils.getFullPathLocal(this.statusDirectory));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new MungeException(this.context.cfg.gs("Stty.hint.status.directory.is.not.a.directory") + this.statusDirectory);
            }
            this.logger.info(MessageFormat.format(this.context.cfg.gs("Stty.using.library.source.directory.for.hint.tracking.datastore"), this.statusLibrary.name, dir));
        } else {
            this.logger.info(MessageFormat.format(this.context.cfg.gs("Stty.creating.new.library.source.directory.for.hint.tracking.datastore"), this.statusLibrary.name, dir));
            dir.mkdirs();
        }
        this.context.hintsRepo.scan(this.statusLibrary.name);
        int count = 0;
        if (this.statusLibrary.items != null) {
            count = this.statusLibrary.items.size();
        }
        if (count == 1) {
            Item item = this.statusLibrary.items.get(0);
            this.statusFullPath = item.getFullPath();
            if (!this.read()) {
                return false;
            }
        } else {
            if (count != 0) {
                throw new MungeException(this.context.cfg.gs("Stty.multiple.status.files.are.not.supported.in") + this.statusDirectory);
            }
            this.statusFullPath = this.statusLibrary.sources[0] + System.getProperty("file.separator") + "hint-datastore.json";
        }
        return true;
    }

    private synchronized void normalize() {
        this.sort("utc");
    }

    public boolean read() throws Exception {
        boolean valid = false;
        try {
            File ds;
            Object path = this.statusFullPath;
            if (Utils.isRelativePath((String)path)) {
                path = this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + (String)path;
            }
            Gson gson = new Gson();
            this.logger.info(this.context.cfg.gs("Stty.reading.hint.datastore") + (String)path);
            if (Utils.isRelativePath((String)path)) {
                path = this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + (String)path;
            }
            String json = (ds = new File((String)path)).exists() ? new String(Files.readAllBytes(Paths.get((String)path, new String[0]))) : "[]";
            Type listType = new TypeToken<ArrayList<Hint>>(){}.getType();
            this.hints = (List)gson.fromJson(json, listType);
            if (this.hints != null) {
                this.normalize();
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Stty.read.successfully.hints"), path, this.hints.size()));
                valid = true;
            } else {
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Stty.read.content.is.empty"), path));
            }
        }
        catch (IOException ioe) {
            String msg = this.context.cfg.gs("Stty.exception.while.reading.hint.datastore") + ioe.toString();
            if (this.context.main.isStartupActive()) {
                this.logger.error(msg);
                int opt = JOptionPane.showConfirmDialog(this.context.guiLogAppender.getStartup(), "<html><body>" + msg + "<br/><br/>Continue?</body></html>", this.context.cfg.getNavigatorName(), 0);
                if (opt == 0) {
                    this.context.fault = false;
                    return false;
                }
            }
            throw new MungeException(msg);
        }
        return valid;
    }

    public boolean reload() throws Exception {
        return this.read();
    }

    public void sort(String element) {
        switch (element.toLowerCase()) {
            case "utc": {
                Collections.sort(this.hints, Datastore.sortByUtc());
            }
        }
    }

    public static synchronized Comparator<Hint> sortByUtc() {
        Comparator<Hint> comp = new Comparator<Hint>(){

            @Override
            public int compare(Hint hint1, Hint hint2) {
                return hint1.utc < hint2.utc ? -1 : (hint1.utc > hint2.utc ? 1 : 0);
            }
        };
        return comp;
    }

    public void write() throws Exception {
        String path = Utils.getFullPathLocal(this.statusFullPath);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this.hints);
        try {
            PrintWriter outputStream = new PrintWriter(path);
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.context.cfg.gs("Z.error.writing") + path + ": " + Utils.getStackTrace(fnf));
        }
    }
}

