/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty.publisher;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Transfer;
import com.corionis.els.Utils;
import com.corionis.els.hints.HintKey;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Repository;
import com.corionis.els.sftp.ClientSftp;
import com.corionis.els.stty.AbstractDaemon;
import com.corionis.els.stty.ClientStty;
import com.corionis.els.stty.ServeStty;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Daemon
extends AbstractDaemon {
    protected static Logger logger = LogManager.getLogger("applog");
    private boolean fault = false;
    private boolean isTerminal = false;
    private Transfer transfer;
    private ServeStty instance = null;

    public Daemon(ServeStty instance, Context context, Repository mine, Repository theirs) {
        super(context, mine, theirs);
        this.instance = instance;
    }

    public synchronized String dumpStatistics() {
        String data = this.context.cfg.gs("Stty.r.nconsole.currently.connected") + (this.connected ? "true" : "false") + "\r\n";
        data = data + this.context.cfg.gs("Stty.connected.on.port") + this.port + "\r\n";
        data = data + this.context.cfg.gs("Stty.connected.to.address") + String.valueOf(this.address) + "\r\n";
        return data;
    }

    @Override
    public String handshake() {
        String system = "";
        try {
            logger.trace(this.context.cfg.gs("Stty.publisher.listener.handshake"));
            this.send("HELO", "");
            String input = this.receive("", 5000);
            if (input != null && (input.equals("DribNit") || input.equals("DribNlt"))) {
                this.isTerminal = input.equals("DribNit");
                if (this.isTerminal && this.myRepo.getLibraryData().libraries.terminal_allowed != null && !this.myRepo.getLibraryData().libraries.terminal_allowed.booleanValue()) {
                    this.send("Terminal session not allowed", "");
                    logger.warn(this.context.cfg.gs("Stty.attempt.to.login.interactively.but.terminal.sessions.are.not.allowed"));
                    return system;
                }
                this.send(this.myKey, "");
                input = this.receive("", 5000);
                if (this.context.authKeys != null) {
                    HintKey connectedKey = this.context.authKeys.findKey(input);
                    if (connectedKey != null) {
                        this.send(this.myRepo.getLibraryData().libraries.flavor, "");
                        system = connectedKey.system;
                        logger.info(MessageFormat.format(this.context.cfg.gs("Stty.server.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + system);
                        this.context.fault = false;
                        this.context.timeout = false;
                    }
                } else if (this.theirRepo != null && input.equals(this.theirRepo.getLibraryData().libraries.key)) {
                    this.send(this.myRepo.getLibraryData().libraries.flavor, "");
                    system = this.theirRepo.getLibraryData().libraries.description;
                    logger.info(MessageFormat.format(this.context.cfg.gs("Stty.server.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + system);
                    this.context.fault = false;
                    this.context.timeout = false;
                }
            }
        }
        catch (Exception e) {
            this.fault = true;
            logger.error(e.getMessage());
        }
        return system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int process() throws Exception, IOException {
        block75: {
            block82: {
                block81: {
                    block78: {
                        block79: {
                            block76: {
                                block77: {
                                    block80: {
                                        attempts = 0;
                                        commandCount = 0;
                                        prompt = basePrompt = ": ";
                                        trace = this.context.cfg.getDebugLevel().trim().equalsIgnoreCase("trace") != false;
                                        this.port = this.getSocket().getPort();
                                        this.address = this.getSocket().getInetAddress();
                                        totalSize = 0L;
                                        group = new ArrayList<Item>();
                                        this.context.transfer = new Transfer(this.context);
                                        this.getSocket().setKeepAlive(true);
                                        this.getSocket().setSoTimeout(this.myRepo.getLibraryData().libraries.timeout * 60 * 1000);
                                        this.getSocket().setSoLinger(true, 10000);
                                        this.in = new DataInputStream(this.getSocket().getInputStream());
                                        this.out = new DataOutputStream(this.getSocket().getOutputStream());
                                        this.connected = true;
                                        system = this.handshake();
                                        if (system.length() != 0) break block80;
                                        if (!this.context.cfg.isKeepGoing()) {
                                            this.status = 1;
                                        }
                                        Daemon.logger.error(MessageFormat.format(this.context.cfg.gs("Stty.connection.to.failed.handshake"), new Object[]{Utils.formatAddresses(this.socket)}));
                                        break block75;
                                    }
                                    if (this.isTerminal) {
                                        this.response = this.context.cfg.gs("Stty.enter.help.for.information.r.n");
                                    } else {
                                        this.createHeartBeat();
                                        this.response = "CMD";
                                        if (this.context.cfg.isForceCollection()) {
                                            this.response = this.response + ":RequestCollection";
                                        }
                                        if (this.context.cfg.isForceTargets()) {
                                            this.response = this.response + ":RequestTargets";
                                        }
                                    }
                                    while (this.status == 0) {
                                        try {
                                            if (this.context.fault || this.context.timeout) {
                                                this.fault = true;
                                                this.status = 1;
                                                Daemon.logger.warn(this.context.cfg.gs("Stty.process.fault.ending.stty"));
                                                break block75;
                                            }
                                            this.send(this.response + (this.isTerminal != false ? prompt : ""), (String)(trace != false ? "writing response " + this.response.length() + " bytes to " + system : ""));
                                            this.response = "";
                                            line = this.receive(trace != false ? "Reading command" : "", -1);
                                            if (line == null) {
                                                if (!this.context.cfg.isKeepGoing()) {
                                                    this.fault = true;
                                                    this.status = 2;
                                                    Daemon.logger.warn(this.context.cfg.gs("Stty.eof.line.process.ended.prematurely"));
                                                    break block75;
                                                } else {
                                                    Daemon.logger.info(this.context.cfg.gs("Stty.eof.line.listener.keep.going.enabled"));
                                                }
                                                break block75;
                                            }
                                            if ((line = line.trim()).length() < 1) {
                                                this.response = "\r";
                                                continue;
                                            }
                                            ++commandCount;
                                            Daemon.logger.info(MessageFormat.format(this.context.cfg.gs("Stty.processing.command.from"), new Object[]{line}) + system);
                                            t = new StringTokenizer(line, "\"");
                                            if (!t.hasMoreTokens()) continue;
                                            theCommand = t.nextToken().trim();
                                            if (theCommand.equalsIgnoreCase("auth")) {
                                                ++attempts;
                                                pw = "";
                                                if (t.hasMoreTokens()) {
                                                    pw = t.nextToken();
                                                }
                                                if (this.context.cfg.getAuthorizedPassword().equals(pw.trim())) {
                                                    this.response = "password accepted\r\n";
                                                    this.authorized = true;
                                                    prompt = "$ ";
                                                    Daemon.logger.info("Command auth accepted");
                                                    continue;
                                                }
                                                Daemon.logger.warn("auth password attempt failed using: " + pw);
                                                if (attempts < 3) continue;
                                                Daemon.logger.error("Too many authentication failures, disconnecting");
                                                break block75;
                                            }
                                            if (theCommand.equalsIgnoreCase("logout")) {
                                                if (this.authorized) {
                                                    this.authorized = false;
                                                    prompt = basePrompt;
                                                    continue;
                                                }
                                                theCommand = this.context.cfg.isKeepGoing() != false ? "bye" : "quit";
                                            }
                                            if (theCommand.equalsIgnoreCase("bye")) {
                                                this.out.flush();
                                                Thread.sleep(1500L);
                                                break block75;
                                            }
                                            if (theCommand.equalsIgnoreCase("collection")) {
                                                try {
                                                    location = Utils.scrubFilename(this.myRepo.getLibraryData().libraries.description).replaceAll(" ", "");
                                                    location = Utils.getStampedFilename(this.myRepo, (String)location + "_collection-generated");
                                                    location = Utils.getTemporaryFilePrefix(this.myRepo, (String)location) + ".json";
                                                    this.context.cfg.setExportCollectionFilename((String)location);
                                                    var16_24 = this.myRepo.getLibraryData().libraries.bibliography;
                                                    var17_29 = var16_24.length;
                                                    for (var18_32 = 0; var18_32 < var17_29; ++var18_32) {
                                                        subLib = var16_24[var18_32];
                                                        if (!(this.context.cfg.isSpecificLibrary() && !this.context.cfg.isSelectedLibrary(subLib.name) || this.context.cfg.isSpecificExclude() && this.context.cfg.isExcludedLibrary(subLib.name))) {
                                                            if (subLib.items != null) {
                                                                subLib.items = null;
                                                            }
                                                            this.myRepo.scan(subLib.name);
                                                            continue;
                                                        }
                                                        Daemon.logger.info(this.context.cfg.gs("Stty.skipping.publisher.library") + subLib.name);
                                                        subLib.name = "ELS-SUBSCRIBER-SKIP_" + subLib.name;
                                                    }
                                                    this.myRepo.exportItems(true);
                                                    Thread.sleep(2500L);
                                                    jsonPath = Paths.get(Utils.getFullPathLocal(this.context.cfg.getExportCollectionFilename()), new String[0]);
                                                    this.response = new String(Files.readAllBytes(jsonPath));
                                                    continue;
                                                }
                                                catch (MungeException e) {
                                                    Daemon.logger.error(e.getMessage());
                                                    continue;
                                                }
                                            }
                                            if (theCommand.equalsIgnoreCase("directory")) {
                                                this.response = this.context.cfg.getWorkingDirectory();
                                                continue;
                                            }
                                            if (theCommand.equalsIgnoreCase("fault")) {
                                                this.fault = true;
                                                this.status = 1;
                                                if (!this.context.timeout) {
                                                    this.send("End-Execution", trace != false ? "send End-Execution" : "");
                                                }
                                                Thread.sleep(1500L);
                                            }
                                            if (theCommand.equalsIgnoreCase("find")) {
                                                if (!this.authorized) {
                                                    this.response = "not authorized\r\n";
                                                    continue;
                                                }
                                                if (!t.hasMoreTokens()) break block76;
                                                find = this.remainingTokens(t);
                                                find = find.toLowerCase();
                                                Daemon.logger.info("find: " + find);
                                                jsonPath = this.myRepo.getLibraryData().libraries.bibliography;
                                                var17_30 = jsonPath.length;
                                                break block77;
                                            }
                                            if (theCommand.equalsIgnoreCase("get")) {
                                                if (!this.authorized) {
                                                    this.response = "not authorized\r\n";
                                                    continue;
                                                }
                                                found = false;
                                                if (!t.hasMoreTokens()) break block78;
                                                find = this.remainingTokens(t);
                                                find = find.toLowerCase();
                                                Daemon.logger.info("get: " + find);
                                                var17_31 = this.myRepo.getLibraryData().libraries.bibliography;
                                                var18_32 = var17_31.length;
                                                break block79;
                                            }
                                            if (theCommand.equalsIgnoreCase("quit") || theCommand.equalsIgnoreCase("exit")) {
                                                this.out.flush();
                                                Thread.sleep(1500L);
                                                if (this.context.cfg.isKeepGoing()) {
                                                    Daemon.logger.info(this.context.cfg.gs("Stty.ignoring.quit.command.listener.keep.going.enabled"));
                                                    break block75;
                                                } else {
                                                    this.status = 1;
                                                }
                                                break block75;
                                            }
                                            if (theCommand.equalsIgnoreCase("space")) {
                                                location = "";
                                                if (t.hasMoreTokens()) {
                                                    location = t.nextToken();
                                                    space = Utils.availableSpace(Utils.getFullPathLocal(location));
                                                    Daemon.logger.info("  space: " + Utils.formatLong(space, true, this.context.cfg.getLongScale()) + " at " + location);
                                                    if (this.isTerminal) {
                                                        this.response = Utils.formatLong(space, true, this.context.cfg.getLongScale());
                                                        continue;
                                                    }
                                                    this.response = String.valueOf(space);
                                                    continue;
                                                }
                                                this.response = this.isTerminal != false ? "space command requires a location\r\n" : "0";
                                                continue;
                                            }
                                            if (theCommand.equalsIgnoreCase("status")) {
                                                if (!this.authorized) {
                                                    this.response = "not authorized\r\n";
                                                    continue;
                                                }
                                                this.response = this.instance.dumpStatistics();
                                                this.response = this.response + this.dumpStatistics();
                                                continue;
                                            }
                                            if (theCommand.equalsIgnoreCase("stop")) {
                                                this.send("End-Execution", trace != false ? "send End-Execution" : "");
                                                Thread.sleep(1500L);
                                                this.status = 2;
                                                break block75;
                                            }
                                            if (theCommand.equalsIgnoreCase("targets")) {
                                                try {
                                                    if (this.context.cfg.getTargetsFilename().length() > 0) {
                                                        this.response = new String(Files.readAllBytes(Paths.get(this.context.cfg.getTargetsFilename(), new String[0])));
                                                        continue;
                                                    }
                                                    this.response = "";
                                                    continue;
                                                }
                                                catch (Exception e) {
                                                    Daemon.logger.error(e.getMessage());
                                                    continue;
                                                }
                                            }
                                            if (theCommand.equalsIgnoreCase("help") || theCommand.equals("?")) {
                                                this.response = "\r\nAvailable commands, not case sensitive:\r\n";
                                                if (this.authorized) {
                                                    this.response = this.response + "  find \"[text]\" = search collection for all matching text, use collection command to refresh\r\n  get \"[text]\" = like find but offers the option to get/copy the listed items in overwrite mode\r\n  status = server and console status information\r\n\r\n And:\r\n";
                                                }
                                                this.response = this.response + "  auth \"password\" = access Authorized commands, enclose password in quotes\r\n  collection = get collection data from remote, can take a few moments to scan\r\n  space \"[location]\" = free space at location on remote\r\n  targets = get targets file from remote\r\n\r\n  help or ? = this list\r\n  logout = exit current level\r\n  bye = disconnect and leave remote end running\r\n  quit, exit = disconnect and quit remote end\r\n\r\n";
                                                continue;
                                            }
                                            this.response = "\r\nunknown command '" + theCommand + "', use 'help' for information\r\n";
                                        }
                                        catch (SocketTimeoutException toe) {
                                            this.context.timeout = true;
                                            this.connected = false;
                                            Daemon.logger.error(this.context.cfg.gs("Stty.sockettimeoutexception") + Utils.getStackTrace(toe));
                                            if (!this.context.cfg.isKeepGoing()) {
                                                this.fault = true;
                                                this.status = 1;
                                                break block75;
                                            } else {
                                                Daemon.logger.info(this.context.cfg.gs("Stty.ignoring.exception.listener.keep.going.enabled"));
                                            }
                                            break block75;
                                        }
                                        catch (SocketException se) {
                                            if (se.toString().contains("timed out")) {
                                                this.context.timeout = true;
                                            }
                                            this.fault = true;
                                            this.connected = false;
                                            this.status = 1;
                                            Daemon.logger.debug(this.context.cfg.gs("Stty.socketexception.timeout.is") + this.context.timeout);
                                            Daemon.logger.error(Utils.getStackTrace(se));
                                            break block75;
                                        }
                                        catch (Exception e) {
                                            this.fault = true;
                                            this.connected = false;
                                            this.status = 1;
                                            Daemon.logger.error(Utils.getStackTrace(e));
                                            try {
                                                if (!this.context.timeout) {
                                                    this.send(e.getMessage(), "Publisher exception");
                                                    Thread.sleep(1500L);
                                                }
                                                break block75;
                                            }
                                            catch (Exception var14_16) {
                                                // empty catch block
                                            }
                                            break block75;
                                        }
                                    }
                                    break block75;
                                    finally {
                                        this.stopHeartBeat();
                                    }
                                }
                                for (var18_32 = 0; var18_32 < var17_30; ++var18_32) {
                                    subLib = jsonPath[var18_32];
                                    titled = false;
                                    if (subLib.items == null) {
                                        this.myRepo.scan(subLib.name);
                                    }
                                    for (Item item : subLib.items) {
                                        if (!item.getItemPath().toLowerCase().contains(find)) continue;
                                        if (!titled) {
                                            this.response = this.response + "  In library: " + subLib.name + "\r\n";
                                            titled = true;
                                        }
                                        this.response = this.response + "    " + item.getItemPath() + "\r\n";
                                    }
                                }
                            }
                            if (this.response.length() >= 1) ** GOTO lbl-1000
                            this.response = "No results found, try collection command if refresh is needed\r\n";
                            ** GOTO lbl-1000
                        }
                        for (var19_35 = 0; var19_35 < var18_32; ++var19_35) {
                            subLib = var17_31[var19_35];
                            titled = false;
                            if (subLib.items == null) {
                                this.myRepo.scan(subLib.name);
                            }
                            for (Item item : subLib.items) {
                                if (this.myRepo.ignore(item)) {
                                    this.response = this.response + "  ! Ignoring '" + item.getItemPath() + "'\r\n";
                                    continue;
                                }
                                if (!item.getItemPath().toLowerCase().contains(find) || item.isDirectory()) continue;
                                if (!titled) {
                                    this.response = this.response + "  In library: " + subLib.name + "\r\n";
                                    titled = true;
                                }
                                this.response = this.response + "    " + item.getItemPath() + "\r\n";
                                if (item.getSize() < 0L) {
                                    Daemon.logger.warn(this.context.cfg.gs("Stty.file.size.was.0.during.get.command.getting"));
                                    size = Files.size(Paths.get(item.getFullPath(), new String[0]));
                                    item.setSize(size);
                                    totalSize += size;
                                } else {
                                    totalSize += item.getSize();
                                }
                                group.add(item);
                                found = true;
                            }
                        }
                    }
                    if (found) break block81;
                    this.response = this.response + "No results found, try collection command if refresh is needed\r\n";
                    ** GOTO lbl-1000
                }
                this.response = this.response + "  Total size: ";
                this.response = this.response + Utils.formatLong(totalSize, true, this.context.cfg.getLongScale()) + "\r\n";
                this.response = this.response + "Copy listed items (y/N)? ";
                this.send(this.response, "");
                line = this.receive("", -1);
                if (line == null) {
                    Daemon.logger.info("EOF line");
                    this.status = 1;
                    break block75;
                }
                if (!line.equalsIgnoreCase("Y")) break block82;
                if (this.context.clientStty == null) {
                    this.context.clientSftp = new ClientSftp(this.context, this.myRepo, this.theirRepo, false);
                    if (!this.context.clientSftp.startClient("transfer")) {
                        throw new MungeException(this.context.cfg.gs("Stty.publisher.sftp.transfer.client.failed.to.connect"));
                    }
                    this.context.clientStty = new ClientStty(this.context, false, false, false);
                    if (!this.context.clientStty.connect(this.myRepo, this.theirRepo)) {
                        throw new MungeException(this.context.cfg.gs("Stty.publisher.sftp.transfer.client.failed.to.connect"));
                    }
                    if (this.context.clientStty.checkBannerCommands()) {
                        Daemon.logger.info(this.context.cfg.gs("Transfer.received.subscriber.commands") + (this.context.cfg.isRequestCollection() != false ? "RequestCollection " : "") + (this.context.cfg.isRequestTargets() != false ? "RequestTargets" : ""));
                    }
                    directory = this.context.clientStty.getWorkingDirectoryRemote();
                    this.context.cfg.setWorkingDirectorySubscriber(directory);
                }
                this.response = this.transfer.copyGroup(group, totalSize, true, null, null, null, null);
                group.clear();
                ** GOTO lbl-1000
            }
            this.response = "skipping get of items\r\n";
            ** GOTO lbl-1000
        }
        if (this.fault) {
            this.context.fault = true;
        }
        statMsg = this.status == 0 ? "Success" : (this.status == 1 ? "Quit" : "Stop");
        Daemon.logger.trace(MessageFormat.format(this.context.cfg.gs("Stty.server.session.done.status.fault"), new Object[]{statMsg}) + this.context.fault);
        return this.status;
    }

    public String remainingTokens(StringTokenizer t) {
        Object result = "";
        while (t.hasMoreTokens()) {
            result = (String)result + t.nextToken() + " ";
        }
        return ((String)result).trim();
    }

    @Override
    public void requestStop() {
        this.status = 1;
        logger.debug(this.context.cfg.gs("Stty.requesting.stop.for.stty.session") + Utils.formatAddresses(this.socket) + ":" + this.socket.getPort());
    }
}

