/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Task;
import java.io.Serializable;

public abstract class AbstractTool
implements Comparable,
Serializable {
    protected transient Context context;
    protected transient boolean dataHasChanged = false;
    protected transient String displayName;
    protected transient boolean isRemote;
    protected transient boolean stop = false;

    private AbstractTool() {
    }

    public AbstractTool(Context context) {
        this.context = context;
        this.dataHasChanged = false;
    }

    public abstract Object clone();

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public Configuration getCfg() {
        return this.context.cfg;
    }

    public abstract String getConfigName();

    public Context getContext() {
        return this.context;
    }

    public String getDirectoryPath() {
        String path = System.getProperty("user.dir") + System.getProperty("file.separator") + (String)(this.getSubsystem().length() > 0 ? this.getSubsystem() + System.getProperty("file.separator") : "") + this.getInternalName();
        return path;
    }

    public abstract String getDisplayName();

    public String getListName() {
        return this.getDisplayName() + ": " + this.getConfigName();
    }

    public String getFullPath() {
        String path = this.getDirectoryPath() + System.getProperty("file.separator") + Utils.scrubFilename(this.getConfigName()) + ".json";
        return path;
    }

    public abstract String getInternalName();

    public abstract String getSubsystem();

    public abstract boolean isDataChanged();

    public boolean isRemote() {
        return this.isRemote;
    }

    public boolean isRequestStop() {
        return this.stop;
    }

    public boolean isToolCachedOrigins() {
        return false;
    }

    public boolean isToolHintServer() {
        return false;
    }

    public boolean isToolOriginsUsed() {
        return false;
    }

    public boolean isToolPubOrSub() {
        return false;
    }

    public boolean isToolPublisher() {
        return true;
    }

    public boolean isToolSubscriber() {
        return true;
    }

    public abstract void processTool(Task var1) throws Exception;

    public void requestStop() {
        this.stop = true;
    }

    public void resetStop() {
        this.stop = false;
    }

    public abstract void setConfigName(String var1);

    public void setContext(Context context) {
        this.context = context;
    }

    public void setDataHasChanged() {
        this.dataHasChanged = true;
    }

    public void setDataHasChanged(boolean state) {
        this.dataHasChanged = state;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setRemote(boolean remote) {
        this.isRemote = remote;
    }

    public String toString() {
        return this.getConfigName();
    }
}

