/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.email;

import com.corionis.els.Context;
import com.corionis.els.Persistent;
import com.corionis.els.Utils;
import com.corionis.els.gui.tools.email.EmailUI;
import com.corionis.els.repository.Libraries;
import com.corionis.els.tools.email.EmailTool;
import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.List;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmailHandler
extends Thread {
    private final String GOOGLE_CLIENT_ID = "863161091698-hj38ceukvile50k4qruj0p6mdjith5l8.apps.googleusercontent.com";
    private final String OUTLOOK_CLIENT_ID = "28d6da7f-9a7c-4cea-aea5-73b9c59c7a15";
    private final int OUTLOOK_FIXED_PORT = 60271;
    private final String ZOHO_CLIENT_ID = "1000.88UA8YCET6S12R7Y9U6KKS2EFMOJQZ";
    private final int ZOHO_FIXED_PORT = 60271;
    private final Logger logger = LogManager.getLogger("applog");
    private String api_domain = "";
    private String attachment = null;
    private String authToken;
    private String codeVerifier;
    private String codeChallenge;
    private final Context context;
    private EmailUI emailUi = null;
    private String error = "";
    private boolean expired = false;
    private boolean fault = false;
    private Function function = null;
    private HttpExchange httpExchange = null;
    private int httpPort = -1;
    private String location = null;
    private boolean nothingToDo = false;
    private String now;
    private Map<String, List> parameters = null;
    private String response = "";
    private boolean responseCompleted = false;
    private String scope = null;
    private HttpServer server = null;
    private int stateInt;
    private boolean stop = false;
    private boolean success = false;
    private boolean timeout = false;
    private EmailTool tool = null;
    private boolean workerRunning = false;

    public EmailHandler(Context context, EmailUI emailUi, EmailTool tool, Function function) {
        this.context = context;
        this.emailUi = emailUi;
        this.tool = tool;
        this.function = function;
    }

    private void authenticate() {
        this.fault = false;
        this.success = false;
        this.timeout = false;
        this.startHttpServer();
        if (!this.fault) {
            this.generatePKCE();
            if (!this.fault) {
                this.authenticateUser();
                if (!(this.fault || this.stop || this.timeout)) {
                    this.requestAccessAndRefreshTokens();
                    if (!(this.fault || this.stop || this.timeout)) {
                        this.writeServerResponse();
                    }
                }
            }
        }
        this.emailUi.setCursor(Cursor.getPredefinedCursor(0));
        if (this.fault) {
            String msg = this.context.cfg.gs("EmailUI.authentication.error") + this.error;
            this.logger.error(msg);
            if (this.emailUi != null) {
                this.emailUi.labelStatus.setText(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogEmail, msg, this.context.cfg.gs("EmailUI.title"), 0);
            }
            this.fault = false;
            this.success = false;
            this.timeout = false;
        } else if (this.timeout) {
            String msg = this.context.cfg.gs("EmailUI.authentication.timeout");
            this.logger.error(msg);
            this.emailUi.labelStatus.setText(msg);
            JOptionPane.showMessageDialog(this.context.navigator.dialogEmail, msg, this.context.cfg.gs("EmailUI.title"), 0);
        } else if (!this.stop) {
            this.success = true;
            try {
                this.tool.write();
            }
            catch (Exception e) {
                this.logger.error(Utils.getStackTrace(e));
                JOptionPane.showMessageDialog(this.context.navigator.dialogEmail, e.getMessage(), this.context.cfg.gs("EmailUI.title"), 0);
            }
            this.emailUi.labelStatus.setText(this.context.cfg.gs("EmailUI.authentication.success"));
        }
        this.requestStop();
        if (this.workerRunning) {
            this.stopHttpServer();
        }
        this.emailUi.updateControls();
        this.emailUi.buttonAuth.setText(this.context.cfg.gs("EmailUI.buttonAuth.text"));
        this.emailUi.buttonAuth.setToolTipText(this.context.cfg.gs("EmailUI.buttonAuth.toolTipText"));
    }

    private void authenticateUser() {
        try {
            this.stateInt = ThreadLocalRandom.current().nextInt(10000, 99999);
            URI uri = null;
            switch (this.tool.getProfile()) {
                case "Apple": {
                    break;
                }
                case "GMail": {
                    uri = new URI("https://accounts.google.com/o/oauth2/v2/auth?client_id=863161091698-hj38ceukvile50k4qruj0p6mdjith5l8.apps.googleusercontent.com&response_type=code&redirect_uri=http://127.0.0.1:" + this.httpPort + "&code_challenge_method=S256&code_challenge=" + this.codeChallenge + "&scope=email&state=" + this.stateInt + "&login_hint=" + this.tool.getUsername());
                    break;
                }
                case "Outlook": {
                    uri = new URI("https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize?client_id=28d6da7f-9a7c-4cea-aea5-73b9c59c7a15&response_type=code&redirect_uri=http://127.0.0.1:60271&scope=offline_access%20openid%20Mail.Send%20SMTP.Send&state=" + this.stateInt + "&code_challenge_method=S256&code_challenge=" + this.codeChallenge + "&login_hint=" + this.tool.getUsername());
                    break;
                }
                case "SMTP": {
                    break;
                }
                case "Zoho": {
                    uri = new URI("https://accounts.zoho.com/oauth/v2/auth?client_id=1000.88UA8YCET6S12R7Y9U6KKS2EFMOJQZ&response_type=code&redirect_uri=http://127.0.0.1:60271&scope=ZohoMail.messages.CREATE&code_challenge_method=S256&code_challenge=" + this.codeChallenge + "&access_type=offline");
                }
            }
            assert (uri != null);
            Desktop.getDesktop().browse(uri);
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            this.error = e.getMessage();
            this.fault = true;
        }
        if (!(this.fault || this.stop || this.timeout)) {
            this.readServerResponse(600000);
            if (!(this.fault || this.stop || this.timeout)) {
                this.parameters = this.parseResponse();
            }
        }
    }

    private String buildOAuth2Token(String email, String accessToken) {
        CallSite authString = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"user=\u0001\u0002\u0001\u0002", "\u0001auth=Bearer ", "\u0001\u0001"}, (String)email, accessToken);
        return Base64.getEncoder().encodeToString(((String)((Object)authString)).getBytes());
    }

    private void email() {
        String msg;
        this.fault = false;
        this.success = false;
        this.timeout = false;
        this.emailConnect();
        if (this.emailUi != null) {
            this.emailUi.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.fault) {
            msg = this.error;
            this.logger.error(msg);
        } else if (this.timeout) {
            msg = this.context.cfg.gs("EmailUI.authentication.timeout");
            this.logger.error(msg);
        } else if (this.expired) {
            msg = MessageFormat.format(this.context.cfg.gs("EmailHandler.the.access.and.refresh.tokens.have.expired.for"), this.tool.getUsername());
            this.logger.error(msg);
            msg = this.context.cfg.gs("EmailHandler.the.access.and.refresh.tokens.have.expired");
            if (this.emailUi != null) {
                JOptionPane.showMessageDialog(this.emailUi, msg, this.context.cfg.gs("Email.title"), 2);
            }
        } else if (this.success) {
            msg = this.context.cfg.gs(this.context.cfg.gs("EmailHandler.email.sent.successfully"));
            this.logger.debug(msg);
        } else if (this.nothingToDo) {
            msg = this.context.cfg.gs("EmailHandler.email.nothing.to.do");
        } else {
            msg = this.context.cfg.gs(this.context.cfg.gs("EmailHandler.email.send.failed") + this.error);
            this.logger.error(msg);
        }
        if (this.emailUi != null) {
            this.emailUi.labelStatus.setText(msg);
            this.emailUi.labelStatus.updateUI();
            this.emailUi.updateControls();
            this.emailUi.buttonTest.setText(this.context.cfg.gs("EmailUI.buttonTest.text"));
            this.emailUi.buttonTest.setToolTipText(this.context.cfg.gs("EmailUI.buttonTest.toolTipText"));
        }
    }

    private void emailConnect() {
        try {
            ArrayList<Recipient> recipients = this.fetchRecipients();
            if (recipients.isEmpty()) {
                this.nothingToDo = true;
                return;
            }
            if (this.tool.getAuthMethod().equalsIgnoreCase("oauth2") && this.tool.isExpired(this.tool.getAccessExpires())) {
                if (this.tool.isExpired(this.tool.getRefreshExpires())) {
                    this.expired = true;
                    this.error = this.context.cfg.gs("EmailHandler.tokens.expired.for") + this.tool.getUsername();
                    return;
                }
                this.refreshAccessToken();
                if (this.fault || this.timeout || this.stop) {
                    return;
                }
            }
            this.expired = false;
            Properties props = new Properties();
            props.put("mail.smtp.host", this.tool.getServer());
            props.put("mail.smtp.port", this.tool.getPort());
            if (this.tool.getAuthMethod().equalsIgnoreCase("oauth2") && !this.tool.getProfile().equalsIgnoreCase("smtp")) {
                if (!this.tool.getProfile().equalsIgnoreCase("apple")) {
                    if (this.tool.getProfile().equalsIgnoreCase("gmail")) {
                        props.put("mail.smtp.user", this.tool.getUsername());
                        props.put("mail.smtp.password", this.tool.getAccessToken());
                        props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                        props.put("mail.smtp.auth", "true");
                        props.put("mail.smtp.starttls.enable", "true");
                        props.put("mail.smtp.sasl.enable", "true");
                        props.put("mail.smtp.sasl.mechanisms", "XOAUTH2");
                        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
                        props.put("mail.smtp.auth.login.disable", "true");
                        props.put("mail.smtp.auth.plain.disable", "true");
                        props.put("mail.smtp.auth.xoauth2.disable", "false");
                    } else if (this.tool.getProfile().equalsIgnoreCase("outlook")) {
                        props.put("mail.smtp.user", this.tool.getUsername());
                        props.put("mail.smtp.password", this.tool.getAccessToken());
                        props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                        props.put("mail.smtp.auth", "true");
                        props.put("mail.smtp.starttls.enable", "true");
                        props.put("mail.smtp.sasl.enable", "true");
                        props.put("mail.smtp.sasl.mechanisms", "XOAUTH2");
                        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
                        props.put("mail.smtp.auth.login.disable", "true");
                        props.put("mail.smtp.auth.plain.disable", "true");
                        props.put("mail.smtp.auth.xoauth2.disable", "false");
                    } else if (this.tool.getProfile().equalsIgnoreCase("zoho")) {
                        props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                        props.put("mail.smtp.auth", "true");
                        props.put("mail.smtp.starttls.enable", "true");
                        props.put("mail.smtp.auth.login.disable", "true");
                        props.put("mail.smtp.auth.plain.disable", "true");
                        props.put("mail.smtp.auth.xoauth2.disable", "false");
                    }
                }
            } else {
                if (this.tool.getSecurity().equalsIgnoreCase("starttls")) {
                    props.put("mail.smtp.auth", "true");
                    props.put("mail.smtp.auth.mechanisms", "LOGIN");
                    props.put("mail.smtp.starttls.enable", "true");
                    props.put("mail.smtp.auth.plain.disable", "true");
                } else if (this.tool.getSecurity().equalsIgnoreCase("ssl/tls")) {
                    props.put("mail.smtp.auth", "true");
                    props.put("mail.smtp.ssl.enable", "true");
                    props.put("mail.smtp.ssl.protocols", "TLSv1.2");
                } else if (this.tool.getSecurity().equalsIgnoreCase("none")) {
                    // empty if block
                }
                if (this.tool.getAuthMethod().equalsIgnoreCase("plain")) {
                    props.put("mail.smtp.auth.login.disable", "true");
                } else {
                    props.put("mail.smtp.auth.plain.disable", "true");
                }
            }
            props.put("mail.smtp.connectiontimeout", (Object)15000);
            if (this.context.cfg.getDebugLevel().trim().equalsIgnoreCase("trace")) {
                props.put("mail.debug", "true");
                props.put("mail.debug.auth", "true");
            }
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (EmailHandler.this.tool.getAuthMethod().equalsIgnoreCase("oauth2")) {
                        return new PasswordAuthentication(EmailHandler.this.tool.getUsername(), EmailHandler.this.tool.getAccessToken());
                    }
                    return new PasswordAuthentication(EmailHandler.this.tool.getUsername(), EmailHandler.this.tool.getPassword());
                }
            };
            Session session = Session.getInstance(props, authenticator);
            if (this.context.cfg.getDebugLevel().trim().equalsIgnoreCase("trace")) {
                session.setDebug(true);
            }
            Transport transport = session.getTransport("smtp");
            transport.connect(this.tool.getServer(), this.tool.getUsername(), this.tool.getPassword());
            for (Recipient recipient : recipients) {
                if (this.function == Function.SEND) {
                    if (!recipient.mismatches && !recipient.whatsNew) continue;
                    if (recipient.mismatches && this.context.cfg.getMismatchFilename().length() > 0) {
                        this.emailSend(session, transport, recipient, true);
                    }
                    if (!recipient.whatsNew || this.context.cfg.getWhatsNewFilename().length() <= 0) continue;
                    this.emailSend(session, transport, recipient, false);
                    continue;
                }
                this.emailSend(session, transport, recipient, false);
            }
            transport.close();
        }
        catch (Exception e) {
            this.error = e.getMessage();
            this.logger.error(Utils.getStackTrace(e));
            this.fault = true;
        }
        if (this.fault) {
            String msg = this.context.cfg.gs("EmailUI.email.send.error") + this.error;
            if (this.emailUi != null) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(this.context.navigator.dialogEmail, msg, this.context.cfg.gs("EmailUI.title"), 0);
            }
            this.fault = false;
        } else {
            this.success = true;
        }
    }

    private void emailSend(Session session, Transport transport, Recipient recipient, boolean isMisMatches) throws Exception {
        MimeMessage message = new MimeMessage(session);
        ((Message)message).setFrom(new InternetAddress(this.tool.getUsername()));
        ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(recipient.address));
        Object ends = "";
        if (this.context.publisherRepo != null) {
            ends = this.context.publisherRepo.getLibraryData().libraries.description + "-";
        }
        if (this.context.subscriberRepo != null) {
            ends = (String)ends + this.context.subscriberRepo.getLibraryData().libraries.description + " ";
        } else if (this.context.hintsRepo != null) {
            ends = this.context.hintsRepo.getLibraryData().libraries.description + " ";
        }
        if (this.function == Function.FAULT) {
            ((Message)message).setSubject("ELS Problem: " + (String)ends + this.now);
        } else if (this.function == Function.SEND) {
            String subject = "";
            if (isMisMatches) {
                ((Message)message).setSubject("ELS Mismatches: " + (String)ends + this.now);
            } else {
                ((Message)message).setSubject("ELS What's New: " + (String)ends + this.now);
            }
        } else if (this.function == Function.TEST) {
            ((Message)message).setSubject("ELS Test Email: " + this.now);
        }
        MimeMultipart multipart = new MimeMultipart("related");
        if (recipient.format.equalsIgnoreCase("text")) {
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(this.fetchContent(recipient, isMisMatches));
            ((Multipart)multipart).addBodyPart(textPart);
        } else if (recipient.format.equalsIgnoreCase("html")) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent(this.fetchContent(recipient, isMisMatches), "text/html; charset=utf-8");
            ((Multipart)multipart).addBodyPart(htmlPart);
        }
        if (this.attachment != null && this.attachment.trim().length() > 0) {
            MimeBodyPart attachmentPart = new MimeBodyPart();
            attachmentPart.attachFile(new File(this.attachment));
            ((Multipart)multipart).addBodyPart(attachmentPart);
        }
        message.setContent(multipart);
        transport.sendMessage(message, ((Message)message).getAllRecipients());
        String msg = this.function == Function.FAULT ? "Fault" + this.context.cfg.gs("EmailHandler.email.sent.to") + recipient.address : (isMisMatches ? "Mismatches" : "What's New") + this.context.cfg.gs("EmailHandler.email.sent.to") + recipient.address;
        this.logger.info(msg);
    }

    private String fetchContent(Recipient recipient, boolean isMisMatches) throws Exception {
        Object text = "";
        if (this.function != Function.SEND) {
            Object hostname = "";
            try {
                hostname = " (" + InetAddress.getLocalHost().getHostName() + ")";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            Object from = "";
            if (this.context.publisherRepo != null) {
                from = this.context.publisherRepo.getLibraryData().libraries.description + (String)hostname;
            } else if (this.context.subscriberRepo != null) {
                from = this.context.subscriberRepo.getLibraryData().libraries.description + (String)hostname;
            } else if (this.context.hintsRepo != null) {
                from = this.context.hintsRepo.getLibraryData().libraries.description + (String)hostname;
            }
            if (recipient.format.equalsIgnoreCase("html")) {
                text = "<!DOCTYPE html><html><body style=\"font-family: Arial, Helvetica, sans-serif;font-size: 100%;\">\n";
                text = (String)text + "<div><img src='https://www.elsnavigator.com/assets/images/els-logo-64px.png' style=\"vertical-align: middle;\"/>\n";
                text = (String)text + "<span style=\"font-family: Arial, Helvetica, sans-serif;font-size: 120%;vertical-align: middle;\">\n";
                text = (String)text + "<b>&nbsp;&nbsp;Automated email from: " + (String)from + "</b></span></div>\n";
                text = (String)text + "<hr/>\n";
            } else if (recipient.format.equalsIgnoreCase("text")) {
                text = "Automated email from: " + (String)from + "\n";
                text = (String)text + "------------------------------------------\n";
            }
        }
        if (this.function == Function.FAULT) {
            this.attachment = this.context.cfg.getLogFileFullPath();
            if (recipient.format.equalsIgnoreCase("html")) {
                text = (String)text + "<p><b>Problem</b></p>";
                text = (String)text + "<span style=\"font-family: monospace; font-size: 120%;\">";
            } else if (recipient.format.equalsIgnoreCase("text")) {
                text = (String)text + "Problem\n\n";
            }
            text = (String)text + "An ELS process appears to have failed. See attached log.\n";
            if (recipient.format.equalsIgnoreCase("html")) {
                text = (String)text + "</span><hr/>";
            } else if (recipient.format.equalsIgnoreCase("text")) {
                text = (String)text + "------------------------------------------\n";
            }
        } else if (this.function == Function.SEND) {
            String buf;
            Object filename;
            Object object = filename = isMisMatches ? this.context.cfg.getMismatchFilename() : this.context.cfg.getWhatsNewFilename();
            if (recipient.format.equalsIgnoreCase("html")) {
                filename = (String)filename + ".html";
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader((String)filename));
            while ((buf = bufferedReader.readLine()) != null) {
                text = (String)text + buf.trim() + "\n";
            }
            bufferedReader.close();
        } else if (this.function == Function.TEST) {
            if (recipient.format.equalsIgnoreCase("html")) {
                text = (String)text + "<p><b>Test Email</b></p>";
                text = (String)text + "<span style=\"font-family: monospace; font-size: 120%;\">";
            } else if (recipient.format.equalsIgnoreCase("text")) {
                text = (String)text + "Test Email\n\n";
            }
            text = (String)text + "This is a test for sending emails using ";
            text = (String)text + this.tool.getServer();
            text = (String)text + "\n";
            if (recipient.format.equalsIgnoreCase("html")) {
                text = (String)text + "</span><hr/>";
            } else if (recipient.format.equalsIgnoreCase("text")) {
                text = (String)text + "------------------------------------------\n";
            }
        }
        if (this.function != Function.SEND) {
            if (recipient.format.equalsIgnoreCase("html")) {
                text = (String)text + "<br/><br/>------- " + this.context.cfg.gs("Email.do.not.reply") + " -------<br/>";
                text = (String)text + "</body></html>";
            } else if (recipient.format.equalsIgnoreCase("text")) {
                text = (String)text + "\n\n";
                text = (String)text + "------- " + this.context.cfg.gs("Email.do.not.reply") + " -------\n";
            }
        }
        return text;
    }

    private ArrayList<Recipient> fetchRecipients() {
        Libraries lib;
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        if (this.context.publisherRepo != null) {
            lib = this.context.publisherRepo.getLibraryData().libraries;
            if (lib.email != null && !lib.email.isEmpty()) {
                recipients.add(new Recipient(this, lib.email, lib.format, lib.mismatches, lib.whatsNew));
            }
        }
        if (this.function != Function.TEST && this.context.subscriberRepo != null) {
            lib = this.context.subscriberRepo.getLibraryData().libraries;
            if (lib.email != null && !lib.email.isEmpty() && (!Persistent.couldNotConnect && lib.skipOffline.booleanValue() || this.function == Function.FAULT && Persistent.couldNotConnect && !lib.skipOffline.booleanValue())) {
                recipients.add(new Recipient(this, lib.email, lib.format, lib.mismatches, lib.whatsNew));
            }
        } else if (this.function == Function.FAULT && this.context.hintsRepo != null) {
            lib = this.context.hintsRepo.getLibraryData().libraries;
            if (lib.email != null && !lib.email.isEmpty()) {
                recipients.add(new Recipient(this, lib.email, lib.format, lib.mismatches, lib.whatsNew));
            }
        }
        return recipients;
    }

    private void generatePKCE() {
        int randomLength = ThreadLocalRandom.current().nextInt(43, 128);
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[randomLength];
        secureRandom.nextBytes(randomBytes);
        this.codeVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(this.codeVerifier.getBytes(StandardCharsets.US_ASCII));
            this.codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(Utils.getStackTrace(e));
            this.error = e.getMessage();
            this.fault = true;
        }
    }

    @Override
    public void interrupt() {
        this.logger.debug(this.context.cfg.gs("EmailHandler.interrupting.email.handler"));
        this.requestStop();
        if (this.workerRunning) {
            this.stopHttpServer();
        }
        super.interrupt();
    }

    public boolean isWorkerRunning() {
        return this.workerRunning;
    }

    private Map<String, List> parseResponse() {
        String[] kvp;
        LinkedHashMap<String, List> parameters = new LinkedHashMap<String, List>();
        for (String pair : kvp = this.response.split("&")) {
            String[] kv = pair.split("=", 2);
            String key = kv[0];
            String value = kv.length > 1 ? kv[1] : "";
            key = URLDecoder.decode(key, StandardCharsets.UTF_8);
            value = URLDecoder.decode(value, StandardCharsets.UTF_8);
            parameters.computeIfAbsent(key, k -> new List()).add(value);
        }
        if (!parameters.isEmpty()) {
            switch (this.tool.getProfile()) {
                case "Apple": {
                    break;
                }
                case "GMail": {
                    String value;
                    List list = (List)parameters.get("error");
                    if (list != null) {
                        this.error = list.getItem(0);
                        this.fault = true;
                        break;
                    }
                    list = (List)parameters.get("code");
                    if (list == null || (value = list.getItem(0)) == null) break;
                    this.authToken = value;
                    break;
                }
                case "Outlook": {
                    String value;
                    List list = (List)parameters.get("error");
                    if (list != null) {
                        this.error = list.getItem(0);
                        list = (List)parameters.get("error_description");
                        if (list != null) {
                            this.error = this.error + ", " + list.getItem(0);
                        }
                        this.fault = true;
                        break;
                    }
                    list = (List)parameters.get("code");
                    if (list == null || (value = list.getItem(0)) == null) break;
                    this.authToken = value;
                    break;
                }
                case "SMTP": {
                    break;
                }
                case "Zoho": {
                    String value;
                    List list = (List)parameters.get("error");
                    if (list != null) {
                        this.error = list.getItem(0);
                        this.fault = true;
                        break;
                    }
                    list = (List)parameters.get("code");
                    if (list != null && (value = list.getItem(0)) != null) {
                        this.authToken = value;
                    }
                    if ((list = (List)parameters.get("location")) != null && (value = list.getItem(0)) != null) {
                        this.location = value;
                    }
                    if ((list = (List)parameters.get("accounts-server")) == null || (value = list.getItem(0)) == null) break;
                    this.tool.setRefreshUrl(value);
                }
            }
            if (!this.fault) {
                this.logger.info("Authorization token retrieved");
            }
        }
        return parameters;
    }

    private void readServerResponse(int milliTimeout) {
        this.response = "";
        this.responseCompleted = false;
        long startTime = System.currentTimeMillis();
        while (!this.responseCompleted) {
            try {
                Thread.sleep(250L);
                if (!this.stop && System.currentTimeMillis() <= startTime + (long)milliTimeout) continue;
                if (this.stop) break;
                this.error = this.context.cfg.gs("EmailHandler.session.timed.out");
                this.timeout = true;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshAccessToken() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HttpRequest request = null;
        switch (this.tool.getProfile()) {
            case "Apple": {
                break;
            }
            case "GMail": {
                parameters.put("client_id", "863161091698-hj38ceukvile50k4qruj0p6mdjith5l8.apps.googleusercontent.com");
                parameters.put("grant_type", "refresh_token");
                parameters.put("refresh_token", this.tool.getRefreshToken());
                String form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
                request = HttpRequest.newBuilder().timeout(Duration.ofMillis(10000L)).uri(URI.create("https://oauth2.googleapis.com/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
                break;
            }
            case "Outlook": {
                break;
            }
            case "SMTP": {
                break;
            }
            case "Zoho": {
                parameters.put("client_id", "1000.88UA8YCET6S12R7Y9U6KKS2EFMOJQZ");
                parameters.put("client_secret", "");
                parameters.put("grant_type", "refresh_token");
                parameters.put("refresh_token", this.tool.getRefreshToken());
                String form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
                if (this.tool.getRefreshUrl().isEmpty()) {
                    this.tool.setRefreshUrl("https://accounts.zoho.com");
                }
                request = HttpRequest.newBuilder().timeout(Duration.ofMillis(10000L)).uri(URI.create(this.tool.getRefreshUrl() + "/oauth/v2/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
            }
        }
        assert (request != null);
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body().toString();
            int status = response.statusCode();
            Gson gson = new Gson();
            if (status == 200) {
                ErrorResponse errorResponse = gson.fromJson(body, ErrorResponse.class);
                if (errorResponse.error != null && !errorResponse.error.isEmpty()) {
                    this.error = errorResponse.error + ": " + errorResponse.error_description;
                    this.logger.error(this.context.cfg.gs("EmailHandler.error.refreshing.access.token.for") + this.tool.getUsername() + ": " + this.error);
                    this.fault = true;
                    return;
                } else {
                    AccessResponse access = gson.fromJson(body, AccessResponse.class);
                    this.tool.setAccessToken(access.access_token);
                    this.tool.setAccessExpires(access.expires_in);
                    this.tool.write();
                    this.logger.info(this.context.cfg.gs("EmailHandler.access.token.refreshed.for") + this.tool.getUsername());
                }
                return;
            }
            if (status == 400) {
                ErrorResponse errorResponse = gson.fromJson(body, ErrorResponse.class);
                this.error = errorResponse.error + ": " + errorResponse.error_description;
                this.logger.error(this.context.cfg.gs("EmailHandler.error.refreshing.access.token.for") + this.tool.getUsername() + ": " + this.error);
                this.fault = true;
                return;
            }
            if (status != 404) return;
        }
        catch (HttpTimeoutException te) {
            this.error = this.context.cfg.gs("EmailUI.authentication.timeout");
            this.timeout = true;
            return;
        }
        catch (Exception e2) {
            this.logger.error(Utils.getStackTrace(e2));
            this.error = e2.getMessage();
            this.fault = true;
        }
    }

    @Override
    public void run() {
        long utc = Instant.now().toEpochMilli();
        Instant instant = Instant.ofEpochMilli(utc);
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        this.now = zdt.format(DateTimeFormatter.ofPattern(this.context.preferences.getDateFormat()));
        switch (this.function) {
            case AUTH: {
                this.authenticate();
                break;
            }
            case FAULT: 
            case SEND: 
            case TEST: {
                this.email();
            }
        }
    }

    private void requestAccessAndRefreshTokens() {
        String form = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HttpRequest request = null;
        switch (this.tool.getProfile()) {
            case "Apple": {
                break;
            }
            case "GMail": {
                parameters.put("client_id", "863161091698-hj38ceukvile50k4qruj0p6mdjith5l8.apps.googleusercontent.com");
                parameters.put("grant_type", "authorization_code");
                parameters.put("code", this.authToken);
                parameters.put("access_type", "offline");
                parameters.put("redirect_uri", "http://127.0.0.1:" + this.httpPort);
                parameters.put("code_verifier", this.codeVerifier);
                form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
                request = HttpRequest.newBuilder().timeout(Duration.ofMillis(10000L)).uri(URI.create("https://oauth2.googleapis.com/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
                break;
            }
            case "Outlook": {
                parameters.put("tenant", "consumers");
                parameters.put("client_id", "28d6da7f-9a7c-4cea-aea5-73b9c59c7a15");
                parameters.put("code", this.authToken);
                parameters.put("redirect_uri", "http://127.0.0.1:60271");
                parameters.put("grant_type", "authorization_code");
                parameters.put("code_verifier", this.codeVerifier);
                parameters.put("access_type", "offline");
                form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
                if (this.tool.getRefreshUrl().isEmpty()) {
                    this.tool.setRefreshUrl("https://login.microsoftonline.com");
                }
                request = HttpRequest.newBuilder().timeout(Duration.ofMillis(10000L)).uri(URI.create(this.tool.getRefreshUrl() + "/consumers/oauth2/v2.0/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
                break;
            }
            case "SMTP": {
                break;
            }
            case "Zoho": {
                parameters.put("client_id", "1000.88UA8YCET6S12R7Y9U6KKS2EFMOJQZ");
                parameters.put("client_secret", "");
                parameters.put("grant_type", "authorization_code");
                parameters.put("code", this.authToken);
                parameters.put("redirect_uri", "http://127.0.0.1:" + this.httpPort);
                parameters.put("code_verifier", this.codeVerifier);
                form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
                if (this.tool.getRefreshUrl().isEmpty()) {
                    this.tool.setRefreshUrl("https://accounts.zoho.com");
                }
                request = HttpRequest.newBuilder().timeout(Duration.ofMillis(10000L)).uri(URI.create(this.tool.getRefreshUrl() + "/oauth/v2/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
            }
        }
        assert (request != null);
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body().toString();
            int status = response.statusCode();
            Gson gson = new Gson();
            if (status == 200) {
                ErrorResponse errorResponse = gson.fromJson(body, ErrorResponse.class);
                if (errorResponse.error != null && !errorResponse.error.isEmpty()) {
                    this.error = errorResponse.error + ": " + errorResponse.error_description;
                    this.logger.error(this.context.cfg.gs("EmailHandler.error.requesting.access.token.for") + this.tool.getUsername() + ": " + this.error);
                    this.fault = true;
                } else {
                    AccessResponse access = gson.fromJson(body, AccessResponse.class);
                    this.tool.setAccessToken(access.access_token);
                    this.tool.setAccessExpires(access.expires_in);
                    this.tool.setRefreshToken(access.refresh_token);
                    this.tool.setRefreshExpires(access.refresh_token_expires_in);
                    this.api_domain = access.api_domain;
                    this.location = access.location;
                    this.scope = access.scope;
                    this.logger.info(this.context.cfg.gs("EmailHandler.access.token.retrieved.for") + this.tool.getUsername());
                }
            } else if (status == 400) {
                ErrorResponse errorResponse = gson.fromJson(body, ErrorResponse.class);
                this.error = errorResponse.error + ": " + errorResponse.error_description;
                this.logger.error(this.error);
                this.fault = true;
            } else if (status == 404) {
                this.error = this.context.cfg.gs("EmailUI.404") + String.valueOf(request.uri());
                this.logger.error(this.error);
                this.fault = true;
            }
        }
        catch (HttpTimeoutException te) {
            this.error = this.context.cfg.gs("EmailUI.authentication.timeout");
            this.timeout = true;
        }
        catch (Exception e2) {
            this.logger.error(Utils.getStackTrace(e2));
            this.error = e2.getMessage();
            this.fault = true;
        }
    }

    private void requestStop() {
        this.stop = true;
    }

    private void startHttpServer() {
        boolean badPort = true;
        while (badPort) {
            try {
                byte[] lh = new byte[]{127, 0, 0, 1};
                InetAddress addr = Inet4Address.getByAddress(lh);
                int randomPort = 0;
                randomPort = this.tool.getProfile().equalsIgnoreCase("outlook") ? 60271 : (this.tool.getProfile().equalsIgnoreCase("zoho") ? 60271 : ThreadLocalRandom.current().nextInt(49152, 65535));
                InetSocketAddress socketAddr = new InetSocketAddress(addr, randomPort);
                this.server = HttpServer.create(socketAddr, 0);
                this.server.createContext("/", new HttpHServer());
                this.server.setExecutor(null);
                this.httpPort = socketAddr.getPort();
                this.server.start();
                badPort = false;
                this.workerRunning = true;
            }
            catch (BindException be) {
                if (!this.tool.getProfile().equalsIgnoreCase("outlook") && !this.tool.getProfile().equalsIgnoreCase("zoho")) continue;
                this.logger.error(Utils.getStackTrace(be));
                this.error = be.getMessage();
                this.fault = true;
                this.workerRunning = false;
                break;
            }
            catch (IOException e) {
                this.logger.error(Utils.getStackTrace(e));
                this.error = e.getMessage();
                this.fault = true;
                this.workerRunning = false;
                break;
            }
        }
    }

    private void stopHttpServer() {
        if (this.server != null) {
            this.server.stop(0);
        }
        this.server = null;
        this.workerRunning = false;
    }

    private void writeServerResponse() {
        if (this.httpExchange != null) {
            int code;
            if (!this.fault && !this.timeout) {
                code = 200;
                this.response = "<html><body style=\"background-color: #1C1B22; color: white; font-family: Arial, Helvetica, sans-serif;font-size: 100%;\">";
                this.response = this.response + "<div><img src='https://www.elsnavigator.com/assets/images/els-logo-72px.png' style=\"vertical-align: middle;\"/><span style=\"font-family: Arial, Helvetica, sans-serif;font-size: 120%;vertical-align: middle;\">";
                this.response = this.response + "<b>&nbsp;&nbsp;" + this.context.cfg.gs("EmailUI.els.authentication.success") + "</b></span><div>";
                this.response = this.response + "<hr/><p>&nbsp;&nbsp;" + this.context.cfg.gs("EmailUI.els.authentication.end") + "</p>";
                this.response = this.response + "</body></html>";
            } else {
                code = 400;
                this.response = "<html><body style=\"background-color: #1C1B22; color: white; font-family: Arial, Helvetica, sans-serif;font-size: 100%;\">";
                this.response = this.response + "<div><img src='https://www.elsnavigator.com/assets/images/els-logo-72px.png' style=\"vertical-align: middle;\"/><span style=\"font-family: Arial, Helvetica, sans-serif;font-size: 120%;vertical-align: middle;\">";
                this.response = this.response + "<b>&nbsp;&nbsp;" + this.context.cfg.gs("EmailUI.els.authentication.failed") + "</b></span><div>";
                this.response = this.response + "<hr/><p>&nbsp;&nbsp;" + this.error + "</p>";
                this.response = this.response + "</body></html>";
            }
            try {
                this.httpExchange.sendResponseHeaders(code, this.response.length());
                OutputStream out = this.httpExchange.getResponseBody();
                out.write(this.response.getBytes());
                out.close();
            }
            catch (IOException e) {
                this.logger.error(Utils.getStackTrace(e));
                this.error = e.getMessage();
                this.fault = true;
            }
        }
        this.response = "";
    }

    public static enum Function {
        AUTH,
        FAULT,
        SEND,
        TEST;

    }

    private class Recipient {
        public String address;
        public String format;
        public boolean mismatches = false;
        public boolean whatsNew = false;

        public Recipient(EmailHandler emailHandler, String address, String format, boolean mismatches, boolean whatsNew) {
            this.address = address;
            this.format = format;
            this.mismatches = mismatches;
            this.whatsNew = whatsNew;
        }
    }

    private class ErrorResponse {
        String error;
        String error_description;
        int[] error_codes;

        private ErrorResponse(EmailHandler emailHandler) {
        }
    }

    private class AccessResponse {
        String access_token;
        String api_domain;
        int expires_in;
        String id_token;
        String location;
        String refresh_token;
        int refresh_token_expires_in;
        String scope;
        String token_type;

        private AccessResponse(EmailHandler emailHandler) {
        }
    }

    private class HttpHServer
    implements HttpHandler {
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            EmailHandler.this.httpExchange = exchange;
            String method = exchange.getRequestMethod();
            if (method.equals("GET")) {
                URI uri = exchange.getRequestURI();
                EmailHandler.this.response = uri.getQuery();
                EmailHandler.this.logger.debug("HTTP GET");
            } else if (method.equals("POST")) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                InputStream in = exchange.getRequestBody();
                StringBuilder requestData = new StringBuilder();
                while ((bytesRead = in.read(buffer)) != -1) {
                    requestData.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                }
                in.close();
                EmailHandler.this.response = new String(requestData.toString().getBytes());
                EmailHandler.this.logger.debug("HTTP POST");
            }
            EmailHandler.this.responseCompleted = true;
        }
    }
}

