/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.renamer;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenamerTool
extends AbstractTool {
    public static final String INTERNAL_NAME = "Renamer";
    public static final String SUBSYSTEM = "tools";
    private String configName;
    private String internalName = "Renamer";
    private int type = 0;
    private int segment = 0;
    private boolean recursive = false;
    private boolean filesOnly = true;
    private String text1 = "";
    private String text2 = "";
    private String text3 = "";
    private boolean option1 = false;
    private boolean option2 = false;
    private boolean option3 = false;
    private transient int counter = -1;
    private transient int renameCount = 0;
    private transient boolean isDryRun = false;
    private transient Logger logger = LogManager.getLogger("applog");
    private transient Repository repo;

    public RenamerTool(Context context) {
        super(context);
        this.setDisplayName(this.getCfg().gs("Renamer.displayName"));
        this.context = context;
    }

    @Override
    public RenamerTool clone() {
        assert (this.context != null);
        RenamerTool renamer = new RenamerTool(this.context);
        renamer.setConfigName(this.getConfigName());
        renamer.setDisplayName(this.getDisplayName());
        renamer.setDataHasChanged();
        renamer.isDryRun = this.isDryRun;
        renamer.setRemote(this.isRemote());
        renamer.setType(this.getType());
        renamer.setSegment(this.getSegment());
        renamer.setIsRecursive(this.isRecursive());
        renamer.setIsFilesOnly(this.isFilesOnly());
        renamer.setText1(this.getText1());
        renamer.setText2(this.getText2());
        renamer.setText3(this.getText3());
        renamer.setOption1(this.isOption1());
        renamer.setOption2(this.isOption2());
        renamer.setOption3(this.isOption3());
        return renamer;
    }

    public String exec(String wholeName) {
        String change = "";
        Object value = "";
        if (wholeName != null && wholeName.length() > 0) {
            String name = FilenameUtils.getBaseName(wholeName);
            String ext = FilenameUtils.getExtension(wholeName);
            switch (this.getSegment()) {
                case 0: {
                    value = name;
                    break;
                }
                case 1: {
                    value = ext;
                    break;
                }
                case 2: {
                    value = wholeName;
                }
            }
            if (((String)value).length() > 0) {
                switch (this.getType()) {
                    case 0: {
                        change = this.execCaseChange((String)value);
                        break;
                    }
                    case 1: {
                        change = this.execInsert((String)value);
                        break;
                    }
                    case 2: {
                        change = this.execNumbering((String)value);
                        break;
                    }
                    case 3: {
                        change = this.execRemove((String)value);
                        break;
                    }
                    case 4: {
                        change = this.execReplace((String)value);
                    }
                }
            }
            switch (this.getSegment()) {
                case 0: {
                    value = change + (String)(ext.length() > 0 ? "." + ext : "");
                    break;
                }
                case 1: {
                    value = name + "." + change;
                    break;
                }
                case 2: {
                    value = change;
                }
            }
        }
        return value;
    }

    private String execCaseChange(String value) {
        switch (this.getText1()) {
            case "firstupper": {
                value = ((String)value).toLowerCase(this.context.cfg.bundle().getLocale());
                String first = ((String)value).substring(0, 1);
                first = first.toUpperCase(this.context.cfg.bundle().getLocale());
                value = first + (((String)value).length() > 1 ? ((String)value).substring(1) : "");
                break;
            }
            case "lower": {
                value = ((String)value).toLowerCase(this.context.cfg.bundle().getLocale());
                break;
            }
            case "titlecase": {
                int sc = StringUtils.countMatches((CharSequence)value, " ");
                int pc = StringUtils.countMatches((CharSequence)value, ".");
                int m = this.getSegment() == 2 ? 2 : 1;
                String sep = pc > m && pc > sc ? "\\." : " ";
                String[] split = ((String)value).split(sep);
                value = "";
                for (int i = 0; i < split.length; ++i) {
                    Object word = split[i];
                    Object fc = ((String)(word = ((String)word).toLowerCase(this.context.cfg.bundle().getLocale()))).length() < 2 ? word : ((String)word).substring(0, 1);
                    fc = ((String)fc).toUpperCase(this.context.cfg.bundle().getLocale());
                    word = (String)fc + (((String)word).length() > 1 ? ((String)word).substring(1) : "");
                    value = (String)value + (((String)value).length() > 0 ? (sep != " " ? "." : " ") : "") + (String)word;
                }
                break;
            }
            case "upper": {
                value = ((String)value).toUpperCase(this.context.cfg.bundle().getLocale());
            }
        }
        return value;
    }

    private String execInsert(String value) {
        int pos = Integer.parseInt(this.getText2());
        value = this.insertString(value, this.getText1(), pos, this.isOption1(), this.isOption2(), this.isOption3());
        return value;
    }

    private String execNumbering(String value) {
        int start = Integer.parseInt(this.getText1());
        this.counter = this.counter < 0 || this.counter < start ? start : (this.counter = this.counter + 1);
        int zeros = Integer.parseInt(this.getText2());
        String format = StringUtils.repeat('0', zeros);
        DecimalFormat formatter = new DecimalFormat(format);
        String numString = formatter.format(this.counter);
        int pos = Integer.parseInt(this.getText3());
        value = this.insertString(value, numString, pos, this.isOption1(), this.isOption2(), this.isOption3());
        return value;
    }

    private String execRemove(String value) {
        int from = Integer.parseInt(this.getText1());
        int length = Integer.parseInt(this.getText2());
        value = this.isOption1() ? (((String)value).length() - length >= 0 ? ((String)value).substring(0, ((String)value).length() - length) : "") : ((String)value).substring(0, from) + ((String)value).substring(from + length);
        return value;
    }

    private String execReplace(String value) {
        if (this.isOption1()) {
            Pattern patt = Pattern.compile(this.getText1());
            value = value.replaceAll(patt.toString(), this.getText2());
        } else {
            value = this.isOption2() ? value.replace(this.getText1(), this.getText2()) : StringUtils.replaceIgnoreCase(value, this.getText1(), this.getText2());
        }
        return value;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public int getSegment() {
        return this.segment;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    public String getText1() {
        return this.text1;
    }

    public String getText2() {
        return this.text2;
    }

    public String getText3() {
        return this.text3;
    }

    public int getType() {
        return this.type;
    }

    private String insertString(String value, String insert, int pos, boolean fromEnd, boolean atEnd, boolean overwrite) {
        if (insert.length() > 0) {
            if (atEnd) {
                value = (String)value + insert;
            } else {
                String left = value;
                String right = "";
                if (pos < 0) {
                    pos = 0;
                }
                if (pos > ((String)value).length()) {
                    pos = ((String)value).length();
                }
                if (fromEnd) {
                    left = ((String)value).substring(0, ((String)value).length() - pos);
                    if (overwrite) {
                        int x = ((String)value).length() - pos + insert.length();
                        if (x < ((String)value).length()) {
                            right = ((String)value).substring(x);
                        }
                    } else {
                        right = ((String)value).substring(((String)value).length() - pos);
                    }
                } else {
                    left = ((String)value).substring(0, pos);
                    right = overwrite ? ((String)value).substring(pos + insert.length()) : ((String)value).substring(pos);
                }
                value = left + insert + right;
            }
        }
        return value;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    public boolean isFilesOnly() {
        return this.filesOnly;
    }

    public boolean isOption1() {
        return this.option1;
    }

    public boolean isOption2() {
        return this.option2;
    }

    public boolean isOption3() {
        return this.option3;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isToolCachedOrigins() {
        return true;
    }

    @Override
    public boolean isToolOriginsUsed() {
        return true;
    }

    @Override
    public boolean isToolPubOrSub() {
        return true;
    }

    @Override
    public boolean isToolSubscriber() {
        return false;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.reset();
        this.isDryRun = task.dryRun;
        if (task.publisherRepo != null && task.subscriberRepo != null) {
            this.context.fault = true;
            throw new MungeException(MessageFormat.format(this.getCfg().gs("Renamer.uses.only.one.repository"), this.getInternalName()));
        }
        Repository repository = this.repo = task.publisherRepo != null ? task.publisherRepo : task.subscriberRepo;
        if (this.repo == null) {
            this.context.fault = true;
            this.logger.error(MessageFormat.format(this.context.cfg.gs("Renamer.has.no.repository.defined"), this.getConfigName()));
            return;
        }
        if (task.previousTask != null) {
            task.origins = task.previousTask.getOrigins();
        }
        if (task.subscriberRepo != null && this.getCfg().isRemoteSubscriber()) {
            this.setRemote(true);
        }
        for (int i = 0; i < task.origins.size() && !this.isRequestStop(); ++i) {
            Origin origin = task.origins.get(i);
            String path = origin.getLocation();
            String rem = this.isRemote() ? this.getCfg().gs("Z.remote.uppercase") : "";
            this.logger.info(this.getDisplayName() + ", " + this.getConfigName() + ": " + rem + "\"" + path + "\"");
            if (origin.getType() == 1) {
                if (origin.getLocation().length() > 0 && !this.repo.getLibraryData().libraries.description.equalsIgnoreCase(origin.getLocation())) {
                    throw new MungeException(this.getCfg().gs("Renamer.task.definition.and.loaded.repository.do.not.match"));
                }
                for (Library lib : this.repo.getLibraryData().libraries.bibliography) {
                    for (String source : lib.sources) {
                        this.scan(source, true, false);
                    }
                }
                continue;
            }
            if (origin.getType() == 5) {
                for (Library lib : this.repo.getLibraryData().libraries.bibliography) {
                    if (!lib.name.equalsIgnoreCase(origin.getLocation())) continue;
                    for (String source : lib.sources) {
                        this.scan(source, true, false);
                    }
                }
                continue;
            }
            if (origin.getType() != 6) continue;
            String change = this.scan(path, true, true);
            if (origin.getLocation().equals(change)) continue;
            origin.setLocation(change);
        }
        this.logger.info(this.getDisplayName() + ", " + this.getConfigName() + ": " + this.renameCount + (this.isDryRun ? this.getCfg().gs("Z.dry.run") : ""));
    }

    private String scan(String path, boolean isFirst, boolean isRenameAllowed) {
        boolean doesNotExist = false;
        Object msg = "";
        try {
            boolean pathIsDir = false;
            if (this.isRemote()) {
                SftpATTRS attrs = this.context.clientSftp.stat(path = this.context.cfg.getFullPathSubscriber(path));
                if (attrs.isDir()) {
                    String fileName;
                    String change;
                    if (isRenameAllowed && !path.equals(change = this.rename(path, fileName = FilenameUtils.getName(path), true))) {
                        path = change;
                    }
                    isFirst = false;
                    pathIsDir = true;
                }
                Vector listing = this.context.clientSftp.listDirectory(path);
                for (int i = 0; i < listing.size() && !this.isRequestStop(); ++i) {
                    ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)listing.get(i);
                    if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    String fullpath = path + (String)(pathIsDir ? this.repo.getSeparator() + entry.getFilename() : "");
                    attrs = entry.getAttrs();
                    if (attrs.isDir() && this.isRecursive()) {
                        this.scan(fullpath, false, true);
                        continue;
                    }
                    String change = this.rename(fullpath, entry.getFilename(), attrs.isDir());
                    if (path.equals(change) || !isFirst) continue;
                    path = change;
                    isFirst = false;
                }
            } else {
                File loc = new File(Utils.getFullPathLocal(path));
                if (loc.exists()) {
                    File[] files;
                    if (loc.isDirectory()) {
                        String change;
                        if (isRenameAllowed && !path.equals(change = this.rename(loc.getPath(), loc.getName(), true))) {
                            path = change;
                            loc = new File(path);
                        }
                        isFirst = false;
                        files = FileSystemView.getFileSystemView().getFiles(loc, true);
                    } else {
                        files = new File[]{loc};
                    }
                    for (int i = 0; i < files.length && !this.isRequestStop(); ++i) {
                        File entry = files[i];
                        if (entry.isDirectory() && this.isRecursive()) {
                            this.scan(entry.getPath(), false, true);
                            continue;
                        }
                        String change = this.rename(entry.getPath(), entry.getName(), entry.isDirectory());
                        if (path.equals(change) || !isFirst) continue;
                        path = change;
                        isFirst = false;
                    }
                } else {
                    doesNotExist = true;
                    msg = this.context.cfg.gs("Z.does.not.exist") + loc.getPath();
                    this.requestStop();
                }
            }
        }
        catch (Exception e) {
            String en = e.getClass().getName();
            if (en.equals("com.jcraft.jsch.SftpException") && e.getMessage().contains("java.nio.file.NoSuchFileException")) {
                doesNotExist = true;
                msg = this.context.cfg.gs("Z.does.not.exist") + path;
            } else {
                msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                if (this.context.navigator != null) {
                    this.logger.error((String)msg);
                    JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.getCfg().gs("Renamer.title"), 0);
                } else {
                    this.logger.error((String)msg);
                }
            }
            this.requestStop();
        }
        if (doesNotExist) {
            this.logger.warn((String)msg);
            JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.getCfg().gs("Renamer.title"), 2);
        }
        return path;
    }

    private String rename(String fullpath, String filename, boolean isDirectory) throws Exception {
        if (!isDirectory || isDirectory && !this.isFilesOnly()) {
            boolean hidden = false;
            if (this.context.navigator != null && this.context.progress != null) {
                this.context.progress.update(" " + (String)filename);
            }
            if (((String)filename).startsWith(".") && ((String)filename).length() > 1) {
                filename = ((String)filename).substring(1);
                hidden = true;
            }
            Object change = this.exec((String)filename);
            if (hidden) {
                change = "." + (String)change;
                filename = "." + (String)filename;
            }
            Object newPath = "";
            if (!((String)filename).equals(change)) {
                String left = Utils.getLeftPath((String)fullpath, this.repo.getSeparator());
                newPath = left + this.repo.getSeparator() + (String)change;
                ++this.renameCount;
                if (this.context.mainFrame != null) {
                    this.context.mainFrame.labelStatusMiddle.setText(this.getCfg().gs("Z.count") + this.renameCount);
                }
                if (!this.isDryRun) {
                    this.getContext().transfer.rename((String)fullpath, (String)newPath, this.isRemote());
                    fullpath = newPath;
                    this.logger.info("  " + this.getCfg().gs("Z.renamed") + "\"" + (String)filename + "\"" + this.getCfg().gs("Z.to") + "\"" + (String)change + "\"");
                } else {
                    this.logger.info("  " + this.getCfg().gs("Z.would.rename") + "\"" + (String)filename + "\"" + this.getCfg().gs("Z.to") + "\"" + (String)change + "\"");
                }
                filename = change;
            }
        }
        return fullpath;
    }

    public void reset() {
        this.counter = -1;
        this.renameCount = 0;
        this.resetStop();
        if (this.logger == null) {
            this.logger = LogManager.getLogger("applog");
        }
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    @Override
    public void setDataHasChanged() {
        this.dataHasChanged = true;
    }

    @Override
    public void setDataHasChanged(boolean state) {
        this.dataHasChanged = state;
    }

    public void setIsFilesOnly(boolean filesOnly) {
        this.filesOnly = filesOnly;
    }

    public void setIsRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setOption1(boolean option1) {
        if (this.option1 != option1) {
            this.option1 = option1;
            this.setDataHasChanged();
        }
    }

    public void setOption2(boolean option2) {
        if (this.option2 != option2) {
            this.option2 = option2;
            this.setDataHasChanged();
        }
    }

    public void setOption3(boolean option3) {
        if (this.option3 != option3) {
            this.option3 = option3;
            this.setDataHasChanged();
        }
    }

    public void setSegment(int segment) {
        if (this.segment != segment) {
            this.segment = segment;
            this.setDataHasChanged();
        }
    }

    public void setText1(String text1) {
        if (!this.text1.equals(text1)) {
            this.text1 = text1;
            this.setDataHasChanged();
        }
    }

    public void setText2(String text2) {
        if (!this.text2.equals(text2)) {
            this.text2 = text2;
            this.setDataHasChanged();
        }
    }

    public void setText3(String text3) {
        if (!this.text3.equals(text3)) {
            this.text3 = text3;
            this.setDataHasChanged();
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void write() throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("Renamer.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }
}

