/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.sleep;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SleepTool
extends AbstractTool {
    public static final String INTERNAL_NAME = "Sleep";
    public static final String SUBSYSTEM = "tools";
    private String configName;
    private String internalName = "Sleep";
    private int sleep = 0;
    private transient boolean isDryRun = false;
    private transient Logger logger = LogManager.getLogger("applog");

    public SleepTool(Context context) {
        super(context);
        this.context = context;
        this.setDisplayName(this.getCfg().gs("Sleep.displayName"));
        this.dataHasChanged = false;
    }

    @Override
    public SleepTool clone() {
        assert (this.context != null);
        SleepTool tool = new SleepTool(this.context);
        tool.setConfigName(this.getConfigName());
        tool.setDisplayName(this.getDisplayName());
        tool.setDataHasChanged();
        tool.isDryRun = this.isDryRun;
        tool.setRemote(this.isRemote());
        tool.setSleepTime(this.getSleepTime());
        return tool;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public int getSleepTime() {
        return this.sleep;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.logger.info(this.context.cfg.gs("Z.launching") + this.getDisplayName() + ", " + this.getConfigName());
        this.logger.info("+------------------------------------------");
        this.logger.info(MessageFormat.format(this.context.cfg.gs("Sleep.sleeping.minutes"), this.sleep));
        Thread.sleep(this.sleep * 1000 * 60);
        this.logger.info(this.getConfigName() + this.context.cfg.gs("Z.completed"));
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    @Override
    public boolean isToolPublisher() {
        return false;
    }

    @Override
    public boolean isToolSubscriber() {
        return false;
    }

    public void reset() {
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    @Override
    public void setDataHasChanged() {
        this.dataHasChanged = true;
    }

    @Override
    public void setDataHasChanged(boolean state) {
        this.dataHasChanged = state;
    }

    public void setSleepTime(int sleep) {
        this.sleep = sleep;
    }

    public void write() throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("Z.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }
}

