/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.ItemID;
import mslinks.data.ItemIDDrive;
import mslinks.data.ItemIDFS;
import mslinks.data.ItemIDRoot;
import mslinks.data.ItemIDUnknown;
import mslinks.data.Registry;

public class LinkTargetIDList
extends LinkedList<ItemID>
implements Serializable {
    public LinkTargetIDList() {
    }

    public LinkTargetIDList(ByteReader data) throws IOException, ShellLinkException {
        int itemSize;
        int size = (int)data.read2bytes();
        int pos = data.getPosition();
        while ((itemSize = (int)data.read2bytes()) != 0) {
            int typeFlags = data.read();
            ItemID item = ItemID.createItem(typeFlags);
            item.load(data, itemSize - 3);
            this.add(item);
        }
        pos = data.getPosition() - pos;
        if (pos != size) {
            throw new ShellLinkException("unexpected size of LinkTargetIDList");
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        int size = 2;
        byte[][] b = new byte[this.size()][];
        int i = 0;
        for (ItemID j : this) {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ByteWriter w = new ByteWriter(ba);
            j.serialize(w);
            b[i++] = ba.toByteArray();
        }
        for (Object j : (Object)b) {
            size += ((Object)j).length + 2;
        }
        bw.write2bytes(size);
        for (Object j : (Object)b) {
            bw.write2bytes(((Object)j).length + 2);
            bw.write((byte[])j);
        }
        bw.write2bytes(0L);
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public boolean isCorrect() {
        return this.canBuildPath();
    }

    public boolean canBuildPath() {
        for (ItemID i : this) {
            if (!(i instanceof ItemIDUnknown)) continue;
            return false;
        }
        return true;
    }

    public boolean canBuildAbsolutePath() {
        if (this.size() < 2) {
            return false;
        }
        ItemID firstId = (ItemID)this.getFirst();
        if (!(firstId instanceof ItemIDRoot)) {
            return false;
        }
        ItemIDRoot rootId = (ItemIDRoot)firstId;
        if (!rootId.getClsid().equals(Registry.CLSID_COMPUTER)) {
            return false;
        }
        ItemID secondId = (ItemID)this.get(1);
        return secondId instanceof ItemIDDrive;
    }

    public String buildPath() {
        StringBuilder path = new StringBuilder();
        if (!this.isEmpty()) {
            ItemID firstId = (ItemID)this.getFirst();
            if (firstId instanceof ItemIDFS) {
                path.append("<Desktop>\\");
            }
            for (ItemID i : this) {
                path.append(i.toString());
            }
        }
        return path.toString();
    }
}

