/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.channel.ServerChannelSessionHolder;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;
import org.apache.sshd.sftp.server.SftpFileSystemAccessorProvider;
import org.apache.sshd.sftp.server.SftpUnsupportedAttributePolicyProvider;

public interface SftpSubsystemEnvironment
extends SessionHolder<ServerSession>,
ServerSessionHolder,
ServerChannelSessionHolder,
SftpFileSystemAccessorProvider,
SftpUnsupportedAttributePolicyProvider {
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 6;
    public static final List<Integer> SUPPORTED_SFTP_VERSIONS = Collections.unmodifiableList(IntStream.rangeClosed(3, 6).boxed().collect(Collectors.toList()));
    public static final String ALL_SFTP_IMPL = GenericUtils.join(SUPPORTED_SFTP_VERSIONS, ',');

    @Override
    default public ServerSession getSession() {
        return this.getServerSession();
    }

    public int getVersion();

    public Path getDefaultDirectory();
}

