! boot.s program

BOOTSEG = 0x07c0
SYSSEG = 0x0100
SYSLEN = 17

entry start
start:
    jmpi    go,#BOOTSEG
go:
    mov ax,cs
    mov ds,ax
    mov ss,ax
    mov sp,#0x0400

load_system:
    xor dx,dx       ! 开始位置, 磁头:硬盘号
    mov cx,#0x0002  ! 开始位置, 磁道:扇区
    mov ax,#0x0100
    mov es,ax       ! 载入到, ES 段
    xor bx,bx       ! 载入到, 偏移量 
    mov ax,#0x0211  ! AH: 读取扇区子功能, AL: 读取多少个扇区
    int 0x13        ! BIOS 13 号中断
    jnc continue_load   ! JUMP if CF = 0
die:
    jmp die

continue_load:
    cli             ! 清除中断允许位标志
    mov ax,#SYSSEG 
    mov ds,ax       ! 设置数据段寄存器位置 0x1000
    xor ax,ax
    mov es,ax       ! 设置扩展段寄存器 0x0000
    mov cx,#0x1000  ! 计数器
    sub si,si
    sub di,di
    rep 
    movsw

    mov ax,#BOOTSEG
    mov ds,ax       ! 重新设置数据段寄存器到当前数据段基地址
    lidt idt_48     ! 设置中断描述符表寄存器
    lgdt gdt_48     ! 设置全局描述符表寄存器

    mov ax,#0x0001
    lmsw ax         ! 设置 CR0, 进入保护模式
    jmpi 0,8

gdt:
    .word   0,0,0,0
    .word   0x07FF,0x0000,0x9A00,0x00C0
    .word   0x07FF,0x0000,0x9200,0x00C0

idt_48:
    .word   0,0,0
gdt_48:
    .word   0x07FF,0x7C00+gdt,0

.org 510
    .word   0xAA55
