close all

fonts1=8;
fonts2=5;
fonts3=8;
irf_fev_hor=20;
linewidthval1=1;

imp_2=irf_fevd_out_2.imp_y_fac_mat_scl; se_imp_2=se_irf_vdecomp_out_2.se_imp_y_fac_mat_scl;
imp_7=irf_fevd_out_7.imp_y_fac_mat_scl; se_imp_7=se_irf_vdecomp_out_7.se_imp_y_fac_mat_scl;
fevd_2=irf_fevd_out_2.vfrac_y_comp_mat; se_fevd_2=se_irf_vdecomp_out_2.se_vfrac_y_comp_mat;
fevd_7=irf_fevd_out_7.vfrac_y_comp_mat; se_fevd_7=se_irf_vdecomp_out_7.se_vfrac_y_comp_mat;

% *********************************************************************
% Figure A.8 -- IRFs and FEVDs from quarterly macro-yields DFM
% *********************************************************************
varlist={'dtfp_util';...
    'GDPC1';...
    'PAYEMS';...
    'PCECC96';...
    'GPDIC1';...
    'CPIAUCSL';...
    'YIELD24';...
    'T5YFFM';...
    'RVol'};
varlistfigure={'Total Factor Productivity';...
    'GDP';...
    'Nonfarm Payroll';...
    'Consumption';...    
    'Investment';...
    'CPI Inflation';...
    '2-Year Yield';...
    'Spread (5-year - FedFunds)';...
    'Realized Volatility'};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

figA8_1=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_level=reshape(imp_2(varind(iy),1,:),hor,1);
    irf_se_mat_level=reshape(se_imp_2(varind(iy),1,:),hor,1);

	irf_mat_slope=reshape(imp_2(varind(iy),2,:),hor,1);
    irf_se_mat_slope=reshape(se_imp_2(varind(iy),2,:),hor,1);      
    
	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_ynews=reshape(se_imp_2(varind(iy),3,:),hor,1);    
      
	irf_mat_spread=reshape(imp_7(varind(iy),1,:),hor,1);
    irf_se_mat_spread=reshape(se_imp_7(varind(iy),1,:),hor,1);         
    
    tmp_level=[irf_mat_level,irf_mat_level-irf_se_mat_level,irf_mat_level+irf_se_mat_level];
    tmp_slope=[irf_mat_slope,irf_mat_slope-irf_se_mat_slope,irf_mat_slope+irf_se_mat_slope];  
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_ynews,irf_mat_ynews+irf_se_mat_ynews];
    tmp_spread=[irf_mat_spread,irf_mat_spread-irf_se_mat_spread,irf_mat_spread+irf_se_mat_spread];     
    
    nexttile

    hold on

    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_spread(:,2)', fliplr(tmp_spread(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')        
    p_ok=plot(0:hor-1,tmp_spread(:,1),'-',...
        'LineWidth',linewidthval1,...
        'Color',[0.5020, 0.5020, 0.5020]);        

    p_level=plot(0:hor-1,tmp_level(:,1),'-.',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0, 1]);    
    
    p_slope=plot(0:hor-1,tmp_slope(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0, 0]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,'MarkerEdgeColor',[1, 0, 0],'MarkerFaceColor',[1, 0, 0]);        
 
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    
    hold off
	xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;

    title(varlistfigure{iy},'fontsize',fonts1)
    
    ylabel('Percent','fontsize',fonts1)    

    if iy==length(varind)
        legend([p_level,p_slope,p_ynews,p_ok],{'Level Shock',...
            'Slope Shock',...
            'Yield News Shock',...
            'Slope Shock\newline(Kurmann & Otrok)'},'location','best','fontsize',fonts2)           
    end       
    
end



figA8_2=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)
    
	fevd_mat_level=reshape(fevd_2(varind(iy),1,:),hor,1);
    fevd_se_mat_level=reshape(se_fevd_2(varind(iy),1,:),hor,1);

	fevd_mat_slope=reshape(fevd_2(varind(iy),2,:),hor,1);
    fevd_se_mat_slope=reshape(se_fevd_2(varind(iy),2,:),hor,1);      
    
	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    
    
	fevd_mat_spread=reshape(fevd_7(varind(iy),1,:),hor,1);
    fevd_se_mat_spread=reshape(se_fevd_7(varind(iy),1,:),hor,1);        
    
    tmp_level=[fevd_mat_level,fevd_mat_level-fevd_se_mat_level,fevd_mat_level+fevd_se_mat_level];
    tmp_slope=[fevd_mat_slope,fevd_mat_slope-fevd_se_mat_slope,fevd_mat_slope+fevd_se_mat_slope];
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_spread=[fevd_mat_spread,fevd_mat_spread-fevd_se_mat_spread,fevd_mat_spread+fevd_se_mat_spread];    
    
    nexttile

    hold on

    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_spread(:,2)', fliplr(tmp_spread(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')    
    p_ok=plot(0:hor-1,tmp_spread(:,1),'-',...
        'LineWidth',linewidthval1,...
        'Color',[0.5020, 0.5020, 0.5020]);    
    
    
    p_level=plot(0:hor-1,tmp_level(:,1),'-.',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0, 1]);    
    
    p_slope=plot(0:hor-1,tmp_slope(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0, 0]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,'MarkerEdgeColor',[1, 0, 0],'MarkerFaceColor',[1, 0, 0]);        
    
    hold off
	xlim([0,irf_fev_hor])
    ylim([0,1])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)

    if iy==length(varind)
        legend([p_level,p_slope,p_ynews,p_ok],{'Level Shock',...
            'Slope Shock',...
            'Yield News Shock',...
            'Slope Shock\newline(Kurmann & Otrok)'},'location','best','fontsize',fonts2)           
    end      
    
end


%-------- save figures
saveas(figA8_1,sprintf('results/FigA8_irfs.eps'),'epsc') 
saveas(figA8_1,sprintf('results/FigA8_irfs.pdf'),'pdf') 
saveas(figA8_2,sprintf('results/FigA8_fevds.eps'),'epsc') 
saveas(figA8_2,sprintf('results/FigA8_fevds.pdf'),'pdf') 