close all

irf_fev_hor=36;
fonts1=8;
fonts2=4;
fonts3=8;
linewidthval1=1;

imp_2=irf_fevd_out_2.imp_y_fac_mat_scl; se_imp_2=se_irf_vdecomp_out_2.se_imp_y_fac_mat_scl;
imp_6=irf_fevd_out_6.imp_y_fac_mat_scl; se_imp_6=se_irf_vdecomp_out_6.se_imp_y_fac_mat_scl;
fevd_2=irf_fevd_out_2.vfrac_y_comp_mat; se_fevd_2=se_irf_vdecomp_out_2.se_vfrac_y_comp_mat;
fevd_6=irf_fevd_out_6.vfrac_y_comp_mat; se_fevd_6=se_irf_vdecomp_out_6.se_vfrac_y_comp_mat;

% *********************************************************************
% Figure 13 -- IRFs and FEVDs of the ten-year yield and components for
% the US, Germany, the UK and Japan to a yield news shock purged of 
% realized volatility and business cycle news 
% ********************************************************************
varlist={'YIELD120'
    'ZCY_120_DE'
    'ZCY_120_UK'
    'ZCY_120_JA'
    'ACMRNY10'
    'ZCYER_120_DE'
    'ZCYER_120_UK'
    'ZCYER_120_JA'
    'ACMTP10'
    'ZCYTP_120_DE'
    'ZCYTP_120_UK'
    'ZCYTP_120_JA'};

varlistfigure={'US: 10-Year Yield'
    'Germany: 10-Year Yield'
    'UK: 10-Year Yield'
    'Japan: 10-Year Yield'
    {'US: Risk-Neutral' ;'10-Year Yield'}
    {'Germany: Risk-Neutral' ;' 10-Year Yield'}
    {'UK: Risk-Neutral' ;' 10-Year Yield'}
    {'Japan: Risk-Neutral' ;' 10-Year Yield'}
    {'US: 10-Year Yield'; 'Term Premium'}
    {'Germany: 10-Year Yield'; 'Term Premium'}
    {'UK: 10-Year Yield'; 'Term Premium'}
    {'Japan: 10-Year Yield'; 'Term Premium'}};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);
end

fig13_1=figure;
set(gcf,'position',[360,180,660,440])
tiledlayout(3,4,'Padding','Compact');
for iy=1:length(varind)
    
    irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_ynews=reshape(se_imp_2(varind(iy),3,:),hor,1);
    irf_mat_purged_ynews=reshape(imp_6(varind(iy),1,:),hor,1);
    irf_se_mat_purged_ynews=reshape(se_imp_6(varind(iy),1,:),hor,1);
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_ynews,irf_mat_ynews+irf_se_mat_ynews];
    tmp_purged_ynews=[irf_mat_purged_ynews,irf_mat_purged_ynews-irf_se_mat_purged_ynews,irf_mat_purged_ynews+irf_se_mat_purged_ynews];
    
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_ynews(:,2)', fliplr(tmp_ynews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'-',...
        'LineWidth',linewidthval1,...
        'Color', [1, 0, 0]);
    
    p_purged_ynews=plot(0:hor-1,tmp_purged_ynews(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0.9290, 0.6940, 0.1250]);
    plot(0:hor-1,tmp_purged_ynews(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0.9290, 0.6940, 0.1250])
    plot(0:hor-1,tmp_purged_ynews(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0.9290, 0.6940, 0.1250])
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel('Percent','fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_ynews p_purged_ynews],{'Yield News Shock',...
            'Orthogonal to Realized Volatility \newline and Business Cycle News Shocks'},...
            'fontsize',fonts2,'location','northwest');
    end
    
end


fig13_2=figure;
set(gcf,'position',[360,180,660,440])
tiledlayout(3,4,'Padding','Compact');
for iy=1:length(varind)
    
    fevd_mat_ynews=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_ynews=reshape(se_fevd_2(varind(iy),3,:),hor,1);    
    fevd_mat_purged_ynews=reshape(fevd_6(varind(iy),1,:),hor,1);
    fevd_se_mat_purged_ynews=reshape(se_fevd_6(varind(iy),1,:),hor,1);
    
    nexttile
    
    tmp_news=[fevd_mat_ynews,fevd_mat_ynews-fevd_se_mat_ynews,fevd_mat_ynews+fevd_se_mat_ynews];
    tmp_purged_ynews=[fevd_mat_purged_ynews,fevd_mat_purged_ynews-fevd_se_mat_purged_ynews,fevd_mat_purged_ynews+fevd_se_mat_purged_ynews];
    
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_news(:,2)', fliplr(tmp_news(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')
    p_ynews=plot(0:hor-1,tmp_news(:,1),'-',...
        'LineWidth',linewidthval1,...
        'Color',[1, 0, 0]);

    p_purged_ynews=plot(0:hor-1,tmp_purged_ynews(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0.9290, 0.6940, 0.1250]);
    plot(0:hor-1,tmp_purged_ynews(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0.9290, 0.6940, 0.1250])
    plot(0:hor-1,tmp_purged_ynews(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0.9290, 0.6940, 0.1250])
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_ynews p_purged_ynews],{'Yield News Shock',...
            'Orthogonal to Realized Volatility \newline and Business Cycle News Shocks'},'fontsize',fonts2,'location','best');
    end
    
    
end


%-------- save figures
saveas(fig13_1,sprintf('results/Fig13_irfs_residual_yield_news.eps'),'epsc')
saveas(fig13_1,sprintf('results/Fig13_irfs_residual_yield_news.pdf'),'pdf')
saveas(fig13_2,sprintf('results/Fig13_fevds_residual_yield_news.eps'),'epsc')
saveas(fig13_2,sprintf('results/Fig13_fevds_residual_yield_news.pdf'),'pdf')