close all

irf_fev_hor=36;
fonts1=8;
fonts2=5;
fonts3=8;
linewidthval1=1;
linewidthval2=.01;
infirfylim=[-.07,.07];
N=length(name_vec);

imp_2=irf_fevd_out_2.imp_y_fac_mat_scl; se_imp_2=se_irf_vdecomp_out_2.se_imp_y_fac_mat_scl;
fevd_1=irf_fevd_out_1.vfrac_y_comp_mat; se_fevd_1=se_irf_vdecomp_out_1.se_vfrac_y_comp_mat;
fevd_2=irf_fevd_out_2.vfrac_y_comp_mat; se_fevd_2=se_irf_vdecomp_out_2.se_vfrac_y_comp_mat;
se_fevd_3shocks_combined_1=se_irf_vdecomp_out_1.se_vfrac_y_comp123_mat;
se_fevd_3shocks_combined_2=se_irf_vdecomp_out_2.se_vfrac_y_comp123_mat;


% *********************************************************************
% Figure 1 -- FEVDs from only-yields and macro-yields DFMs
% *********************************************************************
names_y1={'YIELD24';...
    'YIELD60';...
    'YIELD120'};...
y1listtable={'2-Year Yield';...
    '5-Year Yield';...
    '10-Year Yield'};...

ind_y1=nan(length(names_y1),1);
for i=1:length(names_y1)
    ind_y1(i)=find(ismember(name_vec,names_y1(i))==1);    
end

fig_labels_5fac_1={'Level Shock',...
    'Slope Shock',...
    'Yield News Shock',...
    '\nu_4',...
    '\nu_5'};

nshock=3;

fig1_1 = figure;
tiledlayout(length(ind_y1),nshock+1,'Padding','Compact');
for iy=1:length(ind_y1)

    for ishock=1:nshock
        fevd_mat_1=reshape(fevd_1(ind_y1(iy),ishock,:),hor,1);
        
        fevd_se_mat_1=reshape(se_fevd_1(ind_y1(iy),ishock,:),hor,1);
        
        
        fevd_mat_2=reshape(fevd_2(ind_y1(iy),ishock,:),hor,1);
        
        fevd_se_mat_2=reshape(se_fevd_2(ind_y1(iy),ishock,:),hor,1);
        
        nexttile
        
        tmp_1=[fevd_mat_1,fevd_mat_1-fevd_se_mat_1,fevd_mat_1+fevd_se_mat_1];
        tmp_2=[fevd_mat_2,fevd_mat_2-fevd_se_mat_2,fevd_mat_2+fevd_se_mat_2];
        
        hold on
        
        patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2(:,2)', fliplr(tmp_2(:,3)')],...
            [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none')      
        plot(0:hor-1,tmp_2(:,1),'-',...
            'LineWidth',linewidthval1,...
            'Color', 'k')        
        
        plot(0:hor-1,tmp_1(:,1),'--',...
            'LineWidth',linewidthval1,...
            'Color', [0, 0.4470, 0.7410])
     
        plot(0:hor-1,tmp_1(:,2),'--',...
            'LineWidth',linewidthval1,...
            'Color', [0, 0.4470, 0.7410])
        plot(0:hor-1,tmp_1(:,3),'--', ...
            'LineWidth',linewidthval1,...
            'Color', [0, 0.4470, 0.7410])
        
        hold off
        
        ylim([0,1])
        xlim([0,irf_fev_hor])
        ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
        
        title(fig_labels_5fac_1(ishock),'fontsize',fonts1)

        if ishock==1
            ylabel(y1listtable{iy},'fontsize',fonts1)
        end
    end
    
    tmp=fevd_1(:,[1,2,3],:);
    tmp=reshape(sum(tmp,2),N,size(fevd_1,3));
    fevd_comp123_1=tmp(ind_y1(iy),:)';
    fevd_se_comp123_1=se_fevd_3shocks_combined_1(ind_y1(iy),:)';
    
    tmp=fevd_2(:,[1,2,3],:);
    tmp=reshape(sum(tmp,2),N,size(fevd_2,3));
    fevd_comp123_2=tmp(ind_y1(iy),:)';
    fevd_se_comp123_2=se_fevd_3shocks_combined_2(ind_y1(iy),:)';       
    
    nexttile
    
    tmp_1=[fevd_comp123_1,fevd_comp123_1-fevd_se_comp123_1,fevd_comp123_1+fevd_se_comp123_1];
    tmp_2=[fevd_comp123_2,fevd_comp123_2-fevd_se_comp123_2,fevd_comp123_2+fevd_se_comp123_2];
    
    hold on
    
	patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2(:,2)', fliplr(tmp_2(:,3)')],...
            [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none')       
    p2=plot(0:hor-1,tmp_2(:,1),'-',...
        'LineWidth',linewidthval1,...
        'Color', 'k');    
    
    p1=plot(0:hor-1,tmp_1(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
 
    plot(0:hor-1,tmp_1(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_1(:,3),'--', ...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title({'Level, Slope'; 'and Yield News'},'fontsize',fonts1)
    
    if iy==length(ind_y1)
        legend([p1 p2],{'Only-yields model','Macro-yields model'},...
            'location','best','fontsize',fonts2)
    end    
    
    
end


%------ canonical correlations of the shocks identified from the two models
resid_oy=fac_est_out_1.varout.resid;
levelshock_my=irf_fevd_out_2.eps_structural(:,1);
slopeshock_my=irf_fevd_out_2.eps_structural(:,2);
newsshock_my=irf_fevd_out_2.eps_structural(:,3);
indtmp=isnan(sum([newsshock_my,resid_oy],2))==0;
[~,~,ccorr1]=canoncorr(levelshock_my(indtmp==1),resid_oy(indtmp==1,:));
[~,~,ccorr2]=canoncorr(newsshock_my(indtmp==1),resid_oy(indtmp==1,:));
[~,~,ccorr3]=canoncorr(slopeshock_my(indtmp==1),resid_oy(indtmp==1,:));


% *********************************************************************
% Figure 1 -- Scatter plots of each shock estimated in the two model 
% specifications
% *********************************************************************
fig1_2=figure;
set(gcf,'position',[360,180,560,200])
tiledlayout(1,3,'Padding','Compact');
tmp1=irf_fevd_out_1.eps_structural;
tmp2=irf_fevd_out_2.eps_structural;
nexttile;
scatter(tmp1(indtmp==1,1),tmp2(indtmp==1,1),8,...
    'MarkerEdgeColor',[0, 0.4470, 0.7410])
refline
title('Level Shock','fontsize',fonts1);
xlabel('only-yields model','fontsize',fonts1)
ylabel('macro-yields model','fontsize',fonts1)
xlim([-6,6])
ylim([-6,6])
ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
corrmat=corr([tmp1(indtmp==1,1),tmp2(indtmp==1,1)]);
text(-2.5,-5,sprintf('correlation = %.2f',corrmat(1,2)),'fontsize',fonts1-1)
    
nexttile;
scatter(tmp1(indtmp==1,2),tmp2(indtmp==1,2),8,...
    'MarkerEdgeColor',[0, 0.4470, 0.7410])
refline
title('Slope Shock','fontsize',fonts1)
xlabel('only-yields model','fontsize',fonts1)
ylabel('macro-yields model','fontsize',fonts1)
xlim([-6,6])
ylim([-6,6])
ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
corrmat=corr([tmp1(indtmp==1,2),tmp2(indtmp==1,2)]);
text(-2.5,-5,sprintf('correlation = %.2f',corrmat(1,2)),'fontsize',fonts1-1)


nexttile;
scatter(tmp1(indtmp==1,3),tmp2(indtmp==1,3),8,...
    'MarkerEdgeColor',[0, 0.4470, 0.7410])
refline
title('Yield News Shock','fontsize',fonts1)
xlabel('only-yields model','fontsize',fonts1)
ylabel('macro-yields model','fontsize',fonts1)
xlim([-6,6])
ylim([-6,6])
ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
corrmat=corr([tmp1(indtmp==1,3),tmp2(indtmp==1,3)]);
text(-2.5,-5,sprintf('correlation = %.2f',corrmat(1,2)),'fontsize',fonts1-1)


% *********************************************************************
% Figure 2 -- IRFs and FEVDs of yields and their components to yield shocks
% *********************************************************************

names_y2={'YIELD24';...
    'ACMRNY02';...
    'ACMTP02'};
ind_y2=nan(length(names_y2),1);
for i=1:length(names_y2)
    ind_y2(i)=find(ismember(name_vec,names_y2(i))==1);    
end


names_y10={'YIELD120';...
    'ACMRNY10';...
    'ACMTP10'};
ind_y10=nan(length(names_y10),1);
for i=1:length(names_y10)
    ind_y10(i)=find(ismember(name_vec,names_y10(i))==1);    
end

varnamesfigure={'Yield';...
    {'Expected Short Rate';...
    'Component'};...
    {'Term Premium';...
    'Component'}};

shocknamesfigure={'Level Shock';'Slope Shock';'Yield News Shock'};

fig2_1=figure;
tiledlayout(3,3,'Padding','Compact');
for i=1:3
	irf_2y=reshape(imp_2(ind_y2(1),i,:),hor,1);
    irf_se_2y=reshape(se_imp_2(ind_y2(1),i,:),hor,1);
    
	irf_2y_rn=reshape(imp_2(ind_y2(2),i,:),hor,1);
    irf_se_2y_rn=reshape(se_imp_2(ind_y2(2),i,:),hor,1);
    
	irf_2y_tp=reshape(imp_2(ind_y2(3),i,:),hor,1);
    irf_se_2y_tp=reshape(se_imp_2(ind_y2(3),i,:),hor,1);    

	irf_10y=reshape(imp_2(ind_y10(1),i,:),hor,1);
    irf_se_10y=reshape(se_imp_2(ind_y10(1),i,:),hor,1);
    
	irf_10y_rn=reshape(imp_2(ind_y10(2),i,:),hor,1);
    irf_se_10y_rn=reshape(se_imp_2(ind_y10(2),i,:),hor,1);
    
	irf_10y_tp=reshape(imp_2(ind_y10(3),i,:),hor,1);
    irf_se_10y_tp=reshape(se_imp_2(ind_y10(3),i,:),hor,1);  
    
    tmp_2y=[irf_2y,irf_2y-irf_se_2y,irf_2y+irf_se_2y];
    tmp_2y_rn=[irf_2y_rn,irf_2y_rn-irf_se_2y_rn,irf_2y_rn+irf_se_2y_rn];
    tmp_2y_tp=[irf_2y_tp,irf_2y_tp-irf_se_2y_tp,irf_2y_tp+irf_se_2y_tp];
    
    tmp_10y=[irf_10y,irf_10y-irf_se_10y,irf_10y+irf_se_10y];
    tmp_10y_rn=[irf_10y_rn,irf_10y_rn-irf_se_10y_rn,irf_10y_rn+irf_se_10y_rn];
    tmp_10y_tp=[irf_10y_tp,irf_10y_tp-irf_se_10y_tp,irf_10y_tp+irf_se_10y_tp];    
    
    nexttile
	hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2y(:,2)', fliplr(tmp_2y(:,3)')],...
        [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none');
    plot(0:hor-1,tmp_2y(:,1),...
        'LineWidth',linewidthval1,...
        'Color', 'k');
    
    plot(0:hor-1,tmp_10y(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);    
    plot(0:hor-1,tmp_10y(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_10y(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0, 0.4470, 0.7410]);        
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    hold off
    xlim([0,irf_fev_hor])
    title(varnamesfigure{1},'fontsize',fonts1)
    ylabel(shocknamesfigure{i},'fontsize',fonts1)    
    if i==1
        ylim([-.35,.05])
    elseif i==2
        ylim([-.5,.25])
    else
        ylim([-.35,.05])
    end
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;

    
    nexttile
    hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2y_rn(:,2)', fliplr(tmp_2y_rn(:,3)')],...
        [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none');
    plot(0:hor-1,tmp_2y_rn(:,1),...
        'LineWidth',linewidthval1,...
        'Color', 'k');

    
    plot(0:hor-1,tmp_10y_rn(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);    
    plot(0:hor-1,tmp_10y_rn(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_10y_rn(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0, 0.4470, 0.7410]);        
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    hold off
    xlim([0,irf_fev_hor])
    title(varnamesfigure{2},'fontsize',fonts1)
    ylabel(shocknamesfigure{i},'fontsize',fonts1)     
    if i==1
        ylim([-.35,.05])
    elseif i==2
        ylim([-.5,.25])
    else
        ylim([-.35,.05])
    end
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;

    
    nexttile
    hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2y_tp(:,2)', fliplr(tmp_2y_tp(:,3)')],...
        [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none');
    p1=plot(0:hor-1,tmp_2y_tp(:,1),...
        'LineWidth',linewidthval1,...
        'Color', 'k');
    
    p2=plot(0:hor-1,tmp_10y_tp(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);    
    plot(0:hor-1,tmp_10y_tp(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_10y_tp(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0, 0.4470, 0.7410]);      
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    hold off
    xlim([0,irf_fev_hor])
    title(varnamesfigure{3},'fontsize',fonts1)
    ylabel(shocknamesfigure{i},'fontsize',fonts1)   
    if i==1
        ylim([-.1,.1]) 
    elseif i==2
        ylim([-.1,.5])
    else 
        ylim([-.1,.1])
    end
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;    

    if i==3
        legend([p1,p2],{'Maturity 2 Years',...
            'Maturity 10 Years'},'location','northeast','fontsize',fonts2)
    end
    
end



fig2_2=figure;
tiledlayout(3,3,'Padding','Compact');
for i=1:3
	fevd_2y=reshape(fevd_2(ind_y2(1),i,:),hor,1);
    fevd_se_2y=reshape(se_fevd_2(ind_y2(1),i,:),hor,1);
    
	fevd_2y_rn=reshape(fevd_2(ind_y2(2),i,:),hor,1);
    fevd_se_2y_rn=reshape(se_fevd_2(ind_y2(2),i,:),hor,1);
    
	fevd_2y_tp=reshape(fevd_2(ind_y2(3),i,:),hor,1);
    fevd_se_2y_tp=reshape(se_fevd_2(ind_y2(3),i,:),hor,1);    

	fevd_10y=reshape(fevd_2(ind_y10(1),i,:),hor,1);
    fevd_se_10y=reshape(se_fevd_2(ind_y10(1),i,:),hor,1);
    
	fevd_10y_rn=reshape(fevd_2(ind_y10(2),i,:),hor,1);
    fevd_se_10y_rn=reshape(se_fevd_2(ind_y10(2),i,:),hor,1);
    
	fevd_10y_tp=reshape(fevd_2(ind_y10(3),i,:),hor,1);
    fevd_se_10y_tp=reshape(se_fevd_2(ind_y10(3),i,:),hor,1);  
    
    tmp_2y=[fevd_2y,fevd_2y-fevd_se_2y,fevd_2y+fevd_se_2y];
    tmp_2y_rn=[fevd_2y_rn,fevd_2y_rn-fevd_se_2y_rn,fevd_2y_rn+fevd_se_2y_rn];
    tmp_2y_tp=[fevd_2y_tp,fevd_2y_tp-fevd_se_2y_tp,fevd_2y_tp+fevd_se_2y_tp];
    
    tmp_10y=[fevd_10y,fevd_10y-fevd_se_10y,fevd_10y+fevd_se_10y];
    tmp_10y_rn=[fevd_10y_rn,fevd_10y_rn-fevd_se_10y_rn,fevd_10y_rn+fevd_se_10y_rn];
    tmp_10y_tp=[fevd_10y_tp,fevd_10y_tp-fevd_se_10y_tp,fevd_10y_tp+fevd_se_10y_tp];    
    
    nexttile
	hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2y(:,2)', fliplr(tmp_2y(:,3)')],...
        [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none');
    plot(0:hor-1,tmp_2y(:,1),...
        'LineWidth',linewidthval1,...
        'Color', 'k');

    
    plot(0:hor-1,tmp_10y(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);    
    plot(0:hor-1,tmp_10y(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_10y(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0, 0.4470, 0.7410]);        
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    hold off
    xlim([0,irf_fev_hor])
    title(varnamesfigure{1},'fontsize',fonts1)
    ylabel(shocknamesfigure{i},'fontsize',fonts1)    
    ylim([0,1])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    nexttile
    hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2y_rn(:,2)', fliplr(tmp_2y_rn(:,3)')],...
        [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none');
    plot(0:hor-1,tmp_2y_rn(:,1),...
        'LineWidth',linewidthval1,...
        'Color', 'k');

    
    plot(0:hor-1,tmp_10y_rn(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);    
    plot(0:hor-1,tmp_10y_rn(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_10y_rn(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0, 0.4470, 0.7410]);        
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    hold off
    xlim([0,irf_fev_hor])
    title(varnamesfigure{2},'fontsize',fonts1)
    ylabel(shocknamesfigure{i},'fontsize',fonts1)     
    ylim([0,1])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    
    nexttile
    hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_2y_tp(:,2)', fliplr(tmp_2y_tp(:,3)')],...
        [0.5 0.5 0.5], 'FaceAlpha',0.5, 'EdgeColor','none');
    p1=plot(0:hor-1,tmp_2y_tp(:,1),...
        'LineWidth',linewidthval1,...
        'Color', 'k');

    
    p2=plot(0:hor-1,tmp_10y_tp(:,1),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);    
    plot(0:hor-1,tmp_10y_tp(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_10y_tp(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color',[0, 0.4470, 0.7410]);      
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])    
    hold off
    xlim([0,irf_fev_hor])
    title(varnamesfigure{3},'fontsize',fonts1)
    ylabel(shocknamesfigure{i},'fontsize',fonts1)   
    ylim([0,1])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;

    if i==3
        legend([p1,p2],{'Maturity 2 Years',...
            'Maturity 10 Years'},'location','northeast','fontsize',fonts2)
    end
    
end


% *********************************************************************
% Figure 3 -- IRFs and FEVDs of financial market indicators to yield shocks
% *********************************************************************
varlist={'YIELD24';...
    'ML MOVE 1M BOND VOLATILITY INDEX - PRICE INDEX';...   
    'GZ - excess bond premium'    
    'S&P 500';...
    'VXOCLSx';...
    'RVol'};


varlistfigure={'2-Year Yield'
    {'MOVE 1-Month Bond Volatility'};...      
    'GZ - Excess Bond Premium'
    'S&P 500';...
    'VXO';...
    'Realized Volatility'};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

fig3_1=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_2_level=reshape(imp_2(varind(iy),1,:),hor,1);
    irf_se_mat_2_level=reshape(se_imp_2(varind(iy),1,:),hor,1);
   
	irf_mat_2_slope=reshape(imp_2(varind(iy),2,:),hor,1);
    irf_se_mat_2_slope=reshape(se_imp_2(varind(iy),2,:),hor,1);        

	irf_mat_2_news=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_2_news=reshape(se_imp_2(varind(iy),3,:),hor,1);        

    nexttile
   
    tmp_1=[irf_mat_2_level,irf_mat_2_level-irf_se_mat_2_level,irf_mat_2_level+irf_se_mat_2_level];
    tmp_2=[irf_mat_2_slope,irf_mat_2_slope-irf_se_mat_2_slope,irf_mat_2_slope+irf_se_mat_2_slope];
    tmp_3=[irf_mat_2_news,irf_mat_2_news-irf_se_mat_2_news,irf_mat_2_news+irf_se_mat_2_news];
    
    hold on
    

    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_3(:,2)', fliplr(tmp_3(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')        
    p3=plot(0:hor-1,tmp_3(:,1),...
        'LineWidth',linewidthval1,...
        'Color', [1, 0, 0]);    
    
    
    p1=plot(0:hor-1,tmp_1(:,1),...
        'LineWidth',linewidthval1,...
        'Color', [0, 0, 1]);  
    plot(0:hor-1,tmp_1(:,2),'-.',...
        'LineWidth',linewidthval2,...
        'Color', [0, 0, 1]);
    plot(0:hor-1,tmp_1(:,3),'-.',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 1]);    


    p2=plot(0:hor-1,tmp_2(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[0, 0, 0]);
    plot(0:hor-1,tmp_2(:,2),'--',...
        'LineWidth',linewidthval2,...
        'Color', [0, 0, 0])
    plot(0:hor-1,tmp_2(:,3),'--',...
        'LineWidth',linewidthval2,...
        'Color', [0, 0, 0])  
    



    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    if iy==2 
    ylabel('Standard deviation','fontsize',fonts1)    
    else
    ylabel('Percent','fontsize',fonts1)
    end
    
    
    title(varlistfigure{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p1,p2,p3],{'Level Shock',...
            'Slope Shock',...
            'Yield News Shock'},'location','east','fontsize',fonts2)        
    end       
    
end


fig3_2=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_2_level=reshape(fevd_2(varind(iy),1,:),hor,1);
    fevd_se_mat_2_level=reshape(se_fevd_2(varind(iy),1,:),hor,1);

	fevd_mat_2_slope=reshape(fevd_2(varind(iy),2,:),hor,1);
    fevd_se_mat_2_slope=reshape(se_fevd_2(varind(iy),2,:),hor,1);     

	fevd_mat_2_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_2_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);     
    
    nexttile
    
    tmp_1=[fevd_mat_2_level,fevd_mat_2_level-fevd_se_mat_2_level,fevd_mat_2_level+fevd_se_mat_2_level];
    tmp_2=[fevd_mat_2_slope,fevd_mat_2_slope-fevd_se_mat_2_slope,fevd_mat_2_slope+fevd_se_mat_2_slope];
    tmp_3=[fevd_mat_2_news,fevd_mat_2_news-fevd_se_mat_2_news,fevd_mat_2_news+fevd_se_mat_2_news];
    
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_3(:,2)', fliplr(tmp_3(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')        
    p3=plot(0:hor-1,tmp_3(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[1, 0, 0]);    
    
    p1=plot(0:hor-1,tmp_1(:,1),...
        'LineWidth',linewidthval1,...
        'Color', [0, 0, 1]);
    plot(0:hor-1,tmp_1(:,2),'-.',...
        'LineWidth',linewidthval2,...
        'Color', [0, 0, 1]);
    plot(0:hor-1,tmp_1(:,3),'-.',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 1]);  
    

    p2=plot(0:hor-1,tmp_2(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[0, 0, 0]);
    plot(0:hor-1,tmp_2(:,2),'--',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 0])
    plot(0:hor-1,tmp_2(:,3),'--',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 0])  
 
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
	title(varlistfigure{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p1,p2,p3],{'Level Shock',...
            'Slope Shock',...
            'Yield News Shock'},'location','east','fontsize',fonts2)        
    end
end



% *********************************************************************
% Figure 4 -- IRFs and FEVDs of macroeconomic variables to yield shocks
% *********************************************************************
varlist={'INDPRO';...
    'PAYEMS';...    
    'DPCERA3M086SBEA';...    
    'USSLIND';...
    'HOUST';...
    'CLAIMSx'    
    'CPIAUCSL';...   
    'FEDFUNDS';...
    'TB3SAvg'};
  
varlistfigure={'IP';...
    'Nonfarm Payroll';...      
    {'Personal Consumption';...
    'Expenditures'};...
    'Philadelphia Leading Indicator';...
    'Housing Starts';...
    'Initial Claims';...
    'CPI Inflation';...        
    'Federal Funds Rate';...
    {'3-Month Treasury Rate';...
    'Survey Forecast'}};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

fig4_1=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_2_level=reshape(imp_2(varind(iy),1,:),hor,1);
    irf_se_mat_2_level=reshape(se_imp_2(varind(iy),1,:),hor,1);

	irf_mat_2_slope=reshape(imp_2(varind(iy),2,:),hor,1);
    irf_se_mat_2_slope=reshape(se_imp_2(varind(iy),2,:),hor,1);      
    
	irf_mat_2_news=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_2_news=reshape(se_imp_2(varind(iy),3,:),hor,1);    
      
    nexttile
    
    tmp_1=[irf_mat_2_level,irf_mat_2_level-irf_se_mat_2_level,irf_mat_2_level+irf_se_mat_2_level];
    tmp_2=[irf_mat_2_slope,irf_mat_2_slope-irf_se_mat_2_slope,irf_mat_2_slope+irf_se_mat_2_slope];    
    tmp_3=[irf_mat_2_news,irf_mat_2_news-irf_se_mat_2_news,irf_mat_2_news+irf_se_mat_2_news];
    
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_3(:,2)', fliplr(tmp_3(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')   
    p3=plot(0:hor-1,tmp_3(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[1, 0, 0]);    
    
    
    p1=plot(0:hor-1,tmp_1(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[0, 0, 1]);
    plot(0:hor-1,tmp_1(:,2),'-.',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 1]);
    plot(0:hor-1,tmp_1(:,3),'-.',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 1]);    


    p2=plot(0:hor-1,tmp_2(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[0, 0, 0]);
    plot(0:hor-1,tmp_2(:,2),'--',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 0])
    plot(0:hor-1,tmp_2(:,3),'--',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 0])  
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist(iy),{'CPIAUCSL'})==1
        ylim(infirfylim)
    end 
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)

    ylabel('Percent','fontsize',fonts1)    
    
    if iy==length(varind)
        legend([p1,p2,p3],{'Level Shock',...
            'Slope Shock',...
            'Yield News Shock'},'location','best','fontsize',fonts2)        
    end       
    
end


fig4_2=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_1_level=reshape(fevd_2(varind(iy),1,:),hor,1);
    fevd_se_mat_1_level=reshape(se_fevd_2(varind(iy),1,:),hor,1);

	fevd_mat_1_slope=reshape(fevd_2(varind(iy),2,:),hor,1);
    fevd_se_mat_1_slope=reshape(se_fevd_2(varind(iy),2,:),hor,1);      
    
	fevd_mat_1_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_1_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    
    
    nexttile
    
    tmp_1=[fevd_mat_1_level,fevd_mat_1_level-fevd_se_mat_1_level,fevd_mat_1_level+fevd_se_mat_1_level];
	tmp_2=[fevd_mat_1_slope,fevd_mat_1_slope-fevd_se_mat_1_slope,fevd_mat_1_slope+fevd_se_mat_1_slope];
    tmp_3=[fevd_mat_1_news,fevd_mat_1_news-fevd_se_mat_1_news,fevd_mat_1_news+fevd_se_mat_1_news];
    
    hold on
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_3(:,2)', fliplr(tmp_3(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')       
    p3=plot(0:hor-1,tmp_3(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[1, 0, 0]);    
    
    
    p1=plot(0:hor-1,tmp_1(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[0, 0, 1]);
    plot(0:hor-1,tmp_1(:,2),'-.',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 1]);
    plot(0:hor-1,tmp_1(:,3),'-.',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 1]);  
    

    p2=plot(0:hor-1,tmp_2(:,1),...
        'LineWidth',linewidthval1,...
        'Color',[0, 0, 0]);
    plot(0:hor-1,tmp_2(:,2),'--',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 0])
    plot(0:hor-1,tmp_2(:,3),'--',...
        'LineWidth',linewidthval2,...
        'Color',[0, 0, 0])  

    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)    
    
    if iy==length(varind)
        legend([p1,p2,p3],{'Level Shock',...
            'Slope Shock',...
            'Yield News Shock'},'location','best','fontsize',fonts2)        
    end
end


%-------- save figures
saveas(fig1_1,sprintf('results/Fig1_fevds_model_comparison.eps'),'epsc')
saveas(fig1_1,sprintf('results/Fig1_fevds_model_comparison.pdf'),'pdf')
saveas(fig1_2,sprintf('results/Fig1_scatterplots_model_comparison.eps'),'epsc') 
saveas(fig1_2,sprintf('results/Fig1_scatterplots_model_comparison.pdf'),'pdf') 
saveas(fig2_1,sprintf('results/Fig2_irfs_yield_components.eps'),'epsc') 
saveas(fig2_1,sprintf('results/Fig2_irfs_yield_components.pdf'),'pdf') 
saveas(fig2_2,sprintf('results/Fig2_fevds_yield_components.eps'),'epsc') 
saveas(fig2_2,sprintf('results/Fig2_fevds_yield_components.pdf'),'pdf') 
saveas(fig3_1,sprintf('results/Fig3_irfs_financial_yield_shocks.eps'),'epsc') 
saveas(fig3_1,sprintf('results/Fig3_irfs_financial_yield_shocks.pdf'),'pdf') 
saveas(fig3_2,sprintf('results/Fig3_fevds_financial_yield_shocks.eps'),'epsc') 
saveas(fig3_2,sprintf('results/Fig3_fevds_financial_yield_shocks.pdf'),'pdf') 
saveas(fig4_1,sprintf('results/Fig4_irfs_macro_yield_shocks.eps'),'epsc') 
saveas(fig4_1,sprintf('results/Fig4_irfs_macro_yield_shocks.pdf'),'pdf') 
saveas(fig4_2,sprintf('results/Fig4_fevds_macro_yield_shocks.eps'),'epsc') 
saveas(fig4_2,sprintf('results/Fig4_fevds_macro_yield_shocks.pdf'),'pdf') 
