
%- Number of factors
r1=5; nfac.unobserved1 = r1;% number of the yield curve factors 
r2=8; nfac.unobserved2 = r2;% number of the macro factors estimated 
est_par.fac_par.w = [];     % don't use if all the factors are treated as unobserved -- here we treat all the factors as unobserved
nfac.observed = 0;          % number of observed factors
r = r1+r2; nfac.unobserved = r;
nfac.total = nfac.unobserved+nfac.observed;
est_par.fac_par.nfac = nfac;

%- Identification here is for level, slope and yield news shocks 
% First set horizon for max FEV share problem 
if m2q==0
    k_yield_news_shock=11;
else
    k_yield_news_shock=3;
end

% Target variables
m=[]; % Use when identification is for stock market volatility or business cycle news shocks 

identification_par=[];
identification_par.k_yield_news_shock=k_yield_news_shock; 
identification_par.m=m; % This contains index of target variables
identification_par.res_ynews=0; % Set to 1 when identification is for a residual yield news that is orthogonal to the realized volatility and business cycle news shocks

%- Note, scale of shocks set so that they each lead to the same peak decline of the two-year yield 
scl_par=[];
indstrvar=find(ismember(name_vec,{'YIELD24'})); 
scl_par.indstrvar=indstrvar; % This contains the index of the two-year yield

% horizon for IRFs and FEVDs
if m2q==0 
    hor=121;  
else 
    hor=41;  
end

%-- Construct estimates of factors
fac_est_out =factor_estimation_ls_full_simple(data,inclcode_vec,est_par);
fac_est_out.varout.coef.G0=fac_est_out.varout.coef.G;

%-- Construct estimates of IRFs and FEVDs
[Hy,H]=max_fev_share(fac_est_out,est_par,hor,tcode_vec,identification_par);
irf_fevd_out = irf_fevd_full(Hy,H,scl_par,fac_est_out,est_par,hor,tcode_vec,identification_par.res_ynews);  

%-- Compute SEs for IRFs and FEVDs
se_irf_vdecomp_out = se_irf_fevd(data,fac_est_out,est_par,...
    hor,identification_par,scl_par,n_rep,inclcode_vec,tcode_vec);
