
% *********************************************************************
% Table 2 -- OLS regressions of one-year change in Treasury yields on 
% lagged factors
% *********************************************************************
fac=fac_est_out_2.fac;
y_2 = data(:,ismember(name_vec,'YIELD24'));
y_5 = data(:,ismember(name_vec,'YIELD60'));
y_10 = data(:,ismember(name_vec,'YIELD120'));

nfac_vec=[3,5,13]; % vector of number of factors included in each regression

% OLS regressions ---- columns (1),(2) and (3) ---- two-year yield 
y = y_2;

bhat_mat=nan(13,3);
se_bhat_mat=nan(13,3);
rbarsq_vec=nan(1,3);
for ifac=1:length(nfac_vec)
    nf=nfac_vec(ifac);
    
    yreg = lag(y,-12)-y;
    
    % Construct matrix of controls
    xreg = [ones(T,1), fac(:,1:nf)];
    ismpl = isnan(sum([yreg,xreg],2));
    yreg = yreg(ismpl==0);
    xreg = xreg(ismpl==0,:);
    [bhat,se_bhat] = hac_simple(xreg,yreg,18);
    
    bhat_mat(1:nf,ifac)=bhat(2:end);
    se_bhat_mat(1:nf,ifac)=se_bhat(2:end);
    
    u=yreg-xreg*bhat;
    y_m = yreg - mean(yreg);
    tss = (yreg - mean(yreg))'*(yreg - mean(yreg));
    ess = u'*u;
    rbarsq = 1 - (ess/(size(xreg,1)-size(xreg,2)))/(tss/(size(xreg,1)-1));
    rbarsq_vec(ifac)=rbarsq;
end

bhat_mat_2=bhat_mat;
se_bhat_mat_2=se_bhat_mat;
rbarsq_vec_2=rbarsq_vec;


% OLS regressions ---- columns (4),(5) and (6) ---- five-year yield 
y = y_5;

bhat_mat=nan(13,3);
se_bhat_mat=nan(13,3);
rbarsq_vec=nan(1,3);
for ifac=1:length(nfac_vec)
    nf=nfac_vec(ifac);
    
    yreg = lag(y,-12)-y;
    
    % Construct matrix of controls
    xreg = [ones(T,1), fac(:,1:nf)];
    ismpl = isnan(sum([yreg,xreg],2));
    yreg = yreg(ismpl==0);
    xreg = xreg(ismpl==0,:);
    [bhat,se_bhat] = hac_simple(xreg,yreg,18);    
    
    bhat_mat(1:nf,ifac)=bhat(2:end);
    se_bhat_mat(1:nf,ifac)=se_bhat(2:end);
    
    u=yreg-xreg*bhat;
    y_m = yreg - mean(yreg);
    tss = (yreg - mean(yreg))'*(yreg - mean(yreg));
    ess = u'*u;
    rbarsq = 1 - (ess/(size(xreg,1)-size(xreg,2)))/(tss/(size(xreg,1)-1));
    rbarsq_vec(ifac)=rbarsq;
end

bhat_mat_5=bhat_mat;
se_bhat_mat_5=se_bhat_mat;
rbarsq_vec_5=rbarsq_vec;


% OLS regressions ---- columns (7),(8) and (9) ---- ten-year yield 
y = y_10;

bhat_mat=nan(13,3);
se_bhat_mat=nan(13,3);
rbarsq_vec=nan(1,3);
for ifac=1:length(nfac_vec)
    nf=nfac_vec(ifac);
    
    yreg = lag(y,-12)-y;
    
    % Construct matrix of controls
    xreg = [ones(T,1), fac(:,1:nf)];
    ismpl = isnan(sum([yreg,xreg],2));
    yreg = yreg(ismpl==0);
    xreg = xreg(ismpl==0,:);
    [bhat,se_bhat] = hac_simple(xreg,yreg,18);
    
    bhat_mat(1:nf,ifac)=bhat(2:end);
    se_bhat_mat(1:nf,ifac)=se_bhat(2:end);
    
    u=yreg-xreg*bhat;
    y_m = yreg - mean(yreg);
    tss = (yreg - mean(yreg))'*(yreg - mean(yreg));
    ess = u'*u;
    rbarsq = 1 - (ess/(size(xreg,1)-size(xreg,2)))/(tss/(size(xreg,1)-1));
    rbarsq_vec(ifac)=rbarsq;
end

bhat_mat_10=bhat_mat;
se_bhat_mat_10=se_bhat_mat;
rbarsq_vec_10=rbarsq_vec;

bhat_mat=[bhat_mat_2,bhat_mat_5,bhat_mat_10];
se_bhat_mat=[se_bhat_mat_2,se_bhat_mat_5,se_bhat_mat_10];
rbarsq_vec=[rbarsq_vec_2,rbarsq_vec_5,rbarsq_vec_10];


outfile_name = 'results/Table_2.csv';
fileID = fopen(outfile_name,'w');
fprintf(fileID,'OLS regressions of one-year change in Treasury yields on lagged factors \n\n');
fprintf(fileID,',2-year yield,,,5-year yield,,,10-year yield,, \n');
fprintf(fileID,',="(1)",="(2)",="(3)",="(4)",="(5)",="(6)",="(7)",="(8)",="(9)" \n');
fprintf(fileID,'F_Level,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f \n',...
    bhat_mat(1,:));
fprintf(fileID,',="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)" \n',...
    se_bhat_mat(1,:));
fprintf(fileID,'F_Slope,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f \n',...
    bhat_mat(2,:));
fprintf(fileID,',="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)" \n',...
    se_bhat_mat(2,:));
fprintf(fileID,'F_Curv,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f \n',...
    bhat_mat(3,:));
fprintf(fileID,',="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)",="(%2.2f)" \n',...
    se_bhat_mat(3,:));
fprintf(fileID,'F_Y4,,%2.2f,%2.2f,,%2.2f,%2.2f,,%2.2f,%2.2f \n',...
    bhat_mat(4,[2,3,5,6,8,9]));
fprintf(fileID,',,="(%2.2f)",="(%2.2f)",,="(%2.2f)",="(%2.2f)",,="(%2.2f)",="(%2.2f)" \n',...
    se_bhat_mat(4,[2,3,5,6,8,9]));
fprintf(fileID,'F_Y5,,%2.2f,%2.2f,,%2.2f,%2.2f,,%2.2f,%2.2f \n',...
    bhat_mat(5,[2,3,5,6,8,9]));
fprintf(fileID,',,="(%2.2f)",="(%2.2f)",,="(%2.2f)",="(%2.2f)",,="(%2.2f)",="(%2.2f)" \n',...
    se_bhat_mat(5,[2,3,5,6,8,9]));
fprintf(fileID,'F_Z1,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(6,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(6,[3,6,9]));
fprintf(fileID,'F_Z2,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(7,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(7,[3,6,9]));
fprintf(fileID,'F_Z3,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(8,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(8,[3,6,9]));
fprintf(fileID,'F_Z4,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(9,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(9,[3,6,9]));
fprintf(fileID,'F_Z5,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(10,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(10,[3,6,9]));
fprintf(fileID,'F_Z6,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(11,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(11,[3,6,9]));
fprintf(fileID,'F_Z7,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(12,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(12,[3,6,9]));
fprintf(fileID,'F_Z8,,,%2.2f,,,%2.2f,,,%2.2f \n',...
    bhat_mat(13,[3,6,9]));
fprintf(fileID,',,,="(%2.2f)",,,="(%2.2f)",,,="(%2.2f)" \n',...
    se_bhat_mat(13,[3,6,9]));
fprintf(fileID,'rbarsq,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f,%2.2f \n',...
    rbarsq_vec(:));


% *********************************************************************
% Table 3 -- Correlations among estimated shocks
% *********************************************************************
L=irf_fevd_out_2.eps_structural(:,1);
S=irf_fevd_out_2.eps_structural(:,2);
Y=irf_fevd_out_2.eps_structural(:,3);
VXO=irf_fevd_out_3.eps_structural(:,1);
RVol=irf_fevd_out_4.eps_structural(:,1);
BC=irf_fevd_out_5.eps_structural(:,1);
YP=irf_fevd_out_6.eps_structural(:,1);

shocksmat=[L S Y VXO RVol BC YP];    

corr_mat=corr(packr(shocksmat));

outfile_name = 'results/Table_3.csv';
fileID = fopen(outfile_name,'w');
fprintf(fileID,'Correlations among estimated shocks \n\n');
fprintf(fileID,',L,S,Y,VXO,RVol,BC,YP \n');
fprintf(fileID,'Level Shock (L),%1.2f \n',...
    corr_mat(1,1));
fprintf(fileID,'Slope Shock (S),%1.2f,%1.2f \n',...
    corr_mat(2,1:2));
fprintf(fileID,'Yield News Shock (Y),%1.2f,%1.2f,%1.2f \n',...
    corr_mat(3,1:3));
fprintf(fileID,'Implied Volatility Shock (VXO),%1.2f,%1.2f,%1.2f,%1.2f \n',...
    corr_mat(4,1:4));
fprintf(fileID,'Realized Volatility Shock (RVol),%1.2f,%1.2f,%1.2f,%1.2f,%1.2f \n',...
    corr_mat(5,1:5));
fprintf(fileID,'Business Cycle News Shock (BC),%1.2f,%1.2f,%1.2f,%1.2f,%1.2f,%1.2f \n',...
    corr_mat(6,1:6));
fprintf(fileID,'Yield News Shock Purged of Realized Volatility & BC News (YP),%1.2f,%1.2f,%1.2f,%1.2f,%1.2f,%1.2f,%1.2f \n',...
    corr_mat(7,:));
