close all

irf_fev_hor=36;
fonts1=8;
fonts2=5;
fonts3=8;
linewidthval1=1;
tpirfylim=[-.2,.2];

imp_2=irf_fevd_out_2.imp_y_fac_mat_scl; se_imp_2=se_irf_vdecomp_out_2.se_imp_y_fac_mat_scl;
imp_5=irf_fevd_out_5.imp_y_fac_mat_scl; se_imp_5=se_irf_vdecomp_out_5.se_imp_y_fac_mat_scl;
fevd_2=irf_fevd_out_2.vfrac_y_comp_mat; se_fevd_2=se_irf_vdecomp_out_2.se_vfrac_y_comp_mat;
fevd_5=irf_fevd_out_5.vfrac_y_comp_mat; se_fevd_5=se_irf_vdecomp_out_5.se_vfrac_y_comp_mat;

% *********************************************************************
% Figure 9 -- IRFs and FEVDs of yields and their components to business cycle 
% news shock
% *********************************************************************
varlist={'YIELD24';...
    'ACMRNY02';...
    'ACMTP02';...    
    'YIELD120';...
    'ACMRNY10';...
    'ACMTP10'};
varlistfigure={'2-Year Yield';...
    {'Risk-Neutral';...
    '2-Year Yield'};...
    {'2-Year Yield';...
    'Term Premium'};...    
    '10-Year Yield';...
    {'Risk-Neutral';...
    '10-Year Yield'};...
    {'10-Year Yield';...
    'Term Premium'}};
varind=nan(length(varlist),1);
for i=1:length(varlist)
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

ylabelvec={'Percent','Percent','Percent','Percent','Percent','Percent'};

legendvec={'Yield News Shock',...
    'Business Cycle News Shock'};    

fig9_1=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_ynews=reshape(se_imp_2(varind(iy),3,:),hor,1);    
   
	irf_mat_bcnews=reshape(imp_5(varind(iy),1,:),hor,1);
    irf_se_mat_bcnews=reshape(se_imp_5(varind(iy),1,:),hor,1);        
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_ynews,irf_mat_ynews+irf_se_mat_ynews];
    tmp_bcnews=[irf_mat_bcnews,irf_mat_bcnews-irf_se_mat_bcnews,irf_mat_bcnews+irf_se_mat_bcnews];    
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_bcnews(:,2)', fliplr(tmp_bcnews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')          
    p_bcnews=plot(0:hor-1,tmp_bcnews(:,1),'-','LineWidth',linewidthval1,'Color', [0.3922, 0.8314, 0.0745]);
 
    p_news=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist{iy},{'ACMTP02','ACMTP10'})
        ylim(tpirfylim)
    end
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(ylabelvec{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_news p_bcnews],legendvec,...
            'location','best','fontsize',fonts2)          
    end
end


fig9_2=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    

    fevd_mat_bcnews=reshape(fevd_5(varind(iy),1,:),hor,1);
    fevd_se_mat_bcnews=reshape(se_fevd_5(varind(iy),1,:),hor,1);        
    
    nexttile
    
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_bcnews=[fevd_mat_bcnews,fevd_mat_bcnews-fevd_se_mat_bcnews,fevd_mat_bcnews+fevd_se_mat_bcnews]; 
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_bcnews(:,2)', fliplr(tmp_bcnews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')    
    p_bcnews=plot(0:hor-1,tmp_bcnews(:,1),'-','LineWidth',linewidthval1,'Color', [0.3922, 0.8314, 0.0745]);
      
    p_news=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(' ','fontsize',fonts1)
    
    if iy==length(varind)     
        legend([p_news p_bcnews],legendvec,...
            'location','best','fontsize',fonts2)          
    end
end


% *********************************************************************
% Figure 10 -- IRFs and FEVDs of financial market indicators to business cycle 
% news shock
% *********************************************************************
varlist={'YIELD24';...
    'ML MOVE 1M BOND VOLATILITY INDEX - PRICE INDEX';...   
    'GZ - excess bond premium'    
    'S&P 500';...
    'VXOCLSx';...
    'RVol'};

varlistfigure={'2-Year Yield'
    {'MOVE 1-Month Bond Volatility'};...      
    'GZ - Excess Bond Premium'
    'S&P 500';...
    'VXO';...
    'Realized Volatility'};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

ylabelvec={'Percent','Standard deviation','Percent','Percent','Percent','Percent'};

fig10_1=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_ynews=reshape(se_imp_2(varind(iy),3,:),hor,1);    
   
	irf_mat_bcnews=reshape(imp_5(varind(iy),1,:),hor,1);
    irf_se_mat_bcnews=reshape(se_imp_5(varind(iy),1,:),hor,1);        
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_ynews,irf_mat_ynews+irf_se_mat_ynews];
    tmp_bcnews=[irf_mat_bcnews,irf_mat_bcnews-irf_se_mat_bcnews,irf_mat_bcnews+irf_se_mat_bcnews];    
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_bcnews(:,2)', fliplr(tmp_bcnews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')          
    p_bcnews=plot(0:hor-1,tmp_bcnews(:,1),'-','LineWidth',linewidthval1,'Color', [0.3922, 0.8314, 0.0745]);
 
    p_news=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist{iy},{'ACMTP02','ACMTP10'})
        ylim(tpirfylim)
    end
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(ylabelvec{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_news p_bcnews],legendvec,...
            'location','best','fontsize',fonts2)          
    end
end


fig10_2=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    

    fevd_mat_bcnews=reshape(fevd_5(varind(iy),1,:),hor,1);
    fevd_se_mat_bcnews=reshape(se_fevd_5(varind(iy),1,:),hor,1);        
    
    nexttile
    
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_bcnews=[fevd_mat_bcnews,fevd_mat_bcnews-fevd_se_mat_bcnews,fevd_mat_bcnews+fevd_se_mat_bcnews]; 
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_bcnews(:,2)', fliplr(tmp_bcnews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')    
    p_bcnews=plot(0:hor-1,tmp_bcnews(:,1),'-','LineWidth',linewidthval1,'Color', [0.3922, 0.8314, 0.0745]);
      
    p_news=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(' ','fontsize',fonts1)
    
    if iy==length(varind)     
        legend([p_news p_bcnews],legendvec,...
            'location','best','fontsize',fonts2)          
    end
end


% *********************************************************************
% Figure 11 -- IRFs and FEVDs of key macroeconomic indicators to business cycle 
% news shock
% *********************************************************************
varlist={'INDPRO';...
    'PAYEMS';...    
    'DPCERA3M086SBEA';...    
    'USSLIND';...
    'HOUST';...
    'CLAIMSx'    
    'CPIAUCSL';...   
    'FEDFUNDS';...
    'TB3SAvg'};
  
varlistfigure={'IP';...
    'Nonfarm Payroll';...      
    {'Personal Consumption';...
    'Expenditures'};...
    'Philadelphia Leading Indicator';...
    'Housing Starts';...
    'Initial Claims';...
    'CPI Inflation';...        
    'Federal Funds Rate';...
    {'3-Month Treasury Rate';...
    'Survey Forecast'}};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

ylabelvec={'Percent','Percent','Percent','Percent','Percent','Percent','Percent','Percent','Percent'};

fig11_1=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_ynews=reshape(se_imp_2(varind(iy),3,:),hor,1);    
   
	irf_mat_bcnews=reshape(imp_5(varind(iy),1,:),hor,1);
    irf_se_mat_bcnews=reshape(se_imp_5(varind(iy),1,:),hor,1);        
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_ynews,irf_mat_ynews+irf_se_mat_ynews];
    tmp_bcnews=[irf_mat_bcnews,irf_mat_bcnews-irf_se_mat_bcnews,irf_mat_bcnews+irf_se_mat_bcnews];    
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_bcnews(:,2)', fliplr(tmp_bcnews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')          
    p_bcnews=plot(0:hor-1,tmp_bcnews(:,1),'-','LineWidth',linewidthval1,'Color', [0.3922, 0.8314, 0.0745]);
 
    p_news=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist{iy},{'ACMTP02','ACMTP10'})
        ylim(tpirfylim)
    end
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(ylabelvec{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_news p_bcnews],legendvec,...
            'location','best','fontsize',fonts2)          
    end
end


fig11_2=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    

    fevd_mat_bcnews=reshape(fevd_5(varind(iy),1,:),hor,1);
    fevd_se_mat_bcnews=reshape(se_fevd_5(varind(iy),1,:),hor,1);        
    
    nexttile
    
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_bcnews=[fevd_mat_bcnews,fevd_mat_bcnews-fevd_se_mat_bcnews,fevd_mat_bcnews+fevd_se_mat_bcnews]; 
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_bcnews(:,2)', fliplr(tmp_bcnews(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')    
    p_bcnews=plot(0:hor-1,tmp_bcnews(:,1),'-','LineWidth',linewidthval1,'Color', [0.3922, 0.8314, 0.0745]);
      
    p_news=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(' ','fontsize',fonts1)
    
    if iy==length(varind)     
        legend([p_news p_bcnews],legendvec,...
            'location','best','fontsize',fonts2)          
    end
end


%-- save figures
saveas(fig9_1,sprintf('results/Fig9_irfs_yields_bc_news_shock.eps'),'epsc') 
saveas(fig9_1,sprintf('results/Fig9_irfs_yields_bc_news_shock.pdf'),'pdf') 
saveas(fig9_2,sprintf('results/Fig9_fevds_yields_bc_news_shock.eps'),'epsc') 
saveas(fig9_2,sprintf('results/Fig9_fevds_yields_bc_news_shock.pdf'),'pdf') 
saveas(fig10_1,sprintf('results/Fig10_irfs_financial_bc_news_shock.eps'),'epsc') 
saveas(fig10_1,sprintf('results/Fig10_irfs_financial_bc_news_shock.pdf'),'pdf') 
saveas(fig10_2,sprintf('results/Fig10_fevds_financial_bc_news_shock.eps'),'epsc') 
saveas(fig10_2,sprintf('results/Fig10_fevds_financial_bc_news_shock.pdf'),'pdf') 
saveas(fig11_1,sprintf('results/Fig11_irfs_macro_bc_news_shock.eps'),'epsc') 
saveas(fig11_1,sprintf('results/Fig11_irfs_macro_bc_news_shock.pdf'),'pdf') 
saveas(fig11_2,sprintf('results/Fig11_fevds_macro_bc_news_shock.eps'),'epsc') 
saveas(fig11_2,sprintf('results/Fig11_fevds_macro_bc_news_shock.pdf'),'pdf') 
