close all

irf_fev_hor=36;
fonts1=8;
fonts2=5;
fonts3=8;
linewidthval1=1;
tpirfylim=[-.2,.2];
N=size(name_vec,1);

imp_2=irf_fevd_out_2.imp_y_fac_mat_scl; se_imp_2=se_irf_vdecomp_out_2.se_imp_y_fac_mat_scl;
imp_3=irf_fevd_out_3.imp_y_fac_mat_scl; se_imp_3=se_irf_vdecomp_out_3.se_imp_y_fac_mat_scl;
imp_4=irf_fevd_out_4.imp_y_fac_mat_scl; se_imp_4=se_irf_vdecomp_out_4.se_imp_y_fac_mat_scl;
fevd_2=irf_fevd_out_2.vfrac_y_comp_mat; se_fevd_2=se_irf_vdecomp_out_2.se_vfrac_y_comp_mat;
fevd_3=irf_fevd_out_3.vfrac_y_comp_mat; se_fevd_3=se_irf_vdecomp_out_3.se_vfrac_y_comp_mat;
fevd_4=irf_fevd_out_4.vfrac_y_comp_mat; se_fevd_4=se_irf_vdecomp_out_4.se_vfrac_y_comp_mat;

% *********************************************************************
% Figure 6 -- IRFs and FEVDs of financial market indicators to realized and 
% implied volatility shocks
% *********************************************************************
varlist={'YIELD24';...
    'ML MOVE 1M BOND VOLATILITY INDEX - PRICE INDEX';...   
    'GZ - excess bond premium'    
    'S&P 500';...
    'VXOCLSx';...
    'RVol'};

varlistfigure={'2-Year Yield'
    {'MOVE 1-Month Bond Volatility'};...      
    'GZ - Excess Bond Premium'
    'S&P 500';...
    'VXO';...
    'Realized Volatility'};
NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

ylabelvec={'Percent','Standard deviation','Percent','Percent','Percent','Percent'};

legendvec={'Yield News Shock',...
    'Realized Volatility Shock',...
    'Implied Volatility Shock'};   

fig6_1=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_news=reshape(se_imp_2(varind(iy),3,:),hor,1);    

    irf_mat_vxo=reshape(imp_3(varind(iy),1,:),hor,1);
    irf_se_mat_vxo=reshape(se_imp_3(varind(iy),1,:),hor,1);     
    
	irf_mat_rvol=reshape(imp_4(varind(iy),1,:),hor,1);
    irf_se_mat_rvol=reshape(se_imp_4(varind(iy),1,:),hor,1);       
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_news,irf_mat_ynews+irf_se_mat_news];
    tmp_vxo=[irf_mat_vxo,irf_mat_vxo-irf_se_mat_vxo,irf_mat_vxo+irf_se_mat_vxo];
    tmp_rv=[irf_mat_rvol,irf_mat_rvol-irf_se_mat_rvol,irf_mat_rvol+irf_se_mat_rvol];
        
    hold on

    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_vxo(:,2)', fliplr(tmp_vxo(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')       
    p_vxo=plot(0:hor-1,tmp_vxo(:,1),'-','LineWidth',linewidthval1,...
        'Color', [0.75, 0, 0.75]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    p_rvol=plot(0:hor-1,tmp_rv(:,1),'--','LineWidth',linewidthval1,'Color',...
        [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_rv(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_rv(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])      
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist{iy},{'ACMTP02','ACMTP10'})
        ylim(tpirfylim)
    end
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(ylabelvec{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_ynews p_rvol p_vxo],legendvec,...
            'location','best','fontsize',fonts2)                         
    end
end


fig6_2=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    

    fevd_mat_vxo=reshape(fevd_3(varind(iy),1,:),hor,1);
    fevd_se_mat_vxo=reshape(se_fevd_3(varind(iy),1,:),hor,1);     
    
	fevd_mat_rvol=reshape(fevd_4(varind(iy),1,:),hor,1);
    fevd_se_mat_rvol=reshape(se_fevd_4(varind(iy),1,:),hor,1);       
    
    nexttile
    
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_vxo=[fevd_mat_vxo,fevd_mat_vxo-fevd_se_mat_vxo,fevd_mat_vxo+fevd_se_mat_vxo];
    tmp_rvol=[fevd_mat_rvol,fevd_mat_rvol-fevd_se_mat_rvol,fevd_mat_rvol+fevd_se_mat_rvol];
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_vxo(:,2)', fliplr(tmp_vxo(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')  
    p_vxo=plot(0:hor-1,tmp_vxo(:,1),'-','LineWidth',linewidthval1,...
        'Color', [0.75, 0, 0.75]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    p_rvol=plot(0:hor-1,tmp_rvol(:,1),'--','LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_rvol(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_rvol(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])   
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(' ','fontsize',fonts1)
    
    if iy==length(varind)     
        legend([p_ynews p_rvol p_vxo],legendvec,...
            'location','best','fontsize',fonts2)                  
    end
end

% *********************************************************************
% Figure 7 -- IRFs and FEVDs of yields and their components to realized and 
% implied volatility shocks
% *********************************************************************
varlist={'YIELD24';...
    'ACMRNY02';...
    'ACMTP02';...    
    'YIELD120';...
    'ACMRNY10';...
    'ACMTP10'};
varlistfigure={'2-Year Yield';...
    {'Risk-Neutral';...
    '2-Year Yield'};...
    {'2-Year Yield';...
    'Term Premium'};...    
    '10-Year Yield';...
    {'Risk-Neutral';...
    '10-Year Yield'};...
    {'10-Year Yield';...
    'Term Premium'}};
varind=nan(length(varlist),1);
for i=1:length(varlist)
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

ylabelvec={'Percent','Percent','Percent','Percent','Percent','Percent'};

fig7_1=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_news=reshape(se_imp_2(varind(iy),3,:),hor,1);    

    irf_mat_vxo=reshape(imp_3(varind(iy),1,:),hor,1);
    irf_se_mat_vxo=reshape(se_imp_3(varind(iy),1,:),hor,1);     
    
	irf_mat_rvol=reshape(imp_4(varind(iy),1,:),hor,1);
    irf_se_mat_rvol=reshape(se_imp_4(varind(iy),1,:),hor,1);       
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_news,irf_mat_ynews+irf_se_mat_news];
    tmp_vxo=[irf_mat_vxo,irf_mat_vxo-irf_se_mat_vxo,irf_mat_vxo+irf_se_mat_vxo];
    tmp_rv=[irf_mat_rvol,irf_mat_rvol-irf_se_mat_rvol,irf_mat_rvol+irf_se_mat_rvol];
        
    hold on

    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_vxo(:,2)', fliplr(tmp_vxo(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')       
    p_vxo=plot(0:hor-1,tmp_vxo(:,1),'-','LineWidth',linewidthval1,...
        'Color', [0.75, 0, 0.75]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    p_rvol=plot(0:hor-1,tmp_rv(:,1),'--','LineWidth',linewidthval1,'Color',...
        [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_rv(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_rv(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])      
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist{iy},{'ACMTP02','ACMTP10'})
        ylim(tpirfylim)
    end
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(ylabelvec{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_ynews p_rvol p_vxo],legendvec,...
            'location','best','fontsize',fonts2)                         
    end
end


fig7_2=figure;
tiledlayout(2,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    

    fevd_mat_vxo=reshape(fevd_3(varind(iy),1,:),hor,1);
    fevd_se_mat_vxo=reshape(se_fevd_3(varind(iy),1,:),hor,1);     
    
	fevd_mat_rvol=reshape(fevd_4(varind(iy),1,:),hor,1);
    fevd_se_mat_rvol=reshape(se_fevd_4(varind(iy),1,:),hor,1);       
    
    nexttile
    
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_vxo=[fevd_mat_vxo,fevd_mat_vxo-fevd_se_mat_vxo,fevd_mat_vxo+fevd_se_mat_vxo];
    tmp_rvol=[fevd_mat_rvol,fevd_mat_rvol-fevd_se_mat_rvol,fevd_mat_rvol+fevd_se_mat_rvol];
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_vxo(:,2)', fliplr(tmp_vxo(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')  
    p_vxo=plot(0:hor-1,tmp_vxo(:,1),'-','LineWidth',linewidthval1,...
        'Color', [0.75, 0, 0.75]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    p_rvol=plot(0:hor-1,tmp_rvol(:,1),'--','LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_rvol(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_rvol(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])   
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(' ','fontsize',fonts1)
    
    if iy==length(varind)     
        legend([p_ynews p_rvol p_vxo],legendvec,...
            'location','best','fontsize',fonts2)                  
    end
end


% *********************************************************************
% Figure 8 -- IRFs and FEVDs of macroeconomic variables to realized and 
% implied volatility shocks
% *********************************************************************
varlist={'INDPRO';...
    'PAYEMS';...    
    'DPCERA3M086SBEA';...    
    'USSLIND';...
    'HOUST';...
    'CLAIMSx'    
    'CPIAUCSL';...   
    'FEDFUNDS';...
    'TB3SAvg'};

varlistfigure={'IP';...
    'Nonfarm Payroll';...      
    {'Personal Consumption';...
    'Expenditures'};...
    'Philadelphia Leading Indicator';...
    'Housing Starts';...
    'Initial Claims';...
    'CPI Inflation';...        
    'Federal Funds Rate';...
    {'3-Month Treasury Rate';...
    'Survey Forecast'}};

NM=length(varlist);

varind=nan(NM,1);
for i=1:NM
    varind(i)=find(ismember(name_vec,varlist(i))==1);    
end

ylabelvec={'Percent','Percent','Percent','Percent','Percent','Percent','Percent','Percent','Percent'};

fig8_1=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	irf_mat_ynews=reshape(imp_2(varind(iy),3,:),hor,1);
    irf_se_mat_news=reshape(se_imp_2(varind(iy),3,:),hor,1);    

    irf_mat_vxo=reshape(imp_3(varind(iy),1,:),hor,1);
    irf_se_mat_vxo=reshape(se_imp_3(varind(iy),1,:),hor,1);     
    
	irf_mat_rvol=reshape(imp_4(varind(iy),1,:),hor,1);
    irf_se_mat_rvol=reshape(se_imp_4(varind(iy),1,:),hor,1);       
    
    nexttile
    
    tmp_ynews=[irf_mat_ynews,irf_mat_ynews-irf_se_mat_news,irf_mat_ynews+irf_se_mat_news];
    tmp_vxo=[irf_mat_vxo,irf_mat_vxo-irf_se_mat_vxo,irf_mat_vxo+irf_se_mat_vxo];
    tmp_rv=[irf_mat_rvol,irf_mat_rvol-irf_se_mat_rvol,irf_mat_rvol+irf_se_mat_rvol];
        
    hold on

    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_vxo(:,2)', fliplr(tmp_vxo(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')       
    p_vxo=plot(0:hor-1,tmp_vxo(:,1),'-','LineWidth',linewidthval1,...
        'Color', [0.75, 0, 0.75]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    p_rvol=plot(0:hor-1,tmp_rv(:,1),'--','LineWidth',linewidthval1,'Color',...
        [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_rv(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_rv(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])      
    
    plot((0:irf_fev_hor),zeros(1,irf_fev_hor+1),'color',[0.7 0.7 0.7])
    
    hold off
    
    if ismember(varlist{iy},{'ACMTP02','ACMTP10'})
        ylim(tpirfylim)
    end
    
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(ylabelvec{iy},'fontsize',fonts1)
    
    if iy==length(varind)
        legend([p_ynews p_rvol p_vxo],legendvec,...
            'location','best','fontsize',fonts2)                         
    end
end


fig8_2=figure;
tiledlayout(3,3,'Padding','Compact');
for iy=1:length(varind)

	fevd_mat_news=reshape(fevd_2(varind(iy),3,:),hor,1);
    fevd_se_mat_news=reshape(se_fevd_2(varind(iy),3,:),hor,1);    

    fevd_mat_vxo=reshape(fevd_3(varind(iy),1,:),hor,1);
    fevd_se_mat_vxo=reshape(se_fevd_3(varind(iy),1,:),hor,1);     
    
	fevd_mat_rvol=reshape(fevd_4(varind(iy),1,:),hor,1);
    fevd_se_mat_rvol=reshape(se_fevd_4(varind(iy),1,:),hor,1);       
    
    nexttile
    
    tmp_ynews=[fevd_mat_news,fevd_mat_news-fevd_se_mat_news,fevd_mat_news+fevd_se_mat_news];
    tmp_vxo=[fevd_mat_vxo,fevd_mat_vxo-fevd_se_mat_vxo,fevd_mat_vxo+fevd_se_mat_vxo];
    tmp_rvol=[fevd_mat_rvol,fevd_mat_rvol-fevd_se_mat_rvol,fevd_mat_rvol+fevd_se_mat_rvol];
        
    hold on
    
    patch([(0:hor-1), fliplr((0:hor-1))],  [tmp_vxo(:,2)', fliplr(tmp_vxo(:,3)')],...
        [.5, .5, .5], 'FaceAlpha',0.5, 'EdgeColor','none')  
    p_vxo=plot(0:hor-1,tmp_vxo(:,1),'-','LineWidth',linewidthval1,...
        'Color', [0.75, 0, 0.75]);
    
    p_ynews=plot(0:hor-1,tmp_ynews(:,1),'o','MarkerSize',3,...
    'MarkerEdgeColor',[1, 0, 0],...
    'MarkerFaceColor',[1, 0, 0]);
    
    p_rvol=plot(0:hor-1,tmp_rvol(:,1),'--','LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410]);
    plot(0:hor-1,tmp_rvol(:,2),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])
    plot(0:hor-1,tmp_rvol(:,3),'--',...
        'LineWidth',linewidthval1,...
        'Color', [0, 0.4470, 0.7410])   
    
    hold off
    
    ylim([0,1])
    xlim([0,irf_fev_hor])
    ax = gca; ax.XAxis.FontSize = fonts3; ax.YAxis.FontSize = fonts3;
    
    title(varlistfigure{iy},'fontsize',fonts1)
    ylabel(' ','fontsize',fonts1)
    
    if iy==length(varind)     
        legend([p_ynews p_rvol p_vxo],legendvec,...
            'location','best','fontsize',fonts2)                  
    end
end


%-- save figures
saveas(fig6_1,sprintf('results/Fig6_irfs_financial_vol_shocks.eps'),'epsc') 
saveas(fig6_1,sprintf('results/Fig6_irfs_financial_vol_shocks.pdf'),'pdf') 
saveas(fig6_2,sprintf('results/Fig6_fevds_financial_vol_shocks.eps'),'epsc') 
saveas(fig6_2,sprintf('results/Fig6_fevds_financial_vol_shocks.pdf'),'pdf') 
saveas(fig7_1,sprintf('results/Fig7_irfs_yields_vol_shocks.eps'),'epsc') 
saveas(fig7_1,sprintf('results/Fig7_irfs_yields_vol_shocks.pdf'),'pdf') 
saveas(fig7_2,sprintf('results/Fig7_fevds_yields_vol_shocks.eps'),'epsc') 
saveas(fig7_2,sprintf('results/Fig7_fevds_yields_vol_shocks.pdf'),'pdf') 
saveas(fig8_1,sprintf('results/Fig8_irfs_macro_vol_shocks.eps'),'epsc') 
saveas(fig8_1,sprintf('results/Fig8_irfs_macro_vol_shocks.pdf'),'pdf') 
saveas(fig8_2,sprintf('results/Fig8_fevds_macro_vol_shocks.eps'),'epsc') 
saveas(fig8_2,sprintf('results/Fig8_fevds_macro_vol_shocks.pdf'),'pdf') 
