function lsout = factor_estimation_ls_simple(est_data, est_par,catcode)

% Preliminaries
smpl_par           = est_par.smpl_par;
nfac_u1            = est_par.fac_par.nfac.unobserved1;
nfac_u2            = est_par.fac_par.nfac.unobserved2;
nfac_o             = est_par.fac_par.nfac.observed;
nfac_t             = est_par.fac_par.nfac.total;

if nfac_o > 0;
    w = est_par.fac_par.w;
end;

% Estimate factors with unbalanced panel by LS -- standardize data first
% Sample period
[istart, iend] = smpl_HO(smpl_par);
istart = max(istart,1);
iend = min(iend,size(est_data,1));

% Estimate Factors
xdata = est_data(istart:iend,:);
nt = size(xdata,1);
ns = size(xdata,2);

% Mean and Standard Deviation
xmean = nanmean(xdata)';                                  % mean (ignoring NaN)
mult = sqrt((sum(~isnan(xdata))-1)./sum(~isnan(xdata)));  % num of non-NaN entries for each series
xstd = (nanstd(xdata).*mult)';                            % std (ignoring NaN)
xdata_std = (xdata - repmat(xmean',nt,1))./repmat(xstd',nt,1);   % standardized data

if nfac_o > 0;
    wdata = w(istart:iend,:);
    if sum(sum(isnan(wdata))) ~= 0;
        error('w contains missing values over sample period, processing stops');
    end;
else
    wdata=[];
end;

%-- Construct estimates of the yield curve factors
if nfac_u1 > 0;
    xbal=packr(xdata_std(:,catcode==1)')';
    [ev,eigval,~]=svd(xbal*xbal');
    f1=sqrt(size(xbal,1))*ev(:,1:nfac_u1);
else
    f1=[];
end

f1a=[f1,wdata];
%   f1a=[wdata,f1];

%-- Construct estimates of the macro factors
if nfac_u2>0
    xbal=packr(xdata_std(:,catcode==2)')';
    if size(f1a,2)>0
        edata=nan(size(xbal));
        x=f1a;
        xxi = inv(x'*x);
        for i=1:size(xbal,2)
            y=xbal(:,i);
            bols = xxi*(x'*y);
            edata(:,i)=y-x*bols;
        end
        
        [ev,eigval,~]=svd(edata*edata');
        f2=sqrt(size(edata,1))*ev(:,1:nfac_u2);
        
    else
        
        [ev,eigval,~]=svd(xbal*xbal');
        f2=sqrt(size(xbal,1))*ev(:,1:nfac_u2);
    end
else
    f2=[];
end

fa = [f1a,f2];

f_est = fa;

fac_est = NaN(size(est_data,1),nfac_t);
fac_est(istart:iend,:)=f_est;

lsout.fac = fac_est;


end
