% function lolik_bgw_aly.m computes the loglikelihood implied by the Kalman filter given
% the parameter vector param_vec and the input data x and  y_bar
% copyright : Emanuel Moench and Harald Uhlig
% Email: emanuel.moench@ny.frb.org and huhlig@uchicago.edu

function LIK = loglik_bgw_aly(param_vec,x,y_bar);

[xi_TT_out,P_TT_out,xi_TL_out,P_TL_out,nu_out,v_out] = kalman_filter_bgw_aly(param_vec,x,y_bar);

% Calculate loglikelihood 
LIK = 0;
for t = 1:length(nu_out),
    v_t = v_out(:,:,t);
    nu_t = nu_out(:,:,t);
    if (t >= min(find(y_bar)) & mod(t,12) == 0), 
        LIK = LIK + 0.5*log(det(v_t)) + 0.5*(nu_t*inv(v_t)*nu_t');
    end;
end,

