% function plot_shade_with_tps.m
% copyright : Emanuel Moench and Harald Uhlig
% Email: emanuel.moench@ny.frb.org and huhlig@uchicago.edu
% shades recession periods in a line chart and highlights second set of turning points by red vertical lines
%
%
% ****************************************************************************************************
% **                                                                                                **
% **   Inputs           ser : series to plot                                                        **
%                 startdate : first monthly observation, e.g. 1970.01                               **
%                     peaks : binary vector of same length as series indicating peaks with a 1      **
%                   troughs : binary vector of same length as series indicating troughs with a 1    **
%                    peaks2 : binary vector of same length as series indicating peaks with a 1      **
%                  troughs2 : binary vector of same length as series indicating troughs with a 1    **
% **                                                                                                **
% ****************************************************************************************************

function done = plot_with_tps(ser,startdate,peaks,troughs,peaks2,troughs2,titlestring);

enddate = startdate + fix(length(ser)/12) + mod(length(ser),12)/100;
unit = (enddate-startdate)/(length(ser)-1);
time = startdate:unit:enddate;

hndl = plot(time,ser);
title(titlestring, 'FontSize', 14);
hold on;

xx = get(gca,'xlim');
yy = get(gca,'ylim'); 

t = min(find(peaks));
while t < length(time),
    year = floor(time(1)) + floor((t-1)/12);
    if peaks(t) == 1, 
        x = [time(t) time(t)];
        y = [yy(1) yy(2)];
        year_str = num2str(year);
        year_str = year_str(3:4);
        month = mod(t,12); if month == 0, month = 12; end;
        str = [year_str,'M',num2str(month)];
        hndl = line(x,y,'Color',[1 0 0],'LineWidth',0.5);
        hold on;
    elseif troughs(t) ==1,
        x = [time(t) time(t)];
        y = [yy(1) yy(2)];
        year_str = num2str(year);
        year_str = year_str(3:4);
        month = mod(t,12); if month == 0, month = 12; end;
        str = [year_str,'M',num2str(month)];
        hndl = line(x,y,'Color',[1 0 0],'LineWidth',0.5);
        hold on;
    end;
    t = t + 1;
end;

t = min(find(peaks2));
while t < length(time),
    if peaks2(t) == 1, 
        t2 = t;
        while t2 < length(time),
            if troughs2(t2) == 1,
                x = [time(t) time(t); time(t) time(t2); time(t2) time(t2); time(t2) time(t)];
                yy = get(gca,'ylim'); 
                y = [yy(1) yy(1); yy(1) yy(1); yy(1) yy(2); yy(2) yy(2)];
                hndl2 = patch(x,y,[0.75 0.75 0.75],'EdgeColor',[0.75 0.75 0.75],'EdgeAlpha',0);
                hold on;
            end;
            if troughs2(t2) == 1, t = t2; break;
            else; t2 = t2 + 1;
            end;
        end;
    end;
    t = t + 1;
end;

hndl3 = plot(time,ser);
hold off;

done = 1;
