// MyDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "resource.h"
#include "MyDialog.h"
#include "plugin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAX_TEXT_LENGTH	1024

extern void DeleteMyDialog();


/*
	$Id: MyDialog.cpp,v 1.4 2004/08/28 12:37:02 Tomoo Exp $
	
	$Log: MyDialog.cpp,v $
	Revision 1.4  2004/08/28 12:37:02  Tomoo
	_CAOύX
	
	Revision 1.3  2004/08/25 04:21:14  Tomoo
	̃`FbN{bNX̓ǉ
	
	Revision 1.2  2004/08/24 19:53:52  Tomoo
	RCSL[[hǉ
	
 */

/////////////////////////////////////////////////////////////////////////////
// CMyDialog _CAO


CMyDialog::CMyDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMyDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMyDialog)
	//}}AFX_DATA_INIT
}


void CMyDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyDialog)
	DDX_Control(pDX, IDC_LIST1, m_Bookmarks);
	DDX_Control(pDX, IDC_CHECK1, m_SyncCheck);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMyDialog, CDialog)
	//{{AFX_MSG_MAP(CMyDialog)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_NOTIFY(NM_CLICK, IDC_LIST1, OnClickList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyDialog bZ[W nh

void CMyDialog::OnButton1() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	DeleteMyDialog();
}

BOOL CMyDialog::ChangeList()
{
	if( m_hParent == NULL ){
		return FALSE;
	}

	int nLine = -1, index = 0;
	TCHAR szText[ MAX_TEXT_LENGTH ], szLine[ 64 ];
	_GET_LINE_INFO li = { MAX_TEXT_LENGTH, FLAG_LOGICAL, 0 };
	bool bFailed = false;
	LVITEM lvitem;

	lvitem.mask = LVIF_TEXT;
	lvitem.state = 0;
	lvitem.stateMask = 0;
	lvitem.iImage = 0;
	lvitem.lParam = NULL;
	lvitem.iIndent = 0;
	do{
		nLine = Editor_Info( m_hParent, EI_GET_NEXT_BOOKMARK, nLine );
		if( nLine == -1 ){
			break;
		}
		li.yLine = nLine;
#ifdef _UNICODE
		Editor_GetLineW( m_hParent, &li, szText );
		_ultow( li.yLine + 1, szLine, 10 );
#else
		Editor_GetLineA( m_hParent, &li, szText );
		_ultoa( li.yLine + 1, szLine, 10 );
#endif
		if( m_Bookmarks.InsertItem( index, szLine ) == -1 ){
			bFailed = true;
			break;
		}

		lvitem.pszText = szText;
		lvitem.cchTextMax = _tcslen( szText ) + 1;
		lvitem.iItem = index;
		lvitem.iSubItem = 1;
		if( m_Bookmarks.SetItem( &lvitem ) == 0 ){
			bFailed = true;
			break;
		}
		index++;
	}while( nLine != -1 );

	if( bFailed == true ){
		m_Bookmarks.DeleteAllItems();
		return FALSE;
	}

	return TRUE;
}

BOOL CMyDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CRect rcList;

	m_Bookmarks.GetClientRect( rcList );
	m_Bookmarks.InsertColumn( 0, _T("s"), LVCFMT_LEFT, 64, -1 );
	m_Bookmarks.InsertColumn( 1, _T("eLXg"), LVCFMT_LEFT, rcList.Width() - 64, -1 );
	m_Bookmarks.SetExtendedStyle( LVS_EX_FULLROWSELECT );

	ChangeList();

	UpdateData( FALSE );

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

BOOL CMyDialog::SyncBookmark()
{
	int index;
	POINT ptCaret = { 0, 0 }, ptPage;
	CString strText;

	index = m_Bookmarks.GetNextItem( -1, LVNI_ALL | LVNI_SELECTED );
	if( index == -1 ){
		return FALSE;
	}
	strText = m_Bookmarks.GetItemText( index, 0 );
	if( strText.IsEmpty() == TRUE ){
		return FALSE;
	}
	ptCaret.y = _ttoi( strText ) - 1;
	Editor_GetPageSize( m_hParent, &ptPage );
	ptPage.x = 0;
	ptPage.y += ptCaret.y;
#ifdef _UNICODE
	Editor_SetCaretPos( m_hParent, POS_LOGICAL_W, &ptPage );
	Editor_SetCaretPos( m_hParent, POS_LOGICAL_W, &ptCaret );
#else
	Editor_SetCaretPos( m_hParent, POS_LOGICAL_A, &ptPage );
	Editor_SetCaretPos( m_hParent, POS_LOGICAL_A, &ptCaret );
#endif
	if( m_Bookmarks.SetItemState( index, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED ) == FALSE ){
		return FALSE;
	}

	return TRUE;
}

void CMyDialog::OnClickList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UINT status = m_SyncCheck.GetState();
	if( ( status & 0x3 ) == 1 ){
		SyncBookmark();

		UpdateData( FALSE );
	}
	
	*pResult = 0;
}
