// MyDialog.cpp : Cve[V t@C
//

/*
	$Id: MyDialog.cpp,v 1.7 2004/08/28 06:07:38 Tomoo Exp $
	
	$Log: MyDialog.cpp,v $
	Revision 1.7  2004/08/28 06:07:38  Tomoo
	_CAOύXɔoOC
	
	Revision 1.6  2004/08/28 05:28:40  Tomoo
	_CAOύX
	
	Revision 1.5  2004/08/25 04:23:00  Tomoo
	tpXł͂Ȃt@Ĉݕ\悤ɕύX
	
	Revision 1.4  2004/08/24 16:21:45  Tomoo
	deft@CgȂ悤ɕύX
	
	Revision 1.3  2004/08/21 06:49:41  Tomoo
	̃EChẼubN}[NɂΉ
	
	Revision 1.2  2004/08/18 14:21:42  Tomoo
	_uNbNƍs̕\ɑΉ
	
	Revision 1.1.1.1  2004/08/18 13:36:33  Tomoo
	CVSŊǗJn
	
 */

#include "stdafx.h"
#include "resource.h"
#include "MyDialog.h"
#include "common_data.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyDialog _CAO


CMyDialog::CMyDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMyDialog::IDD, pParent)
	, m_nLine( LB_ERR )
{
	//{{AFX_DATA_INIT(CMyDialog)
	//}}AFX_DATA_INIT
	m_Editor.RemoveAll();
}


void CMyDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyDialog)
	DDX_Control(pDX, IDC_LIST1, m_Bookmarks);
	DDX_Control(pDX, IDC_COMBO1, m_FileNames);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMyDialog, CDialog)
	//{{AFX_MSG_MAP(CMyDialog)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST1, OnDblclkList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyDialog bZ[W nh

// _CAÕXg{bNX
// ubN}[Nǉ鏈
BOOL CMyDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	ASSERT( m_Editor.GetSize() > 0 );
	
	CRect rcList;

	m_Bookmarks.GetClientRect( rcList );
	m_Bookmarks.InsertColumn( 0, _T("s"), LVCFMT_LEFT, 64, -1 );
	m_Bookmarks.InsertColumn( 1, _T("eLXg"), LVCFMT_LEFT, rcList.Width() - 64, -1 );
	m_Bookmarks.SetExtendedStyle( LVS_EX_FULLROWSELECT );

	m_hEditorWnd = NULL;

	if( InitFileNames() == TRUE ){
		InitBookmarks();
	}

	UpdateData( FALSE );

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMyDialog::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	GetEditorHwnd();
	GetBookmark();

	CDialog::OnOK();
}

void CMyDialog::OnDblclkList1() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	GetEditorHwnd();
	GetBookmark();

	CDialog::OnOK();	
}

BOOL CMyDialog::GetBookmark()
{
	int index;
	CString strText;

	m_nLine = 0;

	index = m_Bookmarks.GetNextItem( -1, LVNI_ALL | LVNI_SELECTED );
	if( index == -1 ){
		return FALSE;
	}
	strText = m_Bookmarks.GetItemText( index, 0 );

	m_nLine = _ttoi( strText ) - 1;

	return TRUE;
}

BOOL CMyDialog::InitFileNames()
{
	HWND hwnd;
	int index, res, last, i;
	bool bError = false;
	DWORD item;
	TCHAR *pszName = NULL;

	last = m_Editor.GetSize();
	for( i = 0; i < last; i++ ){
		hwnd = m_Editor.GetAt( i );
#ifdef _UNICODE
		Editor_Info( hwnd, EI_GET_FILE_NAMEW, g_szFileName );
#else
		Editor_Info( hwnd, EI_GET_FILE_NAMEA, g_szFileName );
#endif
		pszName = _tcsrchr( g_szFileName, _T('\\') );
		if( pszName == NULL ){
			index = m_FileNames.AddString( g_szFileName );
		}
		else{
			pszName++;
			index = m_FileNames.AddString( pszName );
		}

		if( index == CB_ERR || index == CB_ERRSPACE ){
			bError = true;
			break;
		}
		g_szFileName[ 0 ] = _T('\0');

		res = m_FileNames.SetItemData( index, ( DWORD )hwnd );
		if( res == CB_ERR ){
			bError = true;
			break;
		}
	}

	if( bError == true ){
		return FALSE;
	}

	last = m_FileNames.GetCount();
	for( index = 0; index < last; index++ ){
		res = m_FileNames.GetLBTextLen( index );
		if( res == CB_ERR ){
			bError = true;
			break;
		}
		item = m_FileNames.GetItemData( index );
		if( item == CB_ERR ){
			bError = true;
			break;
		}
		hwnd = ( HWND )item;
#ifdef _UNICODE
		Editor_Info( hwnd, EI_GET_FILE_NAMEW, g_szFileName );
#else
		Editor_Info( hwnd, EI_GET_FILE_NAMEA, g_szFileName );
#endif
		if( _tcscmp( g_szFileName, m_szCaption ) == 0 ){
			res = m_FileNames.SetCurSel( index );
			if( res == CB_ERR ){
				bError = true;
			}
			break;
		}
	}

	if( bError == true ){
		return FALSE;
	}

	return TRUE;
}

BOOL CMyDialog::InitBookmarks()
{
	HWND hwnd;
	int index;
	DWORD item;
	int row = -1, list_row = 0;
	LVITEM lvitem;
	TCHAR szLine[64];

	index = m_FileNames.GetCurSel();
	if( index == CB_ERR ){
		return FALSE;
	}
	item = m_FileNames.GetItemData( index );
	if( item == CB_ERR ){
		return FALSE;
	}

	hwnd = ( HWND )item;

	g_LineInfo.flags = FLAG_LOGICAL;
	lvitem.mask = LVIF_TEXT;
	lvitem.state = 0;
	lvitem.stateMask = 0;
	lvitem.iImage = 0;
	lvitem.lParam = NULL;
	lvitem.iIndent = 0;
	if( m_Bookmarks.DeleteAllItems() == FALSE ){
		return FALSE;
	}

	do{
		g_LineInfo.cb = 0;
		g_LineInfo.yLine = 0;

		row = Editor_Info( hwnd, EI_GET_NEXT_BOOKMARK, row );
		if( row == -1 ){
			break;
		}
		g_LineInfo.yLine = row;
#ifdef _UNICODE
		g_LineInfo.cb = Editor_GetLineW( hwnd, &g_LineInfo, g_szSentence );
#else
		g_LineInfo.cb = Editor_GetLineA( hwnd, &g_LineInfo, g_szSentence );
#endif
		if( g_LineInfo.cb == 0 ) continue;
		if( g_LineInfo.cb > MAX_LINE_LENGTH ){
			g_LineInfo.cb = MAX_LINE_LENGTH;
		}
#ifdef _UNICODE
		Editor_GetLineW( hwnd, &g_LineInfo, g_szSentence );
#else
		Editor_GetLineA( hwnd, &g_LineInfo, g_szSentence );
#endif
		if( _tcslen( g_szSentence ) == 0 ){
			continue;
		}

		lvitem.iItem = list_row;
		lvitem.iSubItem = 0;
#ifdef _UNICODE
		_ultow( g_LineInfo.yLine + 1, szLine, 10 );
#else
		_ultoa( g_LineInfo.yLine + 1, szLine, 10 );
#endif
		lvitem.pszText = szLine;
		lvitem.cchTextMax = _tcslen( szLine ) + 1;
		m_Bookmarks.InsertItem( list_row, szLine );
		lvitem.iItem = list_row;
		lvitem.iSubItem = 1;
		lvitem.pszText = g_szSentence;
		lvitem.cchTextMax = _tcslen( g_szSentence ) + 1;
		m_Bookmarks.SetItem( &lvitem );
		list_row++;
	}while( row != -1 );

	if( m_Bookmarks.SetItemState( 0, LVIS_SELECTED, LVIS_SELECTED ) == FALSE ){
		return FALSE;
	}

	return TRUE;
}

BOOL CMyDialog::GetEditorHwnd()
{
	int index;
	DWORD item;

	m_hEditorWnd = NULL;

	index = m_FileNames.GetCurSel();
	if( index == CB_ERR ){
		return FALSE;
	}
	item = m_FileNames.GetItemData( index );
	if( item == CB_ERR ){
		return FALSE;
	}

	m_hEditorWnd = ( HWND )item;

	return TRUE;
}

void CMyDialog::OnSelchangeCombo1() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitBookmarks();

	UpdateData( FALSE );
}
