#pragma once
#ifndef __EMULATIONVI__H__ 
#define __EMULATIONVI__H__ 

//============== Copyright 1999 - 2008, Sungan., All rights reserved. ==================
//
// Purpose :
//
// Programed by sungan
//
//======================================================================================
#include "plugin.h"
class EmulationVI
{
public:
	class IContext
	{
	public:
		virtual ~IContext() {}
	};
	class Setting
	{
	public:
		Setting() : findForward(true) {}
		bool findForward;
	};
private:
	enum Mode
	{
		Invalid,
		Command,
		Insert,
		Overwrite,
		Visual,
	};
	enum CommandType
	{
		CommandType_Unknown = 0,
		CommandType_Motion,
		CommandType_Volatile,
		CommandType_Record,
	};
	Mode curMode;

	std::vector<wchar_t> curCommands;
	HWND hWnd;
	struct Cmd
	{
		Cmd() : first(0), second(), repeat(0) {}
		wchar_t first;
		wchar_t second;
		int repeat;
	};

	struct RecCmd
	{
		RecCmd(Cmd &cmd, SIZE_PTR &selection) : cmd(cmd), selection(selection){}
		Cmd cmd;
		std::wstring input;
		SIZE_PTR selection;
	};
	std::vector<RecCmd> recCmds;
	POINT_PTR beginInputPos, endInputPos;
	IContext *context;
	Setting setting;
	Cmd lastFindCmd;

public:
	EmulationVI(HWND hWnd, IContext *context) ;
	virtual ~EmulationVI() ;
public:
	bool OnKeyDown(int keyCode, bool shift, bool ctrl);
	void OnCaretMoved(BOOL reset = TRUE);
	bool EmptyCommand() const {return curCommands.empty();}
	bool IsCommandMode() const {return GetCurMode() == Command || GetCurMode() == Visual;}
	bool IsInputMode() const {return GetCurMode() == Insert || GetCurMode() == Overwrite;}
	bool IsVisualMode() const {return GetCurMode() == Visual;}
	Setting &GetSetting() {return setting;}
	void UpdateStatus();
private:
	bool OnChar(wchar_t c);
	void ParseCommands(const std::vector<wchar_t> &commands, Cmd &cmd);
	CommandType ProcessCommandMode(Cmd &cmd);
	CommandType ProcessCommandMotion(wchar_t c, int repeat, bool hasSelection);
	CommandType ProcessSingleCommand(wchar_t c, int repeat, bool hasSelection);
	CommandType ProcessDoubleCommand(wchar_t first, wchar_t second, int repeat, bool hasSelection);

	bool ProcessInputMode(wchar_t c);
	std::wstring GetStatus() const;

private:
	Mode GetCurMode() const;
	void ChangeMode(Mode mode);
	void OnEnterMode(Mode mode);
	void OnLeaveMode(Mode mode);
	void CloseInputText();
	void SetCursorState(Mode mode);
} ;


#endif //#define __EMULATIONVI__H__