// implementatin of this specific plug-in is here:
//

#define COMBO_WIDTH				400
#define COMBO_HEIGHT			100
#define REG_ENTRY_FIND			_T("Find")
#define REG_ENTRY_COMMANDLINE	_T("CommandLine")
#define BUTTON_SIZE_SMALL   22
#define BUTTON_SIZE_LARGE   30

#define MAX_FIND_LENGTH    10000

#define ZERO_INIT_FIRST_MEM(classname, firstmem)  ZeroMemory( &firstmem, sizeof( classname ) - ((char*)&firstmem - (char*)this) );

LPCTSTR const szFindFlag = _T("FindFlag");
LPCTSTR const aszFindValue[4] = { TEXT("Find"), TEXT("Replace"), TEXT("File"), TEXT("Path") };

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
INT_PTR CALLBACK EmViProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
LRESULT CALLBACK FindComboProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
HWND GetComboEdit( HWND hwndCombo );


struct CTBInfo
{
	WORD nID;
	BYTE iBitmap;
	BYTE fStyle;
};

static CTBInfo buttons[] = 
{
	{ ID_BROWSE_REG_EXP,	0, 0 },
	{ ID_PREV,				1, 0 },
	{ ID_NEXT,				2, 0 },
	{ ID_INCREMENTAL,		3, 0 },
	{ ID_OPEN_DOC,			4, 0 },
	{ ID_CASE,				5, 0 },
	{ ID_REG_EXP,			6, 0 },
	{ ID_ESCAPE,			7, 0 },
	{ ID_ONLY_WORD,		8, 0 },
	{ ID_AROUND,			9, 0 },
};


static BYTE anDefToolbarIndex[] = 
{
	(BYTE)(-3), 0, 1, 2, (BYTE)(-1), 3, 4, 5, 6, 7, 8, 9, (BYTE)(-2)
};


LPWSTR GetComboBoxString( HWND hwndCombo, int nIndex )
{
	LPWSTR pResult = NULL;
	INT_PTR nLen = SendMessageW( hwndCombo, CB_GETLBTEXTLEN, nIndex, 0 ) + 1;
	pResult = new WCHAR[nLen];
	if( pResult != NULL ){
		SendMessageW( hwndCombo, CB_GETLBTEXT, nIndex, (LPARAM)pResult );
	}
	return pResult;
}

LPWSTR MyGetWindowText( HWND hwnd )
{
	LPWSTR pResult = NULL;
	INT_PTR nLen = SendMessageW( hwnd, WM_GETTEXTLENGTH, 0, 0 ) + 1;
	pResult = new WCHAR[ nLen ];
	if( pResult != NULL ){
		SendMessageW( hwnd, WM_GETTEXT, nLen, (LPARAM)pResult );
	}
	return pResult;
}

class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_TRUE_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= CLR_NONE				};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 7010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 7000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= FALSE					};

	// user-defined members

	// data that can be set zeros below
	HWND m_hwndToolbar;
	HIMAGELIST m_himageToolbar;
	HWND m_hDlg;
	std::wstring m_strIncremental;
	POINT_PTR m_ptOrgCaretPos;
	WNDPROC m_lpOldFindComboProc;
	DWORD m_dwFindFlags;
	UINT m_nClientID;
	UINT m_cx;
	UINT m_fStyle;
	UINT m_nBand;
	TCHAR m_szFind[MAX_PATH];
	bool m_bProfileLoaded;
	bool m_bOpenStartup;

	bool m_bIncremental;
	bool m_bOpenDoc;
	bool m_bCase;
	bool m_bRegExp;
	bool m_bEscape;
	bool m_bOnlyWord;
	bool m_bAround;

	bool m_bVisible;
	bool m_bUninstalling;
	bool m_bFocusView;
	//bool m_bFocusViewAfterFound;
	bool m_bNeedSaveFindHistory;

	EmulationVI *emulator;
	
	void SetButtonStatus( UINT nID, bool bChecked, bool bEnabled )
	{
		_ASSERT( m_hwndToolbar );
		SendMessage( m_hwndToolbar, TB_SETSTATE, nID, (LPARAM)MAKELONG((bChecked? TBSTATE_CHECKED : 0) | (bEnabled ? TBSTATE_ENABLED : 0), 0) );
	}

	void AddButtons( HWND hwndToolbar )
	{
		TBBUTTON atb[_countof( anDefToolbarIndex )];
		ZeroMemory( atb, sizeof( atb ) );
		BYTE* pnIndex = anDefToolbarIndex;
		int i = 0;
		while( *pnIndex != (BYTE)-2 ){
			BYTE nIndex = *pnIndex++;
			if( nIndex == (BYTE)-3 ) {  // Find ComboBox
				atb[i].fsStyle = TBSTYLE_SEP;
				atb[i].iBitmap = COMBO_WIDTH;
			}
			else if( nIndex != (BYTE)-1 ){
				atb[i].iBitmap = buttons[nIndex].iBitmap;
				atb[i].idCommand = buttons[nIndex].nID;
				atb[i].fsStyle = buttons[nIndex].fStyle;
			}
			else {  // separator
				atb[i].fsStyle = TBSTYLE_SEP;
			}
			atb[i].fsState = TBSTATE_ENABLED;
			i++;
		}
		SendMessage( hwndToolbar, TB_ADDBUTTONSA, i, (LPARAM)atb );
	}

	void DisplayBar( bool bVisible )
	{
		if( m_hwndToolbar ){
			_ASSERT( m_nClientID );
			Editor_ToolbarShow( m_hWnd, m_nClientID, bVisible );
			m_bVisible = bVisible;
		}
		else {
			m_bVisible = false;
			TCHAR sz[260];
			TCHAR szAppName[80];
			LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
			if( Editor_GetVersion( m_hWnd ) < 7000 ){
				LoadString( EEGetInstanceHandle(), IDS_INVALID_VERSION, sz, _countof( sz ) );
				MessageBox( m_hWnd, sz, szAppName, MB_OK | MB_ICONSTOP );
				return;
			}

			HWND hDlg = CreateDialog( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_DIALOGBAR ), m_hWnd, EmViProc );
			_ASSERT( hDlg );
			if( !hDlg ){
				return;
			}
			m_hDlg = hDlg;

			DWORD dwStyle = TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT | WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | CCS_NODIVIDER | CCS_NORESIZE | WS_VISIBLE | TBSTYLE_FLAT | CCS_NOPARENTALIGN | CCS_NOMOVEY;
			DWORD dwExStyle = TBSTYLE_EX_HIDECLIPPEDBUTTONS | TBSTYLE_EX_DRAWDDARROWS;
			HWND hwndToolbar = CreateWindowEx( 0, TOOLBARCLASSNAME, NULL, dwStyle,
				0, 0, 0, BUTTON_SIZE_SMALL, m_hDlg, (HMENU)(INT_PTR)100, NULL, NULL );
			m_hwndToolbar = hwndToolbar;
			SendMessage( hwndToolbar, TB_BUTTONSTRUCTSIZE, (WPARAM) sizeof(TBBUTTON), 0 ); 
			SendMessage( hwndToolbar, TB_SETBUTTONSIZE, 0, MAKELONG( 22, 22 ) );
			SendMessage( hwndToolbar, TB_SETEXTENDEDSTYLE, 0, dwExStyle );
			_ASSERT( m_himageToolbar == NULL );
			m_himageToolbar = ImageList_LoadImage( EEGetInstanceHandle(), MAKEINTRESOURCE( IDB_TOOLBAR ), 16, 0, RGB( 255, 0, 255 ), IMAGE_BITMAP, LR_CREATEDIBSECTION );
			_ASSERT( m_himageToolbar );
			SendMessage( hwndToolbar, TB_SETIMAGELIST, 0, (LPARAM)m_himageToolbar );
			AddButtons( hwndToolbar );

			HFONT hFont = (HFONT)SendMessage( hDlg, WM_GETFONT, 0, 0 );

			HWND hwndComboCommandLine = CreateWindowEx(0L, L"COMBOBOX", NULL, WS_CHILD | WS_BORDER | WS_VISIBLE | CBS_DROPDOWN | WS_TABSTOP | CBS_AUTOHSCROLL, 
			   COMBO_WIDTH/2, 0, COMBO_WIDTH/2, COMBO_HEIGHT, hDlg, (HMENU) ID_COMMANDLINE, EEGetInstanceHandle(), 0 );
			SetParent( hwndComboCommandLine, hwndToolbar );
			SendMessage( hwndComboCommandLine, WM_SETFONT, (WPARAM)hFont, 0 );

			HWND hwndComboFind = CreateWindowEx(0L, L"COMBOBOX", NULL, WS_CHILD | WS_BORDER | WS_VISIBLE | CBS_DROPDOWN | WS_TABSTOP | CBS_AUTOHSCROLL, 
			   0, 0, COMBO_WIDTH/2, COMBO_HEIGHT, hDlg, (HMENU) ID_FIND, EEGetInstanceHandle(), 0 );
			SetParent( hwndComboFind, hwndToolbar );
			SendMessage( hwndComboFind, WM_SETFONT, (WPARAM)hFont, 0 );

			//m_lpOldFindComboProc = (WNDPROC)(LONG_PTR)SetWindowLongPtr( GetComboEdit( hwndComboFind ), GWLP_WNDPROC, (LONG_PTR)FindComboProc );

			SendMessage( m_hwndToolbar, TB_SETSTATE, ID_INCREMENTAL, (LPARAM)MAKELONG((m_bIncremental? TBSTATE_CHECKED : 0) | TBSTATE_ENABLED, 0) );
			m_dwFindFlags = LoadFindFlags();

			m_bOpenDoc = !!(m_dwFindFlags & FLAG_FIND_OPEN_DOC);
			m_bCase = !!(m_dwFindFlags & FLAG_FIND_CASE);
			m_bEscape = !!(m_dwFindFlags & FLAG_FIND_ESCAPE);
			m_bOnlyWord = !!(m_dwFindFlags & FLAG_FIND_ONLY_WORD);
			m_bAround = !!(m_dwFindFlags & FLAG_FIND_AROUND);
			m_bRegExp = !!(m_dwFindFlags & FLAG_FIND_REG_EXP);
			SetButtonStatus( ID_INCREMENTAL, m_bIncremental, true );
			SetButtonStatus( ID_OPEN_DOC, m_bOpenDoc, true );
			SetButtonStatus( ID_CASE, m_bCase, true );
			SetButtonStatus( ID_REG_EXP, m_bRegExp, true );
			SetButtonStatus( ID_ESCAPE, m_bEscape, true );
			SetButtonStatus( ID_ONLY_WORD, m_bOnlyWord, true );
			SetButtonStatus( ID_AROUND, m_bAround, true );
			ShowHideRegexp();
			ShowHideOpenDoc();
			InitFindDlg( hwndToolbar, L"" );
			InitCommandLineDlg( hwndToolbar, L"" );

  			if( hwndToolbar ){
				TCHAR szTitle[80];
				LoadString( EEGetInstanceHandle(), IDS_TITLE, szTitle, _countof( szTitle ) );
				RECT rcClient = { 0 };
				GetClientRect( hwndToolbar, &rcClient );
				TOOLBAR_INFO cri;
				ZeroMemory( &cri, sizeof( cri ) );
				cri.cbSize = sizeof( cri );
				cri.nMask = TIM_CLIENT | TIM_TITLE | TIM_FLAGS | TIM_STYLE | TIM_MINCHILD | TIM_CX | TIM_CXIDEAL | TIM_BAND | TIM_PLUG_IN_CMD_ID;
				cri.wPlugInCmdID = EEGetCmdID();
				cri.pszTitle = szTitle;
				cri.hwndClient = hwndToolbar;
				cri.cxMinChild = 0;
				cri.cyMinChild = rcClient.bottom - rcClient.top;
				cri.cxIdeal = rcClient.right - rcClient.left;
				cri.cx = m_cx;
				if( bVisible ){
					m_fStyle &= ~RBBS_HIDDEN;
				}
				else {
					m_fStyle |= RBBS_HIDDEN;
				}
				cri.fStyle = m_fStyle;
				cri.nBand = m_nBand;

				m_nClientID = Editor_ToolbarOpen( m_hWnd, &cri );

				if( !m_nClientID ){
					CustomBarClosed();
				}
				else {
					m_bVisible = bVisible;
				}

				ShowWindow( hwndToolbar, m_bVisible );
			}
		}
		delete emulator;
		emulator = NULL;
		if(m_bVisible)
			emulator = new EmulationVI(m_hWnd, NULL);
	}

	bool IsVisible()
	{
		return m_hwndToolbar && m_bVisible;
	}

	void OnCommand( HWND /*hwndView*/ )
	{
		DisplayBar(!IsVisible());
		return;
		/*
		_ASSERT( m_hwndToolbar );
		if( m_hwndToolbar ){
			HWND hwndComboFind = ::GetDlgItem( m_hwndToolbar, ID_FIND );
			_ASSERT( hwndComboFind );
			if( hwndComboFind ){
				if( GetParent( GetFocus() ) == hwndComboFind ){
					Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
					DisplayBar( false );
				}
				else {
					DisplayBar( true );
					SetFocus( hwndComboFind );
				}
			}
			return;
		}
		DisplayBar( true );
		*/
	}

	void CustomBarClosed()
	{
		if( m_hwndToolbar ){
			_ASSERTE( IsWindow( m_hwndToolbar ) );
//			if( IsWindow( m_hwndToolbar ) ){
				if( m_lpOldFindComboProc ){
					HWND hwndComboFind = ::GetDlgItem( m_hwndToolbar, ID_FIND );
					_ASSERT( hwndComboFind );
					SetWindowLongPtr( GetComboEdit( hwndComboFind ), GWLP_WNDPROC, (LONG_PTR)m_lpOldFindComboProc );
					m_lpOldFindComboProc = NULL;
					DestroyWindow( hwndComboFind );
				}
				DestroyWindow( m_hwndToolbar );
//			}
			_ASSERT( !IsWindow( m_hwndToolbar ) );
			m_hwndToolbar = NULL;
			m_nClientID = 0;
			delete emulator;
			emulator = NULL;
		}
		if( m_hDlg ){
			DestroyWindow( m_hDlg );
			m_hDlg = NULL;
		}
	}

	BOOL QueryStatus( HWND /*hwndView*/, LPBOOL pbChecked )
	{		
		*pbChecked = IsVisible();
		return TRUE;
	}

	void OnEvents( HWND /*hwndView*/, UINT nEvent, LPARAM lParam )
	{
		if(emulator && (nEvent & EVENT_CARET_MOVED) && !(nEvent & EVENT_CHANGE))
			emulator->OnCaretMoved();
		if(emulator && (nEvent & 0x20000000) && (lParam == 0xD0FBBC))//? μ { ԷҶ ڵ indent Ǵ° ̰   ̰ͻ..
		{
			emulator->OnCaretMoved(FALSE);
		}
		/*
		if(nEvent != EVENT_IDLE)
		{
			if(m_bVisible)
			{
				wchar_t buf[MAX_PATH];
				StringPrintf( buf, MAX_PATH, _T("%X:%X"), nEvent, lParam );
				::MessageBox(m_hWnd, buf, NULL, MB_OK);
			}
		}
		*/
		/*
		if(nEvent != EVENT_IDLE)
		{
			if(m_bVisible)
			{
				wchar_t buf[MAX_PATH];
				StringPrintf( buf, MAX_PATH, _T("%X:%X"), nEvent, lParam );
				//::MessageBox(m_hWnd, buf, NULL, MB_OK);
			}
		}
		if(nEvent & EVENT_CHAR)
		{
			if(m_bVisible)
			{
				Editor_ExecCommand(m_hWnd, EEID_EDIT_UNDO);
				switch(lParam)
				{
				case 'h':
					Editor_ExecCommand(m_hWnd, EEID_LEFT);
					break;
				case 'j':
					Editor_ExecCommand(m_hWnd, EEID_DOWN);
					break;
				case 'k':
					Editor_ExecCommand(m_hWnd, EEID_UP);
					break;
				case 'l':
					Editor_ExecCommand(m_hWnd, EEID_RIGHT);
					break;
				default:
					{
						wchar_t buf[MAX_PATH];
						StringPrintf( buf, MAX_PATH, _T("/X:%X"), lParam );
						::MessageBox(m_hWnd, buf, NULL, MB_OK);
					}
					break;
				}
			}
		}
		*/
		if( nEvent & EVENT_CREATE_FRAME ){

			LoadProfile();
			DisplayBar( m_bOpenStartup );
		}
		if( nEvent & EVENT_CLOSE_FRAME ){
			if( m_hwndToolbar ){
				_ASSERTE( m_nClientID );
				Editor_ToolbarClose( m_hWnd, m_nClientID );
				CustomBarClosed();
			}
		}
		if( nEvent & EVENT_TOOLBAR_CLOSED ){
			// this message arrives even if plug-in does not own this custom bar, so make sure it is mine.
			TOOLBAR_INFO* pTI = (TOOLBAR_INFO*)lParam;
			if( (pTI->nMask & TIM_ID) && pTI->nID == m_nClientID ){
				_ASSERT( m_hwndToolbar != NULL );
				CustomBarClosed();
				// if the frame closed while Custom Bar is open, save the status for next startup.
				if( pTI->nMask & TIM_FLAGS ){
					if( pTI->nFlags & CLOSED_FRAME_WINDOW ){
						m_bOpenStartup = !(pTI->fStyle & RBBS_HIDDEN);
					}
				}
				if( pTI->nMask & TIM_CX ){
					m_cx = pTI->cx;
				}
				if( pTI->nMask & TIM_STYLE ){
					m_fStyle = pTI->fStyle;
				}
				if( pTI->nMask & TIM_BAND ){
					m_nBand = pTI->nBand;
				}
				SaveProfile();
			}
		}
		if( nEvent & EVENT_TOOLBAR_SHOW ){
			TOOLBAR_INFO* pTI = (TOOLBAR_INFO*)lParam;
			if( (pTI->nMask & TIM_ID) && pTI->nID == m_nClientID ){
				_ASSERT( m_hwndToolbar != NULL );
				if( pTI->nMask & TIM_STYLE ){
					m_bVisible = !(pTI->fStyle & RBBS_HIDDEN);
				}
			}
		}
		if( nEvent & (EVENT_FILE_OPENED | EVENT_DOC_SEL_CHANGED) ){
		}
		if( nEvent & EVENT_CHANGE ){
		}
		if( nEvent & EVENT_SEL_CHANGED ){
			if(emulator)
				emulator->UpdateStatus();
		}
		if( nEvent & EVENT_CARET_MOVED ){
		}
		if( nEvent & EVENT_IDLE ){
			if( m_hwndToolbar ){
				if( m_bFocusView ){
					Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
					m_bFocusView = false;
				}
			}
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam )
	{
		TCHAR szProductCode[80] = { 0 };
		HKEY hKey = NULL;
		if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, _T("Software\\EmSoft\\EmEditorPlugIns\\EmVi"), 0, KEY_READ, &hKey ) == ERROR_SUCCESS && hKey ){
			GetProfileStringReg( hKey, _T("ProductCode"), szProductCode, _countof( szProductCode ), _T("") );
			if( szProductCode[0] ){
				GetSystemDirectory( pszUninstallCommand, MAX_PATH );
				PathAppend( pszUninstallCommand, _T("msiexec.exe") );

				StringPrintf( pszUninstallParam, MAX_PATH, _T("/X%s"), szProductCode );
				RegCloseKey( hKey );
				return UNINSTALL_RUN_COMMAND;
			}
		}
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			// Delete the registry/INI key.
			TCHAR szFileName[MAX_PATH];
			if( GetModuleFile( szFileName ) ){
				EraseProfile();
			}
			m_bUninstalling = true;
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	BOOL PreTranslateMessage( HWND hwndView, MSG* pMsg )
	{
		if(IsVisible())
		{
			HWND hwndFocus = GetFocus();
			if( hwndFocus && !IsChild( m_hwndToolbar, hwndFocus)) {
				if( pMsg->message == WM_KEYDOWN ){
					int scanCode = int(pMsg->lParam & 0x00ff0000) >> 16;
					int keyCode = MapVirtualKey(scanCode, 1);
					if(pMsg->wParam >= VK_LWIN && pMsg->wParam <= VK_RMENU)
						keyCode = pMsg->wParam;
					else if(pMsg->wParam == VK_PROCESSKEY && keyCode == VK_ESCAPE)
						return false;
					//if ime composition, skip this.
					HIMC himc = ImmGetContext(hwndView);
					if(himc)
					{
						if(ImmGetOpenStatus(himc))
						{
							int len = ImmGetCompositionStringW(himc, GCS_COMPSTR, NULL, 0);
							if(len > 0)
							{
								ImmReleaseContext(hwndView, himc) ;
								return false;
							}
						}
						ImmReleaseContext(hwndView, himc) ;
					}
					bool bShiftKey = !!(::GetKeyState(VK_SHIFT) & 0x80);
					bool bCtrlKey = !!(::GetKeyState(VK_CONTROL) & 0x80);
					if(emulator->EmptyCommand() && emulator->IsCommandMode())
					{
						switch(keyCode)
						{
						case VK_OEM_1:
							if(bShiftKey)// ':'
							{
								::SetFocus(::GetDlgItem(m_hwndToolbar, ID_COMMANDLINE));
								return true;
							}
							break;
						case VK_OEM_2: // '/'
							::SetFocus(::GetDlgItem(m_hwndToolbar, ID_FIND));
							emulator->GetSetting().findForward = !bShiftKey;
							return true;
						}
					}
					return !!emulator->OnKeyDown(keyCode, bShiftKey, bCtrlKey);
				}
			}
			else if( hwndFocus && IsChild( m_hwndToolbar, hwndFocus ) ){
				if( pMsg->message == WM_KEYDOWN ){
					bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
					bool bShift = GetKeyState( VK_SHIFT ) < 0;
					if( !bCtrl ){
						if( pMsg->wParam == VK_ESCAPE ){
							if( !bShift ){
								Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
								return TRUE;
							}
						}
						else if( pMsg->wParam == VK_F3 ){
							if( m_hwndToolbar ){
								Find( m_hwndToolbar, !bShift, FALSE );
								return TRUE;
							}
						}
						else if(pMsg->wParam == VK_RETURN){
							Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
							if(::IsChild(::GetDlgItem(m_hwndToolbar, ID_FIND), hwndFocus))
								OnCommand(m_hWnd, ID_FIND_OK);
							else if(::IsChild(::GetDlgItem(m_hwndToolbar, ID_COMMANDLINE), hwndFocus))
								OnCommand(m_hWnd, ID_COMMANDLINE_OK);
						}
					}
				}
				else if( pMsg->message == WM_SYSKEYDOWN ){
					bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
					if( !bCtrl ){
						WPARAM wID = 0;
						switch( pMsg->wParam ){
						case VK_OEM_PERIOD:  wID = ID_BROWSE_REG_EXP;  break;
						case 'I':  wID = ID_INCREMENTAL;  break;
						case 'S':  wID = ID_OPEN_DOC; break;
						case 'C':  wID = ID_CASE; break;
						case 'X':  wID = ID_REG_EXP; break;
						case 'E':  wID = ID_ESCAPE; break;
						case 'O':  wID = ID_ONLY_WORD; break;
						case 'M':  wID = ID_AROUND; break;
						}
						if( wID ){
							OnCommand( m_hWnd, wID );
							return TRUE;
						}
					}
				}
				if( IsDialogMessage( m_hwndToolbar, pMsg ) ){
					return TRUE;
				}
			}
		}
		return FALSE;
	}

	CMyFrame()
	{
		ZERO_INIT_FIRST_MEM( CMyFrame, m_hwndToolbar );
		m_nBand = (UINT)-1;
	}

	~CMyFrame()
	{
		_ASSERT( m_hwndToolbar == NULL );
		CustomBarClosed();
	}

	void LoadProfile()
	{
		if( !m_bProfileLoaded ){
			m_bProfileLoaded = true;
			m_bOpenStartup = !!GetProfileInt( _T("OpenStartup"), FALSE );
			m_bIncremental = !!GetProfileInt( _T("Incremental"), FALSE );
			m_cx = GetProfileInt( _T("cx"), FALSE );
			m_fStyle = GetProfileInt( _T("Style"), FALSE );
			m_nBand = GetProfileInt( _T("Band"), -1 );
			//m_bFocusViewAfterFound = !!GetProfileInt( _T("FocusView"), TRUE );
		}
	}

	void SaveProfile()
	{
		if( m_bUninstalling )  return;
		TCHAR szFileName[MAX_PATH];
		if( !GetModuleFile( szFileName ) )  return;
		WriteProfileInt( _T("OpenStartup"), !!m_bOpenStartup );
		WriteProfileInt( _T("Incremental"), !!m_bIncremental );
		WriteProfileInt( _T("cx"), m_cx );
		WriteProfileInt( _T("Style"), m_fStyle );
		WriteProfileInt( _T("Band"), m_nBand );
	}

	void DoCommandLine( HWND /* hwnd */ )
	{
		TCHAR szFileName[MAX_PATH];
		GetModuleFile(szFileName);
		HWND hwndCombo = ::GetDlgItem( m_hwndToolbar, ID_COMMANDLINE );
		LPWSTR pszFind = TerminateCombo( &hwndCombo, EEREG_PLUGINS, szFileName, REG_ENTRY_COMMANDLINE, SIGNATURE_FIND_LIST);
		std::vector<std::wstring> param;
		LPWSTR str = pszFind;
		while(*str)
		{
			if(*str == ' ' || *str == '\t')
			{
				while(*str == ' ' || *str == '\t')
					*str++ = 0;
				break;
			}
			++str;
		}
		if(*pszFind)
			param.push_back(pszFind);
		if(*str)
			param.push_back(str);
		delete [] pszFind;
		if(!param.empty())
		{
			int lineNum = _ttoi(param[0].c_str());
			if(lineNum > 0)
			{
				POINT_PTR pos = {0, lineNum-1};
				Editor_SetCaretPos(m_hWnd, POS_LOGICAL_W, &pos);
			}
			else if(!param[0].compare(L"q") || !param[0].compare(L"quit"))
				Editor_ExecCommand(m_hWnd, EEID_APP_EXIT);
			else if(!param[0].compare(L"q!") || !param[0].compare(L"quit!"))
			{
				Editor_SetModified(m_hWnd, FALSE);
				Editor_ExecCommand(m_hWnd, EEID_APP_EXIT);
			}
			else if(!param[0].compare(L"clo") || !param[0].compare(L"close"))//close current file or window split
				Editor_ExecCommand(m_hWnd, EEID_APP_EXIT);
			else if(!param[0].compare(L"bd") || !param[0].compare(L"bdelete"))
				Editor_ExecCommand(m_hWnd, EEID_APP_EXIT);
			else if(!param[0].compare(L"w") || !param[0].compare(L"write"))
			{
				if(param.size() <= 1)
					Editor_ExecCommand(m_hWnd, EEID_FILE_SAVE);
				else
					Editor_SaveFileW(m_hWnd, TRUE, param[1].c_str());
			}
			else if(!param[0].compare(L"wa") || !param[0].compare(L"wall"))
				Editor_ExecCommand(m_hWnd, EEID_FILE_SAVE_ALL);
			else if(!param[0].compare(L"wq") || !param[0].compare(L"qw") || !param[0].compare(L"x"))
				Editor_ExecCommand(m_hWnd, EEID_FILE_SAVE_EXIT);
			else if(!param[0].compare(L"new")/* || !param[0].compare(L"n")*/)
				Editor_ExecCommand(m_hWnd, EEID_FILE_NEW);
			else if(!param[0].compare(L"qa") || !param[0].compare(L"qall"))
				Editor_ExecCommand(m_hWnd, EEID_EXIT_ALL);
			else if(!param[0].compare(L"xa") || !param[0].compare(L"xall"))
				Editor_ExecCommand(m_hWnd, EEID_SAVE_EXIT_ALL);
			else if(!param[0].compare(L"sp") || !param[0].compare(L"split"))
				Editor_ExecCommand(m_hWnd, EEID_WINDOW_SPLIT_HORZ_TOGGLE);
			else if(!param[0].compare(L"spv") || !param[0].compare(L"splitv"))
				Editor_ExecCommand(m_hWnd, EEID_WINDOW_SPLIT_VERT_TOGGLE);
			else if(!param[0].compare(L"bn") || !param[0].compare(L"n"))
				Editor_ExecCommand(m_hWnd, EEID_NEXT_WINDOW);
			else if(!param[0].compare(L"bp") || !param[0].compare(L"N"))
				Editor_ExecCommand(m_hWnd, EEID_PREV_WINDOW);
			else if(!param[0].compare(L"s") || !param[0].compare(L"sd"))
				Editor_ExecCommand(m_hWnd, EEID_EDIT_REPLACE);
			else if(!param[0].compare(L"f") || !param[0].compare(L"fd"))
				Editor_ExecCommand(m_hWnd, EEID_EDIT_FIND);
			else if(!param[0].compare(L"e") || !param[0].compare(L"edit"))
			{
				if(param.size() <= 1)
					Editor_ExecCommand(m_hWnd, EEID_FILE_OPEN);
				else
				{
					Editor_ExecCommand(m_hWnd, EEID_FILE_NEW);
					Editor_LoadFileW(m_hWnd, NULL, param[1].c_str());
				}
			}
			else if(!param[0].compare(L"u") || !param[0].compare(L"undo"))
				Editor_ExecCommand(m_hWnd, EEID_EDIT_UNDO);
			else if(!param[0].compare(L"red") || !param[0].compare(L"redo"))
				Editor_ExecCommand(m_hWnd, EEID_EDIT_REDO);
			else if(param[0].length() >= 2 && param[0][0] == '!')
			{
				std::wstring buf = L"/k ";
				buf += &param[0][1];
				::ShellExecute(m_hWnd, L"open", L"cmd", buf.c_str(), NULL, SW_SHOW);
			}
		}
	}
	void Find( HWND /* hwnd */, BOOL bDown, BOOL bIncremental )
	{
		bDown ^= !emulator->GetSetting().findForward;
		m_dwFindFlags &= FLAG_GREP_MASK;
		m_dwFindFlags |= (bDown ? FLAG_FIND_NEXT : 0);
		if( m_bOpenDoc )  m_dwFindFlags |= FLAG_FIND_OPEN_DOC;
		if( m_bCase )  m_dwFindFlags |= FLAG_FIND_CASE;
		if( m_bEscape )  m_dwFindFlags |= FLAG_FIND_ESCAPE;
		if( m_bOnlyWord )  m_dwFindFlags |= FLAG_FIND_ONLY_WORD;
		if( m_bAround )  m_dwFindFlags |= FLAG_FIND_AROUND;
		if( m_bRegExp )  m_dwFindFlags |= FLAG_FIND_REG_EXP;

		SaveFindFlags( m_dwFindFlags );
		if(!bIncremental)
		{
			Editor_GetSelStart( m_hWnd, POS_LOGICAL_W, &m_ptOrgCaretPos);
			Editor_ExecCommand( m_hWnd, EEID_ESCAPE );
		}
		else
		{
		}
		if(!bDown)
			Editor_ExecCommand(m_hWnd, EEID_LEFT);

		HWND hwndComboFind = ::GetDlgItem( m_hwndToolbar, ID_FIND );
		_ASSERT( hwndComboFind );
		LPWSTR pszFind;
		if( bIncremental ){
			pszFind = MyGetWindowText( hwndComboFind );
		}
		else {
			pszFind = TerminateCombo( &hwndComboFind, EEREG_COMMON, NULL, REG_ENTRY_FIND, SIGNATURE_FIND_LIST );
		}

		DWORD dwFlags = m_dwFindFlags;
		POINT_PTR curCaretPos = m_ptOrgCaretPos;
		if(bIncremental ){
			dwFlags |= FLAG_FIND_NO_PROMPT;
			if(wcsncmp(&m_strIncremental[0], pszFind, m_strIncremental.length()))
				Editor_SetCaretPos( m_hWnd, POS_LOGICAL_W, &m_ptOrgCaretPos );
			m_strIncremental = pszFind;
			if( !pszFind || *pszFind == 0 ){
				Editor_ExecCommand( m_hWnd, EEID_ESCAPE );
				Editor_ExecCommand( m_hWnd, EEID_ERASE_FIND_HILITE );
			}
		}

		if( pszFind && *pszFind ){
			if( Editor_FindW( m_hWnd, dwFlags, pszFind ) )
			{  // found!
				if( !bIncremental )
				{
					/*POINT_PTR pos;
					Editor_GetCaretPos(m_hWnd, POS_LOGICAL_W, &pos);
					pos.x -= lstrlen(pszFind);
					Editor_SetCaretPos(m_hWnd, POS_LOGICAL_W, &pos);
					*/
				}
			}
			m_bFocusView = /*m_bFocusViewAfterFound && */!bIncremental;
		}
		/*
		if(!m_bFocusView)
			::SetFocus(hwndComboFind);
			*/
		if( !bIncremental )
			SendMessage( hwndComboFind, CB_SETEDITSEL, 0, MAKELPARAM( 0, -1 ) );
		else
			SendMessage( hwndComboFind, CB_SETEDITSEL, 0, MAKELPARAM( -1, 0 ) );

		//if(bIncremental )
			m_ptOrgCaretPos = curCaretPos;//Change in CBN_SETFOCUS
		//else
		//	Editor_GetCaretPos( m_hWnd, POS_LOGICAL_W, &m_ptOrgCaretPos );
		delete [] pszFind;
		if(emulator->IsVisualMode())
		{
			POINT_PTR next;
			Editor_GetSelEnd(m_hWnd, POS_LOGICAL_W, &next);
			Editor_SetCaretPos(m_hWnd, POS_LOGICAL_W, &m_ptOrgCaretPos);
			Editor_SetCaretPosEx(m_hWnd, POS_LOGICAL_W, &next, true);
		}
	}

	void OnCommand( HWND hwnd, WPARAM wParam )
	{
		switch( wParam ){
		case ID_COMMANDLINE_OK:
			{
				DoCommandLine( hwnd );
			}
			break;
		case ID_FIND_OK:
			{
				if(m_bIncremental)
				{
					POINT_PTR spos;
					Editor_GetSelStart(m_hWnd, POS_LOGICAL_W, &spos);
					Editor_SetCaretPos(m_hWnd, POS_LOGICAL_W, &spos);
				}
				{
					BOOL bShift = (GetKeyState(VK_SHIFT) < 0);
					Find( hwnd, !bShift, FALSE );
				}
			}
			break;
			
		case MAKEWPARAM( ID_FIND, CBN_SETFOCUS ):
			m_strIncremental.clear();
			Editor_GetSelStart( m_hWnd, POS_LOGICAL_W, &m_ptOrgCaretPos);
			break;

		case MAKEWPARAM( ID_FIND, CBN_SELENDOK ):
			{
				PostMessage( hwnd, WM_COMMAND, ID_FIND_OK, 0 );
			}
			break;

		case MAKEWPARAM( ID_FIND, CBN_CLOSEUP ):
			{
				if( m_bNeedSaveFindHistory ){
					HWND hwndComboFind = ::GetDlgItem( m_hwndToolbar, ID_FIND );
					_ASSERT( hwndComboFind );
					LPWSTR pszFind = TerminateCombo( &hwndComboFind, EEREG_COMMON, NULL, REG_ENTRY_FIND, SIGNATURE_FIND_LIST );
					delete [] pszFind;
					SendMessage( hwndComboFind, CB_SETEDITSEL, 0, MAKELPARAM( 0, -1 ) );
					Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
				}
			}
			break;

		case MAKEWPARAM( ID_FIND, CBN_EDITCHANGE ):
			{
				if( m_bIncremental ) {
					Find( hwnd, TRUE, TRUE );
				}
			}
			break;

		case ID_BROWSE_REG_EXP:
			if( m_bRegExp ){
				HandleRegexpMenu( hwnd, (int)wParam, ID_FIND );
			}
			break;

		case ID_PREV:
			Find( hwnd, FALSE, FALSE );
			break;

		case ID_NEXT:
			Find( hwnd, TRUE, FALSE );
			break;

		case ID_INCREMENTAL:
			m_bIncremental = !m_bIncremental;
			SetButtonStatus( ID_INCREMENTAL, m_bIncremental, true );
			break;

		case ID_OPEN_DOC:
			m_bOpenDoc = !m_bOpenDoc;
			SetButtonStatus( ID_OPEN_DOC, m_bOpenDoc, true );
			ShowHideOpenDoc();
			break;

		case ID_CASE:
			m_bCase = !m_bCase;
			SetButtonStatus( ID_CASE, m_bCase, true );
			break;

		case ID_REG_EXP:
			m_bRegExp = !m_bRegExp;
			SetButtonStatus( ID_REG_EXP, m_bRegExp, true );
			ShowHideRegexp();
			break;

		case ID_ESCAPE:
			if( !m_bRegExp ){
				m_bEscape = !m_bEscape;
				SetButtonStatus( ID_ESCAPE, m_bEscape, true );
			}
			break;

		case ID_ONLY_WORD:
			m_bOnlyWord = !m_bOnlyWord;
			SetButtonStatus( ID_ONLY_WORD, m_bOnlyWord, true );
			break;

		case ID_AROUND:
			if( !m_bOpenDoc ){
				m_bAround = !m_bAround;
				SetButtonStatus( ID_AROUND, m_bAround, true );
			}
			break;
		}
	}


#pragma warning( push )
#pragma warning( disable : 4244 ) // 'argument' : conversion from 'LONG_PTR' to 'LONG', possible loss of data
#pragma warning( disable : 4312 )  // 'type cast' : conversion from 'LONG' to 'WNDPROC' of greater size
	void OnDestroy( HWND /* hwnd */ )
	{
	}
#pragma warning( pop )

	BOOL GetProfileBinaryReg( DWORD dwKey, LPCTSTR pszConfig, LPCTSTR lpszEntry, BYTE** ppData, UINT* pBytes )
	{
		DWORD dwCount = GetProfileBinary( dwKey, pszConfig, lpszEntry, NULL, 0 );
		if( dwCount ){
			*pBytes = dwCount;
			*ppData = new BYTE[*pBytes];
			if( !GetProfileBinary( dwKey, pszConfig, lpszEntry, *ppData, dwCount ) ){
				delete [] *ppData;
				*ppData = NULL;
				return FALSE;
			}
			return TRUE;
		}
		return FALSE;
	}

	DWORD LoadFindFlags()
	{
		return (DWORD)GetProfileInt( EEREG_COMMON, NULL, szFindFlag, 0 );
	}

	void SaveFindFlags( DWORD dwFlags )
	{
		WriteProfileInt( EEREG_COMMON, NULL, szFindFlag, (int)dwFlags );
	}

	void HandleRegexpMenu( HWND /*hwndDlg*/, int nButtonID, int nComboID )
	{
		bool bReplace = false;

		RECT rect = { 0 };
		int nIndex = (int)SendMessage( m_hwndToolbar, TB_COMMANDTOINDEX, nButtonID, 0L );
		if( nIndex != -1 ){
			SendMessage( m_hwndToolbar, TB_GETITEMRECT, nIndex, (LPARAM)&rect );
			rect.top = rect.bottom;
			::ClientToScreen( m_hwndToolbar, (LPPOINT)&rect );
		}

		HMENU hMenu = LoadMenu( EEGetInstanceHandle(), MAKEINTRESOURCE( IDR_REGEXP_FIND_POPUP ) );
		HMENU hSubMenu = GetSubMenu( hMenu, 0 );
		UINT uID = TrackPopupMenu( hSubMenu, TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, rect.left, rect.top, 0, m_hwndToolbar, NULL );
		if( uID != 0 ){
			if( uID != 99 ){
				TCHAR sz[80];
				if( GetMenuString( hSubMenu, uID, sz, _countof( sz ), MF_BYCOMMAND ) ){
					LPTSTR p = _tcschr( sz, '\t' );
					if( p )  *p = 0;
					HWND hwndCombo = GetDlgItem( m_hwndToolbar, nComboID );
					_ASSERT( hwndCombo );
					if( hwndCombo ){
						int nLen = (int)SendMessage( hwndCombo, WM_GETTEXTLENGTH, 0, 0 ) + 40;
						TCHAR* pszText = new TCHAR[ nLen ];
						if( pszText != NULL ){
							ZeroMemory( pszText, sizeof( TCHAR ) * nLen );
							SendMessage( hwndCombo, WM_GETTEXT, nLen, (LPARAM)pszText );
							int cchBuf = nLen + 80;
							TCHAR* pszNewText = new TCHAR[ cchBuf ];
							if( pszNewText ){
								if( !bReplace && uID == 1 ){
									StringCopy( pszNewText, cchBuf, sz );
									StringCat( pszNewText, cchBuf, pszText );
								}
								else {
									StringCopy( pszNewText, cchBuf, pszText );
									StringCat( pszNewText, cchBuf, sz );
								}
								SetWindowText( hwndCombo, pszNewText );
								delete [] pszNewText;
							}
							delete [] pszText;
						}
					}
				}
			}
			else {
//				CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwndDlg ));
//				if( pFrame ){
					Editor_Help( m_hWnd, _T("howto/search/search_regexp_syntax.htm") );
//				}
			}
		}
		DestroyMenu( hMenu );
	}

	LPWSTR TerminateCombo( HWND* pCombo, DWORD dwKey, LPCWSTR config, LPCWSTR entry, int signature )
	{
		if( m_bNeedSaveFindHistory ){
			m_bNeedSaveFindHistory = false;
		}
		if( *pCombo == NULL )  return NULL;
		LPWSTR pszFind = MyGetWindowText( *pCombo );
		if( pszFind != NULL ){
			if( *pszFind != '\0' ){
				int nMax = (int)SendMessage( *pCombo, CB_GETCOUNT, 0, 0 );
				for( int i = 0; i < nMax; i++ ){
					LPWSTR pBuf = GetComboBoxString( *pCombo, i );

					if( pBuf != NULL ){
						if( wcscmp( pBuf, pszFind ) == 0 ){
							SendMessage( *pCombo, CB_DELETESTRING, i, 0 );
							::SetWindowTextW( *pCombo, pszFind );
							delete [] pBuf;
							break;
						}
						delete [] pBuf;
					}
				}
				SendMessageW( *pCombo, CB_INSERTSTRING, 0, (LPARAM)pszFind );
			}
			int nMax = (int)SendMessage( *pCombo, CB_GETCOUNT, 0, 0 );
			if( nMax > MAX_FIND_HISTORY )  nMax = MAX_FIND_HISTORY;

			DWORD dwCount;
			dwCount = sizeof( int );
			for( int i = 0; i < nMax; i++ ){
				LPWSTR psz = GetComboBoxString( *pCombo, i );
				if( psz != NULL ){
					int nLen = (int)lstrlen( psz );
					if( nLen > MAX_FIND_LENGTH )  nLen = MAX_FIND_LENGTH;
					dwCount += nLen * sizeof(WCHAR) + sizeof( int );
					delete [] psz;
				}
			}
			dwCount += sizeof(DWORD);
			char* pBuf = new char[dwCount + sizeof(WCHAR)];
			if( pBuf != NULL ){
				char* p = pBuf;
				*((DWORD*)p) = signature;
				p += sizeof( DWORD );
				*((int*)p) = nMax;
				p += sizeof( int );
				for( int i = 0; i < nMax; i++ ){
					LPWSTR psz = GetComboBoxString( *pCombo, i );
					if( psz != NULL ){
						int nLen = (int)lstrlen( psz );
						if( nLen > MAX_FIND_LENGTH )  nLen = MAX_FIND_LENGTH;
						*((int*)p) = nLen;
						p += sizeof( int );
						StringCopyNW( (LPWSTR)p, nLen + 1, (LPCWSTR)psz, nLen );
						p += nLen * sizeof(WCHAR);
						delete [] psz;
					}
				}
				WriteProfileBinary( dwKey, config, entry, (const LPBYTE)pBuf, dwCount, true );
				delete [] pBuf;
			}
		}
		return pszFind;
	}

	void InitializeCombo( HWND* pCombo, LPCWSTR szFind, DWORD dwKey, LPCWSTR config, LPCWSTR entry, int signature )
	{
		if( *pCombo == NULL )  return;
		SendMessage( *pCombo, CB_SETEXTENDEDUI, TRUE, 0 );
		SendMessage( *pCombo, CB_LIMITTEXT, MAX_FIND_LENGTH, 0 );
		SendMessage( *pCombo, CB_RESETCONTENT, 0, 0 );

		if( szFind[0] != '\0' ){
			SendMessage( *pCombo, CB_ADDSTRING, 0, (LPARAM)(szFind) );
			SetWindowText( *pCombo, szFind );
		}
		DWORD dwCount;
		WCHAR szWord[MAX_FIND_LENGTH + 1];
		char* pBuf;
		if( GetProfileBinaryReg( dwKey, config, entry, (LPBYTE*)&pBuf, (UINT*)&dwCount ) ){
			char* pTemp = new char[dwCount];
			if( pTemp != NULL ){
				int nMax, nLen;
				char* p = pBuf;
				DWORD dwSign = *((DWORD*)p);
				p += sizeof( DWORD );
				char* p0 = p;
				if( dwSign == signature ){
					HFONT hFont = (HFONT)SendMessage( *pCombo, WM_GETFONT, 0, 0 );
					_ASSERT( hFont );
					int cxMax = 0;
					HDC hdc = GetDC( *pCombo );
					if( hdc ){
						HFONT hOldFont = NULL;
						if( hFont ){
							hOldFont = (HFONT)SelectObject( hdc, hFont );
						}
						nMax = *((int*)p);
						p += sizeof( int );
						p0 = p;
						for( int i = 0; i < nMax; i ++ ){
							nLen = *((int*)p);
							p += sizeof( int );
							StringCopyNW( szWord, _countof( szWord ), (LPWSTR)p, min( nLen, MAX_FIND_LENGTH ) );
							SIZE size = { 0 };
							BOOL bResult = GetTextExtentPoint32( hdc, szWord, lstrlen( szWord ), &size );
							_ASSERT( bResult );
							if( bResult ){
								if( size.cx > cxMax ){
									cxMax = size.cx;
								}
							}
							p += nLen * sizeof(WCHAR);
						}
						_ASSERT( p == pBuf + dwCount );
						SendMessage( *pCombo, CB_SETDROPPEDWIDTH , min( cxMax + 24, 600 ), 0 );

						if( szFind[0] != '\0' ){
							SetWindowText( *pCombo, szFind );
						}

						p = p0;
						for( int i = 0; i < nMax; i ++ ){
							nLen = *((int*)p);
							p += sizeof( int );
							StringCopyNW( szWord, _countof( szWord ), (LPWSTR)p, min( nLen, MAX_FIND_LENGTH ) );
							if( wcscmp( szFind, szWord ) != 0 ){  // don't add szFind again.
								SendMessage( *pCombo, CB_ADDSTRING, 0, (LPARAM)szWord );
							}
							if( i == 0 && szFind[0] == '\0' ){
								SetWindowText( *pCombo, szWord );
							}
							p += nLen * sizeof(WCHAR);
						}
						_ASSERT( p == pBuf + dwCount );
						if( hOldFont ){
							SelectObject( hdc, hOldFont );
						}
						ReleaseDC( *pCombo, hdc );
					}

				}
				delete [] pTemp;
			}
			delete [] pBuf;
		}
	}

	void InitFindDlg( HWND hwnd, LPCWSTR szFind )
	{
		{
			HWND hwndCombo = GetDlgItem( hwnd, ID_FIND );
			_ASSERT( hwndCombo );
			InitializeCombo( &hwndCombo,
				(LPCWSTR)szFind,
				EEREG_COMMON,
				NULL,
				REG_ENTRY_FIND,
				SIGNATURE_FIND_LIST );
		}
	}
	void InitCommandLineDlg( HWND hwnd, LPCWSTR szFind )
	{
		{
			TCHAR szFileName[MAX_PATH];
			GetModuleFile(szFileName);
			HWND hwndCombo = GetDlgItem( hwnd, ID_COMMANDLINE );
			_ASSERT( hwndCombo );
			InitializeCombo( &hwndCombo,
				(LPCWSTR)szFind,
				EEREG_PLUGINS,
				szFileName,
				REG_ENTRY_COMMANDLINE,
				SIGNATURE_FIND_LIST );
		}
	}
	
	// PropDlg
	BOOL OnPropInitDialog( HWND hwnd )
	{
		_ASSERTE( m_bProfileLoaded );
		TCHAR sz[80];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, sz, _countof( sz ) );
		SetWindowText( hwnd, sz );
		//CheckDlgButton( hwnd, IDC_FOCUS_VIEW, m_bFocusViewAfterFound );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WPARAM wParam )
	{
		switch( wParam ){
		case IDOK:
			{
				//m_bFocusViewAfterFound = !!IsDlgButtonChecked( hwnd, IDC_FOCUS_VIEW );
				//WriteProfileInt( _T("FocusView"), m_bFocusViewAfterFound );
				EndDialog( hwnd, IDOK );
			}
			break;

		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
		return;
	}
	
	void ShowHideRegexp()
	{
		SetButtonStatus( ID_ESCAPE, m_bEscape, !m_bRegExp );
		SetButtonStatus( ID_BROWSE_REG_EXP, false, m_bRegExp );
	}

	void ShowHideOpenDoc()
	{
		SetButtonStatus( ID_AROUND, m_bAround, !m_bOpenDoc );
	}
};

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			bResult = pFrame->OnPropInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			pFrame->OnDlgCommand( hwnd, wParam );
		}
		break;
	}
	return bResult;
}


INT_PTR CALLBACK EmViProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	INT_PTR bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
		}
		break;

	case WM_COMMAND:
		{
			//TRACE( _T("WM_COMMAND: wParam = %x, lParam = %x.\n"), wParam, lParam );
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			pFrame->OnCommand( hwnd, wParam );
		}
		break;

	case WM_DESTROY:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			if( pFrame ){
				pFrame->OnDestroy( hwnd );
			}
		}
		break;

	case WM_NOTIFY:
		{
			NMHDR* pnmh = (NMHDR*)lParam;
			switch( pnmh->code ){
			case TTN_GETDISPINFO:
				{
					NMTTDISPINFO* pDispInfo = (NMTTDISPINFO*)pnmh;
					LoadString( EEGetInstanceHandle(), (UINT)pDispInfo->hdr.idFrom, pDispInfo->szText, _countof( pDispInfo->szText ) );
				}
			break;
			}
		}
		break;
	}
	return bResult;
}

HWND GetComboEdit( HWND hwndCombo )
{
	HWND hwndEdit = GetDlgItem( hwndCombo, 1001 );
	_ASSERT( hwndEdit );
	return hwndEdit;
}

LRESULT CALLBACK FindComboProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg ){
	//case WM_KEYDOWN:
	case WM_SYSKEYDOWN:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			_ASSERTE( pFrame != NULL );
			if( wParam == VK_DELETE ){
				HWND hwndCombo = GetParent( hwnd );
				_ASSERT( hwndCombo );

				int iSel = (int)SendMessage( hwndCombo, CB_GETCURSEL, 0, 0 );
				if( iSel >= 0 ){
					SendMessage( hwndCombo, CB_DELETESTRING, iSel, 0 );
					SendMessage( hwndCombo, CB_SETCURSEL, iSel, 0 );
					pFrame->m_bNeedSaveFindHistory = true;
				}
				return 0;
			}
		}
		break;
	}

	CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
//  pFrame can be NULL
	if( pFrame != NULL && pFrame->m_lpOldFindComboProc != NULL ){
		return CallWindowProc( pFrame->m_lpOldFindComboProc, hwnd, msg, wParam, lParam);
	}
	else {
		return 0;
	} 
}


// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

