#include "stdafx.h"
#include "migemo.hpp"

namespace {

void to_mbcs(std::string& out, LPCSTR str) {
  out.assign(str);
}

void to_mbcs(std::string& out, const std::string& str) {
  out.assign(str);
}

void to_mbcs(std::string& out, LPCWSTR wstr) {
  LPSTR buffer;

  int length = WideCharToMultiByte(CP_ACP, 0, wstr, -1, 0, 0, 0, 0);

  buffer = new CHAR[length];

  WideCharToMultiByte(CP_ACP, 0, wstr, -1, buffer, length, 0, 0);

  out.assign(buffer);

  delete[] buffer;
}

void to_mbcs(std::string& out, const std::wstring& wstr) {
  to_mbcs(out, wstr.c_str());
}

void to_wcs(std::wstring& out, LPCWSTR wstr) {
  out.assign(wstr);
}

void to_wcs(std::wstring& out, const std::wstring& wstr) {
  out.assign(wstr);
}

void to_wcs(std::wstring& out, LPCSTR str) {
  LPWSTR buffer;

  int length = MultiByteToWideChar(CP_ACP, 0, str, -1, 0, 0);

  buffer = new WCHAR[length];

  MultiByteToWideChar(CP_ACP, 0, str, -1, buffer, length);

  out.assign(buffer);

  delete[] buffer;
}

void to_wcs(std::wstring& out, const std::string& str) {
  to_wcs(out, str.c_str());
}

}

CMigemo::CMigemo()
    : m_handle(0), m_object(0) {
}

bool CMigemo::Load(LPCTSTR lpMigemo) {
  Release();
  m_handle = LoadLibrary(lpMigemo);
  if (!m_handle) {
    return false;
  }
  MIGEMO_open migemo_open = reinterpret_cast<MIGEMO_open>(GetProcAddress(m_handle, "migemo_open"));

  m_object = migemo_open(0);
  if (!m_object) {
    return false;
  }

  m_migemo_is_enable = reinterpret_cast<MIGEMO_is_enable>(GetProcAddress(m_handle, "migemo_is_enable"));
  m_migemo_load = reinterpret_cast<MIGEMO_load>(GetProcAddress(m_handle, "migemo_load"));
  m_migemo_query = reinterpret_cast<MIGEMO_query>(GetProcAddress(m_handle, "migemo_query"));
  m_migemo_release = reinterpret_cast<MIGEMO_release>(GetProcAddress(m_handle, "migemo_release"));
  m_migemo_set_operator = reinterpret_cast<MIGEMO_set_operator>(GetProcAddress(m_handle, "migemo_set_operator"));

  return true;
}

bool CMigemo::LoadDictionary(LPCTSTR lpDict) {
  if (!m_object) {
    return false;
  }

  std::string dict_path, dict_dir;

  to_mbcs(dict_path, lpDict);

  {
    CHAR dict_dir_[MAX_PATH + 1];

    lstrcpynA(dict_dir_, dict_path.c_str(), MAX_PATH);
    PathRemoveFileSpecA(dict_dir_);
    PathAddBackslashA(dict_dir_);

    to_mbcs(dict_dir, dict_dir_);
  }

  if (m_migemo_load(m_object, MIGEMO_DICTID_MIGEMO, dict_path.c_str()) == MIGEMO_DICTID_INVALID) {
    return false;
  }
  if (m_migemo_load(m_object, MIGEMO_DICTID_ROMA2HIRA, (dict_dir + "roma2hira.dat").c_str()) == MIGEMO_DICTID_INVALID) {
    return false;
  }
  if (m_migemo_load(m_object, MIGEMO_DICTID_HIRA2KATA, (dict_dir + "hira2kata.dat").c_str()) == MIGEMO_DICTID_INVALID) {
    return false;
  }
  if (m_migemo_load(m_object, MIGEMO_DICTID_HAN2ZEN, (dict_dir + "han2zen.dat").c_str()) == MIGEMO_DICTID_INVALID) {
    return false;
  }

  return true;
}

bool CMigemo::Query(std::wstring& out, const std::wstring& in) {
  std::string q;
  to_mbcs(q, in);

  char* regexp = m_migemo_query(m_object, q.c_str());

  to_wcs(out, regexp);

  m_migemo_release(m_object, regexp);

  return true;
}

void CMigemo::Release() {
  if (!m_handle) {
    return;
  }
  if (m_object) {
    MIGEMO_close migemo_close = reinterpret_cast<MIGEMO_close>(GetProcAddress(m_handle, "migemo_close"));
    migemo_close(m_object);
    m_object = 0;
  }
  FreeLibrary(m_handle);
  m_handle = 0;
}

void CMigemo::SetOperator(MIGEMO_OPINDEX index, const char* op) {
  if (!m_object) {
    return;
  }
  m_migemo_set_operator(m_object, index, op);
}
