#pragma once

#define MIGEMO_VERSION "1.2"

enum MIGEMO_DICTID {
  MIGEMO_DICTID_INVALID	= 0,
  MIGEMO_DICTID_MIGEMO	= 1,
  MIGEMO_DICTID_ROMA2HIRA	= 2,
  MIGEMO_DICTID_HIRA2KATA	= 3,
  MIGEMO_DICTID_HAN2ZEN	= 4,
};

enum MIGEMO_OPINDEX {
  MIGEMO_OPINDEX_OR		  = 0,
  MIGEMO_OPINDEX_NEST_IN	  =	1,
  MIGEMO_OPINDEX_NEST_OUT	  =	2,
  MIGEMO_OPINDEX_SELECT_IN  =	3,
  MIGEMO_OPINDEX_SELECT_OUT =	4,
  MIGEMO_OPINDEX_NEWLINE	  =	5,
};

class CMigemo {
public:


  typedef int (__cdecl *MIGEMO_PROC_CHAR2INT)(unsigned char*, unsigned int*);
  typedef int (__cdecl *MIGEMO_PROC_INT2CHAR)(unsigned int, unsigned char*);

  typedef void* migemo_object;

  typedef migemo_object (__cdecl *MIGEMO_open) (const char* dict);
  typedef void (__cdecl *MIGEMO_close) (migemo_object object);
  typedef char* (__cdecl *MIGEMO_query) (migemo_object object, const char* query);
  typedef void (__cdecl *MIGEMO_release) (migemo_object object, char* string);

  typedef int (__cdecl *MIGEMO_set_operator) (migemo_object object, int index, const char* op);
  typedef const char* (*MIGEMO_get_operator) (migemo_object object, int index);
  typedef void (__cdecl *MIGEMO_setproc_char2int) (migemo_object object, MIGEMO_PROC_CHAR2INT proc);
  typedef void (__cdecl *MIGEMO_setproc_int2char) (migemo_object object, MIGEMO_PROC_INT2CHAR proc);

  typedef int (__cdecl *MIGEMO_load) (migemo_object obj, int dict_id, const char* dict_file);
  typedef int (__cdecl *MIGEMO_is_enable) (migemo_object obj);

  CMigemo();

  ~CMigemo() {
    Release();
  }

  bool Load(LPCTSTR lpMigemo);

  bool LoadDictionary(LPCTSTR lpDict);

  void Release();

  bool IsEnable() {
    return m_object && m_migemo_is_enable(m_object) != 0;
  }

  bool Query(std::wstring& out, const std::wstring& in);

  void SetOperator(MIGEMO_OPINDEX index, const char* op);

private:
  HMODULE m_handle;
  migemo_object m_object;
  MIGEMO_load m_migemo_load;
  MIGEMO_release m_migemo_release;
  MIGEMO_query m_migemo_query;
  MIGEMO_set_operator m_migemo_set_operator;
  MIGEMO_get_operator m_migemo_get_operator;
  MIGEMO_setproc_char2int m_migemo_setproc_char2int;
  MIGEMO_setproc_int2char m_migemo_setproc_int2char;
  MIGEMO_is_enable m_migemo_is_enable;

};
