#pragma once

class CMyFrame : public CETLFrame<CMyFrame>
{
public:

	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_TRUE_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= CLR_NONE				};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 7010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 7000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

  struct ClosedFile {
    std::wstring name;
    int codePage;
  };

  std::list<ClosedFile> files;
  
	BOOL QueryStatus(HWND hwndView, LPBOOL pbChecked)
	{
		*pbChecked = FALSE;
		return static_cast<BOOL>(!files.empty());
	}

  void OnCommand(HWND hwndView)
  {
    const ClosedFile& file = files.back();

    LOAD_FILE_INFO_EX info;
    info.cbSize = sizeof(LOAD_FILE_INFO_EX);
    info.nCP = file.codePage;
    info.bDetectAll = FALSE;
    info.bDetectCharset = TRUE;
    info.bDetectUnicode = TRUE;
    info.bDetectUTF8 = TRUE;
    info.nFlags = LFI_ALLOW_NEW_WINDOW;

    Editor_LoadFileW(hwndView, &info, file.name.c_str());

    files.pop_back();
  }

	void OnEvents(HWND hwndView, UINT nEvent, LPARAM lParam)
	{
    if(nEvent & EVENT_DOC_CLOSE) {
      HEEDOC hDoc = reinterpret_cast<HEEDOC>(lParam);
      int index = Editor_Info(hwndView, EI_DOC_TO_INDEX, reinterpret_cast<LPARAM>(hDoc));

      WCHAR szFileName[MAX_PATH];
      Editor_DocInfo(hwndView, index, EI_GET_FILE_NAMEW, reinterpret_cast<LPARAM>(szFileName));

      int codePage = static_cast<int>(Editor_DocInfo(hwndView, index, EI_GET_ENCODE, 0));

      ClosedFile file = { szFileName, codePage };

      std::list<ClosedFile>::iterator it = std::find_if(files.begin(), files.end(), boost::bind(std::equal_to<std::wstring>(), boost::bind(&ClosedFile::name, _1), file.name));
      if(it != files.end()) {
        files.erase(it);
      }
      files.push_back(file);
    }
	}

	BOOL QueryUninstall(HWND hDlg)
	{
		return TRUE;
	}

	BOOL SetUninstall(HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam)
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString(EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof(sz) / sizeof(TCHAR));
		LoadString(EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof(szAppName) / sizeof(TCHAR));
		if(MessageBox(hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION) == IDYES) {
			// TODO: Delete the registry/INI key.
  		return UNINSTALL_SIMPLE_DELETE;
    }
    return UNINSTALL_FALSE;
	}

	BOOL QueryProperties(HWND hDlg)
	{
		return TRUE;
	}

	BOOL SetProperties(HWND hDlg)
	{
		return TRUE;
	}

	BOOL PreTranslateMessage(HWND hwndView, MSG* pMsg)
	{
		return FALSE;
	}

  BOOL UseDroppedFiles(HWND hwndView)
  {
    return FALSE;
  }

	CMyFrame()
	{
	}

	~CMyFrame()
	{
	}




};
