// ShowReturns.cpp
//

#include "stdafx.h"
#include "resource.h"
#include "plugin.h"

#define EMEDITOR_API extern "C"

HINSTANCE g_hInstance = NULL;
UINT g_nCmdID = 0;

BOOL APIENTRY DllMain( HINSTANCE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    if( ul_reason_for_call == DLL_PROCESS_ATTACH ){
		g_hInstance = hModule;
	}
    return TRUE;
}

LPCTSTR szConfigRootKey = _T("Software\\EmSoft\\EmEditor v3\\Config");
LPCTSTR szCust = _T("Cust");

HKEY GetConfigRootKey()
{
	HKEY hKey = NULL;
	if( RegOpenKeyEx( HKEY_CURRENT_USER, szConfigRootKey, 0, KEY_READ, &hKey ) == ERROR_SUCCESS ){
		return hKey;
	}
	return NULL;
}

HKEY GetConfigKey( LPCTSTR pszConfig )
{
	HKEY hConfigKey = NULL;
	HKEY hSecKey = GetConfigRootKey();
	if( hSecKey != NULL ){
		RegOpenKeyEx(hSecKey, pszConfig, 0, KEY_WRITE|KEY_READ, &hConfigKey );
		RegCloseKey(hSecKey);
	}
	return hConfigKey;
}

void SaveCustomizeInfo( HKEY hKey, CCustomizeInfo& cust )
{
	RegSetValueEx(hKey, szCust, 0, REG_BINARY, (LPBYTE)&cust, sizeof( CCustomizeInfo ) );
}

BOOL SaveProfile( LPCTSTR pszConfig, CCustomizeInfo& cust )
{
	HKEY hKey = GetConfigKey( pszConfig );
	if( hKey != NULL ){
		SaveCustomizeInfo( hKey, cust );
		RegCloseKey( hKey );
		return TRUE;
	}
	return FALSE;
}


BOOL LoadCustomizeInfo( HKEY hKey, CCustomizeInfo& cust )
{
	DWORD dwType;
	DWORD dwCount;
	if( RegQueryValueEx( hKey, szCust, NULL, &dwType, (LPBYTE)NULL, &dwCount) == ERROR_SUCCESS ){
		if( dwType == REG_BINARY && dwCount == sizeof( CCustomizeInfo ) ){
			return( RegQueryValueEx( hKey, szCust, NULL, &dwType, (LPBYTE)&cust, &dwCount) == ERROR_SUCCESS );
		}
	}
	return FALSE;
}

BOOL LoadProfile( LPCTSTR pszConfig, CCustomizeInfo& cust )
{
	BOOL bResult = FALSE;
	HKEY hKey = GetConfigKey( pszConfig );
	if( hKey != NULL ){
		bResult = LoadCustomizeInfo( hKey, cust );
		RegCloseKey( hKey );
	}
	return bResult;
}


EMEDITOR_API void OnCommand( HWND hwnd )
{
	TCHAR szConfigName[MAX_CONFIG_NAME];
	Editor_GetConfigA( hwnd, szConfigName );
	CCustomizeInfo cust;
	LoadProfile( szConfigName, cust );
	
	cust.m_bShowCR = !cust.m_bShowCR;

	if( SaveProfile( szConfigName, cust ) ){
		Editor_LoadConfigA( hwnd, szConfigName );
	}
}

EMEDITOR_API BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	hwnd;
	TCHAR szConfigName[MAX_CONFIG_NAME];
	Editor_GetConfigA( hwnd, szConfigName );
	CCustomizeInfo cust;
	LoadProfile( szConfigName, cust );
	*pbChecked = cust.m_bShowCR;
	return TRUE;
}

EMEDITOR_API void OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam )
{
	if( nEvent & EVENT_CREATE ){
		g_nCmdID = (UINT)lParam;
	}
	if( nEvent & EVENT_SEL_CHANGED ){
		Editor_UpdateToolbar( hwnd, g_nCmdID );
	}
}

EMEDITOR_API UINT GetMenuTextID()
{
	return IDS_MENU_TEXT;
}

EMEDITOR_API UINT GetStatusMessageID()
{
	return IDS_STATUS_MESSAGE;
}

EMEDITOR_API UINT GetBitmapID()
{
	return IDB_BITMAP;
}

EMEDITOR_API LRESULT PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam )
{
	TCHAR sz[80];
	TCHAR szAppName[80];
	LRESULT lResult = 0;
	switch( nMsg ){
	case EP_GET_NAMEA:
		LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		lResult = lstrlen( szAppName ) + 1;
		if( lParam != NULL ){
			lstrcpyn( (LPTSTR)lParam, szAppName, wParam );
		}
		break;
	case EP_GET_VERSIONA:
		LoadString( g_hInstance, IDS_VERSION, sz, sizeof( sz ) / sizeof( TCHAR ) );
		lResult = lstrlen( sz ) + 1;
		if( lParam != NULL ){
			lstrcpyn( (LPTSTR)lParam, sz, wParam );
		}
		break;
	case EP_QUERY_UNINSTALL:
		lResult = TRUE;
		break;
	case EP_SET_UNINSTALL:
		LoadString( g_hInstance, IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hwnd, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			lResult = TRUE;
		}
		break;
	case EP_GET_BITMAP:
		if( wParam & BITMAP_LARGE ){
			if( wParam & BITMAP_24BIT_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_TRUE_24_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_TRUE_24_HOT;
				}
				else {
					lResult = IDB_TRUE_24_DEFAULT;
				}
			}
			else if( wParam & BITMAP_256_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_256C_24_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_256C_24_HOT;
				}
				else {
					lResult = IDB_256C_24_DEFAULT;
				}
			}
			else {
				lResult = IDB_16C_24;
			}
		}
		else {
			if( wParam & BITMAP_24BIT_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_TRUE_16_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_TRUE_16_HOT;
				}
				else {
					lResult = IDB_TRUE_16_DEFAULT;
				}
			}
			else if( wParam & BITMAP_256_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_256C_16_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_256C_16_HOT;
				}
				else {
					lResult = IDB_256C_16_DEFAULT;
				}
			}
			else {
				lResult = IDB_BITMAP;
			}
		}
		break;
	case EP_GET_MASK:
		if( wParam & BITMAP_24BIT_COLOR ){
			lResult = CLR_NONE;
		}
		else if( wParam & BITMAP_256_COLOR ){
			lResult = RGB( 255, 0, 255 );
		}
		break;
	}
	return lResult;
}

