// vertical.cpp
//

#include "stdafx.h"
#include "resource.h"
#include "plugin.h"

#define EMEDITOR_API extern "C"

HINSTANCE g_hInstance = NULL;
UINT g_nCmdID = 0;

BOOL APIENTRY DllMain( HINSTANCE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    if( ul_reason_for_call == DLL_PROCESS_ATTACH ){
		g_hInstance = hModule;
	}
    return TRUE;
}

EMEDITOR_API void OnCommand( HWND hwnd )
{
	BOOL bOverwrite;
	Editor_QueryStatus( hwnd, EEID_INSERT, &bOverwrite );
	if( bOverwrite ){
		Editor_ExecCommand( hwnd, EEID_INSERT );
	}
	POINT ptStart, ptEnd;
	Editor_GetSelStart( hwnd, TRUE, &ptStart );
	Editor_GetSelEnd( hwnd, TRUE, &ptEnd );
	if( ptStart.x != 0 )
		ptStart.x = 0;
	if( ptEnd.x != 0 ){
		ptEnd.x = 0;
		ptEnd.y++;
	}
	if( ptStart.y < ptEnd.y ){
		int nSelLine = ptEnd.y - ptStart.y ;
		GET_LINE_INFO gli;
		gli.cb = 0;
		gli.flags = FLAG_LOGICAL;
		gli.yLine = ptStart.y;
		int x = 0;
		int y;
		int nMaxLen = 0;
		int* pnBufLen = new int[nSelLine];
		int nHalfChar = 0;
		int nTempBufLen = 0;
		int nAllChar = 0;
		// es̕ pnBufLen Ɏ擾
		for( gli.yLine ; gli.yLine < (UINT)ptEnd.y ; gli.yLine++ ){
			y = gli.yLine - ptStart.y;
			gli.cb = 0;
			pnBufLen[y] = Editor_GetLineW( hwnd, &gli, NULL );
			WCHAR* pBuf = new WCHAR[pnBufLen[y]];
			gli.cb = pnBufLen[y];
			Editor_GetLineW( hwnd, &gli, pBuf );
			nTempBufLen = wcslen( pBuf );
			for( int i = 0; i < nTempBufLen; i++){
				if( Editor_IsCharHalfOrFull( hwnd, pBuf[i] ) == 1 ){
					nHalfChar++;
				}
			}
			nAllChar += nTempBufLen;
			if( nMaxLen < nTempBufLen )
				nMaxLen = nTempBufLen;

			delete [] pBuf;
		}

		// nMaxLen * ( nSelLine * 2 + 1 ) : s * (1s̕ƃXy[X + sL)
		// nHalfChar : p̑
		// nMaxLen * nSelLine - nAllChar : c̕ - ̕
		// 1 : '\0'
		int nStringLength = nMaxLen * ( nSelLine * 2 + 1 ) + nHalfChar + ( nMaxLen * nSelLine - nAllChar ) + 1;
		WCHAR* pMatrix = new WCHAR[ nStringLength ] ;

		int* pnPosEachLine = new int[ nMaxLen ];
		for( x = 0; x < nMaxLen; x++ ){
			pnPosEachLine[x] = x * ( nSelLine * 2 + 1 );
		}

		// pMatrix ɂĊes̊Jnʒu pnPosEachLine Ɏ擾
		for( gli.yLine = ptStart.y; gli.yLine < (UINT)ptEnd.y ; gli.yLine++ ){
			int y = gli.yLine - ptStart.y;
			WCHAR* pBuf = new WCHAR[pnBufLen[y]];
			gli.cb = pnBufLen[y];
			Editor_GetLineW( hwnd, &gli, pBuf );
			for( x = 0; x < nMaxLen; x++ ){
				if( x < pnBufLen[y] - 1){
					// p
					if( Editor_IsCharHalfOrFull( hwnd, pBuf[x] ) == 1 ){
						for( int i = x + 1; i < nMaxLen; i++)
							pnPosEachLine[i] += 1;
					}
				}
				else {
					for( int i = x + 1; i < nMaxLen; i++)
						pnPosEachLine[i] += 1;
				}
			}
			delete [] pBuf;
		}
		int i = 1;
		// pMatrixɂāAes̍Ōɂʒuɉs
		for( x = 0 ; x < nStringLength - 3; x++ ){
			if( nMaxLen > 1 && x == pnPosEachLine[i] - 2 ){
				pMatrix[ x++ ] = L'\r';
				pMatrix[ x++ ] = L'\n';
				if( i < nMaxLen - 1 )
					i++;
			}
			pMatrix[ x ] = L' ';
		}
		pMatrix[ x++ ] = L'\r';
		pMatrix[ x++ ] = L'\n';
		pMatrix[ x ] = L'\0';
		
		
		// eLXg擾1 pMatrix ɑ
		for( gli.yLine = ptEnd.y -1; (int)gli.yLine >= ptStart.y ; gli.yLine-- ){
			int y = gli.yLine - ptStart.y;
			WCHAR* pBuf = new WCHAR[pnBufLen[y]];
			gli.cb = pnBufLen[y];
			Editor_GetLineW( hwnd, &gli, pBuf );

			for( x = 0; x < nMaxLen; x++ ){
				if( x < pnBufLen[y] - 1){
					pMatrix[ pnPosEachLine[x] ] = pBuf[x];
					pnPosEachLine[x] += 2;
					if( Editor_IsCharHalfOrFull( hwnd, pBuf[x] ) == 1 ){
						pnPosEachLine[x]++;
					}
				}
				else {
					pnPosEachLine[x] += 3;
				}
			}
			delete [] pBuf;
		}
		Editor_SetSelView( hwnd, &ptStart, &ptEnd );
		Editor_ExecCommand( hwnd, EEID_DELETE );
		Editor_InsertStringW( hwnd, pMatrix );

		delete [] pnPosEachLine;
		delete [] pnBufLen;
		delete [] pMatrix;
	}
	if( bOverwrite ){
		Editor_ExecCommand( hwnd, EEID_INSERT );
	}
}

EMEDITOR_API BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	*pbChecked = FALSE;
	BOOL bReadOnly;
	Editor_QueryStatus( hwnd, EEID_READ_ONLY, &bReadOnly );
	if( bReadOnly )  return FALSE;
	int nFlags = (Editor_GetSelType( hwnd ) & SEL_TYPE_MASK);
	return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
}

EMEDITOR_API void OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam )
{
	if( nEvent & EVENT_CREATE ){
		g_nCmdID = (UINT)lParam;
	}
	if( nEvent & EVENT_SEL_CHANGED ){
		Editor_UpdateToolbar( hwnd, g_nCmdID );
	}
}

EMEDITOR_API UINT GetMenuTextID()
{
	return IDS_MENU_TEXT;
}

EMEDITOR_API UINT GetStatusMessageID()
{
	return IDS_STATUS_MESSAGE;
}

EMEDITOR_API UINT GetBitmapID()
{
	return IDB_BITMAP;
}

EMEDITOR_API LRESULT PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam )
{
	TCHAR sz[80];
	TCHAR szAppName[80];
	LRESULT lResult = 0;
	switch( nMsg ){
	case EP_GET_NAMEA:
		LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		lResult = lstrlen( szAppName ) + 1;
		if( lParam != NULL ){
			lstrcpyn( (LPTSTR)lParam, szAppName, wParam );
		}
		break;
	case EP_GET_VERSIONA:
		LoadString( g_hInstance, IDS_VERSION, sz, sizeof( sz ) / sizeof( TCHAR ) );
		lResult = lstrlen( sz ) + 1;
		if( lParam != NULL ){
			lstrcpyn( (LPTSTR)lParam, sz, wParam );
		}
		break;
	case EP_QUERY_UNINSTALL:
		lResult = TRUE;
		break;
	case EP_SET_UNINSTALL:
		LoadString( g_hInstance, IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hwnd, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			lResult = TRUE;
		}
		break;
	case EP_GET_BITMAP:
		if( wParam & BITMAP_LARGE ){
			if( wParam & BITMAP_24BIT_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_TRUE_24_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_TRUE_24_HOT;
				}
				else {
					lResult = IDB_TRUE_24_DEFAULT;
				}
			}
			else if( wParam & BITMAP_256_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_256C_24_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_256C_24_HOT;
				}
				else {
					lResult = IDB_256C_24_DEFAULT;
				}
			}
			else {
				lResult = IDB_16C_24;
			}
		}
		else {
			if( wParam & BITMAP_24BIT_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_TRUE_16_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_TRUE_16_HOT;
				}
				else {
					lResult = IDB_TRUE_16_DEFAULT;
				}
			}
			else if( wParam & BITMAP_256_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_256C_16_BW;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_256C_16_HOT;
				}
				else {
					lResult = IDB_256C_16_DEFAULT;
				}
			}
			else {
				lResult = IDB_BITMAP;
			}
		}
		break;
	case EP_GET_MASK:
		if( wParam & BITMAP_24BIT_COLOR ){
			lResult = CLR_NONE;
		}
		else if( wParam & BITMAP_256_COLOR ){
			lResult = RGB( 255, 0, 255 );
		}
		break;
	}
	return lResult;
}

