

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   AutoAppend EmEditor Plugin 1.4                                *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                        2004-10-05   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#include "stdafx.h"

#include "engine.h"
#include "escape.h"
#include "resource.h"


#define EMEDITOR_API extern "C"


#ifdef _UNICODE
#define Editor_GetSelText( a, b, c ) Editor_GetSelTextW( a, b, c )
#else
#define Editor_GetSelText( a, b, c ) Editor_GetSelTextA( a, b, c )
#endif



HINSTANCE g_hInstance = NULL;
UINT g_nCmdID = 0;

DEVIL_CONFIG * g_CONFIG = NULL;
TCHAR * g_szAppend = NULL;

HWND g_hParent = NULL;
bool g_bInCommand = false;

HWND g_hDropbox  = NULL;
HWND g_hOK       = NULL;

UINT g_bEscape			= 0;
UINT g_bEscape_OLD		= 0;
UINT g_uHistoryCount	= 0;
UINT g_uHistoryLast		= 0;
UINT g_bShowDialog		= 0;
UINT g_bShowDialog_OLD	= 0;

bool g_bNullstring = true;



/******************************************************************************************************
**  DllMain                                                                                          **
******************************************************************************************************/

bool g_bFirst = true;

BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD dwReason, LPVOID lpReserved )
{
	// Deny running the "other" version
	if( g_bFirst )
	{
		g_bFirst = false;

		// ANSI code that runs on both
		OSVERSIONINFOA osvi;
		osvi.dwOSVersionInfoSize = sizeof( OSVERSIONINFOA );
		GetVersionExA( &osvi );

		if(
			( sizeof( TCHAR ) == sizeof( wchar_t ) ) ^				// UNICODE compile?
			( osvi.dwPlatformId == VER_PLATFORM_WIN32_NT )			// UNICODE system?
		)
		{
			// Mismatch -> Deny loading
			return FALSE;
		}
	}

    if( dwReason == DLL_PROCESS_ATTACH )
	{
		g_hInstance = hModule;
	}

	return TRUE;
}


/******************************************************************************************************
**  wndproc_APPEND                                                                                   **
******************************************************************************************************/

BOOL CALLBACK wndproc_APPEND( HWND hwnd, UINT message, WPARAM wp, LPARAM lp )
{
	switch( message )
	{
		case WM_INITDIALOG:
		{
			// Handles
			g_hDropbox = GetDlgItem( hwnd, IDC_TEXT );
			g_hOK      = GetDlgItem( hwnd, IDOK );


			// Apply settings
			if( !g_bInCommand )
			{
				SendMessage( g_hOK, WM_SETTEXT, 0, ( LPARAM )_T( "&OK" ) );
			}

			g_CONFIG->Read( _T( "Escape" ),        ( int * )&g_bEscape,       0 );
			g_CONFIG->Read( _T( "History_Count" ), ( int * )&g_uHistoryCount, 0 );
			g_CONFIG->Read( _T( "History_Last" ),  ( int * )&g_uHistoryLast,  0 );
			g_CONFIG->Read( _T( "Show_Dialog" ),   ( int * )&g_bShowDialog,   1 );

			g_bEscape_OLD      = g_bEscape;
			g_bShowDialog_OLD  = g_bShowDialog;

			CheckDlgButton( hwnd, IDC_ESCAPE,      ( g_bEscape     ? BST_CHECKED : BST_UNCHECKED ) );
			CheckDlgButton( hwnd, IDC_SHOW_DIALOG, ( g_bShowDialog ? BST_CHECKED : BST_UNCHECKED ) );
			
			if( g_uHistoryCount )
			{
				if( g_uHistoryLast > g_uHistoryCount )
				{
					g_uHistoryLast = g_uHistoryCount;
				}

				for( UINT u = g_uHistoryCount; u; u-- )
				{
					TCHAR szKey[ 20 ];
					wsprintf( szKey, _T( "History_%u" ), u );
					TCHAR szString[ 256 ];
					g_CONFIG->Read( szKey, szString, _T( "" ), 255 );

					if( !_tcslen( szString ) )
					{
						continue;
					}

					if( u == g_uHistoryLast )
					{
						SendMessage( g_hDropbox, WM_SETTEXT, 0, ( LPARAM )szString );
						g_bNullstring = false;
					}

					LRESULT res = SendMessage( ( HWND )g_hDropbox, ( UINT )CB_ADDSTRING, ( WPARAM )0, ( LPARAM )szString );
					if( ( res == CB_ERR ) || ( res == CB_ERRSPACE ) )
					{
						break;
					}
				}
			}
			else
			{
				g_bNullstring = true;
			}


			// Center window
			RECT r1;
			if( GetWindowRect( g_hParent, &r1 ) )
			{
				RECT r2;
				if( GetWindowRect( hwnd, &r2 ) )
				{
					const int w1 = r1.right - r1.left;
					const int h1 = r1.bottom - r1.top;
					const int w2 = r2.right - r2.left;
					const int h2 = r2.bottom - r2.top;

					const int x2 = r1.left + ( w1 - w2 ) / 2;
					const int y2 = r1.top + ( h1 - h2 ) / 2;

					MoveWindow( hwnd, x2, y2, w2, h2, TRUE );
				}
			}

			break;
		}
		case WM_COMMAND:
		{
			switch( LOWORD( wp ) )
			{
				case IDC_TEXT:
				{
					// Enable/disable "Append" button
					if( HIWORD( wp ) == CBN_EDITUPDATE )
					{
						UINT uLen = ( UINT )SendMessage( g_hDropbox, WM_GETTEXTLENGTH, 0, 0 );
						if( ( uLen == 0 ) ^ g_bNullstring )
						{
							g_bNullstring = !uLen;
							EnableWindow( g_hOK, ( BOOL )( uLen ? 1 : 0 ) );
						}
					}

					break;
				}
				case IDOK:
				{
					g_bEscape     = ( BST_CHECKED == IsDlgButtonChecked( hwnd, IDC_ESCAPE      ) );
					g_bShowDialog = ( BST_CHECKED == IsDlgButtonChecked( hwnd, IDC_SHOW_DIALOG ) );

					if( g_bEscape != g_bEscape_OLD )
					{
						g_CONFIG->Write( _T( "Escape" ), ( int )g_bEscape );
						g_bEscape_OLD = g_bEscape;
					}
					if( g_bShowDialog != g_bShowDialog_OLD )
					{
						g_CONFIG->Write( _T( "Show_Dialog" ), ( int )g_bShowDialog );
						g_bShowDialog_OLD = g_bShowDialog;
					}

					UINT uLen = 1 + SendMessage( g_hDropbox, WM_GETTEXTLENGTH, 0, 0 );
					if( uLen > 1 )
					{
						g_szAppend = new TCHAR[ uLen ];
						SendMessage( g_hDropbox, WM_GETTEXT, uLen, ( LPARAM )g_szAppend );

						// New text?
						LRESULT res = SendMessage( g_hDropbox, CB_FINDSTRINGEXACT, ( WPARAM )( -1 ), ( LPARAM )g_szAppend );
						if( res == CB_ERR )
						{
							// Not found -> NEW
							g_uHistoryCount++;
							g_CONFIG->Write( _T( "History_Count" ), ( int )g_uHistoryCount );
							g_CONFIG->Write( _T( "History_Last" ), ( int )g_uHistoryCount );

							TCHAR szKey[ 20 ];
							wsprintf( szKey, _T( "History_%u" ), g_uHistoryCount );
							g_CONFIG->Write( szKey, g_szAppend );
						}
						else
						{
							// Save index
							g_CONFIG->Write( _T( "History_Last" ), ( int )( g_uHistoryCount - res ) );
						}

						if( !g_bInCommand )
						{
							delete [] g_szAppend;
						}
					}

					// NO BREAK !
				}
				case IDCANCEL:	// Button or [ESCAPE]
				{
					EndDialog( hwnd, LOWORD( wp ) );	// IDOK or IDCANCEL

					return TRUE;
				}
			}

			break;
		}
	}

	return 0;
}


/******************************************************************************************************
**  OnCommand                                                                                    @1  **
******************************************************************************************************/

EMEDITOR_API void OnCommand( HWND hwnd )
{
	// Config load
	g_CONFIG->Read( _T( "Escape" ),      ( int * )&g_bEscape,     0 );
	g_CONFIG->Read( _T( "Show_Dialog" ), ( int * )&g_bShowDialog, 1 );

	g_bEscape_OLD      = g_bEscape;
	g_bShowDialog_OLD  = g_bShowDialog;

	if( !g_bShowDialog )
	{
		g_CONFIG->Read( _T( "History_Count" ), ( int * )&g_uHistoryCount, 0 );
		g_CONFIG->Read( _T( "History_Last" ),  ( int * )&g_uHistoryLast,  0 );

		if( g_uHistoryCount )
		{
			if( g_uHistoryLast > g_uHistoryCount )
			{
				g_uHistoryLast = g_uHistoryCount;
			}

			TCHAR szKey[ 20 ];
			wsprintf( szKey, _T( "History_%u" ), g_uHistoryLast );

			g_szAppend = new TCHAR[ 256 ];
			g_CONFIG->Read( szKey, g_szAppend, _T( "" ), 255 );

			if( !_tcslen( g_szAppend ) )
			{
				delete [] g_szAppend;
				g_bShowDialog = 1;
			}
		}
		else
		{
			g_bShowDialog = 1;
		}
	}

	if( g_bShowDialog )
	{
		g_hParent     = GetForegroundWindow();
		g_bInCommand  = true;

		int res = DialogBox( g_hInstance, MAKEINTRESOURCE( IDD_APPEND ), g_hParent, wndproc_APPEND );

		if( ( res == IDCANCEL ) || ( g_szAppend == NULL ) || !_tcslen( g_szAppend ) )
		{
			return;
		}
	}


	if( g_bEscape != g_bEscape_OLD )
	{
		g_CONFIG->Write( _T( "Escape" ), ( int )g_bEscape );
		g_bEscape_OLD = g_bEscape;
	}
	if( g_bShowDialog != g_bShowDialog_OLD )
	{
		g_CONFIG->Write( _T( "Show_Dialog" ), ( int )g_bShowDialog );
		g_bShowDialog_OLD = g_bShowDialog;
	}


	// Decode escape sequences
	if( g_bEscape )
	{
		TCHAR * temp = NULL;
		decode_escape_sequences( g_szAppend, temp );
		delete [] g_szAppend;
		g_szAppend = temp;
	}


	// Process text
	UINT uLen = Editor_GetSelText( hwnd, 0, NULL );
	if( uLen > 1 )
	{
		// Process selection only

		// (1) Get selected text
		TCHAR * in = new TCHAR[ uLen ];
		Editor_GetSelText( hwnd, uLen, in );

		// (2) Create new text
		TCHAR * out = NULL;
		if( engine( in, out, g_szAppend ) )
		{
			// (3) Replace with new text
			SendMessage( hwnd, EM_REPLACESEL, TRUE, ( LPARAM )out );
		}

		if( out	!= NULL )
		{
			delete [] out;
		}

		delete [] in;
	}
	else
	{
		// Process all

		// (0) Get length
		uLen = 1 + SendMessage( hwnd, WM_GETTEXTLENGTH, 0, 0 );
		if( uLen > 1 )
		{
			// At least one character

			// (1) Get all text
			TCHAR * in = new TCHAR[ uLen ];
			if( SendMessage( hwnd, WM_GETTEXT, uLen, ( LPARAM )in ) )
			{
				// (2) Create new text
				TCHAR * out = NULL;
				if( engine( in, out, g_szAppend ) )
				{
					// (3) Replace with new text
					SendMessage( hwnd, WM_SETTEXT, 0, ( LPARAM )out );
				}

				if( out	!= NULL )
				{
					delete [] out;
				}
			}

			delete [] in;
		}
		else
		{
			// No text

			TCHAR in[] = _T( "\0" );
			TCHAR * out = NULL;
			if( engine( in, out, g_szAppend ) )
			{
				SendMessage( hwnd, WM_SETTEXT, 0, ( LPARAM )out );
			}
		}
	}
}


/******************************************************************************************************
**  QueryStatus                                                                                  @2  **
******************************************************************************************************/

EMEDITOR_API BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	*pbChecked = FALSE;
	BOOL bReadOnly;
	Editor_QueryStatus( hwnd, EEID_READ_ONLY, &bReadOnly );
	return !bReadOnly;
}


/******************************************************************************************************
**  OnEvents                                                                                     @3  **
******************************************************************************************************/

EMEDITOR_API void OnEvents( HWND hwnd, UINT uEvent, LPARAM lp )
{
	if( uEvent & EVENT_CREATE )
	{
		g_nCmdID = ( UINT )LOWORD( lp );
	}
}


/******************************************************************************************************
**  GetMenuTextID                                                                                @4  **
******************************************************************************************************/

EMEDITOR_API UINT GetMenuTextID()
{
	return IDS_MENU_TEXT;
}


/******************************************************************************************************
**  GetStatusMessageID                                                                           @5  **
******************************************************************************************************/

EMEDITOR_API UINT GetStatusMessageID()
{
	return IDS_STATUS_MESSAGE;
}


/******************************************************************************************************
**  GetBitmapID                                                                                  @6  **
******************************************************************************************************/

EMEDITOR_API UINT GetBitmapID()
{
	return IDB_16164_DEFAULT;
}


/******************************************************************************************************
**  PlugInProc                                                                                   @7  **
******************************************************************************************************/

bool g_bDoInit = true;

EMEDITOR_API LRESULT PlugInProc( HWND hwnd, UINT message, WPARAM wp, LPARAM lp )
{
	if( g_bDoInit )
	{
		g_CONFIG = new DEVIL_CONFIG( _T( "AutoAppend" ), g_hInstance );

		g_bDoInit = false;
	}

	LRESULT res = 0;

	switch( message )
	{
		case EP_QUERY_PROPERTIES:
		{
			res = TRUE;
		
			break;
		}
		case EP_SET_PROPERTIES:
		{
			g_bShowDialog_OLD = g_bShowDialog;

			g_hParent     = GetForegroundWindow();
			g_bInCommand  = false;
			DialogBox( g_hInstance, MAKEINTRESOURCE( IDD_APPEND ), g_hParent, wndproc_APPEND );

			if( g_bShowDialog_OLD != g_bShowDialog )
			{
				g_CONFIG->Write( _T( "Show_Dialog" ), ( int )g_bShowDialog );
			}
		
			res = TRUE;

			break;
		}
		case EP_GET_NAME:
		{
			TCHAR szAppName[ 80 ];
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			res = lstrlen( szAppName ) + 1;
			if( lp != NULL )
			{
				lstrcpyn( ( TCHAR * )lp, szAppName, wp );
			}
		
			break;
		}
		case EP_GET_VERSION:
		{

			TCHAR sz[ 80 ];
			LoadString( g_hInstance, IDS_VERSION, sz, sizeof( sz ) / sizeof( TCHAR ) );
			res = lstrlen( sz ) + 1;
			if( lp != NULL )
			{
				lstrcpyn( ( TCHAR * )lp, sz, wp );
			}

			break;
		}
		case EP_GET_BITMAP:
		{
			if( wp & BITMAP_LARGE )
			{
				if( wp & BITMAP_DISABLED )
				{
					res = IDB_24244_GRAY;
				}
				else
				{
					res = IDB_24244_DEFAULT;
				}
			}
			else
			{
				if( wp & BITMAP_DISABLED )
				{
					res = IDB_16164_GRAY;
				}
				else
				{
					res = IDB_16164_DEFAULT;
				}
			}

			break;
		}
		case EP_GET_MASK:
		{
			res = RGB( 192, 192, 192 );
		
			break;
		}
		case EP_QUERY_UNINSTALL:
		{
			res = TRUE;		// TRUE to allow
			
			break;
		}
		case EP_SET_UNINSTALL:
		{
			TCHAR sz[ 160 ];
			TCHAR szFormat[ 80 ];
			TCHAR szAppName[ 80 ];
			LoadString( g_hInstance, IDS_SURE_TO_UNINSTALL, szFormat, sizeof( szFormat ) / sizeof( TCHAR ) );
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			wsprintf( sz, szFormat, szAppName );
			if( MessageBox( hwnd, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES )
			{
				res = TRUE;
			}
		
			break;
		}
	}

	return res;
}

