

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   AutoAppend EmEditor Plugin 1.4                                *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                        2004-10-05   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#include "stdafx.h"



/******************************************************************************************************
**  engine                                                                                           **
******************************************************************************************************/

bool engine( TCHAR * in, TCHAR * & out, TCHAR * app )
{
	UINT in_len   = _tcslen( in );
	UINT out_len  = 0;
	UINT app_len  = _tcslen( app );


	TCHAR * szWalker = in;
	bool b13before = false;
	UINT uLines = 0;


	// (I) Count lines (to predict size of output)
	while( *szWalker != _T( '\0' ) )
	{
		switch( *szWalker )
		{
			case _T( '\x0D' ):
			{
				b13before = true;
				
				break;
			}
			case _T( '\x0A' ):
			{
				if( b13before )
				{
					uLines++;
				}

				b13before = false;

				break;
			}
			default:
			{
				b13before = false;
			}
		}

		szWalker++;
	}

	// Finishing newline?
	bool bNewlineFinish =	( in_len >= 2 ) &&
							( *( szWalker - 2 ) == _T( '\x0D' ) ) &&
							( *( szWalker - 1 ) == _T( '\x0A' ) );
	if( !bNewlineFinish )
	{
		uLines++;
	}

	szWalker = in;		// Reset to start


	// Allocate new buffer
	out = new TCHAR[ in_len + ( app_len * uLines ) + 1 ];


	// (II) Create new content
	bool bSearching = true;
	TCHAR * szBeg = NULL;
	TCHAR * szEnd = NULL;
	TCHAR * szBegNext = in;

	while( uLines-- )
	{
		// (0) Search end of line/string
		b13before   = false;
		bSearching  = true;

		while( bSearching )
		{
			switch( *szWalker )
			{
				case _T( '\x0D' ):
				{
					b13before = true;

					break;
				}
				case _T( '\x0A' ):
				{
					if( b13before )
					{
						bSearching  = false;		// STOP
						b13before   = false;
					}
					
					break;
				}
				case _T( '\0' ):
				{
					bSearching = false;			// STOP
					szWalker--;					// We only walk _one_ past the end
					
					break;
				}
				default:
				{
					b13before = false;
				}
			}

			szWalker++;
		}


		// (1) Copy line
		szBeg = szBegNext;
		szEnd = szWalker - ( ( uLines || bNewlineFinish ) ? 2 : 0 );

		UINT line_len = szEnd - szBeg;
		if( line_len > 0 )
		{
			memcpy( out + out_len, szBeg, line_len * sizeof( TCHAR ) );
			out_len += line_len;
		}
		szBegNext = szEnd;


		// (2) Append
		memcpy( out + out_len, app, app_len * sizeof( TCHAR ) );
		out_len += app_len;


		// (3) Rest
		if( !uLines && bNewlineFinish )
		{
			UINT rest_len = ( in + in_len ) - szBegNext;
			memcpy( out + out_len, szBegNext, rest_len * sizeof( TCHAR ) );
			out_len += rest_len;
		}
	}

	out[ out_len ] = _T( '\0' );

	return true;
}