

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   AutoAppend EmEditor Plugin 1.4                                *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                        2004-10-05   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#include "stdafx.h"


#define IS_HEX_DIGIT( ch ) ( ( ch >= _T( '0' ) ) && ( ch <= _T( '9' ) ) ) || (	( ch >= _T( 'A' ) ) && ( ch <= _T( 'F' ) ) ) || ( ( ch >= _T( 'a' ) ) && ( ch <= _T( 'f' ) ) )
#define IS_OCT_DIGIT( ch ) ( ( ch >= _T( '0' ) ) && ( ch <= _T( '7' ) ) )



/******************************************************************************************************
**  decode_hex                                                                                       **
******************************************************************************************************/

bool decode_hex( TCHAR * in, UINT & out )
{
	out = 0;

	UINT in_len = _tcslen( in );
	while( in_len-- )
	{
		TCHAR ch = *( in++ );

		if(
			( ch >= _T( '0' ) ) &&
			( ch <= _T( '9' ) )
		)
		{
			out +=	( ch - _T( '0' ) +  0 )	<< ( in_len << 2 );
		}
		else if(
			( ch >= _T( 'A' ) ) &&
			( ch <= _T( 'F' ) )
		)
		{
			out +=	( ch - _T( 'A' ) + 10 )	<< ( in_len << 2 );
		}
		else if(
			( ch >= _T( 'a' ) ) &&
			( ch <= _T( 'f' ) )
		)
		{
			out +=	( ch - _T( 'a' ) + 10 )	<< ( in_len << 2 );
		}
		else
		{
			return false;
		}
	}

	return true;
}


/******************************************************************************************************
**  decode_oct                                                                                       **
******************************************************************************************************/

bool decode_oct( TCHAR * in, UINT & out )
{
	out = 0;

	UINT in_len = _tcslen( in );
	while( in_len-- )
	{
		TCHAR ch = *( in++ );

		if(
			( ch >= _T( '0' ) ) &&
			( ch <= _T( '7' ) )
		)
		{
			out +=	( ch - _T( '0' )  )	<< ( in_len * 3 );
		}
		else
		{
			return false;
		}
	}

	return true;
}


/******************************************************************************************************
**  decode_escape_sequences                                                                          **
******************************************************************************************************/

bool decode_escape_sequences( TCHAR * in, TCHAR * & out )
{
	/*

	0x005C	\\			Backslash

	0x????	\x????		Hexadecimal	(1-4 digits)
	0x00??	\0??		Octal		(1-2 digits)

	0x0007	\a			Bell/alarm
	0x0008	\b			Backspace
	0x001B	\e			ASCII Escape character
	0x000C	\f			Formfeed
	0x000A	\n			Newline
	0x000D	\r			Carriage return
	0x0009	\t			Horizontal tab
	0x000B	\v			Vertical tab

	*/


	UINT in_len = _tcslen( in );
	if( in_len == 0 )
	{
		return false;
	}

	out = new TCHAR[ in_len + 1 ];
	UINT out_len = 0;
	UINT app_len = 0;

	bool bInsideEscape	= false;
	bool bInsideHex		= false;
	bool bInsideOct		= false;

	UINT uDigits;
	TCHAR * beg = in;

	while( *in != _T( '\0' ) )
	{
		if( bInsideEscape )
		{
			if( bInsideHex || bInsideOct )
			{
				if( bInsideHex )
				{
					if( IS_HEX_DIGIT( *in ) )
					{
						if( ++uDigits == 4 )													// *
						{
							// Maximum length reached -> decode
							bInsideEscape	= false;
							bInsideHex		= false;

							TCHAR * hex = new TCHAR[ uDigits + 1 ];
							memcpy( hex, in - uDigits + 1, uDigits * sizeof( TCHAR ) );			// *
							hex[ uDigits ] = _T( '\0' );

							UINT res;
							decode_hex( hex, res );
							out[ out_len ] = ( TCHAR )res;
							out_len++;

							delete [] hex;
						}
					}
					else	// !IS_HEX_DIGIT( *in )
					{
						// End reached -> decode
						bInsideEscape	= false;
						bInsideHex		= false;

						if( uDigits > 0 )
						{
							TCHAR * hex = new TCHAR[ uDigits + 1 ];
							memcpy( hex, in - uDigits, uDigits * sizeof( TCHAR ) );
							hex[ uDigits ] = _T( '\0' );

							UINT res;
							decode_hex( hex, res );
							out[ out_len ] = ( TCHAR )res;
							out_len++;

							delete [] hex;

							in--;																// *
						}
						else
						{
							// Wrong escape sequence -> plain copy
							out[ out_len     ] = *( in - 1 );
							out[ out_len + 1 ] = *( in     );
							out_len += 2;
						}
					}
				}
				else	// bInsideOct
				{
					if( IS_OCT_DIGIT( *in ) )
					{
						if( ++uDigits == 2 )													// *
						{
							// Maximum length reached -> decode
							bInsideEscape	= false;
							bInsideOct		= false;

							TCHAR * oct = new TCHAR[ uDigits + 1 ];
							memcpy( oct, in - uDigits + 1, uDigits * sizeof( TCHAR ) );			// *
							oct[ uDigits ] = _T( '\0' );

							UINT res;
							decode_oct( oct, res );
							out[ out_len ] = ( TCHAR )res;
							out_len++;

							delete [] oct;
						}
					}
					else	// IS_OCT_DIGIT( *in )
					{
						// End reached -> decode
						bInsideEscape	= false;
						bInsideOct		= false;

						if( uDigits > 0 )
						{
							TCHAR * oct = new TCHAR[ uDigits + 1 ];
							memcpy( oct, in - uDigits, uDigits * sizeof( TCHAR ) );
							oct[ uDigits ] = _T( '\0' );

							UINT res;
							decode_oct( oct, res );
							out[ out_len ] = ( TCHAR )res;
							out_len++;

							delete [] oct;

							in--;																// *
						}
						else
						{
							// Wrong escape sequence -> plain copy
							out[ out_len     ] = *( in - 1 );
							out[ out_len + 1 ] = *( in     );
							out_len += 2;
						}
					}
				}

				in++;

				if( !bInsideEscape )
				{
					beg = in;
				}
			}
			else	// !( bInsideHex || bInsideOct )
			{
				switch( *in )
				{
					case _T( '\\' ):
					{
						out[ out_len ] = ( TCHAR )0x5C;
						out_len++;

						break;
					}
					case _T( '0' ):
					{
						bInsideOct = true;
						uDigits = 0;

						break;
					}
					case _T( 'x' ):
					{
						bInsideHex = true;
						uDigits = 0;

						break;
					}
					case _T( 'a' ):
					{
						out[ out_len ] = ( TCHAR )0x07;
						out_len++;

						break;
					}
					case _T( 'b' ):
					{
						out[ out_len ] = ( TCHAR )0x08;
						out_len++;

						break;
					}
					case _T( 'e' ):
					{
						out[ out_len ] = ( TCHAR )0x1B;
						out_len++;

						break;
					}
					case _T( 'f' ):
					{
						out[ out_len ] = ( TCHAR )0x0C;
						out_len++;

						break;
					}
					case _T( 'n' ):
					{
						out[ out_len ] = ( TCHAR )0x0A;
						out_len++;

						break;
					}
					case _T( 'r' ):
					{
						out[ out_len ] = ( TCHAR )0x0D;
						out_len++;

						break;
					}
					case _T( 't' ):
					{
						out[ out_len ] = ( TCHAR )0x09;
						out_len++;

						break;
					}
					case _T( 'v' ):
					{
						out[ out_len ] = ( TCHAR )0x0B;
						out_len++;
				
						break;
					}
					default:
					{
						// Wrong escape sequence -> plain copy
						out[ out_len     ] = *( in - 1 );
						out[ out_len + 1 ] = *( in     );
						out_len += 2;
					}
				}

				in++;

				if( !( bInsideHex || bInsideOct ) )
				{
					beg = in;
					bInsideEscape = false;
				}
			}
		}
		else	// !bInsideEscape
		{
			if( *in == _T( '\\' ) )
			{
				bInsideEscape = true;

				// Copy everything before
				app_len = in - beg;
				if( app_len > 0 )
				{
					memcpy( out + out_len, beg, ( in - beg ) * sizeof( TCHAR ) );
					out_len += app_len;
				}
			}

			in++;	
		}
	}

	if( bInsideEscape )
	{
		// Hex or octal is not finished -> finish now
		if( bInsideHex )
		{
			TCHAR * hex = new TCHAR[ uDigits + 1 ];
			memcpy( hex, in - uDigits, uDigits * sizeof( TCHAR ) );
			hex[ uDigits ] = _T( '\0' );

			UINT res;
			decode_hex( hex, res );
			out[ out_len ] = ( TCHAR )res;
			out_len++;

			delete [] hex;
		}
		else	// bInsideOct
		{
			TCHAR * oct = new TCHAR[ uDigits + 1 ];
			memcpy( oct, in - uDigits, uDigits * sizeof( TCHAR ) );
			oct[ uDigits ] = _T( '\0' );

			UINT res;
			decode_oct( oct, res );
			out[ out_len ] = ( TCHAR )res;
			out_len++;

			delete [] oct;
		}
	}
	else
	{
		// Copy rest
		app_len = in - beg;
		if( app_len > 0 )
		{
			memcpy( out + out_len, beg, ( in - beg ) * sizeof( TCHAR ) );
			out_len += app_len;
		}
	}

	out[ out_len ] = _T( '\0' );

	return true;
}
